#include <exec/types.h>

#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>



extern struct DOSBase *DOSBase;

struct IFFHeader
   {
   char  IFFID[4];
   ULONG IFFLength;
   char  IFFType[4];
   };
   
struct IFFChunk
   {
   char  ChunkID[4];
   ULONG ChunkLength;
   };

struct COMMHeader
   {
   WORD   numChannels;
   ULONG  numSampleFrames; // (Anzahl der Samples)
   WORD   sampleSize;      //(Bits)
   char   sampleRate[10];  //PlayFreq, 80 Bit
   };
struct SSNDHeader
   {
   LONG  Offset,Blocksize;
   };
struct SXHeader
   {
   UBYTE SampleDepth,FixedVolume;
   ULONG SoundLength,PlayRate,CompressionMethod;
   UBYTE UsedChannels,UsedMode;
   ULONG PlayFreq;
   UWORD pad;
   };

IFFHeader  IFFHd;
IFFChunk   IFFCh;
COMMHeader COMM={0,0,0,0,0,0};
SSNDHeader SSND={0,0};
SXHeader   SXHD;

LONG   l,m=0,SampleRes,MemLLoad;
ULONG  MemLS,Loaded,Addr24[6];
APTR   MemALoad;
UBYTE  MyChannels,MyMode,ChCnt,ChBit,i;
LONG  *Data1;
BOOL   SaveCopyright;



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



void Encode80(LONG SFreq)

{
struct IEEE_DBL
   {
   LONG hi,lo;
   };
struct SANE_EXT
   {
   ULONG l1,l2;
   UWORD s1;
   };
UWORD    *ps2;    
ULONG     top2bits;
double    pd;
IEEE_DBL *p_dbl;
SANE_EXT *p_ext;   

 
pd=(double)SFreq;
p_dbl = (IEEE_DBL*)&pd;
p_ext = (SANE_EXT*)&COMM.sampleRate;
top2bits = p_dbl->hi & 0xc0000000;
p_ext->l1 = ((p_dbl->hi >> 4) & 0x3ff0000) | top2bits;
p_ext->l1 |= ((p_dbl->hi >> 5) & 0x7fff) | 0x8000;
p_ext->l2 = (p_dbl->hi << 27) & 0xf8000000;
p_ext->l2 |= ((p_dbl->lo >> 5) & 0x07ffffff);
ps2 = (UWORD*) &(p_dbl->lo);
ps2++;
p_ext->s1 = (*ps2 << 11) & 0xf800;
}



BOOL GETSAVEMEM(void)

{
MemLLoad=(100032/ChCnt)*ChCnt;
MemALoad=AllocVec(MemLLoad,MEMF_FAST);
if (!MemALoad)
   {
   MemLLoad=AvailMem(MEMF_LARGEST)-640;
   if (MemLLoad>=640)
      {
      MemLLoad=((ULONG)(MemLLoad/ChCnt))*ChCnt;
      MemALoad=AllocVec(MemLLoad,MEMF_FAST);
      if (!MemALoad) return FALSE;
      }
   else return FALSE;
   }
return TRUE;
}



BOOL WRITEDATA24(void)

{
ULONG *Data32;
ULONG  DataH;
LONG   Addr32,CCtr=0;
BOOL   Leave;
BYTE   CChannel=-1;
UBYTE *C8;


MyWTStdMsg->Flags=MDE_NO_MEMORY;
if (!GETSAVEMEM()) return FALSE;
do
   {
   Addr32=((ULONG)MemALoad);
   Leave=FALSE;
   do
      {
      ChBit=1;
      for (i=0; i<6; i++)
         {
         if ((MyWTStdMsg->ActiveChannels & ChBit)==ChBit)
            {
            if ((Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24))
               {
               if ((MyWTStdMsg->MemA24[i]) && (Addr24[i]))
                  {
                  Data32=(ULONG*)(Addr32);  Addr32=Addr32+3;
                  Data1=(LONG*)(Addr24[i]); Addr24[i]=Addr24[i]+4;
                  if ((SaveCopyright) && ((CChannel==i) || (CChannel<0)) && (CCtr<MyWTStdMsg->BitSize))
                     {
                     if (CChannel<0) CChannel=i;
                     C8=(BYTE*)((LONG)(MyWTStdMsg->Bits)+CCtr);
                     *Data1=((*Data1 & 0xFFFFFFFE) + (*C8 & 0x01));
                     CCtr++;                     
                     }
                  DataH=(ULONG)((*Data1+MAX24) & 0x00FFFFFF);
                  *Data32=((*Data32 & 0xFF000000)|DataH);
                  }
               else Addr32=Addr32+3;
               }
            else Leave=TRUE;
            }
         ChBit=ChBit*2;
         }
      }
   while ((Addr32<(ULONG)MemALoad+MemLLoad) && (!Leave));      
   l=(Addr32-((ULONG)MemALoad));
   m=Write(MyWTStdMsg->ActFHandle,(APTR)((LONG)MemALoad+1),l);
   }
while ((m==l) && (!Leave));
if (!Leave) return FALSE;
return TRUE;
}



BOOL SAVEAIFF(void)

{
for (i=0; i<6; i++) Addr24[i]=MyWTStdMsg->MemA24[i];
MemALoad=NULL; MemLLoad=0; ChCnt=0; ChBit=1;
for (i=0; i<6; i++)
   {
   if ((MyWTStdMsg->ActiveChannels & ChBit)==ChBit) ChCnt++;
   ChBit=ChBit*2;
   }
char s[50];

strncpy(IFFHd.IFFID,"FORM",4);
strncpy(IFFHd.IFFType,"AIFF",4);
Write(MyWTStdMsg->ActFHandle,&IFFHd,12); //FORM____AIFF

strncpy(IFFCh.ChunkID,"COMM",4);
IFFCh.ChunkLength=sizeof(COMMHeader);
Write(MyWTStdMsg->ActFHandle,&IFFCh,8);
COMM.numChannels=ChCnt;
COMM.numSampleFrames=MyWTStdMsg->PlayL24/4;
COMM.sampleSize=24;
Encode80((ULONG)(10000000.0/(MyWTStdMsg->SRate*2.79365)));
Write(MyWTStdMsg->ActFHandle,&COMM,sizeof(COMMHeader));

strncpy(IFFCh.ChunkID,"SXHD",4);
IFFCh.ChunkLength=sizeof(SXHeader);
Write(MyWTStdMsg->ActFHandle,&IFFCh,8);
SXHD.SampleDepth=24;
SXHD.FixedVolume=64;
SXHD.SoundLength=MyWTStdMsg->PlayL24;
SXHD.PlayRate=MyWTStdMsg->SRate;
SXHD.CompressionMethod=0;
SXHD.UsedChannels=MyWTStdMsg->ActiveChannels;
SXHD.UsedMode=MyWTStdMsg->ActiveMode;
SXHD.PlayFreq=(ULONG)(10000000.0/(MyWTStdMsg->SRate*2.79365));
SXHD.pad=0;
Write(MyWTStdMsg->ActFHandle,&SXHD,sizeof(SXHeader));

strncpy(IFFCh.ChunkID,"ANNO",4);
IFFCh.ChunkLength=28;
strcpy(s,"WaveTracer DS by QXC of VWP");
Write(MyWTStdMsg->ActFHandle,&IFFCh,8);
Write(MyWTStdMsg->ActFHandle,&s,28);

strncpy(IFFCh.ChunkID,"SSND",4);
IFFCh.ChunkLength=(COMM.numChannels*COMM.numSampleFrames*3)+sizeof(SSNDHeader);
l=Write(MyWTStdMsg->ActFHandle,&IFFCh,8);
l=Write(MyWTStdMsg->ActFHandle,&SSND,sizeof(SSNDHeader));
if (l<sizeof(SSNDHeader)) return FALSE;
if (!WRITEDATA24()) return FALSE;
if (MemALoad) FreeVec(MemALoad);
l=Seek(MyWTStdMsg->ActFHandle,4,OFFSET_BEGINNING)-8;
Write(MyWTStdMsg->ActFHandle,&l,4);
return TRUE;
}



void main (void)

{
if (CREATEPORTS(PORT_SAVER))
   {
   if (MyWTStdMsg->Version==VERSION_SAVER)
      {
      DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
      if (DOSBase)
         {            
         if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (MyWTStdMsg->Bits) SaveCopyright=TRUE else SaveCopyright=FALSE;                  
               if (SAVEAIFF())
                  {
                  MyWTStdMsg->Flags=0;
                  MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"AIFF 24 Bit 5.1 Saver, ");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
                  strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
                  MESSAGEHANDLE();
                  MyWTStdMsg->Flags=MDE_READY
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         CloseLibrary((Library*)DOSBase);
         }
      else
         {
         SENDERROR("Can't open dos.library!");
         MyWTStdMsg->Flags=MDE_READY;         
         }
      }
   else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
   MESSAGEHANDLE();
   RemPort(MyPort);
   DeleteMsgPort(MyPort)
   }
}
