//Program IFF;

#include <exec/types.h>
#include <exec/memory.h>
#include <libraries/reqtools.h>
#include <devices/ahi.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#include <pragma/reqtools.h>
#include <pragma/all_lib.h>

#include <iostream.h>
#include <string.h>
#include <wbstartup.h>

struct Library *DBase=NULL;
struct Library *ReqToolsBase=NULL;

struct ENTRHeader
   {
   ULONG BeginOffset,EndOffset,Rate,Delay,Time;
   UWORD Loop,VolumeL,VolumeR;
   char  Name[30];
   ENTRHeader *NextEntry;
   };
struct IFFHeader
   {
   char  IFFID[4];
   ULONG IFFLength;
   char  IFFType[4];
   };
struct IFFChunk
   {
   char  ChunkID[4];
   ULONG ChunkLength;
   };
struct COMMHeader
   {
   WORD   ChannelNum;      //numChannels
   ULONG  numSampleFrames; // (Anzahl der SampleFrames)
   WORD   sampleSize;      // Bits
   char   sampleRate[10];      //PlayFreq, 80 Bit
   ULONG  Compression;
   };
struct SSNDHeader
   {
   LONG  Offset,Blocksize;
   };

IFFHeader    IFFHd;
IFFChunk     IFFCh;
COMMHeader   COMM;
SSNDHeader   SSND;   

ENTRHeader       *FirstEntry,*MyEntry;
APTR             a;
char             PathFR[350]="", FileName[350]="", s[350]="";
rtFileRequester *MyFReq=NULL;
MsgPort         *AHIPort=NULL;
AHIRequest      *AHIReq=NULL;
BYTE             OpenDev=-1;
BOOL             DoLoop;
BPTR             FHandle1,FHandle2;
LONG             DataPos,SFreq[2],SMemL[2],LoopCtr[2];
APTR             SMemA[2];


void Decode80(char ps[10], double *pd)

{
struct IEEE_DBL
   {
   LONG hi,lo;
   };
struct SANE_EXT
   {
   ULONG l1,l2;
   UWORD s1;
   };
   
ULONG    top2bits;
IEEE_DBL *p_dbl;
SANE_EXT *p_ext;


p_dbl = (IEEE_DBL *) pd;
p_ext = (SANE_EXT *) ps;
top2bits = p_ext->l1 & 0xc0000000;
p_dbl->hi = ((p_ext->l1 << 4) & 0x3ff00000) | top2bits;
p_dbl->hi |= (p_ext->l1 << 5) & 0xffff0;
p_dbl->hi |= (p_ext->l2 >> 27) & 0x1f;
p_dbl->lo = (p_ext->l2 << 5) & 0xffffffe0;
p_dbl->lo |= (ULONG) ((p_ext->s1 >> 11) & 0x1f);
}



BOOL ReadPlayList(char *FilePath)

{
WORD i;
char PLLPath[350];
APTR EMemA;
LONG l;

strcpy(PLLPath,FilePath);
i=strlen(PLLPath); 
while (i>0)
   {
   i--;   
   if ((UBYTE)PLLPath[i]==0x2E)
      {
      PLLPath[i]=(char)0;
      strcat(PLLPath,".PLL");
      i=0;
      }
   }
FHandle2=Open(PLLPath,MODE_OLDFILE);
if (!FHandle2)
   {
   cout << "   Playlist " << PLLPath << " not found!\n";
   return FALSE;
   }
cout << "   Playlist: " << PLLPath << "\n";
Read(FHandle2,&IFFHd,12);
if (!(strncmp(IFFHd.IFFID,"FORM",4)))
   {
   if (!strncmp(IFFHd.IFFType,"WTPL",4))
      {
      do
         {
         l=Read(FHandle2,&IFFCh,8);
         if (IFFCh.ChunkLength % 2==1) IFFCh.ChunkLength++;       
         if (!(strncmp(IFFCh.ChunkID,"ENTR",4)))
            {
            while (IFFCh.ChunkLength>=sizeof(ENTRHeader)-4)
               {
               EMemA=AllocVec(sizeof(ENTRHeader),0);
               if (!EMemA)
                  {
                  cout << "Not enough memory for playlist!\n";
                  Close(FHandle2);
                  return TRUE;
                  }
               IFFCh.ChunkLength=IFFCh.ChunkLength-Read(FHandle2,EMemA,sizeof(ENTRHeader)-4);
               if (!FirstEntry)
                  {
                  FirstEntry=(ENTRHeader*)EMemA;
                  MyEntry=FirstEntry;
                  }
               else
                  {
                  MyEntry->NextEntry=(ENTRHeader*)EMemA;
                  MyEntry=MyEntry->NextEntry;
                  }
               MyEntry->NextEntry=NULL;
               }
            }
         Seek(FHandle2,IFFCh.ChunkLength,OFFSET_CURRENT);
         }
      while (l>=8);
      if (!FirstEntry) cout << "File doesn't contains playlist-data!\n";
      }
   else cout << "File isn't a WaveTracer-WTPL-format!\n";
   }
else cout << PLLPath << ": PLL-file isn't a IFF-format!\n";
Close(FHandle2);
return TRUE;
}



void FillSMemA(UBYTE ActS)

{
LONG ScanOffset;

if (!MyEntry) return;
SFreq[ActS]=(LONG)(LONG)(10000000.0/(MyEntry->Rate*2.79365));
SMemL[ActS]=(MyEntry->EndOffset-MyEntry->BeginOffset)/2;
ScanOffset=(MyEntry->BeginOffset)/2;
if (COMM.sampleSize<=8)
   {
   SMemL[ActS]=SMemL[ActS]/2;
   ScanOffset=ScanOffset/2;
   }
if (COMM.ChannelNum>1)
   {
   SMemL[ActS]=SMemL[ActS]*2;
   ScanOffset=ScanOffset*2;
   }
SMemA[ActS]=AllocVec(SMemL[ActS],0);
if (SMemA[ActS])
   {
   Seek(FHandle1,ScanOffset+DataPos,OFFSET_BEGINNING);
   SMemL[ActS]=Read(FHandle1,SMemA[ActS],SMemL[ActS]);
   }
else cout << "Not enough memory!\n";
LoopCtr[ActS]=MyEntry->Loop;
MyEntry=MyEntry->NextEntry; 
}



void PlayPlayList(void)

{
UBYTE ActS;
BOOL  First;


if (!FirstEntry) return;
ActS=0; SMemA[0]=NULL; SMemA[1]=NULL;
AHIReq->ahir_Std.io_Command=CMD_WRITE;
AHIReq->ahir_Std.io_Offset =0;
MyEntry=FirstEntry;
AHIReq->ahir_Link          =NULL;
if (COMM.ChannelNum==1)
   {
   if (COMM.sampleSize<=8) AHIReq->ahir_Type=0
   else if (COMM.sampleSize<=16) AHIReq->ahir_Type=1;
   }
else if (COMM.ChannelNum==2)
   {
   if (COMM.sampleSize<=8) AHIReq->ahir_Type=2
   else if (COMM.sampleSize<=16) AHIReq->ahir_Type=3;
   }            
FillSMemA(ActS);
do
   {
   if (SMemA[ActS])
      {
      AHIReq->ahir_Std.io_Data   =SMemA[ActS];
      AHIReq->ahir_Std.io_Length =SMemL[ActS];
      AHIReq->ahir_Frequency     =SFreq[ActS];
      AHIReq->ahir_Volume        =0x10000;
      AHIReq->ahir_Position      =0x08000;
      First=TRUE;
      while (LoopCtr[ActS]>0)
         {
         SendIO((IORequest*)AHIReq);
         if ((First) && (MyEntry))
            {
            cout << "             " << SFreq[ActS] << " Hz, " << MyEntry->Loop << " x " << MyEntry->Name << "\n";
            if (!SMemA[1-ActS]) FillSMemA(1-ActS);
            First=FALSE;
            }
         WaitIO((IORequest*)AHIReq);
         LoopCtr[ActS]--;
         }
      if (SMemA[ActS])
         {
         FreeVec(SMemA[ActS]);
         SMemA[ActS]=NULL;
         }        
      }
   else return;
   ActS=1-ActS;
   }
while ((MyEntry) || (SMemA[ActS]));
}



void PLAYPLL(char *FilePath)

{
LONG   Load,l,SampleFreq;
double SampleDbl;
APTR   SMemA;
LONG   SMemL;


FirstEntry=NULL;
FHandle1=Open(FilePath,MODE_OLDFILE);
if (!FHandle1)
   {
   cout << FilePath << " not found!\n";
   return;
   }
cout << "   Sample:   " << FilePath << "\n";
Read(FHandle1,&IFFHd,12);
if (!(strncmp(IFFHd.IFFID,"FORM",4)))
   {
   if ((!(strncmp(IFFHd.IFFType,"AIFF",4))) || (!(strncmp(IFFHd.IFFType,"AIFC",4))))
      {
      do
         {
         l=Read(FHandle1,&IFFCh,8);
         if (!(strncmp(IFFCh.ChunkID,"COMM",4)))
            {
            Load=Read(FHandle1,&COMM,IFFCh.ChunkLength);
            cout << "             " << COMM.sampleSize << " Bit\n";
            cout << "             ";
            if (COMM.ChannelNum==1) cout << "1 channel\n";
            else cout << COMM.ChannelNum << " channels\n";
            if (COMM.Compression>0)
               {
               cout << "Unknown compression-method!\n";
               Close(FHandle1);
               return;
               }
            if (COMM.sampleSize>16)
               {
               cout << "Sample-resolution too high!\n";
               Close(FHandle1);
               return;
               }
            if (COMM.ChannelNum>2)
               {
               cout << "Too much audiochannels!\n";
               Close(FHandle1);
               return;
               }
            Decode80(COMM.sampleRate,&SampleDbl);
            SampleFreq=(LONG)SampleDbl;
            if (SampleFreq<60) SampleFreq=60 else if (SampleFreq>100000) SampleFreq=100000;
            }
         else if (strncmp(IFFCh.ChunkID,"SSND",4))
          Load=Seek(FHandle1,IFFCh.ChunkLength,OFFSET_CURRENT);
         }
      while (strncmp(IFFCh.ChunkID,"SSND",4) && (l>=8));
      if (l>=8)
         {
         Read(FHandle1,&SSND,sizeof(SSNDHeader));
         Seek(FHandle1,SSND.Offset,OFFSET_CURRENT);
         DataPos=Seek(FHandle1,0,OFFSET_CURRENT);
         if (!ReadPlayList(FilePath))
            {
            SMemL=COMM.numSampleFrames;
            if (COMM.sampleSize>8) SMemL=SMemL*2;
            if (COMM.ChannelNum>1) SMemL=SMemL*2;
            SMemA=AllocVec(SMemL,0);
            Read(FHandle1,SMemA,SMemL);
            if (SMemA)
               {
               AHIReq->ahir_Std.io_Command=CMD_WRITE;
               AHIReq->ahir_Std.io_Data   =SMemA;
               AHIReq->ahir_Std.io_Length=SMemL;
               AHIReq->ahir_Std.io_Offset =0;
               AHIReq->ahir_Frequency     =SampleFreq;
               AHIReq->ahir_Volume        =0x10000;
               AHIReq->ahir_Position      =0x08000;
               AHIReq->ahir_Link          =NULL;
               if (COMM.ChannelNum==1)
                  {
                  if (COMM.sampleSize<=8) AHIReq->ahir_Type=0
                  else if (COMM.sampleSize<=16) AHIReq->ahir_Type=1;
                  }
               else if (COMM.ChannelNum==2)
                  {
                  if (COMM.sampleSize<=8) AHIReq->ahir_Type=2
                  else if (COMM.sampleSize<=16) AHIReq->ahir_Type=3;
                  }            
               DoIO((IORequest*)AHIReq);
               FreeVec(SMemA);
               }
            }
         else PlayPlayList();            
         if (FirstEntry)
            {
            MyEntry=FirstEntry;
            do
               {
               FirstEntry=MyEntry;
               MyEntry=MyEntry->NextEntry;
               FreeVec((APTR)FirstEntry);
               }
            while (MyEntry);
            }
         }
      else cout << "File corrupt!\n";
      }
   else cout << "No AIFF/AIFC!\n";
   }
else cout << "No IFF-format!\n";
Close(FHandle1);
}



void CloseAHI(void)

{
if (OpenDev==0) CloseDevice ((struct IORequest*)(AHIReq));
OpenDev=-1;
if (AHIReq) DeleteIORequest((struct IORequest*)(AHIReq));
AHIReq=NULL;
if (AHIPort)
   {
   RemPort(AHIPort);
   DeleteMsgPort(AHIPort);
   }
AHIPort=NULL;
}



BOOL OpenAHI(void)

{
AHIPort=CreateMsgPort();
if (AHIPort)
   {
   AddPort(AHIPort);
   AHIReq=(struct AHIRequest*)CreateIORequest(AHIPort,sizeof(struct AHIRequest));
   if (AHIReq)
      {
      AHIReq->ahir_Version=4;
      OpenDev=OpenDevice(AHINAME,0,(IORequest*)AHIReq,NULL);
      if (OpenDev==0) return TRUE;
      else CloseAHI();
      }
   else CloseAHI();
   }
else CloseAHI();
return FALSE;
}



void main(int argc, char *argv[])

{
if (!OpenAHI())
   {
   CloseAHI();
   cout << "Can't open AHI-Device!\n";
   return;
   }
DBase=OpenLibrary("dos.library",39);
if (DBase)
   {
   SetTaskPri(FindTask(NULL),5);
   DoLoop=FALSE;
   if (argc>1)
      {
      strcpy(PathFR,argv[1]);
      if (argc>2) if (!strncmp(argv[2],"LOOP",4)) DoLoop=TRUE;
      }
   else strcpy(PathFR,"");
   cout << "\n";
   cout << "PLayL '020 V 1.0,  1999 by QXC & VWP\n";
   if (!(strcmp(PathFR,""))) 
      {
      ReqToolsBase=OpenLibrary("reqtools.library",0);
      if (ReqToolsBase)
         {
         MyFReq=(rtFileRequester*)rtAllocRequestA(RT_FILEREQ,NULL);
         if (MyFReq)
            {                  
            rtChangeReqAttr(MyFReq,0,TAG_DONE);
            do {
               strcpy(PathFR,FileName);
               a=rtFileRequest(MyFReq,PathFR,"Load AIFF",0,TAG_DONE);
               if (a)
                  {
                  cout << "\n";
                  strcpy(s,MyFReq->Dir);
                  strcpy(FileName,PathFR);
                  if (strlen(s)) if (!((s[strlen(s)-1]=='/') || (s[strlen(s)-1]==':')))
                     {
                     strcat(s,"/");
                     strcat(s,PathFR); 
                     strcpy(PathFR,s);        
                     }
                  else
                     {
                     strcat(s,PathFR);
                     strcpy(PathFR,s);
                     }
                  PLAYPLL(PathFR);
                  }                     
            } 
            while (a);
            rtFreeRequest(MyFReq);
            }
         CloseLibrary(ReqToolsBase);
         }
      else cout << "Couldn't open reqtools.library!\n";
      }
   else if (!(strcmp(PathFR,"?")))
      {
      cout << " \n   A sampleplayer for AIFF- and AIFC-samples and WTPL-playlists\n";
      cout << "   PLayL is FREEWARE\n";
      cout << "   Usage: PLayL <filename> for CLI-handling\n";
      cout << "          PLayL            for a filerequester\n";
      cout << "   PLayL supports playlists of the IFF-WTPL format. These playlists\n";
      cout << "   can be created using the WaveTracer DS softwarepackage wich is also\n";
      cout << "   developed by Virtual Worlds Productions\n\n";
      }
   else
      {
      PLAYPLL(PathFR);
      };
   cout << "\n";
   CloseAHI();
   CloseLibrary(DBase);
   }
else cout << "Couldnt open dos.library!\n";
}
