#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>



extern struct DOSBase *DOSBase;



struct VoiceHeader
   {
   char  VocID[20];
   UWORD DataOffset,Version,VersionKompl;
   };
struct NewVoiceBlock
   {
   UBYTE b1,b2,b3,SampleRate,Compression;
   };
struct SubsequentVoiceBlock
   {
   UBYTE b1,b2,b3;
   };
struct SilenceBlock
   {
   UBYTE b1,b2,b3;
   UWORD Delay;
   UBYTE SRate;
   };
struct ModeBlock
   {
   UBYTE b1,b2,b3,d1,d2,d3,d4;
   };
struct OtherBlock
   {
   UBYTE b1,b2,b3;
   };

VoiceHeader          VoiceHD;
NewVoiceBlock        NVBlk;
ModeBlock            MdBlk;
SubsequentVoiceBlock SubVBlk;
SilenceBlock         SilBlk;
OtherBlock           OtherBlk;

LONG  Addr24[3];
LONG  l,m,MemLS,MemLSX,Loaded,MemLLoad;
APTR  MemALoad;
WORD  i,j;
UBYTE BType,ChCnt,ChBit,ChID,b,MyChannels;
BOOL  MDBlock,StBlock;



/*void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}*/



BOOL GETSAVEMEM(void)

{
MemLLoad=(100032/ChCnt)*ChCnt;
MemALoad=AllocVec(MemLLoad,MEMF_FAST);
if (!MemALoad)
   {
   l=AvailMem(MEMF_LARGEST)-640;
   MemLLoad=((ULONG)(MemLLoad/ChCnt))*ChCnt;
   if (MemLLoad<640) return FALSE;
   MemALoad=AllocVec(MemLLoad,MEMF_FAST);
   if (!MemALoad) return FALSE;
   }
return TRUE;
}



LONG DECODE(UBYTE b1, UBYTE b2, UBYTE b3)

{
LONG   l;

l=b1 + (b2*0x100)+ (b3*0x10000);
return l;
};



UWORD SWAP16(UWORD w1)

{
UWORD w2;

w2=((w1 & 0xFF00)/256)+((w1 & 0x00FF)*256);
return w2;
}



BOOL READHEADER(void)


{
LONG TheSize;


MyChannels=CH_CENTER;
MemLS=0;   MDBlock=FALSE;   StBlock=FALSE;
Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
Read(MyWTStdMsg->ActFHandle,&VoiceHD,sizeof(VoiceHeader));
if (strncmp(VoiceHD.VocID,"Creative Voice File",19))
   {
   MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
   return FALSE;
   }
Seek(MyWTStdMsg->ActFHandle,SWAP16(VoiceHD.DataOffset),OFFSET_BEGINNING);
if (SWAP16(VoiceHD.Version)>266)
   {
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Unknown VOC-Version!");
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Try to load it?");
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"Cancel");
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"");
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"Load");
   MESSAGEHANDLE();   
   if (MyWTStdMsg->WTMsgPrc->PRC_Long1!=3)
      {
      MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
      return FALSE;
      }
   }
do
   {
   l=Read(MyWTStdMsg->ActFHandle,&BType,1);
   if (BType==0)
      {
      }
   else if (BType==1)
      {
      l=Read(MyWTStdMsg->ActFHandle,&NVBlk,5);
      TheSize=DECODE(NVBlk.b1,NVBlk.b2,NVBlk.b3)-5+3;
      if (!StBlock) MyWTStdMsg->SRate=(LONG)(-(NVBlk.SampleRate-256.0)/0.28);
      StBlock=TRUE;
         //   Voc=256-0,28*SRate
         //
         //             Voc-256
         //   SRate= - ---------
         //               0,28
      if (NVBlk.Compression!=0)
         {
         MyWTStdMsg->Flags=0;
         MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Unknown Compression-method!");
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Try to load it?");
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"Cancel");
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"");
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"Load");
         MESSAGEHANDLE();   
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1!=3)
            {
            MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
            return FALSE;
            }
         }
      MemLS=MemLS+TheSize;
      Seek(MyWTStdMsg->ActFHandle,TheSize,OFFSET_CURRENT);
      }
   else if (BType==2)
      {
      l=Read(MyWTStdMsg->ActFHandle,&SubVBlk,3);
      TheSize=DECODE(SubVBlk.b1,SubVBlk.b2,SubVBlk.b3);
      MemLS=MemLS+TheSize;
      m=Seek(MyWTStdMsg->ActFHandle,TheSize,OFFSET_CURRENT);
      }
   else if (BType==3)
      {
      l=Read(MyWTStdMsg->ActFHandle,&SilBlk,6);
      TheSize=DECODE(SilBlk.b1,SilBlk.b2,SilBlk.b3)-6+3;
      MemLS=MemLS+TheSize;
      m=Seek(MyWTStdMsg->ActFHandle,TheSize,OFFSET_CURRENT);
      }
   else if (BType==8)
      {
      MDBlock=TRUE;
      l=Read(MyWTStdMsg->ActFHandle,&MdBlk,7);
      TheSize=DECODE(MdBlk.b1,MdBlk.b2,MdBlk.b3)-7+3;
      if ((MdBlk.d1 & 0xF0)==0xA0) MyChannels=CH_LEFT+CH_RIGHT
      else if ((MdBlk.d1 & 0xF0)==0x50) MyChannels=CH_CENTER;
      m=Seek(MyWTStdMsg->ActFHandle,TheSize,OFFSET_CURRENT);
      }
   else if (BType>8) return FALSE
   else
      {
      l=Read(MyWTStdMsg->ActFHandle,&OtherBlk,3);
      TheSize=DECODE(OtherBlk.b1,OtherBlk.b2,OtherBlk.b3);
      if (TheSize>0) Seek(MyWTStdMsg->ActFHandle,TheSize,OFFSET_CURRENT) else TheSize=-1;
      }
   }
while ((BType!=0) && (l!=0) && (TheSize!=-1));
MyWTStdMsg->Flags=MDE_READY;
return TRUE;
}



BOOL READDATA(void)

{
LONG   l,m,Addr8;
UBYTE  i;
UBYTE *Data8;
LONG  *Data1;


//l=Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
if ((Loaded+MemLS/ChCnt)>MyWTStdMsg->ActWaveOp->Operator[0])
   {
   MemLS=(MyWTStdMsg->ActWaveOp->Operator[0]-Loaded)*ChCnt;
   if (MemLS<ChCnt) return FALSE;
   }
//MemLLoad=MemLS;
if (!GETSAVEMEM()) return FALSE;
l=0;
do
   {
   m=MemLS-l;
   if (m>MemLLoad) m=MemLLoad;
   l=l+Read(MyWTStdMsg->ActFHandle,MemALoad,MemLLoad);
   Addr8=(LONG)MemALoad;
   do
      {
      ChBit=1;
      for (i=0; i<3; i++)
         {
         if ((MyChannels & ChBit)==ChBit)
            {
            Data8=(UBYTE*)Addr8;      Addr8++;
            Data1=(LONG*)(Addr24[i]); Addr24[i]=Addr24[i]+4;
            *Data1=(*Data8-127)*65530;
            }
         ChBit=ChBit*2;
         }
      }
   while (Addr8<(LONG)MemALoad+m);
   }
while (l<MemLS);
Loaded=Loaded+(l/ChCnt);
FreeVec(MemALoad);
return TRUE;
}



BOOL LOADVOC(void)

{
LONG TheSize;


l=Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
for (i=0; i<3; i++) Addr24[i]=MyWTStdMsg->MemA24[i];
Loaded=0;
l=Read(MyWTStdMsg->ActFHandle,&VoiceHD,sizeof(VoiceHeader));
l=Seek(MyWTStdMsg->ActFHandle,SWAP16(VoiceHD.DataOffset),OFFSET_BEGINNING);
do
   {
   l=Read(MyWTStdMsg->ActFHandle,&BType,1);
   if (BType==0)
      {
      }
   else if (BType==1)
      {
      l=Read(MyWTStdMsg->ActFHandle,&NVBlk,5);
      MemLS=DECODE(NVBlk.b1,NVBlk.b2,NVBlk.b3)-5+3;
      if (MemLS>0)
         {
         if (!READDATA()) return FALSE;
         }
      }
   else if (BType==2)
      {
      l=Read(MyWTStdMsg->ActFHandle,&SubVBlk,3);
      MemLS=DECODE(SubVBlk.b1,SubVBlk.b2,SubVBlk.b3);
      if (MemLS>0)
         {
         if (!READDATA()) return FALSE;
         }
      }
   else if (BType==3)
      {
      l=Read(MyWTStdMsg->ActFHandle,&SilBlk,6);
      //MemLS=10;
      //if (!READDATA()) return FALSE;
      Loaded=Loaded+SWAP16(SilBlk.Delay);
      if (MyChannels==CH_CENTER)
         {
         Addr24[2]=Addr24[2]+SWAP16(SilBlk.Delay)*4
         }
      else
         {
         Addr24[0]=Addr24[0]+SWAP16(SilBlk.Delay)*4;
         Addr24[1]=Addr24[1]+SWAP16(SilBlk.Delay)*4;
         }
      if ((Loaded+MemLS/ChCnt)>MyWTStdMsg->ActWaveOp->Operator[0])
         {
         Loaded=MyWTStdMsg->ActWaveOp->Operator[0];
         return TRUE;
         }
      }
   else
      {
      l=Read(MyWTStdMsg->ActFHandle,&OtherBlk,3);
      TheSize=DECODE(OtherBlk.b1,OtherBlk.b2,OtherBlk.b3);
      if (TheSize>0) Seek(MyWTStdMsg->ActFHandle,TheSize,OFFSET_CURRENT) else TheSize=-1;
      }
   }
while ((BType!=0) && (l!=0) && (TheSize!=-1));
return TRUE;
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
if (DOSBase)
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Creative Voice File 2.0 Stereo 8 Bit Loader");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               if (READHEADER())
                  {
                  if (!MDBlock)
                     {
                     do
                        {
                        MyWTStdMsg->Flags=0;
                        MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_CHANNELREQ;
                        strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Incomplete VOC-file, please select existing channels!");
                        MyWTStdMsg->WTMsgPrc->PRC_Long1=0x7;
                        MyWTStdMsg->WTMsgPrc->PRC_Long2=MyWTStdMsg->UsedChannels;
                        MESSAGEHANDLE();
                        MyChannels=MyWTStdMsg->WTMsgPrc->PRC_Long1;
                        if ((MyChannels==CH_LEFT) || (MyChannels==CH_RIGHT)) MyChannels=CH_CENTER;
                        }
                     while ((MyChannels==0) && (MyChannels>CH_CENTER));
                     }
                  if (MyChannels==CH_CENTER)
                     {
                     MyWTStdMsg->ActiveMode=MD_MONO;
                     ChCnt=1;
                     }
                  else if (MyChannels==CH_LEFT+CH_RIGHT)
                     {
                     MyWTStdMsg->ActiveMode=MD_STEREO;
                     ChCnt=2;
                     }
                  MyWTStdMsg->ActiveChannels=MyChannels;
                  MyWTStdMsg->ActWaveOp->Operator[0]=MemLS/ChCnt;
                  MyWTStdMsg->ActWaveOp->Operator[1]=1;
                  MyWTStdMsg->Flags=MDE_READY;
                  }
               else MyWTStdMsg->Flags=MDE_NOTMYFORMAT;               
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (READHEADER())
                  {
                  if (MDBlock)
                     {
                     if (MyWTStdMsg->ActiveMode==MD_MONO)
                        {
                        MyChannels=(MyWTStdMsg->ActiveChannels & (CH_CENTER));
                        ChCnt=1;
                        }
                     else
                        {
                        MyChannels=(MyWTStdMsg->ActiveChannels & (CH_LEFT+CH_RIGHT));
                        ChCnt=2;
                        }
                     }
                  if (MyChannels==0) MyWTStdMsg->Flags=MDE_CHANNELERROR else
                     {
                     if (LOADVOC()) MyWTStdMsg->Flags=MDE_READY else MyWTStdMsg->Flags=MDE_ERROR;
                     Loaded=Loaded*4;
                     }
                  }
               else MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   CloseLibrary((Library*)DOSBase);
   }
}
