#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>


extern struct DOSBase *DOSBase;

struct IFFHeader
   {
   char  IFFID[4];
   ULONG IFFLength;
   char  IFFType[4];
   };
struct IFFChunk
   {
   char  ChunkID[4];
   ULONG ChunkLength;
   };
struct VoiceHeader
   {
   ULONG OneShotHiSamples,RepeatHiSamples,SamplesPerHiCycle;
   UWORD SamplesPerSec;
   UBYTE CtOctave1,SCompression1,FixedVolume1;
   UBYTE CtOctave2,SCompression2,FixedVolume2;
   };
struct SXHeader
   {
   UBYTE SampleDepth,FixedVolume;
   ULONG SoundLength,PlayRate,Flags;
   UBYTE UsedChannels,UsedMode;
   ULONG PlayFreq;
   UWORD pad;
   };
struct ADSRHeader
   {
   LONG Attack,Decay,Sustain,Release;
   };
struct DPANHeader
   {
   UWORD Version,Frames;
   UBYTE FPS,pad1,pad2,pad3;
   };
struct COMMHeader
   {
   WORD   ChannelNum;      //numChannels
   ULONG  numSampleFrames; // (Anzahl der Samples)
   WORD   sampleSize;      // Bits
   char   sampleRate[10];      //PlayFreq, 80 Bit
   ULONG  Compression;
   };

struct SSNDHeader
   {
   LONG  Offset,Blocksize;
   };

#define IFF_NORMAL 1
#define IFF_ANIM   2
#define IFF_AIFF   3

IFFHeader    IFFHd;
IFFChunk     IFFCh;
VoiceHeader  VHDR;
SXHeader     SXHD;
ADSRHeader   ADSR;
DPANHeader   DPAN;
COMMHeader   COMM;
SSNDHeader   SSND;

SDBodyScene *MySDBodyScene;
SDBodyAnim  *MySDBodyAnim;

UBYTE        BitsCnt;
BYTE         IFFType,ChBit,ChID,ChCnt,SaveID,FirstChn;
BOOL         StartFound,Def;
LONG         Addr24[6];
LONG         MyMode,MyChannels,MemLS,Load,l,m,i,Size,SampleCompression,SampleRes,
             SampleDepth,MemLLoad,Loaded;
APTR         MemALoad;
char         s[250];
ULONG        Addr1,Addr2,Addr8,Addr16,RealLength,AlphaLS,AlphaOffset;
BYTE        *Data8;
WORD        *Data16;
LONG        *Data1,*Data2;
BYTE         Bits[161];



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}


void Decode80(char ps[10], double *pd)

{
struct IEEE_DBL
   {
   LONG hi,lo;
   };
struct SANE_EXT
   {
   ULONG l1,l2;
   UWORD s1;
   };
   
ULONG    top2bits;
IEEE_DBL *p_dbl;
SANE_EXT *p_ext;


p_dbl = (IEEE_DBL *) pd;
p_ext = (SANE_EXT *) ps;
top2bits = p_ext->l1 & 0xc0000000;
p_dbl->hi = ((p_ext->l1 << 4) & 0x3ff00000) | top2bits;
p_dbl->hi |= (p_ext->l1 << 5) & 0xffff0;
p_dbl->hi |= (p_ext->l2 >> 27) & 0x1f;
p_dbl->lo = (p_ext->l2 << 5) & 0xffffffe0;
p_dbl->lo |= (ULONG) ((p_ext->s1 >> 11) & 0x1f);
}



BOOL GETSAVEMEM(void)

{
MemLLoad=(100032/ChCnt)*ChCnt;
MemALoad=AllocVec(MemLLoad,MEMF_FAST);
if (!MemALoad)
   {
   l=AvailMem(MEMF_LARGEST);
   if (l>MemLLoad) l=MemLLoad;
   MemLLoad=l;
   MemLLoad=((ULONG)(MemLLoad/ChCnt))*ChCnt;
   MemALoad=AllocVec(MemLLoad,MEMF_FAST);
   if (!MemALoad) return FALSE;
   }
return TRUE;
}



void DECODEDELTA2(void)

{
/*var FibArr32            :array [-45..45] of long;
var i                   :integer;
var DataBefore,AddrE    :long;


procedure INITFIB;

begin
   FibArr32[-1]:=0;
   FibArr32[0]:=1;
   for i:=1 to 45 do FibArr32[i]:=FibArr32[i-1]+FibArr32[i-2];
   FibArr32[0]:=0;
   for i:=1 to 45 do FibArr32[-i]:=-FibArr32[i];
end;


begin
   with MyWTStdMsg^ do begin
      INITFIB;
      ChBit:=1;
      for ChID:=1 to 6 do begin
         if not ((MyChannels and ActiveChannels) and ChBit=0)
          and (MemA24[ChID]<>0) and (FirstChn<>ChID) then begin
            Addr1:=MemA24[FirstChn];
            Addr2:=MemA24[ChID];
            Addr8:=MemA24[ChID]+MemLS*3;
            AddrE:=MemA24[ChID]+MemLS*4;
            DataBefore:=0;
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data2:=ptr(Addr2); Addr2:=Addr2+4;
               Data8:=ptr(Addr8); Addr8:=Addr8+1;
               DataBefore:=DataBefore-FibArr32[Data8^];
               Data2^:=Data1^-DataBefore;
            until (Addr8>=AddrE) or (Addr2>=MemA24[ChID]+MemL24);
         end;
         ChBit:=ChBit*2;
      end;
      PlayL24:=MemLS*4;
   end;
end;*/
}



BOOL READHEADER(BOOL LoadNow)

{
BOOL   OldSVX,SoundData;
LONG   SampleFreq;
double SampleDbl;


MyWTStdMsg->Flags=0;
MemLS=0;
OldSVX=FALSE;
MyChannels=CH_LEFT;
Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
Read(MyWTStdMsg->ActFHandle,&IFFHd,12);
if (!(strncmp(IFFHd.IFFID,"FORM",4)))
   {
   MyMode=0;
   if (!(strncmp(IFFHd.IFFType,"8SVX",4))) OldSVX=TRUE else OldSVX=FALSE;
   if ((!(strncmp(IFFHd.IFFType,"8SVX",4))) || (!(strncmp(IFFHd.IFFType,"16SV",4))) ||
       (!(strncmp(IFFHd.IFFType,"16SX",4))) || (!(strncmp(IFFHd.IFFType,"24SX",4))) ||
       (!(strncmp(IFFHd.IFFType,"HISX",4))) || (!(strncmp(IFFHd.IFFType,"AIFF",4))) ||
       (!(strncmp(IFFHd.IFFType,"AIFC",4))))
      {
      if ((!(strncmp(IFFHd.IFFType,"AIFF",4))) || (!(strncmp(IFFHd.IFFType,"AIFC",4))))
       IFFType=IFF_AIFF else IFFType=IFF_NORMAL;
      SampleCompression=0;
      do
         {
         l=Read(MyWTStdMsg->ActFHandle,&IFFCh,8);
         if (!(strncmp(IFFCh.ChunkID,"VHDR",4)))
            {
            Load=Read(MyWTStdMsg->ActFHandle,&VHDR,IFFCh.ChunkLength);
            MemLS=VHDR.OneShotHiSamples+VHDR.RepeatHiSamples;
            if (VHDR.RepeatHiSamples!=0)
               {
               MyWTStdMsg->Sustain=VHDR.OneShotHiSamples;
               MyWTStdMsg->Release=MemLS;
               }
            MyWTStdMsg->SRate=(LONG)(10000000.0/(VHDR.SamplesPerSec*2.79365));
            if (OldSVX)
               {
               SampleRes=8;  SampleDepth=8;
               }
            else
               {
               SampleRes=16; SampleDepth=16;
               }
            SampleCompression=VHDR.SCompression1;
            }
         else if (!(strncmp(IFFCh.ChunkID,"CHAN",4)))
            {
            Load=Read(MyWTStdMsg->ActFHandle,&Size,IFFCh.ChunkLength);
            MyChannels=0;
            if ((Size & 1)==1) MyChannels=CH_SLEFT;
            if ((Size & 2)==2) MyChannels=MyChannels+CH_LEFT;
            if ((Size & 4)==4) MyChannels=MyChannels+CH_RIGHT;
            if ((Size & 8)==8) MyChannels=MyChannels+CH_CENTER;
            if ((Size & 32)==32) MyChannels=MyChannels+CH_SUB;
            MyMode=0;
            }
         else if (!(strncmp(IFFCh.ChunkID,"SXHD",4)))
            {
            Load=Read(MyWTStdMsg->ActFHandle,&SXHD,IFFCh.ChunkLength);
            if ((SXHD.SampleDepth>=1) && (SXHD.SampleDepth<=8))
               {
               MemLS=SXHD.SoundLength;   SampleRes=8;
               }
            else if ((SXHD.SampleDepth>=9) && (SXHD.SampleDepth<=16))
               {
               MemLS=SXHD.SoundLength/2; SampleRes=16;
               }
            else if (SXHD.SampleDepth>=17)
               {
               MemLS=SXHD.SoundLength/4; SampleRes=24;
               }
            SampleDepth=SXHD.SampleDepth;
            SampleCompression=SXHD.Flags & 0xFF;
            MyWTStdMsg->SRate=SXHD.PlayRate;
            MyChannels=SXHD.UsedChannels;
            MyMode=SXHD.UsedMode;
            }
         else if (!(strncmp(IFFCh.ChunkID,"ADSR",4)))
            {
            Load=Read(MyWTStdMsg->ActFHandle,&ADSR,IFFCh.ChunkLength);
            MyWTStdMsg->Attack=ADSR.Attack;
            MyWTStdMsg->Decay=ADSR.Decay;
            MyWTStdMsg->Sustain=ADSR.Sustain;
            MyWTStdMsg->Release=ADSR.Release;
            }
         else if (!(strncmp(IFFCh.ChunkID,"ACHN",4)))
            {
            if (!LoadNow)
               {
               MyWTStdMsg->Flags=0;
               MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SPECIAL_DATA_FOUND;
               MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_ALPHA_CHANNEL;
               MyWTStdMsg->WTMsgPrc->PRC_Long2=IFFCh.ChunkLength;
               MESSAGEHANDLE();
               }
            else if (MemLS!=0)
               {
               AlphaLS=MemLS/20;
               ChBit=1;
               for (ChID=1; ChID<=6; ChID++)
                  {
                  if (((MyChannels & ChBit)==ChBit) && (MyWTStdMsg->MemAAlpha[ChID-1]))
                     {
                     l=Read(MyWTStdMsg->ActFHandle,APTR(MyWTStdMsg->MemAAlpha[ChID-1]),AlphaLS);
                     IFFCh.ChunkLength=IFFCh.ChunkLength-l;
                     }
                  ChBit=ChBit*2;
                  }
               }
            l=Seek(MyWTStdMsg->ActFHandle,IFFCh.ChunkLength,OFFSET_CURRENT);
            }
         else if (!(strncmp(IFFCh.ChunkID,"DPAN",4)))
            {
            Load=Read(MyWTStdMsg->ActFHandle,&DPAN,IFFCh.ChunkLength);
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ALLOC_SPECIAL_DATA;
            MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_ANIMINFO;
            MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
            MESSAGEHANDLE();
            if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr)
               {
               MySDBodyAnim=(SDBodyAnim*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
               MySDBodyAnim->sdb_SDHeader.NextSpecialData=NULL;
               MySDBodyAnim->sdb_SDHeader.sdh_Size=sizeof(SDBodyAnim);
               MySDBodyAnim->sdb_SDHeader.sdh_Type=SD_ANIMINFO;
               MySDBodyAnim->sdb_Frames=DPAN.Frames;
               MySDBodyAnim->sdb_FPS=DPAN.FPS;
               MySDBodyAnim->sdb_Flags=0;
               MySDBodyAnim->sdb_pad=0;
               MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SPECIAL_DATA_FOUND;
               MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_ANIMINFO;
               MyWTStdMsg->WTMsgPrc->PRC_NewPtr=MySDBodyAnim;
               MESSAGEHANDLE()
               }
            }
         else if ((!(strncmp(IFFCh.ChunkID,"ANIM",4))) && (LoadNow))
            {
            Load=Read(MyWTStdMsg->ActFHandle,&s,IFFCh.ChunkLength);
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ADDANIMPATH;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,s);
            MESSAGEHANDLE();
            }
         else  if ((!(strncmp(IFFCh.ChunkID,"WTSZ",4))) && (LoadNow))
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ALLOC_SPECIAL_DATA;
            MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_SCENE;
            MESSAGEHANDLE();
            if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr)
               {
               MySDBodyScene=(SDBodyScene*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
               MySDBodyScene->sdb_SDHeader.NextSpecialData=NULL;
               MySDBodyScene->sdb_SDHeader.sdh_Size=sizeof(SDBodyScene);
               MySDBodyScene->sdb_SDHeader.sdh_Type=SD_SCENE;
               strcpy(MySDBodyScene->sdb_Name,"");
               MySDBodyScene->sdb_StartFrame=0;
               MySDBodyScene->sdb_EndFrame=0;
               MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SPECIAL_DATA_FOUND;
               MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_SCENE;
               MyWTStdMsg->WTMsgPrc->PRC_NewPtr=MySDBodyScene;
               MESSAGEHANDLE();
               Load=Read(MyWTStdMsg->ActFHandle,&MySDBodyScene->sdb_Name,208);
               }
            else l=Seek(MyWTStdMsg->ActFHandle,IFFCh.ChunkLength,OFFSET_CURRENT);
            }
         else if (!(strncmp(IFFCh.ChunkID,"COMM",4)))
            {
            COMM.Compression=0;
            Load=Read(MyWTStdMsg->ActFHandle,&COMM,IFFCh.ChunkLength);
            if (COMM.Compression>0) SampleCompression=0xFFFF;
            MemLS=COMM.numSampleFrames;
            SampleRes=COMM.sampleSize;
            ChCnt=COMM.ChannelNum;
            if (COMM.ChannelNum==1) MyMode=MD_MONO
            else if (COMM.ChannelNum==2) MyMode=MD_STEREO
            else if (COMM.ChannelNum==3) MyMode=MD_3CH
            else if (COMM.ChannelNum==4) MyMode=MD_SURROUND
            else if (COMM.ChannelNum==5) MyMode=MD_AC3_Sub
            else if (COMM.ChannelNum==6) MyMode=MD_AC3
            else
               {
               SENDERROR("Too much audiochannels in AIFF-file!");
               MyWTStdMsg->Flags=MDE_ERROR;
               return FALSE;
               }
            Decode80(COMM.sampleRate,&SampleDbl);
            SampleFreq=(LONG)SampleDbl;
            if (SampleFreq<60) SampleFreq=60 else if (SampleFreq>60000) SampleFreq=60000;
            MyWTStdMsg->SRate=(LONG)(10000000.0/(SampleFreq*2.79365));
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETCHANNELBITS;
            MyWTStdMsg->WTMsgPrc->PRC_Long1=MyMode;
            MESSAGEHANDLE();
            if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)MyChannels=CH_LEFT
             else MyChannels=MyWTStdMsg->WTMsgPrc->PRC_Long1;
            }
         else if ((strncmp(IFFCh.ChunkID,"BODY",4)) && (strncmp(IFFCh.ChunkID,"SSND",4)))
          Load=Seek(MyWTStdMsg->ActFHandle,IFFCh.ChunkLength,OFFSET_CURRENT);
         }
      while ((strncmp(IFFCh.ChunkID,"BODY",4)) && (strncmp(IFFCh.ChunkID,"SSND",4)) && (l>=8));
      if (IFFType==IFF_NORMAL)
         {
         if ((l<8) || (IFFCh.ChunkLength==0))
            {
            SENDERROR("Corrupt IFF-format! Can't find BODY-chunk!");
            MyWTStdMsg->Flags=MDE_ERROR;
            return FALSE;
            }
         if (((OldSVX) && (SampleCompression>COMPRESSION_FIBONACCI_DELTA)) ||
             ((SampleCompression>COMPRESSION_3BYTE+COMPRESSION_DELTA) && (SampleCompression>COMPRESSION_3BYTE+COMPRESSION_DELTA_2)))
            {
            SENDERROR("Unknown compression-method!");
            MyWTStdMsg->Flags=MDE_ERROR;
            return FALSE;
            }
         if (SampleRes==8)
            {
            MyWTStdMsg->Attack=MyWTStdMsg->Attack*4;
            MyWTStdMsg->Decay=MyWTStdMsg->Decay*4;
            MyWTStdMsg->Sustain=MyWTStdMsg->Sustain*4;
            MyWTStdMsg->Release=MyWTStdMsg->Release*4;
            }
         else if (SampleRes==16)
            {
            MyWTStdMsg->Attack=MyWTStdMsg->Attack*2;
            MyWTStdMsg->Decay=MyWTStdMsg->Decay*2;
            MyWTStdMsg->Sustain=MyWTStdMsg->Sustain*2;
            MyWTStdMsg->Release=MyWTStdMsg->Release*2;
            }
         }
      else
         {
         if ((l<8) || (IFFCh.ChunkLength==0))
            {
            SENDERROR("File corrupt! Can't find SSND-chunk!");
            MyWTStdMsg->Flags=MDE_ERROR;
            return FALSE;
            }
         else
            {
            Read(MyWTStdMsg->ActFHandle,&SSND,sizeof(SSNDHeader));
            Seek(MyWTStdMsg->ActFHandle,SSND.Offset,OFFSET_CURRENT);
            }
         if (SampleRes>32)
            {
            SENDERROR("Unknown sample-resolution (>32 Bit)!!");
            MyWTStdMsg->Flags=MDE_ERROR;
            return FALSE;
            }
         }
      }
   else if (!(strncmp(IFFHd.IFFType,"ANIM",4)))
      {
      IFFType=IFF_ANIM;
      SoundData=FALSE;
      MyWTStdMsg->Flags=0;
      MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ALLOC_SPECIAL_DATA;
      MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_ANIMINFO;
      MESSAGEHANDLE();
      if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr)
         {
         MySDBodyAnim=(SDBodyAnim*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
         MySDBodyAnim->sdb_SDHeader.NextSpecialData=NULL;
         MySDBodyAnim->sdb_SDHeader.sdh_Size=sizeof(SDBodyAnim);
         MySDBodyAnim->sdb_SDHeader.sdh_Type=SD_ANIMINFO;
         MySDBodyAnim->sdb_FPS=0;
         }
      do
         {
         l=Read(MyWTStdMsg->ActFHandle,&IFFCh,8);
         if (IFFCh.ChunkLength%2==1) IFFCh.ChunkLength++;
         if (l)
            {
            if (!(strncmp(IFFCh.ChunkID,"FORM",4)))
               {
               if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr) MySDBodyAnim->sdb_Frames++;
               l=Seek(MyWTStdMsg->ActFHandle,4,OFFSET_CURRENT)
               }
            else if (!(strncmp(IFFCh.ChunkID,"SXHD",4)))
               {
               SoundData=TRUE;
               Load=Read(MyWTStdMsg->ActFHandle,&SXHD,IFFCh.ChunkLength);
               MemLS=0;
               if ((SXHD.SampleDepth>=1) && (SXHD.SampleDepth<=8))
                  {
                  MemLS=SXHD.SoundLength;   SampleRes=8;
                  }
               else if ((SXHD.SampleDepth>=9) && (SXHD.SampleDepth<=16))
                  {
                  MemLS=SXHD.SoundLength/2; SampleRes=16;
                  }
               else if (SXHD.SampleDepth>=17)
                  {
                  MemLS=SXHD.SoundLength/4; SampleRes=24;
                  }
               SampleDepth=SXHD.SampleDepth;
               SampleCompression=(SXHD.Flags & 0xFF);  
               MyWTStdMsg->SRate=SXHD.PlayRate;
               MyChannels=SXHD.UsedChannels;
               MyMode=SXHD.UsedMode
               }
            else if (!(strncmp(IFFCh.ChunkID,"SBDY",4)))
               {
               l=IFFCh.ChunkLength;
               if (MyMode==MD_STEREO) l=l/2;
               else if (MyMode==MD_3CH) l=l/3;
               else if (MyMode==MD_QUADRO) l=l/4;
               else if (MyMode==MD_SURROUND) l=l/4;
               else if (MyMode==MD_AC3_Sub) l=l/5;
               else if (MyMode==MD_AC3) l=l/6;
               if (SampleDepth==16) l=l/2
               else if (SampleDepth==24) l=l/3;
               MemLS=MemLS+l;
               l=Seek(MyWTStdMsg->ActFHandle,IFFCh.ChunkLength,OFFSET_CURRENT);
               }
            else if (!(strncmp(IFFCh.ChunkID,"DPAN",4)))
               {
               Load=Read(MyWTStdMsg->ActFHandle,&DPAN,IFFCh.ChunkLength);
               if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr) MySDBodyAnim->sdb_FPS=DPAN.FPS;
               }
            else l=Seek(MyWTStdMsg->ActFHandle,IFFCh.ChunkLength,OFFSET_CURRENT);
            }
         }
      while (l>0);
      if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr)
         {
         MyWTStdMsg->Flags=0;
         MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SPECIAL_DATA_FOUND;
         MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_ANIMINFO;
         MyWTStdMsg->WTMsgPrc->PRC_NewPtr=MySDBodyAnim;
         MESSAGEHANDLE()
         }
      if (!SoundData)
         {
         SENDERROR("ANIM-file doesn't contains sounddata!");
         MyWTStdMsg->Flags=MDE_ERROR;
         return FALSE;
         }
      }
   else
      {
      strcpy(s,"No sound-IFF (");
      strncat(s,IFFHd.IFFType,4);
      strcat(s,") !");
      SENDERROR(s);
      MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
      return FALSE;
      }
   if (MyChannels==0) MyChannels=CH_LEFT;
   if (MyMode==0)
      {
      if ((MyChannels==CH_LEFT) || (MyChannels==CH_RIGHT) || (MyChannels==CH_CENTER)) MyMode=MD_MONO
      else if (MyChannels<=CH_LEFT+CH_RIGHT) MyMode=MD_STEREO
      else if (MyChannels<=CH_LEFT+CH_RIGHT+CH_CENTER) MyMode=MD_3CH
      else if (MyChannels<=CH_LEFT+CH_RIGHT+CH_CENTER+CH_SLEFT) MyMode=MD_SURROUND
      else if (MyChannels<=CH_LEFT+CH_RIGHT+CH_CENTER+CH_SLEFT+CH_SRIGHT) MyMode=MD_AC3_Sub
      else MyMode=MD_AC3;
      }
   }
else
   {
   MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
   return FALSE;
   }
MyWTStdMsg->Flags=MDE_READY;
return TRUE;
}



void FIBONACCI(ULONG SAddr, ULONG MemLS, ULONG MemL)

{
BYTE   FibArray[16]={-34,-21,-13,-8,-5,-3,-2,-1,0,1,2,3,5,8,13,21};
ULONG  Addr1,Addr2;
UBYTE *Data1,*Data2;
UBYTE  DataBefore;

Addr1=SAddr+MemL-MemLS;
Addr2=SAddr+MemL-(MemLS/2)-2;
DataBefore=0;
Data2=(UBYTE*)(Addr2); Addr2++;
Data2=(UBYTE*)(Addr2); Addr2++;
DataBefore=*Data2;
do
   {
   Data2=(UBYTE*)(Addr2); Addr2++;
   Data1=(UBYTE*)(Addr1); Addr1++;
   DataBefore=DataBefore+FibArray[(*Data2 & 0xF0)/16];
   *Data1=DataBefore;
   Data1=(UBYTE*)(Addr1); Addr1++;
   DataBefore=DataBefore+FibArray[(*Data2 & 0x0F)];
   *Data1=DataBefore;
   }
while ((Addr2<SAddr+MemL) && (Addr1<Addr2));
}



void LOADANIM(void)

{
LONG LoadedData,m,n,Factor;
BYTE i;


if (SampleDepth==8) MyWTStdMsg->PlayL24=MemLS*4;
LoadedData=0;
l=Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
l=Read(MyWTStdMsg->ActFHandle,&IFFHd,12);
do
   {
   l=Read(MyWTStdMsg->ActFHandle,&IFFCh,8);
   if (IFFCh.ChunkLength%2==1) IFFCh.ChunkLength++;
   if (l)
      {
      if (!(strncmp(IFFCh.ChunkID,"FORM",4))) l=Seek(MyWTStdMsg->ActFHandle,4,OFFSET_CURRENT)
      else if (!(strncmp(IFFCh.ChunkID,"SBDY",4)))
         {
         if ((MyMode==MD_MONO) && (MyWTStdMsg->MemA24[2]))
            {
            if (IFFCh.ChunkLength>MemLS-LoadedData)
               {
               l=0;
               IFFCh.ChunkLength=MemLS-LoadedData;
               }
            l=Read(MyWTStdMsg->ActFHandle,(APTR)(MyWTStdMsg->MemA24[2]+MyWTStdMsg->PlayL24-MemLS+LoadedData),IFFCh.ChunkLength);
            LoadedData=LoadedData+IFFCh.ChunkLength;
            }
         else if ((MyWTStdMsg->MemA24[0]) && (MyWTStdMsg->MemA24[1]))
            {
            m=IFFCh.ChunkLength/2;
            if (m>MemLS-LoadedData)
               {
               l=0;
               m=MemLS-LoadedData;
               }
            if (SampleCompression==COMPRESSION_INTERLEAVED)
             n=Read(MyWTStdMsg->ActFHandle,(APTR)(MyWTStdMsg->MemA24[0]+MyWTStdMsg->PlayL24-MemLS*2+LoadedData*2),m*2);
            else
               {
               n=Read(MyWTStdMsg->ActFHandle,(APTR)(MyWTStdMsg->MemA24[0]+MyWTStdMsg->PlayL24-MemLS+LoadedData),m);
               n=Seek(MyWTStdMsg->ActFHandle,(IFFCh.ChunkLength/2)-m,OFFSET_CURRENT);
               n=Read(MyWTStdMsg->ActFHandle,(APTR)(MyWTStdMsg->MemA24[1]+MyWTStdMsg->PlayL24-MemLS+LoadedData),m);
               }
            LoadedData=LoadedData+m;
            }
         }
      else l=Seek(MyWTStdMsg->ActFHandle,IFFCh.ChunkLength,OFFSET_CURRENT);
      }
   }
while (l>0);
if (SampleDepth==8)
   {
   Factor=MAX24/128;
   if ((SampleCompression==COMPRESSION_INTERLEAVED) && (MyMode==MD_STEREO))
      {
      // Daten DeInterleaven nur, wenn nicht Mono
      Addr8=MyWTStdMsg->MemA24[0]+MyWTStdMsg->PlayL24-MemLS*2;
      Addr1=MyWTStdMsg->MemA24[0];
      Addr2=MyWTStdMsg->MemA24[1];
      do
         {
         Data8=(BYTE*)(Addr8); Addr8++;
         Data1=(LONG*)(Addr1); Addr1=Addr1+4;
         *Data1=*Data8*Factor;
         if ((BitsCnt<160) && (SaveID==0))
            {
            if (StartFound)
               {
               Bits[BitsCnt]=(*Data8 & 1);
               BitsCnt++;
               }
            else if ((*Data8 & 1)==1) StartFound=TRUE;
            }
         Data8=(BYTE*)(Addr8); Addr8++;
         Data2=(LONG*)(Addr2); Addr2=Addr2+4;
         *Data2=*Data8*Factor;
         }
      while ((Addr8<MyWTStdMsg->MemA24[0]+MyWTStdMsg->PlayL24) && (Addr1<MyWTStdMsg->MemA24[0]+MyWTStdMsg->PlayL24));
      }
   else for (i=0; i<3; i++)
      {
      if (((MyMode==MD_MONO) && (i==2) && (MyWTStdMsg->MemA24[i])) ||
          ((MyMode==MD_STEREO) && (i<=1) && (MyWTStdMsg->MemA24[i])))
         {
         Addr8=MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24-MemLS;
         Addr1=MyWTStdMsg->MemA24[i];
         do
            {
            Data8=(BYTE*)(Addr8); Addr8++;
            Data1=(LONG*)(Addr1); Addr1=Addr1+4;
            *Data1=*Data8*Factor;
            if ((BitsCnt<160) && (SaveID==0))
               {
               if (StartFound)
                  {
                  Bits[BitsCnt]=(*Data8 & 1);
                  BitsCnt++;
                  }
               else if ((*Data8 & 1)==1) StartFound=TRUE;
               }
            }
         while ((Addr8<MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24) && (Addr1<MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24));
         }
      }
   }
else
   {
   SENDERROR("This Loader supports 8 Bit animsound only!");
   MyWTStdMsg->Flags=MDE_FILEERROR;
   return;
   }
MyWTStdMsg->Flags=MDE_READY;
}



void LOADDELTA1(ULONG SAddr)

{
LONG DataX;


l=Read(MyWTStdMsg->ActFHandle,(APTR)(SAddr+MyWTStdMsg->MemL24-MemLS),MemLS);
if (l<MemLS) Def=TRUE;
Addr8=SAddr+MyWTStdMsg->MemL24-MemLS;
Addr2=MyWTStdMsg->MemA24[FirstChn];
Addr1=SAddr;
do
   {
   Data1=(LONG*)(Addr1); Addr1=Addr1+4;
   *Data1=0;
   Data2=(LONG*)(Addr2); Addr2=Addr2+4;
   Data8=(BYTE*)(Addr8); Addr8++;
   DataX=(LONG)((*Data8*32.26)*(*Data8*32.26));
   if (*Data8<0) DataX=-(DataX);
   *Data1=*Data2+DataX;
   }
while ((Addr8<SAddr+MyWTStdMsg->MemL24) && (Addr1<SAddr+MemLS*4));
}



void LOADIFF(ULONG SAddr)

{
#define MAXREAL=MAX24*2;

ULONG  Addr24;
ULONG *Data24;
LONG   Factor,DataX;


Addr1=SAddr;      Def=FALSE;
if (SampleRes==8)
   {
   if ((SampleCompression & COMPRESSION_FIBONACCI_DELTA)==COMPRESSION_FIBONACCI_DELTA)
      {
      Addr8=SAddr+MyWTStdMsg->MemL24-(MemLS/2)-2;
      l=Read(MyWTStdMsg->ActFHandle,(APTR)(Addr8),(MemLS/2)+2);
      if (l<(MemLS/2)+2) Def=TRUE;
      FIBONACCI(SAddr,MemLS,MyWTStdMsg->MemL24);
      Addr8=SAddr+MyWTStdMsg->MemL24-MemLS;
      }
   else
      {
      Addr8=SAddr+MyWTStdMsg->MemL24-MemLS;
      l=Read(MyWTStdMsg->ActFHandle,(APTR)(Addr8),MemLS);
      if (l<MemLS) Def=TRUE;
      }
   Factor=MAX24/128;
   do
      {
      Data8=(BYTE*)(Addr8); Addr8++;
      Data1=(LONG*)(Addr1); Addr1=Addr1+4;
      *Data1=*Data8*Factor;
      if ((BitsCnt<160) && (SaveID==0))
         {
         if (StartFound)
            {
            Bits[BitsCnt]=(*Data8 & 1);
            BitsCnt++;
            }
         else if ((*Data8 & 1)==1) StartFound=TRUE;
         }
      }
   while ((Addr8<(SAddr+MyWTStdMsg->MemL24)) && (Addr1<(SAddr+MyWTStdMsg->MemL24)));
   if (RealLength>MemLS)
      {
      if ((SampleCompression & COMPRESSION_FIBONACCI_DELTA)==COMPRESSION_FIBONACCI_DELTA) l=Seek(MyWTStdMsg->ActFHandle,(((RealLength-MemLS)/2)+2),OFFSET_CURRENT);
      else l=Seek(MyWTStdMsg->ActFHandle,RealLength-MemLS,OFFSET_CURRENT)
      }
   }
else if (SampleRes==16)
   {
   if ((((SampleCompression & COMPRESSION_DELTA)==0) && ((SampleCompression & COMPRESSION_DELTA_2)==0)) ||
       ((SaveID==0) && (FirstChn<0)) || (FirstChn==ChID))
      {
      if (FirstChn<0) FirstChn=ChID;
      Addr16=SAddr+MyWTStdMsg->MemL24-(MemLS*2);
      l=Read(MyWTStdMsg->ActFHandle,(APTR)(Addr16),MemLS*2);
      if (l<MemLS*2) Def=TRUE;
      Factor=MAX24/32768;
      do
         {
         Data16=(WORD*)(Addr16); Addr16=Addr16+2;
         Data1=(LONG*)(Addr1);   Addr1=Addr1+4;
         *Data1=*Data16*Factor;
         if ( (BitsCnt<160) && (FirstChn==ChID))
            {
            if (StartFound)
               {
               Bits[BitsCnt]=(*Data16 & 1);
               BitsCnt++;
               }
            else if ((*Data16 & 1)==1) StartFound=TRUE;
            }
         }
      while ((Addr16<SAddr+MyWTStdMsg->MemL24) && (Addr1<SAddr+MyWTStdMsg->MemL24));
      }
   else if ((SampleCompression & COMPRESSION_DELTA)==COMPRESSION_DELTA) LOADDELTA1(SAddr);
   else if ((SampleCompression & COMPRESSION_DELTA_2)==COMPRESSION_DELTA_2)
      {
      l=Read(MyWTStdMsg->ActFHandle,(APTR)(SAddr+MyWTStdMsg->MemL24-(MemLS*2)),MemLS);
      }
   if (RealLength>MemLS) l=Seek(MyWTStdMsg->ActFHandle,(RealLength-MemLS)*2,OFFSET_CURRENT);
   }
else if (SampleRes==24)
   {
   if ((((SampleCompression & COMPRESSION_DELTA)==0) && ((SampleCompression & COMPRESSION_DELTA_2)==0)) ||
       ((SaveID==0) && (FirstChn<0)) || (FirstChn==ChID))
      {
      if (FirstChn<0) FirstChn=ChID;
      if ((SampleCompression & COMPRESSION_3BYTE)==0)
         {
         l=Read(MyWTStdMsg->ActFHandle,(APTR)(SAddr),MemLS*4);
         if (l<MemLS*4) Def=TRUE;
         Addr1=Addr1+MemLS*4;
         }
      else if ((SampleCompression & COMPRESSION_3BYTE)==COMPRESSION_3BYTE)
         {
         Addr24=SAddr+MyWTStdMsg->MemL24-(MemLS*3);
         l=Read(MyWTStdMsg->ActFHandle,(APTR)(Addr24),MemLS*3);
         if (l<MemLS*3) Def=TRUE;
         Addr24=Addr24-1;
         do
            {
            Data1=(LONG*)(Addr1);    Addr1=Addr1+4;
            Data24=(ULONG*)(Addr24); Addr24=Addr24+3;
            DataX=(LONG)(*Data24 & 0x00FFFFFF);
            *Data1=(DataX-MAX24);
            if ((BitsCnt<160) && (FirstChn==ChID))
               {
               if (StartFound)
                  {
                  Bits[BitsCnt]=(*Data1 & 1);
                  BitsCnt++;
                  }
               else if ((*Data1 & 1)==1) StartFound=TRUE;
               }
            }
         while ((Addr24<SAddr+MyWTStdMsg->MemL24) && (Addr1<SAddr+MyWTStdMsg->MemL24));
         }
      }
   else if ((SampleCompression & COMPRESSION_DELTA)==COMPRESSION_DELTA) LOADDELTA1(SAddr)
   else if ((SampleCompression & COMPRESSION_DELTA_2)==COMPRESSION_DELTA_2)
      {
      l=Read(MyWTStdMsg->ActFHandle,(APTR)(SAddr+MyWTStdMsg->MemL24-(MemLS*3)),MemLS);
      }
   if (RealLength>MemLS)
      {
      if ((SampleCompression & COMPRESSION_3BYTE)==COMPRESSION_3BYTE) l=Seek(MyWTStdMsg->ActFHandle,(RealLength-MemLS)*3,OFFSET_CURRENT)
      else l=Seek(MyWTStdMsg->ActFHandle,(RealLength-MemLS)*4,OFFSET_CURRENT);
      }
   }
if (Def)
   {
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Corrupt IFF-file!");
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Can't find all sounddata!");
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
   MESSAGEHANDLE();
   }
if (Addr1-SAddr>0) MyWTStdMsg->PlayL24=Addr1-SAddr;
MyWTStdMsg->Flags=MDE_READY;
}



void READDATA8(void)

{
BYTE *Data8;
ULONG Addr8;
BYTE  BitsChannel=-1;

MyWTStdMsg->Flags=MDE_NO_MEMORY;
MemLLoad=MemLS*ChCnt;
if (!GETSAVEMEM()) return;
Loaded=0;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   m=Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   if (m>0)
      {
      Loaded=Loaded+m;
      Addr8=(ULONG)MemALoad;
      do
         {
         ChBit=1;
         for (i=0; i<6; i++)
            {
            if (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
               {
               if ((MyWTStdMsg->MemA24[i]) && (Addr24[i]))
                  {
                  Data8=(BYTE*)(Addr8);     Addr8++;
                  Data1=(LONG*)(Addr24[i]); Addr24[i]=Addr24[i]+4;
                  *Data1=*Data8*65530;
                  if ((BitsCnt<160) && ((BitsChannel==i) || (BitsChannel<0)))
                     {
                     if (BitsChannel<0) BitsChannel=i;
                     if (StartFound)
                        {
                        Bits[BitsCnt]=(*Data8 & 0x1);
                        BitsCnt++;
                        }
                     else if ((*Data8 & 1)==1) StartFound=TRUE;
                     }
                  }
               else Addr8++;
               }
            ChBit=ChBit*2;
            }
         }
      while (Addr8<(ULONG)MemALoad+m);
      }
   }
while ((Loaded<MemLS*ChCnt) && (m!=0));
Loaded=Loaded/ChCnt*4;
MyWTStdMsg->Flags=MDE_READY;
}



void READDATA16(void)

{
WORD *Data16;
ULONG Addr16;
BYTE  BitsChannel=-1;

MyWTStdMsg->Flags=MDE_NO_MEMORY;
MemLS=MemLS*2;
MemLLoad=MemLS*ChCnt;
if (!GETSAVEMEM()) return;
Loaded=0;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   m=Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   if (m>0)
      {
      Loaded=Loaded+m;
      Addr16=(ULONG)MemALoad;
      do
         {
         ChBit=1;
         for (i=0; i<6; i++)
            {
            if (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
               {
               if ((MyWTStdMsg->MemA24[i]) && (Addr24[i]))
                  {
                  Data16=(WORD*)(Addr16);   Addr16=Addr16+2;
                  Data1=(LONG*)(Addr24[i]); Addr24[i]=Addr24[i]+4;
                  *Data1=*Data16*255;
                  if ((BitsCnt<160) && ((BitsChannel==i) || (BitsChannel<0)))
                     {
                     if (BitsChannel<0) BitsChannel=i;
                     if (StartFound)
                        {
                        Bits[BitsCnt]=(*Data16 & 0x0001);
                        BitsCnt++;
                        }
                     else if ((*Data16 & 1)==1) StartFound=TRUE;
                     }
                  }
               else Addr16=Addr16+2;
               }
            ChBit=ChBit*2;
            }
         }
      while (Addr16<(ULONG)MemALoad+m);
      }
   }
while ((Loaded<MemLS*ChCnt) && (m!=0));
Loaded=Loaded/ChCnt*2;
MyWTStdMsg->Flags=MDE_READY;
}



void READDATA24(void)

{
ULONG *Data24;
LONG   DataX;
ULONG  Addr_24;
BYTE   BitsChannel=-1;


MyWTStdMsg->Flags=MDE_NO_MEMORY;
MemLS=MemLS*3;
MemLLoad=MemLS*ChCnt;
if (!GETSAVEMEM()) return;
Loaded=0;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   m=Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   if (m>0)
      {
      Loaded=Loaded+m;
      Addr_24=((ULONG)MemALoad)-1;
      do
         {
         ChBit=1;
         for (i=0; i<6; i++)
            {
            if (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
               {
               if ((MyWTStdMsg->MemA24[i]) && (Addr24[i]))
                  {
                  Data24=(ULONG*)(Addr_24); Addr_24=Addr_24+3;
                  Data1=(LONG*)(Addr24[i]); Addr24[i]=Addr24[i]+4;
                  DataX=(*Data24 & 0x00FFFFFF);
                  *Data1=DataX-MAX24;
                  if ((BitsCnt<160) && ((BitsChannel==i) || (BitsChannel<0)))
                     {
                     if (BitsChannel<0) BitsChannel=i;
                     if (StartFound)
                        {
                        Bits[BitsCnt]=(*Data1 & 0x1);
                        BitsCnt++;
                        }
                     else if ((*Data1 & 0x1)==1) StartFound=TRUE;
                     }
                  }
               else Addr_24=Addr_24+3;
               }
            ChBit=ChBit*2;
            }
         }
      while (Addr_24<(ULONG)MemALoad+m);
      }
   }
while ((Loaded<MemLS*ChCnt) && (m!=0));
Loaded=((Loaded/ChCnt)/3)*4;
MyWTStdMsg->Flags=MDE_READY;
}



void READDATA32(void)

{
LONG *Data32;
ULONG Addr32;
BYTE  BitsChannel=-1;


MyWTStdMsg->Flags=MDE_NO_MEMORY;
MemLS=MemLS*4;
MemLLoad=MemLS*ChCnt;
if (!GETSAVEMEM()) return;
Loaded=0;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   m=Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   if (m>0)
      {
      Loaded=Loaded+m;
      Addr32=(ULONG)MemALoad;
      do
         {
         ChBit=1;
         for (i=0; i<6; i++)
            {
            if (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
               {
               if ((MyWTStdMsg->MemA24[i]) && (Addr24[i]))
                  {
                  Data32=(LONG*)(Addr32);   Addr32=Addr32+4;
                  Data1=(LONG*)(Addr24[i]); Addr24[i]=Addr24[i]+4;
                  *Data1=*Data32/256;
                  if ((BitsCnt<160) && ((BitsChannel==i) || (BitsChannel<0)))
                     {
                     if (BitsChannel<0) BitsChannel=i;
                     if (StartFound)
                        {
                        Bits[BitsCnt]=(*Data32 & 0x00000001);
                        BitsCnt++;
                        }
                     else if ((*Data32 & 1)==1) StartFound=TRUE;
                     }
                  }
               else Addr32=Addr32+4;
               }
            ChBit=ChBit*2;
            }
         }
      while (Addr32<(ULONG)MemALoad+m);
      }
   }
while ((Loaded<MemLS*ChCnt) && (m!=0));
Loaded=Loaded/ChCnt;
MyWTStdMsg->Flags=MDE_READY;
}



void LOADAIFF(void)

{
for (i=0; i<6; i++) Addr24[i]=MyWTStdMsg->MemA24[i];
MemALoad=NULL; MemLLoad=0; ChCnt=0; ChBit=1;
for (i=0; i<6; i++)
   {
   if ((MyChannels & ChBit)==ChBit) ChCnt++;
   ChBit=ChBit*2;
   }
if (SampleRes<=8) READDATA8()
else if (SampleRes<=16) READDATA16()
else if (SampleRes<=24) READDATA24()
else READDATA32();
if (MemALoad) FreeVec(MemALoad);
}



void GETCOPYRIGHT(void)

{
char  CString[25]="";
UBYTE CharCnt,BitValue,CharID;
WORD  i;


CharID=0;
CString[20]=(char)0;
for (CharCnt=0; CharCnt<20; CharCnt++)
   {
   BitValue=1;
   i=0;
   for (BitsCnt=1; BitsCnt<=8; BitsCnt++)
      {
      if (Bits[CharID]>0) i=(i | BitValue);
      CharID++;
      BitValue=BitValue*2;
      }
   CString[CharCnt]=(char)(i);
   }
StartFound=TRUE;
for (i=0; i<20; i++)
 if (!(((UBYTE)CString[i]>=32) && (((UBYTE)CString[i]<=127)) ||
      (((UBYTE)CString[i]>=161) && ((UBYTE)CString[i]<=254)))) StartFound=FALSE;
if (StartFound)
   {
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Hidden copyright found:");
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,CString);
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
   strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
   MESSAGEHANDLE();
   MyWTStdMsg->Flags=MDE_READY;
   }
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
if (DOSBase)
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"IFF 5.1 Loader (8SVX, 16SV, HISX, ANIM, AIFF, AIFC, Alpha)");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               if (READHEADER(FALSE))
                  {
                  MyWTStdMsg->ActiveMode=MyMode;
                  MyWTStdMsg->ActiveChannels=MyChannels;
                  MyWTStdMsg->ActWaveOp->Operator[0]=MemLS;
                  MyWTStdMsg->ActWaveOp->Operator[1]=1;
                  }
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (READHEADER(TRUE))
                  {
                  if (MyWTStdMsg->ActWaveOp->Operator[0]<MemLS)
                     {
                     RealLength=MemLS;
                     MemLS=MyWTStdMsg->ActWaveOp->Operator[0];
                     }
                  if ((MyChannels & MyWTStdMsg->ActiveChannels)==0) MyWTStdMsg->Flags=MDE_CHANNELERROR
                  else if (IFFType==IFF_NORMAL)
                     {
                     MyWTStdMsg->Flags=MDE_READY;
                     ChBit=1; SaveID=0; FirstChn=-1;
                     if (((SampleCompression & COMPRESSION_DELTA_2)==COMPRESSION_DELTA_2) &&
                         ((MyChannels & CH_CENTER)==CH_CENTER)) FirstChn=2;
                     for (ChID=0; ChID<6; ChID++)
                        {
                        if ((((MyChannels & MyWTStdMsg->ActiveChannels) & ChBit)==ChBit) &&
                            (MyWTStdMsg->MemA24[ChID]))
                           {
                           BitsCnt=0; StartFound=FALSE;
                           LOADIFF(MyWTStdMsg->MemA24[ChID]);
                           SaveID++;
                           }
                        ChBit=ChBit*2;
                        }
                     if ((SampleCompression & COMPRESSION_DELTA_2)==COMPRESSION_DELTA_2) DECODEDELTA2();
                     MyWTStdMsg->PlayL24=MemLS*4;
                     }
                  else if (IFFType==IFF_AIFF)
                     {
                     if ((MyChannels & MyWTStdMsg->ActiveChannels)==0) MyWTStdMsg->Flags=MDE_CHANNELERROR
                     else
                        {
                        if (MyWTStdMsg->ActWaveOp->Operator[0]<MemLS) MemLS=MyWTStdMsg->ActWaveOp->Operator[0];
                        MyChannels=(MyChannels & MyWTStdMsg->ActiveChannels);    
                        BitsCnt=0; StartFound=FALSE;
                        LOADAIFF();
                        MyWTStdMsg->PlayL24=Loaded;
                        }
                     }
                  else if (IFFType==IFF_ANIM) LOADANIM();
                  if (MyWTStdMsg->Flags==MDE_READY) GETCOPYRIGHT();
                  }
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   CloseLibrary((Library*)DOSBase);
   }
}
