program LOADER;

Uses ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"};
{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
       "EffIncl.mod"}


type r_InstrData=record
        Name                    :string[22];
        Length                  :word;
        Voices,Volume           :byte;
        RepeatHiSamples,Repeats :word
    end;
type r_InstrInfo=record
        Volume          :byte;
        Length,Loop     :word;
        InstrAddr       :long;
     end;

type r_PatData=record
        Note    :array [0..63,1..4] of long;
     end;
type r_PatInfo=record;
        InstrNum,FX,FXVal       :array [0..63,1..4] of byte;
        PlayRate                :array [0..63,1..4] of word;
     end;

var DWindow             :^Window;
var DKnopf              :array [1..2] of Gadget;
var RawCode,GadCode     :byte;
var IMsg                :^IntuiMessage;
var XGadget             :^Gadget;

var InstrData           :r_InstrData;
var InstrInfo           :array[1..31] of r_InstrInfo;
var PatData             :r_PatData;
var PatInfo             :r_PatInfo;

var Leave,DoPattern,MsgGone             :boolean;
var CalcSize,DosPatPos,DosInstrPos,
    SpaceSize,MaxInstrSize,
    InstrMemA,InstrMemL,BeginOffset,
    EndOffset                           :long;
var SongLength,PlaySpeed,Patterns       :byte;
var PatPlay                             :array [1..128] of byte;
var s                                   :string;

var l,Addr8,AddrX,Addr1,Addr2,LoopA,
    LoopL                               :long;
var SongPos                             :array [1..4] of long;
var Data1,Data2                         :^long;
var Data8,DataX                         :^short;
var i,j,k,m                             :integer;
var Step,Stepsize,SmoothStep            :real;
var ActEntry                            :PlayListEntry;
var ActPattern                          :PlayListPattern;


procedure SETPARAMETERS;

begin
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition SoundTracker 8 Bit 4.0 Surround Loader ( by QXC & VWP)',
                        '','','','',75,0,0,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      DKnopf[1]:=Gadget(NIL,500,40,128,16,GADGHCOMP+GADGIMAGE,$3,BOOLGADGET,WTImg^.GImg5,
                        NIL,WTImg^.OKIText,0,NIL,1,0);
      DKnopf[2]:=Gadget(NIL,20,42,21,12,GADGHIMAGE+GADGIMAGE,$3+TOGGLESELECT,BOOLGADGET,
                        WTImg^.ButtonImg1,WTImg^.ButtonImg2,NIL,0,Nil,2,0);
      WRITE(45,42,2,0,DWindow^,'Playliste verwenden');

      for i:=1 to 2 do AddGadget(DWindow,^DKnopf[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(DWindow^.UserPort);
         If IMsg<>Nil Then begin
            if (IMsg^.class in [GADGETDOWN,GADGETUP]) then begin
               XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg);
            MsgGone:=true;
         End else MsgGone:=false;

      Until (GadCode=1) or (RawCode=68);
      if RawCode=68 then begin
         DKnopf[1].flags:=DKnopf[1].flags or SELECTED;
         RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
         delay(5);
      end;
      with ActWaveOp^ do if (DKnopf[1].Flags and SELECTED=0)
       then Operator[4]:=0 else Operator[4]:=1;
      CloseWindow(DWindow);
      Flags:=MDE_READY;
   end;
end;



function CHECKST:long;

begin
   CHECKST:=0;
   with MyWTStdMsg^ do begin
      l:=DosSeek(ActFHandle,20,OFFSET_BEGINNING);        {*** TITLE ***}
      i:=1; CalcSize:=154;
      repeat                                          {*** INSTRUMENTS ***}
         l:=DosRead(ActFHandle,^InstrData,sizeof(r_InstrData));
         with InstrInfo[i] do if InstrData.Length>0 then begin
            Volume:=InstrData.Volume;
            Length:=InstrData.Length;        CalcSize:=CalcSize+Length*2;
            Loop:=InstrData.RepeatHiSamples; InstrAddr:=0;
         end else Length:=0;
         i:=i+1;
      until i=32;
      l:=DosRead(ActFHandle,^SongLength,1);
      l:=DosRead(ActFHandle,^PlaySpeed,1);
      l:=DosRead(ActFHandle,^PatPlay[1],128);
      l:=DosSeek(ActFHandle,4,OFFSET_CURRENT);
      l:=DosSeek(ActFHandle,0,OFFSET_END);
      l:=DosSeek(ActFHandle,l,OFFSET_BEGINNING);
      Patterns:=(l-CalcSize) div 1024;
      CHECKST:=round((10000000/(MyWTStdMsg^.SRate*2.79365))*Patterns*7.5);
   end;
end;



procedure LOADST;

begin
   with MyWTStdMsg^ do begin
      if ActWaveOp^.Operator[4]=1 then begin
         Flags:=0;
         WTMsgPrc^:=MsgPrc(WTM_FREEPLAYLIST,'','','','','',0,0,0,0,0,NIL);
         MESSAGEHANDLE;
      end;

      l:=DosSeek(ActFHandle,20,OFFSET_BEGINNING);        {*** TITLE ***}
      i:=1; CalcSize:=154;
      repeat                                          {*** INSTRUMENTS ***}
         l:=DosRead(ActFHandle,^InstrData,sizeof(r_InstrData));
          with InstrInfo[i] do if InstrData.Length>0 then begin
            Volume:=InstrData.Volume;
            Length:=InstrData.Length;        CalcSize:=CalcSize+Length*2;
            Loop:=InstrData.RepeatHiSamples; InstrAddr:=0;
         end else Length:=0;
         i:=i+1;
      until i=32;
      l:=0;
      for i:=1 to 31 do with InstrInfo[i] do begin
         InstrAddr:=l;
         l:=l+Length*2
      end;
      l:=DosRead(ActFHandle,^SongLength,1);
      l:=DosRead(ActFHandle,^PlaySpeed,1);
      l:=DosRead(ActFHandle,^PatPlay[1],128);
      l:=DosSeek(ActFHandle,4,OFFSET_CURRENT);
      l:=DosSeek(ActFHandle,0,OFFSET_END);
      l:=DosSeek(ActFHandle,l,OFFSET_BEGINNING);
      Patterns:=(l-CalcSize) div 1024;
      DosPatPos:=DosSeek(ActFHandle,0,OFFSET_END);
      DosInstrPos:=DosPatPos+1024*Patterns;
      SpaceSize:=round((10000000/(MyWTStdMsg^.SRate*2.79365))*0.12)*4;
      BeginOffset:=0; EndOffset:=0;
      for i:=1 to 4 do SongPos[i]:=MemA24[i];
      i:=1;
      Leave:=false;
      while (i<=SongLength) and not Leave do begin
         DoPattern:=true;
         if (i>1) and (ActWaveOp^.Operator[4]=1) then begin
            m:=1;
            repeat
               if PatPlay[i]=PatPlay[m] then DoPattern:=false;
               m:=m+1;
            until (m>=i) or not DoPattern;
            if not DoPattern then begin
               s:='Pattern #'+intstr(PatPlay[i]);
               if ActEntry^.Name=s then ActEntry^.Loop:=ActEntry^.Loop+1 else begin
                  ActPattern:=FirstPlayListPattern;
                  repeat
                     ActPattern:=ActPattern^.NextPattern;
                  until ActPattern^.Name=s;
                  Flags:=0;
                  WTMsgPrc^:=MsgPrc(WTM_ADDENTRY,'','','','','',$0FFFFFFF,0,0,0,0,NIL);
                  MESSAGEHANDLE;
                  ActEntry:=WTMsgPrc^.PRC_NewPtr;
                  if ActEntry=NIL then begin
                     Flags:=MDE_NO_MEMORY;
                     exit;
                  end;
                  ActEntry^.BeginOffset:=ActPattern^.BeginOffset;
                  ActEntry^.EndOffset:=ActPattern^.EndOffset;
                  ActEntry^.Name:=ActPattern^.Name;
                  ActEntry^.Rate:=SRate;
                  ActEntry^.Loop:=1;
                  ActEntry^.VolumeL:=64;
                  ActEntry^.VolumeR:=64;
               end;
            end;
         end;
         if DoPattern then with PatInfo do begin
            l:=DosSeek(ActFHandle,(DosPatPos+1024*PatPlay[i]),OFFSET_BEGINNING);
            l:=DosRead(ActFHandle,^PatData,1024);
            BeginOffset:=SongPos[1]-MemA24[1];
            for j:=0 to 63 do for k:=1 to 4 do begin
               InstrNum[j,k]:=((PatData.Note[j,k] and $F0000000) div $FFFFFF0)+((PatData.Note[j,k] and $F000) div $FFF);
               PlayRate[j,k]:= (PatData.Note[j,k] and $0FFF0000) div $FFFF;
               FX[j,k]:=       (PatData.Note[j,k] and $00000F00) div $FF;
               FXVal[j,k]:=    (PatData.Note[j,k] and $000000FF);
            end;
            j:=0;
            repeat
               for k:=1 to 4 do if FX[j,k]=$D then j:=64;
               if j<64 then begin
                  k:=1;
                  repeat
                     if FX[j,k]=$F then begin  {*** FX Tempo ***}
                      SpaceSize:=round((10000000/(MyWTStdMsg^.SRate*2.79365))*0.02*FXVal[j,k])*4;
                     end;
                     if (InstrNum[j,k]>0) and (PlayRate[j,k]>0) then begin
                        if k=1 then begin
                           Flags:=0;
                           s:=intstr(i)+': Pattern #'+intstr(PatPlay[i])+', Position #'+intstr(j);
                           WTMsgPrc^:=MsgPrc(WTM_WORKINFO,s,'','','','',1,0,0,0,0,NIL);
                           MESSAGEHANDLE;
                        end;

                        Addr1:=SongPos[k];
                        InstrMemL:=InstrInfo[InstrNum[j,k]].Length*2;
                        InstrMemA:=AllocMem(InstrMemL,0);
                        if InstrMemA=0 then begin
                           Flags:=MDE_NO_MEMORY;
                           exit;
                        end;
                        l:=DosSeek(ActFHandle,(DosInstrPos+InstrInfo[InstrNum[j,k]].InstrAddr),OFFSET_BEGINNING);
                        l:=DosRead(ActFHandle,ptr(InstrMemA),InstrMemL);
                        Addr8:=InstrMemA;
                        Step:=0;
                        Stepsize:=abs(SRate/PlayRate[j,k]);
                        MaxInstrSize:=InstrMemL;
                        if j<63 then begin
                           m:=j+1;
                           repeat
                              if (InstrNum[m,k]>0) or (m=63) then begin
                                 MaxInstrSize:=SpaceSize*(m-j);
                                 m:=63;
                              end;
                              m:=m+1;
                           until (m>63);
                        end;
                        repeat
                           AddrX:=Addr8+round(Step);
                           SmoothStep:=Step-round(Step);
                           Step:=Step+Stepsize;
                           Data1:=ptr(Addr1);   Addr1:=Addr1+4;
                           Data8:=ptr(AddrX);
                           if (SmoothStep<0)then begin
                              DataX:=ptr(AddrX-1);
                              Data1^:=32768*round((DataX^*(-SmoothStep))+(Data8^*(1+SmoothStep)));
                           end else if SmoothStep>0 then begin
                              DataX:=ptr(AddrX+1);
                              Data1^:=32768*round((Data8^*(1-SmoothStep))+(DataX^*SmoothStep));
                           end else Data1^:=Data8^*32768;
                           if InstrInfo[InstrNum[j,k]].Volume<64
                            then Data1^:=round(Data1^/64*InstrInfo[InstrNum[j,k]].Volume);
                        until (round(Step)>=InstrMemL)
                           or (round(Step)>=MaxInstrSize)
                           or (Addr1>=MemA24[k]+MemL24);
                        FreeMem(InstrMemA,InstrMemL);
                        with InstrInfo[InstrNum[j,k]] do if Loop>0 then begin
                           LoopL:=round((Length-Loop)*2/Stepsize)*4;
                           LoopA:=SongPos[k]+round(Loop*2/Stepsize)*4;
                           while LoopA+LoopL<MemA24[k]+MemL24 do begin
                              if LoopA+LoopL+LoopL>MemA24[k]+MemL24
                               then l:=MemA24[k]+MemL24-LoopA-LoopL
                               else l:=LoopL;
                              CopyMem(LoopA,LoopA+LoopL,l);
                              LoopA:=LoopA+LoopL;
                              LoopL:=l;
                           end;
                        end;
                     end;
                     if FX[j,k]=$C then begin    {*** FX Volume ***}
                        Addr1:=SongPos[k];
                        repeat
                           Data1:=ptr(Addr1); Addr1:=Addr1+4;
                           Data1^:=Data1^ div 64 * FXVal[j,k];
                        until Addr1>=SongPos[k]+SpaceSize;
                     end;
                     SongPos[k]:=SongPos[k]+SpaceSize;
                     if SongPos[k]>=MemA24[k]+MemL24 then Leave:=true;
                     k:=k+1;
                  until (k>4);
                  j:=j+1;
               end;
            until (j>63) or Leave;
            EndOffset:=SongPos[1]-MemA24[1];
            if EndOffset>MemL24 then EndOffset:=MemL24;
            if ActWaveOp^.Operator[4]=1 then begin
               Flags:=0;
               WTMsgPrc^:=MsgPrc(WTM_ADDPATTERN,'','','','','',0,0,0,0,0,NIL);
               MESSAGEHANDLE;
               ActPattern:=WTMsgPrc^.PRC_NewPtr;
               if ActPattern=NIL then begin
                  Flags:=MDE_NO_MEMORY;
                  exit;
               end;
               ActPattern^.BeginOffset:=BeginOffset;
               ActPattern^.EndOffset:=EndOffset;
               ActPattern^.Name:='Pattern #'+intstr(PatPlay[i]);
               Flags:=0;
               WTMsgPrc^:=MsgPrc(WTM_ADDENTRY,'','','','','',$0FFFFFFF,0,0,0,0,NIL);
               MESSAGEHANDLE;
               ActEntry:=WTMsgPrc^.PRC_NewPtr;
               if ActEntry=NIL then begin
                  Flags:=MDE_NO_MEMORY;
                  exit;
               end;
               ActEntry^.BeginOffset:=BeginOffset;
               ActEntry^.EndOffset:=EndOffset;
               ActEntry^.Name:=ActPattern^.Name;
               ActEntry^.Rate:=SRate;
               ActEntry^.Loop:=1;
               ActEntry^.VolumeL:=64;
               ActEntry^.VolumeR:=64;
            end;
         end;
         i:=i+1;
      end;
      Flags:=0;
{      WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'Channel-Conversion','','','','',1,0,0,0,0,NIL);
      MESSAGEHANDLE;
      if (MemA24[2]<>0) and (MemA24[3]<>0) then begin
         Addr1:=MemA24[2]; Addr2:=MemA24[3];
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data2:=ptr(Addr2); Addr2:=Addr2+4;
            Data1^:=Data1^+Data2^;
            Data2^:=0;
         until Addr1>=MemA24[2]+MemL24;
      end;
      if (MemA24[1]<>0) and (MemA24[4]<>0) then begin
         Addr1:=MemA24[1]; Addr2:=MemA24[4];
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data2:=ptr(Addr2); Addr2:=Addr2+4;
            Data1^:=Data1^+Data2^;
            Data2^:=0;
         until Addr1>=MemA24[1]+MemL24;
      end;}

      Flags:=MDE_READY;
   end;
end;



begin
   OpenLib(DosBase,'dos.library',0);
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_LOADER) then begin
      with MyWTStdMsg^ do if Version=VERSION_LOADER then begin
         if Flags=MDC_ASKREADY then begin
            if DataValid=$BADBAD then SETPARAMETERS else begin
               ActWaveOp^.Operator[1]:=0;
               Flags:=0;
               WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'SoundTracker 8 Bit 4.0 Surround Loader, ',
                                 COPYRIGHT,'','OK','',0,0,0,0,0,NIL);
               MESSAGEHANDLE;
               Flags:=MDE_READY;
            end;
         end else if ActFHandle<>0 then begin
            if Flags=MDC_DEFINEIT then begin
               l:=CHECKST;
               if l>0 then begin
                  ActWaveOp^.Operator[1]:=l;
                  ActWaveOp^.Operator[2]:=1;
                  ActiveMode:=MD_SURROUND;
                  ActiveChannels:=CH_LEFT+CH_RIGHT+CH_CENTER+CH_SLEFT;
                  Flags:=MDE_READY;
               end else Flags:=MDE_NOTMYFORMAT;
            end else if Flags=MDC_DOIT then LOADST;
         end else Flags:=MDE_ERROR;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
   CloseLib(DosBase);
end.
