#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <iostream.h>


extern struct DOSBase *DOSBase;
struct IntuitionBase *IntuitionBase;

struct r_InstrData
   {
   char  Name[22];
   UWORD Length;
   UBYTE Voices,Volume;
   UWORD RepeatHiSamples,Repeats;
   };
struct r_InstrInfo
   {
   UBYTE Volume;
   UWORD Length,Loop;
   LONG  InstrAddr;
   };
struct r_PatData
   {
   LONG Note[64][4];
   };
struct r_PatInfo
   {
   UBYTE InstrNum[64][4],FX[64][4],FXVal[64][4];
   UWORD PlayRate[64][4];
   };


r_InstrData InstrData;
r_InstrInfo InstrInfo[31];
r_PatData   PatData;
r_PatInfo   PatInfo;

BOOL   Leave,DoPattern,MsgGone;
LONG   CalcSize,DosPatPos,DosInstrPos,SpaceSize,MaxInstrSize,InstrMemL,
       BeginOffset,EndOffset,l,Addr8,Addr1,Addr2,LoopA,LoopL,SongPos[4];
APTR   InstrMemA;
UBYTE  SongLength,PlaySpeed,Patterns;
UBYTE  PatPlay[128];
LONG  *Data1,*Data2;
BYTE  *Data8;
WORD   i,j,k,m;
FLOAT  Step,Stepsize;
PlayListEntry   *ActEntry;
PlayListPattern *ActPattern;



void WRITE(UWORD LEdge, UWORD TEdge, UBYTE StPen, UBYTE DMode, Window *Wind, char *txt)

{
IntuiText IT1={StPen,0,0,LEdge,TEdge,Wind->WScreen->Font,txt,NULL};

if (DMode==3) IT1.LeftEdge=LEdge-(IntuiTextLength(&IT1) / 2);
PrintIText(Wind->RPort,&IT1,0,0);
}



LONG CHECKST(void)

{
LONG i,l;


Seek(MyWTStdMsg->ActFHandle,20,OFFSET_BEGINNING);        //*** TITLE ***
i=0; CalcSize=154;
do
   {                                                     //*** INSTRUMENTS ***
   Read(MyWTStdMsg->ActFHandle,&InstrData,sizeof(r_InstrData));
   if (InstrData.Length>0)
      {
      InstrInfo[i].Volume=InstrData.Volume;
      InstrInfo[i].Length=InstrData.Length;
      InstrInfo[i].Loop=InstrData.RepeatHiSamples;
      InstrInfo[i].InstrAddr=0;
      CalcSize=CalcSize+InstrInfo[i].Length*2;
      }
   else InstrInfo[i].Length=0;
   i++;
   }
while (i<31);
Read(MyWTStdMsg->ActFHandle,&SongLength,1);
Read(MyWTStdMsg->ActFHandle,&PlaySpeed,1);
Read(MyWTStdMsg->ActFHandle,&PatPlay[0],128);
Seek(MyWTStdMsg->ActFHandle,4,OFFSET_CURRENT);
l=Seek(MyWTStdMsg->ActFHandle,0,OFFSET_END);
l=Seek(MyWTStdMsg->ActFHandle,l,OFFSET_BEGINNING);
Patterns=(l-CalcSize)/1024;
return (LONG)((10000000.0/(MyWTStdMsg->SRate*2.79365))*Patterns*7.5);
}



void LOADST(void)

{
char s[20],s1[20];


if (MyWTStdMsg->ActWaveOp->Operator[3]==1)
   {
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_FREEPLAYLIST;
   MESSAGEHANDLE();
   }
Seek(MyWTStdMsg->ActFHandle,20,OFFSET_BEGINNING);   //*** TITLE ***
i=0; CalcSize=154;
do                                                  //*** INSTRUMENTS ***
   {
   Read(MyWTStdMsg->ActFHandle,&InstrData,sizeof(r_InstrData));
   if (InstrData.Length>0)
      {
      InstrInfo[i].Volume=InstrData.Volume;
      InstrInfo[i].Length=InstrData.Length;
      InstrInfo[i].Loop=InstrData.RepeatHiSamples;
      InstrInfo[i].InstrAddr=0;
      CalcSize=CalcSize+InstrInfo[i].Length*2;
      }
   else InstrInfo[i].Length=0;
   i++;
   }
while (i<31);
l=0;
for (i=0; i<31; i++)
   {
   InstrInfo[i].InstrAddr=l;
   l=l+InstrInfo[i].Length*2;
   }
Read(MyWTStdMsg->ActFHandle,&SongLength,1);
Read(MyWTStdMsg->ActFHandle,&PlaySpeed,1);
Read(MyWTStdMsg->ActFHandle,&PatPlay[0],128);
Seek(MyWTStdMsg->ActFHandle,4,OFFSET_CURRENT);
l=Seek(MyWTStdMsg->ActFHandle,0,OFFSET_END);
l=Seek(MyWTStdMsg->ActFHandle,l,OFFSET_BEGINNING);
Patterns=(l-CalcSize)/1024;
DosPatPos=Seek(MyWTStdMsg->ActFHandle,0,OFFSET_END);
DosInstrPos=DosPatPos+1024*Patterns;
SpaceSize=(LONG)((10000000.0/(MyWTStdMsg->SRate*2.79365))*0.12)*4;
BeginOffset=0; EndOffset=0;
for (i=0; i<4; i++)
   {
   SongPos[i]=MyWTStdMsg->MemA24[i];
   if (!(SongPos[i]))
      {
      MyWTStdMsg->Flags=MDE_NO_MEMORY;
      return;
      }
   }
i=0;
Leave=FALSE;
while ((i<=SongLength) && (!Leave))
   {
   DoPattern=TRUE;
   if ((i>0) && (MyWTStdMsg->ActWaveOp->Operator[3]==1))
      {
      m=0;
      do
         {
         if (PatPlay[i]==PatPlay[m]) DoPattern=FALSE;
         m++;
         }
      while ((m<i) && (DoPattern));
      if (!DoPattern)
         {
         strcpy(s,"Pattern #");
         inttostr(PatPlay[i],s1);
         strcat(s,s1);
         if (!(strcmp(ActEntry->Name,s))) ActEntry->Loop++ else
            {
            ActPattern=MyWTStdMsg->FirstPlayListPattern;
            do
               {
               ActPattern=ActPattern->NextPattern;
               }
            while (strcmp(ActPattern->Name,s));
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ADDENTRY;
            MyWTStdMsg->WTMsgPrc->PRC_Long1=0x0FFFFFFF;
            MESSAGEHANDLE();
            ActEntry=(PlayListEntry*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
            if (!ActEntry)
               {
               MyWTStdMsg->Flags=MDE_NO_MEMORY;
               return;
               }
            ActEntry->BeginOffset=ActPattern->BeginOffset;
            ActEntry->EndOffset=ActPattern->EndOffset;
            strcpy(ActEntry->Name,ActPattern->Name);
            ActEntry->Rate=MyWTStdMsg->SRate;
            ActEntry->Loop=1;
            ActEntry->VolumeL=64;
            ActEntry->VolumeR=64;
            }
         }
      }
   if (DoPattern) //with PatInfo. do begin
      {
      Seek(MyWTStdMsg->ActFHandle,(DosPatPos+1024*PatPlay[i]),OFFSET_BEGINNING);
      Read(MyWTStdMsg->ActFHandle,&PatData,1024);
      BeginOffset=SongPos[0]-MyWTStdMsg->MemA24[0];
      for (j=0; j<64; j++) for (k=0; k<4; k++)
         {
         PatInfo.InstrNum[j][k]=((PatData.Note[j][k] & 0xF0000000)/0xFFFFFF0)+((PatData.Note[j][k] & 0xF000)/0xFFF);
         PatInfo.PlayRate[j][k]= (PatData.Note[j][k] & 0x0FFF0000)/0xFFFF;
         PatInfo.FX[j][k]=       (PatData.Note[j][k] & 0x00000F00)/0xFF;
         PatInfo.FXVal[j][k]=    (PatData.Note[j][k] & 0x000000FF);
         }
      j=0;
      do
         {
         for (k=0; k<4; k++) if (PatInfo.FX[j][k]==0xD) j=64;
         if (j<64)
            {
            k=0;
            do
               {
               if (PatInfo.FX[j][k]==0xF)            // FX Tempo
                  {
                  SpaceSize=(LONG)((10000000.0/(MyWTStdMsg->SRate*2.79365))*0.02*PatInfo.FXVal[j][k])*4;
                  }
               if ((PatInfo.InstrNum[j][k]>0) && (PatInfo.PlayRate[j][k]>0))
                  {
                  if (k==0)
                     {
                     MyWTStdMsg->Flags=0;
                     inttostr(i,s);            strcat(s,": Pattern #");
                     inttostr(PatPlay[i],s1);  strcat(s,s1);
                     strcat(s,", Position #"); inttostr(j,s1);
                     strcat(s,s1);
                     MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
                     strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,s);
                     MyWTStdMsg->WTMsgPrc->PRC_Long1=1;
                     MESSAGEHANDLE();
                     }
                  Addr1=SongPos[k];
                  InstrMemL=InstrInfo[PatInfo.InstrNum[j][k]].Length*2;
                  InstrMemA=AllocVec(InstrMemL,0);
                  if (!InstrMemA)
                     {
                     MyWTStdMsg->Flags=MDE_NO_MEMORY;
                     return;
                     }
                  Seek(MyWTStdMsg->ActFHandle,(DosInstrPos+InstrInfo[PatInfo.InstrNum[j][k]].InstrAddr),OFFSET_BEGINNING);
                  Read(MyWTStdMsg->ActFHandle,InstrMemA,InstrMemL);
                  Addr8=(LONG)InstrMemA;
                  Step=0;
                  Stepsize=labs(MyWTStdMsg->SRate/PatInfo.PlayRate[j][k]);
                  MaxInstrSize=InstrMemL;
                  if (j<63)
                     {
                     m=j+1;
                     do
                        {
                        if ((PatInfo.InstrNum[m][k]>0) || (m==63))
                           {
                           MaxInstrSize=SpaceSize*(m-j);
                           m=63;
                           }
                        m++;
                        }
                     while (m<=63);
                     }
                  do
                     {
                     Data1=(LONG*)(Addr1);   Addr1=Addr1+4;
                     Data8=(BYTE*)(Addr8);   Addr8=(LONG)InstrMemA+(LONG)(Step);
                     Step=Step+Stepsize;
                     *Data1=*Data8*32767;
                     if (InstrInfo[PatInfo.InstrNum[j][k]].Volume<64)
                      *Data1=(LONG)(*Data1/64*InstrInfo[PatInfo.InstrNum[j][k]].Volume);
                     }
                  while (((LONG)(Step)<InstrMemL) && ((LONG)(Step)<MaxInstrSize) &&
                          (Addr1<MyWTStdMsg->MemA24[k]+MyWTStdMsg->MemL24) &&
                          (Addr1>MyWTStdMsg->MemA24[k]));
                  FreeVec(InstrMemA);
// with InstrInfo[InstrNum[j,k]] do 
                  if (InstrInfo[PatInfo.InstrNum[j][k]].Loop>0)
                     {
                     LoopL=(LONG)((InstrInfo[PatInfo.InstrNum[j][k]].Length-InstrInfo[PatInfo.InstrNum[j][k]].Loop)*2/Stepsize)*4;
                     LoopA=SongPos[k]+(LONG)(InstrInfo[PatInfo.InstrNum[j][k]].Loop*2/Stepsize)*4;
                     while (LoopA+LoopL<MyWTStdMsg->MemA24[k]+MyWTStdMsg->MemL24)
                        {
                        if (LoopA+LoopL+LoopL>MyWTStdMsg->MemA24[k]+MyWTStdMsg->MemL24)
                         l=MyWTStdMsg->MemA24[k]+MyWTStdMsg->MemL24-LoopA-LoopL
                         else l=LoopL;
                        CopyMem((APTR)LoopA,(APTR)(LoopA+LoopL),l);
                        LoopA=LoopA+LoopL;
                        LoopL=l;
                        }
                     }
                  }
               if (PatInfo.FX[j][k]==0xC)            // FX Volume
                  {
                  Addr1=SongPos[k];
                  do
                     {
                     Data1=(LONG*)(Addr1); Addr1=Addr1+4;
                     *Data1=*Data1/64*PatInfo.FXVal[j][k];
                     }
                  while (Addr1<SongPos[k]+SpaceSize);
                  }
               SongPos[k]=SongPos[k]+SpaceSize;
               if (SongPos[k]>=MyWTStdMsg->MemA24[k]+MyWTStdMsg->MemL24) Leave=TRUE;
               k++;
               }
            while (k<4);
            j++;
            };
         }
      while ((j<=63) && (!Leave));
      EndOffset=SongPos[0]-MyWTStdMsg->MemA24[0];
      if (EndOffset>MyWTStdMsg->MemL24) EndOffset=MyWTStdMsg->MemL24;
      if (MyWTStdMsg->ActWaveOp->Operator[3]==1)
         {
         MyWTStdMsg->Flags=0;
         MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ADDPATTERN;
         MESSAGEHANDLE();
         ActPattern=(PlayListPattern*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
         if (!ActPattern)
            {
            MyWTStdMsg->Flags=MDE_NO_MEMORY;
            return;
            };
         ActPattern->BeginOffset=BeginOffset;
         ActPattern->EndOffset=EndOffset;
         strcpy(s,"Pattern #");
         inttostr(PatPlay[i],s1);
         strcat(s,s1);
         strcpy(ActPattern->Name,s);
         MyWTStdMsg->Flags=0;
         MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ADDENTRY;
         MyWTStdMsg->WTMsgPrc->PRC_Long1=0x0FFFFFFF;
         MESSAGEHANDLE();
         ActEntry=(PlayListEntry*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
         if (!ActEntry)
            {
            MyWTStdMsg->Flags=MDE_NO_MEMORY;
            return;
            };
         ActEntry->BeginOffset=BeginOffset;
         ActEntry->EndOffset=EndOffset;
         strcpy(ActEntry->Name,ActPattern->Name);
         ActEntry->Rate=MyWTStdMsg->SRate;
         ActEntry->Loop=1;
         ActEntry->VolumeL=64;
         ActEntry->VolumeR=64;
         };
      };
   i++;
   }
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Channel-convert");
MyWTStdMsg->WTMsgPrc->PRC_Long1=1;
MESSAGEHANDLE();
cout << "A\n";
if ((MyWTStdMsg->MemA24[1]) && (MyWTStdMsg->MemA24[2]))
   {
cout << "B\n";
   Addr1=MyWTStdMsg->MemA24[1]; Addr2=MyWTStdMsg->MemA24[2];
   do
      {
      Data1=(LONG*)Addr1; Addr1=Addr1+4;
      Data2=(LONG*)Addr2; Addr2=Addr2+4;
      *Data1=*Data1+*Data2;
      *Data2=0;
      }
   while (Addr1<MyWTStdMsg->MemA24[1]+MyWTStdMsg->MemL24);
cout << "C\n";
   }
if ((MyWTStdMsg->MemA24[0]) && (MyWTStdMsg->MemA24[3]))
   {
cout << "D\n";
   Addr1=MyWTStdMsg->MemA24[0]; Addr2=MyWTStdMsg->MemA24[3];
   do
      {
      Data1=(LONG*)Addr1; Addr1=Addr1+4;
      Data2=(LONG*)Addr2; Addr2=Addr2+4;
      *Data1=*Data1+*Data2;
      *Data2=0;
      }
   while (Addr1<MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24);
cout << "E\n";
   }
MyWTStdMsg->Flags=MDE_READY;
cout << "F\n";
};



void SETPARAMETERS(void)

{
Window *DWindow;
Gadget  DKnopf[2]={NULL,500,40,128,16,GADGHCOMP+GADGIMAGE,0x3,BOOLGADGET,MyWTStdMsg->WTImg->GImg5,
                   NULL,MyWTStdMsg->WTImg->OKIText,0,NULL,1,0,
                   NULL,20,42,21,12,GADGHIMAGE+GADGIMAGE,0x3+TOGGLESELECT,BOOLGADGET,MyWTStdMsg->WTImg->ButtonImg1,
                   MyWTStdMsg->WTImg->ButtonImg2,NULL,0,NULL,2,0};
BYTE    RawCode,GadCode,i;
Gadget *XGadget;
IntuiMessage *IMsg;


MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Definition SoundTracker 8 Bit 4.0 Surround Loader");
MyWTStdMsg->WTMsgPrc->PRC_Long1=75;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=0;
MyWTStdMsg->WTMsgPrc->PRC_Long4=0;
MyWTStdMsg->WTMsgPrc->PRC_Long5=0;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!(MyWTStdMsg->WTMsgPrc->PRC_NewPtr)))
   {
   MyWTStdMsg->Flags=MDE_ERROR;
   return
   }
DWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
WRITE(45,42,2,0,DWindow,"Use Playlist");
for (i=0; i<2; i++) AddGadget(DWindow,&DKnopf[i],NULL);
if (MyWTStdMsg->ActWaveOp->Operator[3]==1) DKnopf[1].Flags=DKnopf[1].Flags+SELECTED;
RefreshGadgets(DWindow->FirstGadget,DWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(DWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class==GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      }
   else Delay(1);
   }
while ((GadCode!=1) && (RawCode!=68));
if (RawCode==68)
   {
   DKnopf[0].Flags=DKnopf[0].Flags | SELECTED;
   RefreshGadgets(DWindow->FirstGadget,DWindow,NULL);
   Delay(5);
   }
if ((DKnopf[1].Flags & SELECTED)==0) MyWTStdMsg->ActWaveOp->Operator[3]=0
 else MyWTStdMsg->ActWaveOp->Operator[3]=1;
CloseWindow(DWindow);
MyWTStdMsg->Flags=MDE_READY;
};



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (IntuitionBase))
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            if (MyWTStdMsg->DataValid==0xBADBAD) SETPARAMETERS() else
               {
               MyWTStdMsg->ActWaveOp->Operator[3]=0;
               MyWTStdMsg->Flags=0;
               MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"SoundTracker 8 Bit 4.0 Surround Loader");
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
               strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
               MESSAGEHANDLE();
               MyWTStdMsg->Flags=MDE_READY
               }
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               l=CHECKST();
               if (l>0)
                  {
                  MyWTStdMsg->ActiveMode=MD_SURROUND;
                  MyWTStdMsg->ActiveChannels=CH_LEFT+CH_RIGHT+CH_CENTER+CH_SLEFT;
                  MyWTStdMsg->ActWaveOp->Operator[0]=l;
                  MyWTStdMsg->ActWaveOp->Operator[1]=1;
                  MyWTStdMsg->Flags=MDE_READY;
                  }
               else MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               LOADST();
cout << "F - Gone\n";               
               }
cout << "G\n";
            }
         else MyWTStdMsg->Flags=MDE_FILEERROR;
cout << "H\n";
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
cout << "I\n";
      MESSAGEHANDLE();
cout << "J\n";
      RemPort(MyPort);
      DeleteMsgPort(MyPort);
      }
   if (DOSBase) CloseLibrary((Library*)DOSBase);
   if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);
   }
}
