#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>


extern struct DOSBase *DOSBase;

struct SunHeader
   {
   char SunID[4];
   LONG ChunkLength;
   };
struct SunInfo
   {
   LONG SampleLength,SaveMode,SampleFreq,ChannelNum;
   char SampleName[255];
   };

SunHeader SunHd;
SunInfo   SunI;
LONG      MemLS,MemLLoad,l,Loaded,Size,Addr24[6];
LONG     *Data1;
APTR      MemALoad;
WORD      i,j;
char      s[255];
UBYTE     ChCnt,ChBit,ChID,MyChannels,MyMode;



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



BOOL READHEADER(void)

{
MyWTStdMsg->Flags=0;
MemLS=0;
Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
Read(MyWTStdMsg->ActFHandle,&SunHd,sizeof(SunHeader));
if (!(strncmp(SunHd.SunID,".sn",3)))
   {
   Read(MyWTStdMsg->ActFHandle,&SunI,SunHd.ChunkLength);
   MemLS=SunI.SampleLength/SunI.ChannelNum;
   ChCnt=SunI.ChannelNum;
   MyWTStdMsg->SRate=(LONG)(10000000.0/(SunI.SampleFreq*2.79365));
   if (MyWTStdMsg->SRate<60) MyWTStdMsg->SRate=60;
   if (MyWTStdMsg->SRate>60000) MyWTStdMsg->SRate=60000;
   if (SunI.ChannelNum==1) MyMode=MD_MONO
   else if (SunI.ChannelNum==2) MyMode=MD_STEREO
   else if (SunI.ChannelNum==3) MyMode=MD_3CH
   else if (SunI.ChannelNum==4) MyMode=MD_SURROUND
   else if (SunI.ChannelNum==5) MyMode=MD_AC3_Sub
   else if (SunI.ChannelNum==6) MyMode=MD_AC3;
   else
      {
      SENDERROR("Too much channels found!");
      MyWTStdMsg->Flags=MDE_ERROR;
      return FALSE;
      }
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETCHANNELBITS;
   MyWTStdMsg->WTMsgPrc->PRC_Long1=MyMode;
   MESSAGEHANDLE();
   if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) MyChannels=CH_LEFT
   else MyChannels=MyWTStdMsg->WTMsgPrc->PRC_Long1;
   }
else
   {
   MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
   return FALSE;
   }
if (SunI.SaveMode==3) MemLS=MemLS/2             // 16
else if (SunI.SaveMode==4) MemLS=(MemLS/3)      // 24
else if (SunI.SaveMode==5) MemLS=(MemLS/4)      // 32
else if (SunI.SaveMode==6) MemLS=(MemLS/4)      // single
else if (SunI.SaveMode==7) MemLS=(MemLS/8)      // double
else if (SunI.SaveMode!=2)                      //  8
   {
   SENDERROR("Unknown dataformat!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return FALSE;
   }
}



BOOL GETSAVEMEM(void)

{
MemLLoad=(100032/ChCnt)*ChCnt;
MemALoad=AllocVec(MemLLoad,MEMF_FAST);
if (!MemALoad)
   {
   l=AvailMem(MEMF_LARGEST);
   if (l>MemLLoad) l=MemLLoad;
   MemLLoad=l;
   MemLLoad=((ULONG)(MemLLoad/ChCnt))*ChCnt;
   MemALoad=AllocVec(MemLLoad,MEMF_FAST);
   if (!MemALoad) return FALSE;
   }
return TRUE;
}



void READDATA8(void)

{
BYTE *Data8;
LONG  Addr8,m;


if (!GETSAVEMEM())
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
Loaded=0;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   m=Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   Loaded=Loaded+m;
   Addr8=(LONG)MemALoad;
   if (m>0) do
      {
      ChBit=1;
      for (i=0; i<6; i++)
         {
         if (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
            {
            if (MyWTStdMsg->MemA24[i])
               {
               Data8=(BYTE*)Addr8;     Addr8++;
               Data1=(LONG*)Addr24[i]; Addr24[i]=Addr24[i]+4;
               *Data1=*Data8*65535;
               }
            else Addr8++;
            }
         ChBit=ChBit*2;
         }
      }
   while (Addr8<(LONG)MemALoad+l);
   }
while ((Loaded<MemLS*ChCnt) && (m!=0));
Loaded=(Loaded/ChCnt)*4;
MyWTStdMsg->Flags=MDE_READY;
}



void READDATA16(void)

{
WORD *Data16;
LONG  Addr16,m;


if (!GETSAVEMEM())
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
Loaded=0; MemLS=MemLS*2;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   m=Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   Loaded=Loaded+m;
   Addr16=(LONG)MemALoad;
   if (m>0) do
      {
      ChBit=1;
      for (i=0; i<6; i++)
         {
         if (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
            {
            if (MyWTStdMsg->MemA24[i])
               {
               Data16=(WORD*)Addr16;   Addr16=Addr16+2;
               Data1=(LONG*)Addr24[i]; Addr24[i]=Addr24[i]+4;
               *Data1=*Data16*255;
               }
            else Addr16=Addr16+2;
            }
         ChBit=ChBit*2;
         }
      }
   while (Addr16<(LONG)MemALoad+l);
   }
while ((Loaded<MemLS*ChCnt) && (m!=0));
Loaded=(Loaded/ChCnt)*2;
MyWTStdMsg->Flags=MDE_READY;
}



void READDATA24(void)

{
ULONG *Data32;
LONG   Addr32,m;


if (!GETSAVEMEM())
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
Loaded=0; MemLS=MemLS*3;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   m=Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   Loaded=Loaded+m;
   Addr32=(LONG)MemALoad-1;
   if (m>0) do
      {
      ChBit=1;
      for (i=0; i<6; i++)
         {
         if (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
            {
            if (MyWTStdMsg->MemA24[i])
               {
               Data32=(ULONG*)Addr32;   Addr32=Addr32+3;
               Data1=(LONG*)Addr24[i];  Addr24[i]=Addr24[i]+4;
               *Data1=((LONG)(*Data32 & 0x00FFFFFF))-MAX24;
               }
            else Addr32=Addr32+3;
            }
         ChBit=ChBit*2;
         }
      }
   while (Addr32<(LONG)MemALoad+l);
   }
while ((Loaded<MemLS*ChCnt) && (m!=0));
Loaded=((Loaded/ChCnt)/3)*4;
MyWTStdMsg->Flags=MDE_READY;
}



void READDATA32(void)

{
LONG *Data32;
LONG  Addr32,m;


if (!GETSAVEMEM())
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
Loaded=0; MemLS=MemLS*4;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   m=Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   Loaded=Loaded+m;
   Addr32=(LONG)MemALoad;
   if (m>0) do
      {
      ChBit=1;
      for (i=0; i<6; i++)
         {
         if (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
            {
            if (MyWTStdMsg->MemA24[i])
               {
               Data32=(LONG*)Addr32;   Addr32=Addr32+4;
               Data1=(LONG*)Addr24[i]; Addr24[i]=Addr24[i]+4;
               *Data1=*Data32;
               }
            else Addr32=Addr32+4;
            }
         ChBit=ChBit*2;
         }
      }
   while (Addr32<(LONG)MemALoad+l);
   }
while ((Loaded<MemLS*ChCnt) && (m!=0));
Loaded=Loaded/ChCnt;
MyWTStdMsg->Flags=MDE_READY;
}



void READDATASN(void)

{
FLOAT *Data32;
LONG   Addr32,m;


if (!GETSAVEMEM())
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
Loaded=0; MemLS=MemLS*4;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   m=Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   Loaded=Loaded+m;
   Addr32=(LONG)MemALoad;
   if (m>0) do
      {
      ChBit=1;
      for (i=0; i<6; i++)
         {
         if (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
            {
            if (MyWTStdMsg->MemA24[i])
               {
               Data32=(FLOAT*)Addr32;   Addr32=Addr32+4;
               Data1=(LONG*)Addr24[i]; Addr24[i]=Addr24[i]+4;
               *Data1=(LONG)(*Data32);
               }
            else Addr32=Addr32+4;
            }
         ChBit=ChBit*2;
         }
      }
   while (Addr32<(LONG)MemALoad+l);
   }
while ((Loaded<MemLS*ChCnt) && (m!=0));
Loaded=Loaded/ChCnt;
MyWTStdMsg->Flags=MDE_READY;
}



void READDATADBL(void)

{
DOUBLE *Data64;
LONG    Addr64,m;


if (!GETSAVEMEM())
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
Loaded=0; MemLS=MemLS*8;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   m=Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   Loaded=Loaded+m;
   Addr64=(LONG)MemALoad;
   if (m>0) do
      {
      ChBit=1;
      for (i=0; i<6; i++)
         {
         if (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
            {
            if (MyWTStdMsg->MemA24[i])
               {
               Data64=(DOUBLE*)Addr64; Addr64=Addr64+8;
               Data1=(LONG*)Addr24[i]; Addr24[i]=Addr24[i]+4;
               *Data1=(LONG)(*Data64);
               }
            else Addr64=Addr64+8;
            }
         ChBit=ChBit*2;
         }
      }
   while (Addr64<(LONG)MemALoad+l);
   }
while ((Loaded<MemLS*ChCnt) && (m!=0));
Loaded=Loaded/ChCnt/2;
MyWTStdMsg->Flags=MDE_READY;
}



void LOADSUN()

{
for (i=0; i<6; i++) Addr24[i]=MyWTStdMsg->MemA24[i];
MemALoad=NULL; MemLLoad=0; ChCnt=0; ChBit=1;
for (i=0; i<6; i++)
   {
   if ((MyChannels & ChBit)==ChBit) ChCnt=ChCnt+1;
   ChBit=ChBit*2;
   }
if (SunI.SaveMode==2) READDATA8()
else if (SunI.SaveMode==3) READDATA16()
else if (SunI.SaveMode==4) READDATA24()
else if (SunI.SaveMode==5) READDATA32()
else if (SunI.SaveMode==6) READDATASN()
else if (SunI.SaveMode==7) READDATADBL();
if (MemALoad) FreeVec(MemALoad);
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
if (DOSBase)
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Sun- / DEC-Audio 5.1 Loader");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               if (READHEADER())
                  {
                  MyWTStdMsg->ActiveMode=MyMode;
                  MyWTStdMsg->ActiveChannels=MyChannels;
                  MyWTStdMsg->ActWaveOp->Operator[0]=MemLS;
                  MyWTStdMsg->ActWaveOp->Operator[1]=1;
                  MyWTStdMsg->Flags=MDE_READY;
                  }
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (READHEADER())
                  {
                  MyChannels=(MyChannels & MyWTStdMsg->ActiveChannels);
                  if (MyChannels==0) MyWTStdMsg->Flags=MDE_CHANNELERROR
                  else
                     {
                     if (MyWTStdMsg->ActWaveOp->Operator[0]<MemLS) MemLS=MyWTStdMsg->ActWaveOp->Operator[0];
                     LOADSUN();
                     MyWTStdMsg->PlayL24=Loaded;
                     }
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   CloseLibrary((Library*)DOSBase);
   }
}
