program LOADER;

Uses ExecIO;

type Image=ptr;
type Window=ptr;
type Screen=ptr;
type IntuiText=ptr;
type Gadget=ptr;

type r_Synthesis=record;
        FileID                                  :string[32];
        XLong                                   :long;
        InstrName                               :string[32];
        Oscillator                              :array [1..128] of short;
        LFO                                     :array [1..256] of byte;
        Others                                  :array [1..6] of byte;
        WaveAmt                                 :word;
        AmplitudeVol,AmplitudeEG,AmplitudeLFO   :word;
        FreqPort,FreqLFO                        :word;
        FilterFreq,FilterEG,FilterLFO           :word;
        LFOSpeed,LFOSync,LFODelay               :word;   {LFOSync: On -1 Off 0 Once 1}
        PhaseSpeed,PhaseDepth                   :word;
        EGLevel,EGRate                          :array [1..4] of word;
     end;


{$incl "libraries/dos.h","exec/memory.h"};
{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod"}

var Addr1,Addr2,l                               :long;
var Data8                                       :^short;
var Data1,Data2                                 :^long;
var i                                           :integer;
var MemLS,LFOSize                               :long;
var Synthesis                                   :r_Synthesis;
var SFreq,LFOFactor,LFOOffset,AddrR,Factor,
    Stepsize                                    :real;
var RealEGLevel                                 :array [0..4] of long;



procedure CREATEWAVE(ChID :byte);

begin
   with MyWTStdMsg^ do begin
      if MemA24[ChID]=0 then begin
         Flags:=MDE_NO_MEMORY;
         exit;
      end;
      if SRate>65535 then SRate:=65535;
      SFreq:=round(10000000/(SRate*2.79365));
      if SFreq<60 then SFreq:=60;
      l:=DosSeek(ActFHandle,0,OFFSET_BEGINNING);
      l:=DosRead(ActFHandle,^Synthesis,502);
      if l<502 then begin
         Flags:=0;
         WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'File corrupt or no Synthesis-format!','Operation cancelled',
                           '','OK','',0,0,0,0,0,NIL);
         MESSAGEHANDLE;
         Flags:=MDE_ERROR;
         exit;
      end;
      with Synthesis do begin                               { *** OSCILLATOR *** }
         for i:=1 to 255 do LFO[i]:=130+LFO[i];
         Addr1:=MemA24[ChID];
         repeat
            i:=1;
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data1^:=Oscillator[i]*131070;
               i:=i+1;
            until (Addr1>=MemA24[ChID]+MemL24) or (i>128)
         until Addr1>=MemA24[ChID]+MemL24;
         PlayL24:=(MemLS div 128) * 512;
         if (PlayL24<8) or (PlayL24>MemL24) then PlayL24:=MemL24;

         l:=LFOSpeed or 1;
         LFOSize:=round(SFreq*(34.42286/l));
         l:=LFoSize or 1;
         LFOFactor:=255/l;

         if (AmplitudeLFO>0) and (LFOSpeed>0) then begin    { *** AMPLITUDE LFO *** }
            Addr1:=MemA24[ChID];
            if (LFODelay>0) and (LFOSync<>0) then begin
               l:=round(SFreq*LFODelay*0.007843);
               l:=succ(l div 4)*4;
               repeat
                  Data1:=ptr(Addr1); Addr1:=Addr1+4;
                  Data1^:=Data1^ div 512 * (LFO[1]+AmplitudeLFO);
               until (Addr1>=MemA24[ChID]+l) or (Addr1>=MemA24[ChID]+PlayL24-4);
            end;

            LFOOffset:=1;
            repeat
               repeat
                  Data1:=ptr(Addr1); Addr1:=Addr1+4;
                  Data1^:=Data1^ div 600 * (LFO[round(LFOOffset)]+AmplitudeLFO);
                  LFOOffset:=LFOOffset+LFOFactor
               until (Addr1>=MemA24[ChID]+PlayL24) or (LFOOffset>255);
               LFOOffset:=1;
            until (Addr1>=MemA24[ChID]+PlayL24) or (LFOSync=1);
         end;

         if (FreqLFO>0) and (LFOSpeed>0) then begin    { *** FREQENCY LFO *** }
            Addr1:=MemA24[ChID];
            if (LFODelay>0) and (LFOSync<>0) then begin
               l:=round(SFreq*LFODelay*0.007843);
               Addr1:=Addr1+(succ(l div 4)*4);
            end;
            Addr2:=Addr1;
            LFOOffset:=1;
            AddrR:=1;
            repeat
               repeat
                  Addr1:=Addr1+4;
                  Data1:=ptr(Addr1);
                  AddrR:=AddrR+((LFO[round(LFOOffset)]+FreqLFO)/1500)+1;
                  Data2:=ptr(Addr2+round(AddrR)*4);
                  Data1^:=Data2^;
                  LFOOffset:=LFOOffset+LFOFactor
               until (Addr2+round(AddrR*4)>=MemA24[ChID]+PlayL24) or (Addr1>=MemA24[ChID]+PlayL24) or (LFOOffset>255);
               LFOOffset:=1;
            until (Addr2+round(AddrR*4)>=MemA24[ChID]+PlayL24) or (LFOSync=1) or (Addr1>=MemA24[ChID]+PlayL24);
         end;
         if LFOSync<>1 then PlayL24:=Addr1-MemA24[ChID];
         if (PlayL24<8) or (PlayL24>MemL24) then PlayL24:=MemL24;

{         if FilterFreq>0 then begin         { *** FILTER FREQ *** }
            Addr1:=MemA24[ChID];
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data2:=ptr(Addr2);
               l:=round( ((Data1^/2)-(Data2^/2)) * (FilterFreq/80));
               Data1^:=Data1^+l;
            until Addr1>=MemA24[ChID]+PlayL24;
         end;}

         if (AmplitudeLFO>0) and (LFOSpeed>0) then begin    { *** FILTER LFO *** }
            Addr1:=MemA24[ChID];
            if (LFODelay>0) and (LFOSync<>0) then begin
               l:=round(SFreq*LFODelay*0.007843);
               Addr1:=Addr1+(succ(l div 4)*4);
            end;

            LFOOffset:=1;
            repeat
               repeat
                  Data1:=ptr(Addr1); Addr1:=Addr1+4;
                  Data2:=ptr(Addr2);
                  l:=round( ((Data1^/2)-(Data2^/2)) * (LFO[round(LFOOffset)]/80));
                  Data1^:=Data1^+l;
                  LFOOffset:=LFOOffset+LFOFactor
               until (Addr1>=MemA24[ChID]+PlayL24) or (LFOOffset>255);
               LFOOffset:=1;
            until (Addr1>=MemA24[ChID]+PlayL24) or (LFOSync=1);
         end;

                                                        { *** ENVELOPE GENERATOR *** }
         RealEGLevel[0]:=26;
         for i:=1 to 4 do RealEGLevel[i]:=round((EGLevel[i]+26)/1.12);
         Addr1:=MemA24[ChID];
         for i:=0 to 2 do begin
            if (RealEGLevel[i]<>RealEGLevel[i+1]) and (Addr1<MemA24[ChID]+PlayL24) then begin
               Addr2:=Addr1+(PlayL24 div 20 * 4);
               Stepsize:=(RealEGLevel[i+1]-RealEGLevel[i])/PlayL24 * 20;
               Stepsize:=Stepsize*(EGRate[i+1]/192+1);
               Factor:=RealEGLevel[i]+1;
               repeat
                  Data1:=ptr(Addr1); Addr1:=Addr1+4;
                  Data1^:=round(Data1^*Factor/255);
                  Factor:=Factor+Stepsize;
                  if Stepsize>0 then if Factor>=RealEGLevel[i+1] then Factor:=-1;
                  if Stepsize<=0 then if Factor<=RealEGLevel[i+1] then Factor:=-1;
               until (Factor=-1) or (Addr1>=Addr2) or (Addr1>=MemA24[ChID]+PlayL24);
            end;
         end;

         if Addr1<MemA24[ChID]+PlayL24 then begin
            Addr2:=Addr1+(PlayL24 div 20 * 4);
            Factor:=RealEGLevel[3]+1;
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data1^:=round(Data1^*Factor/255);
            until (Factor=-1) or (Addr1>=Addr2) or (Addr1>=MemA24[ChID]+PlayL24);
         end;

         if (RealEGLevel[3]<>RealEGLevel[4]) and (Addr1<MemA24[ChID]+PlayL24) then begin
            Addr2:=Addr1+(PlayL24 div 20 * 4);
            Stepsize:=(RealEGLevel[4]-RealEGLevel[3])/PlayL24 * 20;
            Stepsize:=Stepsize*(EGRate[4]/192+1);
            Factor:=RealEGLevel[3]+1;
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data1^:=round(Data1^*Factor/255);
               Factor:=Factor+Stepsize;
               if Stepsize>0 then if Factor>=RealEGLevel[4] then Factor:=-1;
               if Stepsize<=0 then if Factor<=RealEGLevel[4] then Factor:=-1;
            until (Factor=-1) or (Addr1>=Addr2) or (Addr1>=MemA24[ChID]+PlayL24);
         end;


         Addr2:=MemA24[ChID]+PlayL24;
         if Addr1<Addr2 then begin
            Sustain:=Addr1-MemA24[ChID];
            Release:=Addr2-MemA24[ChID];
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data1^:=round(Data1^*succ(EGLevel[4])/255);
            until Addr1>=Addr2;
         end;

      end;
      Flags:=MDE_READY;
   end;
end;



begin
   OpenLib(DosBase,'dos.library',0);
   if CREATEPORTS(PORT_LOADER) then begin
      with MyWTStdMsg^ do if Version=VERSION_LOADER then begin
         if Flags=MDC_ASKREADY then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'Sonix-SynthesisInstrument 1.0 Mono Loader, ',COPYRIGHT,
                              '','OK','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            Flags:=MDE_READY;
         end else if ActFHandle<>0 then begin
            if Flags=MDC_DEFINEIT then begin
               ActWaveOp^.Operator[1]:=10000;
               ActWaveOp^.Operator[2]:=1;
               SRate:=179;
               ActiveChannels:=CH_CENTER;
               ActiveMode:=MD_MONO;
               Flags:=MDE_READY;
            end else if Flags=MDC_DOIT then begin
               MemLS:=ActWaveOp^.Operator[1]*ActWaveOp^.Operator[2];
               if ActiveMode=MD_MONO then CREATEWAVE(3) else CREATEWAVE(1);
            end;
         end else Flags:=MDE_ERROR;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(DosBase);
end.




