#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>
#include <devices/ahi.h>

//#include <clib/alib_protos.h>
#include <clib/intuition_protos.h>
#include <clib/graphics_protos.h>
#include <clib/dos_protos.h>

//#include <pragma/all_lib.h>

#include <string.h>
//#include <math.h>
//#include <stdlib.h>
#include <iostream.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/EffIncl.c>
#include </WaveTracer/WTIncl.h>

extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;

MsgPort    *AHIPort=NULL;
AHIRequest *AHIReq=NULL;
BYTE        OpenDev=-1;


void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



void UNPACK(LONG UnPackedD, LONG PackedD, LONG Laenge)

{
LONG   Anfang;
UBYTE *Anz,*Inh,*Dest;
WORD   i;


Anfang=UnPackedD;
do
   {
   Anz=(UBYTE*)(PackedD);   PackedD++;
   if (*Anz>127)
      {
      *Anz=*Anz-127;
      CopyMem((APTR)PackedD,(APTR)UnPackedD,*Anz);
      PackedD=PackedD+*Anz;
      UnPackedD=UnPackedD+*Anz;
      }
   else
      {
      Inh=(UBYTE*)(PackedD);   PackedD++;
      for (i=1; i<=*Anz; i++)
         {
         Dest=(UBYTE*)(UnPackedD); UnPackedD++;
         *Dest=*Inh;
         }
      }
   }
while ((UnPackedD<PackedD) && (UnPackedD<Anfang+Laenge));
}



void CloseAHI(void)

{
if (OpenDev==0) CloseDevice ((struct IORequest*)(AHIReq));
OpenDev=-1;
if (AHIReq) DeleteIORequest((struct IORequest*)(AHIReq));
AHIReq=NULL;
if (AHIPort)
   {
   RemPort(AHIPort);
   DeleteMsgPort(AHIPort);
   }
AHIPort=NULL;
}



BOOL OpenAHI(void)

{
AHIPort=CreateMsgPort();
if (AHIPort)
   {
   AddPort(AHIPort);
   AHIReq=(struct AHIRequest*)CreateIORequest(AHIPort,sizeof(struct AHIRequest));
   if (AHIReq)
      {
      AHIReq->ahir_Version=4;
      OpenDev=OpenDevice(AHINAME,0,(IORequest*)AHIReq,NULL);
      if (OpenDev==0) return TRUE;
      else CloseAHI();
      }
   else CloseAHI();
   }
else CloseAHI();
return FALSE;
}



void RECORD(void)

{
BPTR      FHandle;
Window   *DWindow;
BYTE      i,GadCode,RawCode,PMode=0,RMode;
APTR      IMemA;
WORD      *WData1,*WData2;
LONG      IMemL;
Image     XImg={0,0,192,24,5,NULL,31,0,NULL};
Gadget    DKnopf[5]={NULL,500,20,128,17,GADGHCOMP+GADGIMAGE,0x3,BOOLGADGET,NULL,NULL,NULL,0,NULL,1,0,
                     NULL,83,17,26,24,GADGHCOMP,0x3,BOOLGADGET,NULL,NULL,NULL,0,NULL,2,0,
                     NULL,111,17,26,24,GADGHCOMP,0x3,BOOLGADGET,NULL,NULL,NULL,0,NULL,3,0,
                     NULL,139,17,26,24,GADGHCOMP,0x3,BOOLGADGET,NULL,NULL,NULL,0,NULL,4,0,
                     NULL,167,17,26,24,GADGHCOMP,0x3,BOOLGADGET,NULL,NULL,NULL,0,NULL,5,0};
Gadget       *XGadget;
IntuiMessage *IMsg;


cout << "1\n";
if ((MyWTStdMsg->MemA24[0]) && (MyWTStdMsg->MemA24[1])) RMode=3
else if (MyWTStdMsg->MemA24[2]) RMode=1
else
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
cout << "2\n";
if (!OpenAHI())
   {
   SENDERROR("Can't open AHI-Device!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
cout << "3\n";
AHIReq->ahir_Std.io_Command=CMD_READ;
AHIReq->ahir_Std.io_Data   =(APTR)MyWTStdMsg->MemA24[0];
AHIReq->ahir_Std.io_Length =400; //MyWTStdMsg->MemL24/4;
AHIReq->ahir_Std.io_Offset =0;
AHIReq->ahir_Frequency     =(LONG)(10000000.0/(MyWTStdMsg->SRate*2.79365));
AHIReq->ahir_Volume        =0x10000;
AHIReq->ahir_Position      =0x08000;
AHIReq->ahir_Link          =AHIReq;
AHIReq->ahir_Type          =RMode;
cout << "4\n";
if (RMode==1)
   {
   AHIReq->ahir_Std.io_Data  =(APTR)(MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24/2);
   WData1=(WORD*)MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24/2;
   WData2=(WORD*)MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24/2+2;
   }
else
   {
   AHIReq->ahir_Std.io_Data  =(APTR)(MyWTStdMsg->MemA24[0]);
   WData1=(WORD*)MyWTStdMsg->MemA24[0];
   WData2=(WORD*)MyWTStdMsg->MemA24[0]+2;
   }
cout << "5\n";
if (DoIO((struct IORequest*)AHIReq))
   {
   SENDERROR("AHI-failure!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
cout << "6\n";   
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"");
MyWTStdMsg->WTMsgPrc->PRC_Long1=44;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=0;
MESSAGEHANDLE();
cout << "7\n";
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr))
   {
   SENDERROR("Can't open definitionwindow!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
DWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
cout << "8\n";
IMemA=AllocVec(3000,MEMF_CHIP+MEMF_CLEAR);
if (!IMemA)
   {
   CloseWindow(DWindow);
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
FHandle=Open("LOADER/RecordAHI.data",MODE_OLDFILE);
if (!FHandle)
   {
   SENDERROR("Cant`t find file RAMScan.data.");
   CloseWindow(DWindow);
   FreeVec(IMemA);
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   };
cout << "9\n";   
IMemL=Seek(FHandle,0,OFFSET_END);
IMemL=Seek(FHandle,0,OFFSET_BEGINNING);
Read(FHandle,(APTR)((LONG)IMemA+3000-IMemL),IMemL);
Close(FHandle);
UNPACK((LONG)IMemA,(LONG)IMemA+3000-IMemL,2880);
XImg.ImageData=(UWORD*)IMemA;
DrawImage(DWindow->RPort,&XImg,4,17);

DKnopf[0].GadgetRender=MyWTStdMsg->WTImg->GImg5;
DKnopf[0].GadgetText=MyWTStdMsg->WTImg->OKIText;

for (i=0; i<5; i++) AddGadget(DWindow,&DKnopf[i],NULL);
RefreshGadgets(DWindow->FirstGadget,DWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(DWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class=GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      };
   
   PMode=GadCode;
   if (GadCode!=0)
      {
      SetAPen(DWindow->RPort,0);
      RectFill(DWindow->RPort,200,20,300,35);
      }
   if (GadCode==2) WRITE(200,20,2,0,*DWindow,"Auto-Record")
   else if (GadCode==3) WRITE(200,20,2,0,*DWindow,"Record")
   else if (GadCode==4) WRITE(200,20,2,0,*DWindow,"Play")
   else if (GadCode==5) WRITE(200,20,2,0,*DWindow,"Stop");
   
   if ((PMode==0) || (PMode==2))
      {
cout << *WData1 << "<>" << *WData2 << " ";
      DoIO((IORequest*)AHIReq);         
      SetAPen(DWindow->RPort,2);
      RectFill(DWindow->RPort,12,21,(WORD)(12+((*WData2+32767.0)/820)),22);
      SetAPen(DWindow->RPort,0);
      RectFill(DWindow->RPort,(WORD)(12+((*WData2+32767.0)/820),21),21,82,22);
      WaitTOF();
      }
   
   }
while ((GadCode!=1) && (RawCode!=68));
if (RawCode==68)
   {
   DKnopf[0].Flags=DKnopf[0].Flags | SELECTED;
   RefreshGadgets(DWindow->FirstGadget,DWindow,NULL);
   Delay(5);
   }
AbortIO((IORequest*)AHIReq);   
CloseAHI();
CloseWindow(DWindow);
MyWTStdMsg->Flags=MDE_READY;
};



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (IntuitionBase) && (GfxBase))
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"RecordAHI,");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_NICE_SOFTMOD;
            }
         else if (MyWTStdMsg->Flags==MDC_DEFINEIT) MyWTStdMsg->Flags=MDE_NICE_SOFTMOD
         else if (MyWTStdMsg->Flags==MDC_DOIT) RECORD()
         else (MyWTStdMsg->Flags=MDE_ERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   }
if (DOSBase) CloseLibrary((Library*)DOSBase);
if (GfxBase) CloseLibrary((Library*)GfxBase);
if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);
}
