#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>

//#include <pragma/all_lib.h>

#include <string.h>
#include <stdlib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

extern void GETCOPYRIGHT(void);
void DECRYPT8(UBYTE *Data8);
void DECRYPT16(UWORD *Data16);

extern struct DOSBase *DOSBase;

struct fmtHeader
   {
   UWORD formatTag,nChannels;
   LONG  nSamplesPerSec,nAvgBytesPerSec;
   UWORD nBlockAlign,nBitsPerSample;
   };

UBYTE     i,ChCnt;
char      ChunkID[5];
LONG      ChunkLength,HackedLong;
fmtHeader fmtHd;
LONG      MemLS,MemLSX,l,SampleDepth,SampleRes,SampleCompression;
UBYTE     MyChannels,BitsCnt;
BYTE      Bits[161],SaveID,Chan[2]={-1,-1};
BOOL      StartFound;



UWORD SWAP16(UWORD w1)

{
UWORD w2;

w2=((w1 & 0xFF00)/0x100)+
   ((w1 & 0x00FF)*0x100);
return w2;
}



ULONG SWAP32(ULONG l1)

{
ULONG l2;


l2=((l1 & 0xFF000000)/0x1000000) +
   ((l1 & 0x00FF0000)/0x100) +
   ((l1 & 0x0000FF00)*0x100) +
   ((l1 & 0x000000FF)*0x1000000);
return l2;
}



BOOL READHEADER(void)

{
char s[50];
BOOL dataFound;

dataFound=FALSE;
Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
Read(MyWTStdMsg->ActFHandle,&ChunkID,4);
if (!(strncmp(ChunkID,"RIFF",4)))
   {
   Read(MyWTStdMsg->ActFHandle,&ChunkLength,4);
   Read(MyWTStdMsg->ActFHandle,&ChunkID,4);
   if (!(strncmp(ChunkID,"WAVE",4)))
      {
      do
         {
         l=Read(MyWTStdMsg->ActFHandle,&ChunkID,4);
         l=l+Read(MyWTStdMsg->ActFHandle,&ChunkLength,4);
         ChunkLength=SWAP32(ChunkLength);
         if (!(strncmp(ChunkID,"fmt ",4)))
            {
            ChunkLength=ChunkLength-Read(MyWTStdMsg->ActFHandle,&fmtHd,sizeof(fmtHeader));
            if (SWAP16(fmtHd.formatTag)!=1)
               {
               SENDERROR("No PCM-format!");
               MyWTStdMsg->Flags=MDE_ERROR;
               return FALSE;
               }
            if (SWAP16(fmtHd.nBitsPerSample)<=8) SampleRes=8
            else if (SWAP16(fmtHd.nBitsPerSample)<=12) SampleRes=12
            else if (SWAP16(fmtHd.nBitsPerSample)<=16) SampleRes=16
            else
               {
               SENDERROR("Unknown sample-resolution!");
               MyWTStdMsg->Flags=MDE_ERROR;
               return FALSE;
               }
            if (SWAP16(fmtHd.nChannels)==1) MyChannels=CH_CENTER else MyChannels=CH_LEFT+CH_RIGHT;
            MyWTStdMsg->SRate=SWAP32(fmtHd.nSamplesPerSec);
            if ((MyWTStdMsg->SRate<5000) && (MyWTStdMsg->SRate>24000)) MyWTStdMsg->SRate=22000;
            MyWTStdMsg->SRate=(LONG)(10000000.0/(MyWTStdMsg->SRate*2.79365));
            if (MyWTStdMsg->SRate<60) MyWTStdMsg->SRate=60;
            if (MyWTStdMsg->SRate>60000) MyWTStdMsg->SRate=60000;
            }
         else if (!(strncmp(ChunkID,"data",4))) dataFound=TRUE;
         if ((!dataFound) && (ChunkLength>0))
            {
            Seek(MyWTStdMsg->ActFHandle,ChunkLength,OFFSET_CURRENT);
            }
         }
      while ((l>=8) && (!dataFound));
      if (l<8)
         {
         SENDERROR("File corrupt! Can`t find data-chunk.");
         MyWTStdMsg->Flags=MDE_ERROR;
         return FALSE;
         }
      MemLS=labs(ChunkLength/SWAP16(fmtHd.nBlockAlign));
      MemLS=(MemLS/2)*2;
      }
   else
      {
      strcpy(s,"No sound-RIFF (");
      strncat(s,ChunkID,4);
      strcat(s,") !");
      SENDERROR(s);
      MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
      return FALSE;
      }
   }
else
   {
   MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
   return FALSE;
   }
return TRUE;
};



void LOAD8BIT(void)

{
UBYTE *Data8;
LONG  *Data1,*Data2;
LONG   Addr1,Addr2,Addr8;


if (MyWTStdMsg->MemA24[Chan[0]]==0) return;
l=Read(MyWTStdMsg->ActFHandle,(APTR)(MyWTStdMsg->MemA24[Chan[0]]+MyWTStdMsg->MemL24-(MemLS*ChCnt)),MemLS*ChCnt);
Addr1=MyWTStdMsg->MemA24[Chan[0]];
if ((Chan[1]>0) && (MyWTStdMsg->MemA24[Chan[1]])) Addr2=MyWTStdMsg->MemA24[Chan[1]] else Addr2=0;
Addr8=MyWTStdMsg->MemA24[Chan[0]]+MyWTStdMsg->MemL24-MemLS*ChCnt;
do
   {
   Data1=(LONG*)Addr1;  Addr1=Addr1+4;
   Data8=(UBYTE*)Addr8; Addr8++;
   DECRYPT8(Data8);
   *Data1=(*Data8-127)*65535;
   if (Addr2)
      {
      Data2=(LONG*)Addr2;  Addr2=Addr2+4;
      Data8=(UBYTE*)Addr8; Addr8++;
      *Data2=(*Data8-127)*65535;
      }
   }
while (Addr8<MyWTStdMsg->MemA24[Chan[0]]+MyWTStdMsg->MemL24);
MyWTStdMsg->PlayL24=MemLS*4;
MyWTStdMsg->Flags=MDE_READY;
}



void LOAD12BIT(void)

{
UWORD *Data16;
LONG *Data1,*Data2;
LONG  Addr1,Addr2,Addr16;


MemLS=MemLS*2;
if (MyWTStdMsg->MemA24[Chan[0]]==0) return;
l=Read(MyWTStdMsg->ActFHandle,(APTR)(MyWTStdMsg->MemA24[Chan[0]]+MyWTStdMsg->MemL24-(MemLS*ChCnt)),MemLS*ChCnt);
Addr1=MyWTStdMsg->MemA24[Chan[0]];
if ((Chan[1]>0) && (MyWTStdMsg->MemA24[Chan[1]])) Addr2=MyWTStdMsg->MemA24[Chan[1]] else Addr2=0;
Addr16=MyWTStdMsg->MemA24[Chan[0]]+MyWTStdMsg->MemL24-MemLS*ChCnt;
do
   {
   Data1=(LONG*)Addr1;    Addr1=Addr1+4;
   Data16=(UWORD*)Addr16; Addr16=Addr16+2;
   DECRYPT16(Data16);
   *Data1=SWAP16(*Data16);
   if (*Data1>2048) *Data1=*Data1-4096;
   if (Addr2)
      {
      Data2=(LONG*)Addr2;    Addr2=Addr2+4;
      Data16=(UWORD*)Addr16; Addr16=Addr16+2;
      *Data2=SWAP16(*Data16);
      if (*Data2>2048) *Data2=*Data2-4096;
      }
   }
while (Addr16<MyWTStdMsg->MemA24[Chan[0]]+MyWTStdMsg->MemL24);
MyWTStdMsg->PlayL24=MemLS*2;
MyWTStdMsg->Flags=MDE_READY;
}



void LOAD16BIT(void)

{
UWORD *Data16;
LONG *Data1,*Data2;
LONG  Addr1,Addr2,Addr16;


MemLS=MemLS*2;
if (MyWTStdMsg->MemA24[Chan[0]]==0) return;
l=Read(MyWTStdMsg->ActFHandle,(APTR)(MyWTStdMsg->MemA24[Chan[0]]+MyWTStdMsg->MemL24-(MemLS*ChCnt)),MemLS*ChCnt);
Addr1=MyWTStdMsg->MemA24[Chan[0]];
if ((Chan[1]>0) && (MyWTStdMsg->MemA24[Chan[1]])) Addr2=MyWTStdMsg->MemA24[Chan[1]] else Addr2=0;
Addr16=MyWTStdMsg->MemA24[Chan[0]]+MyWTStdMsg->MemL24-MemLS*ChCnt;
do
   {
   Data1=(LONG*)Addr1;    Addr1=Addr1+4;
   Data16=(UWORD*)Addr16; Addr16=Addr16+2;
   DECRYPT16(Data16);
   *Data1=SWAP16(*Data16);
   if (*Data1>32767) *Data1=*Data1-65536;
   if (Addr2)
      {
      Data2=(LONG*)Addr2;    Addr2=Addr2+4;
      Data16=(UWORD*)Addr16; Addr16=Addr16+2;
      *Data2=SWAP16(*Data16);
      if (*Data2>32767) *Data2=*Data2-65536;
      }
   }
while (Addr16<MyWTStdMsg->MemA24[Chan[0]]+MyWTStdMsg->MemL24);
MyWTStdMsg->PlayL24=MemLS*2;
MyWTStdMsg->Flags=MDE_READY;
}





void LOADRIFF(void)

{
MyWTStdMsg->Flags=MDE_ERROR;
if (SWAP16(fmtHd.nChannels)==1)
   {
   Chan[0]=2;
   ChCnt=1;
   }
else
   {
   Chan[0]=0;
   Chan[1]=1;
   ChCnt=2;
   }
if (SampleRes==8) LOAD8BIT()
else if (SampleRes==12) LOAD12BIT()
else LOAD16BIT();
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
if (DOSBase)
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"RIFF-WAVE 2.0 Stereo Loader, 8, 12 & 16 Bit");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               SaveID=0;
               if (READHEADER())
                  {
                  MyWTStdMsg->ActWaveOp->Operator[0]=MemLS;
                  MyWTStdMsg->ActWaveOp->Operator[1]=1;
                  if (MyChannels==CH_LEFT+CH_RIGHT) MyWTStdMsg->ActiveMode=MD_STEREO
                   else MyWTStdMsg->ActiveMode=MD_MONO;
                  MyWTStdMsg->ActiveChannels=MyChannels;
                  MyWTStdMsg->Flags=MDE_READY;
                  }
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (READHEADER())
                  {
                  MyChannels=(MyChannels & MyWTStdMsg->ActiveChannels);
                  if (MyChannels==0) MyWTStdMsg->Flags=MDE_CHANNELERROR
                  else
                     {
                     if (MyWTStdMsg->ActWaveOp->Operator[0]<MemLS) MemLS=MyWTStdMsg->ActWaveOp->Operator[0];
                     BitsCnt=0; StartFound=FALSE;
                     LOADRIFF();
                     if (MyWTStdMsg->Flags==MDE_READY) GETCOPYRIGHT();
                     }
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   CloseLibrary((Library*)DOSBase);
   }
}
