program SoftModul;

Uses ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h", "exec/memory.h","soundplay.mod","exec/execbase.h"}
{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod"}

var ChBit,ChID  :byte;
var l           :long;


procedure UNPACK(UnPackedD,PackedD,Laenge :long);

var Anfang              :long;
var Anz,Inh,Dest        :^byte;
var i                   :integer;

begin
   Anfang:=UnPackedD;
   repeat
      Anz:=ptr(PackedD);   PackedD:=PackedD+1;
      if Anz^>127 then begin
         Anz^:=Anz^-127;
         CopyMem(PackedD,UnPackedD,Anz^);
         PackedD:=PackedD+Anz^;
         UnPackedD:=UnPackedD+Anz^;
      end else begin
         Inh:=ptr(PackedD);   PackedD:=PackedD+1;
         for i:=1 to Anz^ do begin
            Dest:=Ptr(UnPackedD); UnPackedD:=UnPackedD+1;
            Dest^:=Inh^;
         end;
      end;
   until (UnPackedD>=PackedD) or (UnPackedD>=Anfang+Laenge);
end;



procedure WRITE(LEdge,TEdge :word; Stpen,DMode :byte; Wind :Window; txt :str);

var IT1 :IntuiText;
var l   :long;

begin
   IT1:=IntuiText(StPen,0,0,LEdge,TEdge,MyWTStdMsg^.WTScreen^.Font,txt,NIL);
   if DMode=2 then begin
      l:=LEdge-(IntuiTextLength(^IT1) div 2);
      IT1.LeftEdge:=l;
   end;
   PrintIText(Wind.RPort,^IT1,0,0);
end;



procedure MAKEWAVE(SAddr :long);

type r_RamType=record
        RamAddrA,RamAddrE       :long;
        RamName                 :string;
     end;

const MAXRAM=5;

var DWindow                                     :^Window;
var RamType                                     :array [1..MAXRAM] of r_RamType;
var Addr1,Addr8,DispA,PlayA,Factor,
    MaxFactor,MarkE,MarkA,FastPlayA             :long;
var Data8                                       :^short;
var Data1                                       :^long;
var FHandle                                     :BPTR;
var XImg                                        :Image;
var DKnopf                                      :array[1..8] of Gadget;
var XGadget                                     :^Gadget;
var GadCode,RawCode,RamID,i,j                   :byte;
var MsgGone,Button                              :boolean;
var IMsg                                        :^IntuiMessage;
var EBase                                       :^ExecBase;
var MyMemHeader                                 :^MemHeader;
var MyList                                      :List;
var s                                           :string;
var LastCPos                                    :word;


procedure DRAWCURSOR(NewCPos :word);

procedure DRAWTRIANGLE;

begin
   Move(^MyWTStdMsg^.WTScreen^.RastPort,LastCPos,24);
   if LastCPos>3 then Draw(^MyWTStdMsg^.WTScreen^.RastPort,LastCPos-4,17)
   else Draw(^MyWTStdMsg^.WTScreen^.RastPort,LastCPos,17);
   if LastCPos<636 then Draw(^MyWTStdMsg^.WTScreen^.RastPort,LastCPos+4,17)
   else Draw(^MyWTStdMsg^.WTScreen^.RastPort,LastCPos,17);
   Draw(^MyWTStdMsg^.WTScreen^.RastPort,LastCPos,24);
end;

begin
   if NewCPos<0 then NewCPos:=0;
   if NewCPos>pred(MyWTStdMsg^.WTScreen^.Width) then NewCPos:=pred(MyWTStdMsg^.WTScreen^.Width);
   SetAPen(^MyWTStdMsg^.WTScreen^.RastPort,0);
   DRAWTRIANGLE;
   SetAPen(^MyWTStdMsg^.WTScreen^.RastPort,9);
   LastCPos:=NewCPos;
   DRAWTRIANGLE
end;


procedure DRAWRAM;

var Divider             :real;
var Offset              :long;
var x                   :word;

begin
   with RamType[RamID] do WRITE(139,20,2,2,DWindow^,RamName);
   with MyWTStdMsg^ do begin
      Move(WTWindow^.RPort,0,103);
      Addr1:=DispA; x:=0;
      Offset:=round((WTScreen^.Height-95) div 2 + 16);
      Divider:=275 / (WTScreen^.Height-95);
      if Divider=0 then Divider:=1;
      repeat
         Data8:=ptr(Addr1); Addr1:=Addr1+Factor;
         if Addr1 in [MarkA*Factor..MarkE*Factor] then SetAPen(WTWindow^.RPort,5)
          else SetAPen(WTWindow^.RPort,0);
         RectFill(WTWindow^.RPort,x,17,x,WTScreen^.Height-70);
         SetAPen(WTWindow^.RPort,4);
         Draw(WTWindow^.RPort,x,round(Data8^/Divider+Offset));
         x:=x+1;
      until (x=640) or (Addr1>=RamType[RamID].RamAddrE);
      DRAWCURSOR((PlayA-DispA) div Factor);
   end;
end;



procedure STARTSOUND;

begin
   with MyWTStdMsg^ do begin
      DMACON_WRITE^:=$0003;
      CopyMemQuick(PlayA,FastPlayA,1000);
      SPAddrA^:=FastPlayA;  SPAddrB^:=FastPlayA;
      SPFreqA^:=SRate;      SPFreqB^:=SRate;
      SPVolA^:=64;          SPVolB^:=64;
      SPLengthA^:=500;      SPLengthB^:=500;
      DMACON_WRITE^:=$8003; MsgGone:=false;
      DRAWCURSOR((PlayA-DispA)div Factor);
      repeat
         NTREQ_WRITE^:=$0180;
         PlayA:=PlayA+1000;
         CopyMemQuick(PlayA,FastPlayA,1000);
         l:=(PlayA-DispA) div Factor;
         DRAWCURSOR(l);
         repeat
            IMsg:=Get_Msg(DWindow^.UserPort);
            if IMsg<>NIL then begin
               if IMsg^.Class=GADGETUP then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end else if IMsg^.Class=RAWKEY then MsgGone:=true;;
               Reply_Msg(IMsg);
            end;
         until (NTREQ_READ^ and $180<>0) or (GadCode=4) or MsgGone;
      until (GadCode=4) or MsgGone or (PlayA+1000>=DispA+Factor*640);
      DMACON_WRITE^:=$0003;
   end;
end;



begin
   with MyWTStdMsg^ do if SAddr<>0 then begin
      LastCPos:=0;
      EBase:=SysBase;
      MyList:=EBase^.MemList;
      MyMemHeader:=^MyList.lh_Head^.ln_Succ;
      i:=1;
      repeat
         with MyMemHeader^ do if mh_Node.ln_Type=NT_MEMORY then begin
            RamType[i].RamAddrA:=long(mh_Lower);
            RamType[i].RamAddrE:=long(mh_Upper);
            RamType[i].RamName:=mh_Node.ln_Name;
            i:=i+1;
         end;
         MyMemHeader:=^MyMemHeader^.mh_Node.ln_Succ^;
      until (MyMemHeader^.mh_Node.ln_Succ=NIL) or (i>MAXRAM);
      if i<=MAXRAM then for j:=i to MAXRAM do RamType[j].RamName:='';

      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'','','','','',42,0,0,0,0,NIL);
      MESSAGEHANDLE;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      if (WTMsgPrc^.PRC_Long1=-1) or (DWindow=NIL) then begin
         Flags:=MDE_NO_MEMORY; exit;
      end;
      FastPlayA:=AllocMem(4000,MEMF_CHIP+MEMF_CLEAR);
      if FastPlayA=0 then begin
         CloseWindow(DWindow);
         Flags:=MDE_NO_MEMORY;
         exit;
      end;
      FHandle:=DosOpen('LOADER/RAMScan.data',MODE_OLDFILE);
      if FHandle=0 then begin
         WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'Cant`t find file RAMScan.data.',
                           'Operation cancelled!','','OK','',0,0,0,0,0,NIL);
         MESSAGEHANDLE;
         CloseWindow(DWindow);
         FreeMem(FastPlayA,4000);
         Flags:=MDE_ERROR;
         exit;
      end;
      l:=DosRead(FHandle,ptr(FastPlayA+2137),1863);
      DosClose(FHandle);
      UNPACK(FastPlayA,FastPlayA+2137,3840);
      XImg:=Image(0,0,640,24,2,ptr(FastPlayA),3,0,NIL);
      DrawImage(DWindow^.RPort,^XImg,0,16);
      DKnopf[1]:=Gadget(NIL,5,16,56,24,GADGHCOMP,$1,BOOLGADGET,NIL,NIL,NIL,0,NIL,1,0);
      for i:=2 to 5 do DKnopf[i]:=Gadget(NIL,218+(i-2)*46,16,46,18,GADGHCOMP,
                                         $3,BOOLGADGET,NIL,NIL,NIL,0,NIL,i,0);
      for i:=6 to 7 do DKnopf[i]:=Gadget(NIL,402+(i-6)*53,16,53,24,GADGHCOMP,
                                         $1,BOOLGADGET,NIL,NIL,NIL,0,NIL,i,0);
      DKnopf[8]:=Gadget(NIL,508,20,128,16,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,WTImg^.GImg5,
                         NIL,WTImg^.OKIText,0,NIL,8,0);
      for i:=1 to 8 do AddGadget(DWindow,^DKnopf[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      RamID:=1;
      MaxFactor:=(RamType[RamID].RamAddrE-RamType[RamID].RamAddrA) div 640;
      Factor:=MaxFactor;
      DispA:=RamType[RamID].RamAddrA;
      PlayA:=RamType[RamID].RamAddrA;

      INITCHANNELS;
      DRAWCURSOR(1);
      DRAWRAM;
      MarkA:=0; MarkE:=0; Button:=false;
      repeat
         RawCode:=0; GadCode:=0; MsgGone:=false;
         repeat
            IMsg:=Get_Msg(DWindow^.UserPort);
            if IMsg<>NIL then begin
               if IMsg^.Class in [GADGETUP,GADGETDOWN] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end else if IMsg^.Class=RAWKEY then Rawcode:=IMsg^.Code
               else if IMsg^.Class=INACTIVEWINDOW then GadCode:=11;
               Reply_Msg(IMsg);
               MsgGone:=true;
            end else begin
               IMsg:=Get_Msg(WTWindow^.UserPort);
               if IMsg<>NIL then begin
                  if IMsg^.Class=GADGETDOWN then begin
                     XGadget:=IMsg^.IAddress;
                     WTWindow^.RPort^.Mask:=%1010;
                     if MarkE<>0 then begin
                        MarkA:=0; MarkE:=0;
                        SetAPen(WTWindow^.RPort,0);
                        RectFill(WTWindow^.RPort,0,18,639,WTScreen^.Height-70);
                        MsgGone:=true
                     end else while not (XGadget^.Flags and SELECTED=0) and not MsgGone do begin
                        if (MarkA=0) and (MarkE=0) then MarkA:=WTWindow^.MouseX;
                        MarkE:=WTWindow^.MouseX;
                        if MarkE<MarkA then begin
                           exchange(MarkE,MarkA); i:=1;
                        end else i:=0;
                        SetAPen(WTWindow^.RPort,0);
                        if MarkA>0   then RectFill(WTWindow^.RPort,0,18,MarkA-1,WTScreen^.Height-70);
                        if MarkE<640 then RectFill(WTWindow^.RPort,MarkE+1,18,639,WTScreen^.Height-70);
                        SetAPen(WTWindow^.RPort,15);
                        RectFill(WTWindow^.RPort,MarkA,18,MarkE,WTScreen^.Height-70);
                        if i=1 then exchange(MarkE,MarkA);
                     end;
                     WTWindow^.RPort^.Mask:=$FF;
                  end;
                  if IMsg^.Class=GADGETUP then Button:=false;
                  Reply_Msg(IMsg);
               end else delay(1)
            end;
         until MsgGone;

         if GadCode=7 then begin
            Factor:=Factor*2; if Factor>MaxFactor then Factor:=MaxFactor;
            if DispA-Factor*640>RamType[RamID].RamAddrE then DispA:=RamType[RamID].RamAddrE-Factor*640;
            PlayA:=DispA;
            DRAWRAM;
         end else if GadCode=1 then begin
            repeat
               RamID:=RamID+1;
               if RamID>MAXRAM then RamID:=1;
            until RamType[RamID].RamName<>'';
            MaxFactor:=(RamType[RamID].RamAddrE-RamType[RamID].RamAddrA) div 640;
            Factor:=MaxFactor;
            DispA:=RamType[RamID].RamAddrA;
            PlayA:=RamType[RamID].RamAddrA;
            SetAPen(DWindow^.RPort,0); RectFill(DWindow^.RPort,63,17,213,38);
            DRAWRAM;
         end else if GadCode=2 then begin
            while not (DKnopf[2].Flags and SELECTED=0) do begin
               PlayA:=PlayA-MaxFactor;
               if PlayA<DispA then begin
                  if DispA-MaxFactor>RamType[RamID].RamAddrA then DispA:=DispA-MaxFactor
                  else DispA:=RamType[RamID].RamAddrA;
                  PlayA:=DispA;
                  DRAWRAM;
               end;
               DRAWCURSOR((PlayA-DispA)div Factor);
               WaitTOF;
            end;
         end else if Gadcode=3 then begin
            if PlayA+1000>=DispA+Factor*640 then PlayA:=DispA;
            STARTSOUND;
         end else if GadCode=5 then begin
            while not (DKnopf[5].Flags and SELECTED=0) do begin
               PlayA:=PlayA+MaxFactor;
               if PlayA>RamType[RamID].RamAddrE then PlayA:=RamType[RamID].RamAddrE;
               l:=(PlayA-DispA) div Factor;
               if l>639 then begin
                  DispA:=DispA+MaxFactor;
                  DRAWRAM;
               end;
               DRAWCURSOR(l);
               WaitTOF;
            end;
         end else if GadCode=6 then if MarkA+MarkE>0 then begin
            if MarkE<MarkA then exchange(MarkE,MarkA);
            DispA:=DispA+MarkA*Factor; PlayA:=DispA;
            Factor:=(MarkE-MarkA)*Factor div 640;
            if Factor<1 then Factor:=1;
            MarkA:=0; MarkE:=0;
            DRAWRAM;
         end;

         if GadCode in [6,7] then begin
            s:='Display: '+intstr(640*Factor)+' Bytes';
            WRITE(320,WTScreen^.Height-82,2,2,WTWindow^,s);
         end;

         if ((GadCode=8) or (RawCode=68)) and (MarkE=0) then begin
            WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'No area marked!',
                              'Leave really?','Cancel','','Leave',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            if WTMsgPrc^.PRC_Long1=1 then begin
               Gadcode:=0; RawCode:=0;
            end;
         end;

      until (GadCode=8) or (RawCode=68);
      while DWindow^.FirstGadget<>NIL do RemoveGadgets(DWindow,DWindow^.FirstGadget);
      CloseWindow(DWindow);
      if MarkA>MarkE then exchange(MarkA,MarkE);
      if MarkE=0 then l:=MemL24 div 4 else begin
         l:=(MarkE-MarkA)*Factor;
         if l>MemL24 div 4 then l:=MemL24 div 4;
      end;
      Addr1:=SAddr; Addr8:=DispA+(MarkA*Factor);
      MarkE:=Addr8+l;
      repeat
         Data1:=ptr(Addr1); Addr1:=Addr1+4;
         Data8:=ptr(Addr8); Addr8:=Addr8+1;
         Data1^:=Data8^*65535;
      until (Addr8>=MarkE) or (Addr1>SAddr+MemL24);
      PlayL24:=Addr1-SAddr;
      FreeMem(FastPlayA,4000);
      Flags:=MDE_READY;
   end;
end;



begin
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(DosBase,'dos.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_LOADER) then begin
      with MyWTStdMsg^ do if Version=VERSION_LOADER then begin
         if Flags=MDC_ASKREADY then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'RAM-Scan, ',COPYRIGHT,
                              '','OK','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            ActiveChannels:=CH_LEFT;
            ActiveMode:=MD_MONO;
            Flags:=MDE_NICE_SOFTMOD;
         end else if Flags=MDC_DEFINEIT then Flags:=MDE_NICE_SOFTMOD
         else if Flags=MDC_DOIT then begin
            ChBit:=1;
            ChID:=1;
            repeat
               if not (ActiveChannels and ChBit=0) then begin
                  MAKEWAVE(MemA24[ChID]);
                  ChID:=6;
               end;
               ChBit:=ChBit*2;
               ChID:=ChID+1;
            until ChID>6;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(DosBase);
   CloseLib(IntBase);
end.


