#include <exec/types.h>
#include <exec/memory.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>
#include <clib/exec_protos.h>

#include <intuition/intuitionbase.h>

#include <pragma/all_lib.h>

#include <string.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>
#include </common/QT.h>

extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;

extern DPANHeader DPAN;
extern AudioDescription AudioDescr;
extern LONG MyMode,MyChannels,LastPosition;
extern APTR SoundLengthMemA,SoundOffsetMemA,GfxLengthMemA,GfxOffsetMemA;
extern APTR GfxTimeMemA;
extern LONG SoundLengthMemL,SoundOffsetMemL,SampleBeginOffset,SampleEndOffset;


extern void SCANANIM(LONG StartFrame, LONG EndFrame);
extern void DEFINESCENE(void);



void CREATEANIM(void)

{
SampleLengthTable *SLTable;
SDBodyScene       *MySDBodyScene;
LONG              *Offset,*Data1,*Data2;
LONG               LoadAddr,LoadSize,OffsetAddr,LengthAddr,Length;
LONG               OldLoadAddr,Ctr,Addr1,Addr2,Addr3,LoadLength;
UBYTE             *Data3;


MyWTStdMsg->PlayL24=MyWTStdMsg->ActWaveOp->Operator[0]*MyWTStdMsg->ActWaveOp->Operator[1]*4;
if (((MyWTStdMsg->ActWaveOp->Operator[4]>=1) || (MyWTStdMsg->ActWaveOp->Operator[5]<=DPAN.Frames)) &&
     (MyWTStdMsg->ActWaveOp->Operator[4]<MyWTStdMsg->ActWaveOp->Operator[5]))
   {
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ALLOC_SPECIAL_DATA;
   MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_SCENE;
   MESSAGEHANDLE();
   if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr)
      {
      MySDBodyScene=(SDBodyScene*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;                
      MySDBodyScene->sdb_SDHeader.NextSpecialData=NULL;
      MySDBodyScene->sdb_SDHeader.sdh_Size=sizeof(SDBodyScene);
      MySDBodyScene->sdb_SDHeader.sdh_Type=SD_SCENE;
      strcpy(MySDBodyScene->sdb_Name,"");
      MySDBodyScene->sdb_StartFrame=MyWTStdMsg->ActWaveOp->Operator[4];
      MySDBodyScene->sdb_EndFrame=MyWTStdMsg->ActWaveOp->Operator[5];
      MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SPECIAL_DATA_FOUND;
      MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_SCENE;
      MyWTStdMsg->WTMsgPrc->PRC_NewPtr=MySDBodyScene;
      MESSAGEHANDLE();
      MyWTStdMsg->Flags=MDE_READY;
      }
   else
      {
      MyWTStdMsg->Flags=MDE_NO_MEMORY;
      return;
      }
   }
SCANANIM(MyWTStdMsg->ActWaveOp->Operator[4],MyWTStdMsg->ActWaveOp->Operator[5]);   
LoadSize=LastPosition;
if (AudioDescr.ChannelNum==2) LoadSize=LoadSize*2;

if (LoadSize>MyWTStdMsg->PlayL24/4) LoadSize=MyWTStdMsg->PlayL24/4;
if ((MyMode==MD_MONO) && (MyWTStdMsg->MemA24[2])) LoadAddr=MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24-LoadSize
else if ((MyMode==MD_STEREO) && (MyWTStdMsg->MemA24[0])) LoadAddr=MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24-LoadSize
else
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
OldLoadAddr=LoadAddr;
OffsetAddr=(LONG)SoundOffsetMemA;
LengthAddr=(LONG)SoundLengthMemA;
SLTable=(SampleLengthTable*)LengthAddr; LengthAddr=LengthAddr+12;
Length=SLTable->SamplesPerChunk;
SLTable=(SampleLengthTable*)LengthAddr;
Ctr=0;
do
   {
   if (OffsetAddr<(LONG)SoundOffsetMemA+SoundOffsetMemL)
      {
      Offset=(LONG*)OffsetAddr; OffsetAddr=OffsetAddr+4; Ctr++;
      }
   if ((LengthAddr<(LONG)SoundLengthMemA+SoundLengthMemL) && (Ctr>=SLTable->FirstChunk))
      {
      SLTable=(SampleLengthTable*)LengthAddr; LengthAddr=LengthAddr+12;
      Length=SLTable->SamplesPerChunk;
      }
   SampleBeginOffset=SampleBeginOffset-Length;
   if (SampleBeginOffset<0)
      {
      if (Length>-SampleBeginOffset)
         {
         Seek(MyWTStdMsg->ActFHandle,*Offset+Length+SampleBeginOffset,OFFSET_BEGINNING);
         LoadLength=-SampleBeginOffset;
         }
      else
         {
         Seek(MyWTStdMsg->ActFHandle,*Offset,OFFSET_BEGINNING);
         LoadLength=Length;
         }
      if (LoadSize<LoadLength) LoadLength=LoadSize;
      Read(MyWTStdMsg->ActFHandle,(APTR)LoadAddr,LoadLength);          
      LoadAddr=LoadAddr+LoadLength;
      LoadSize=LoadSize-LoadLength;
      }
   }
while ((LoadSize>0) && (Ctr>0));
if (MyMode==MD_MONO)
   {
   Addr3=OldLoadAddr; Addr1=MyWTStdMsg->MemA24[2];
   do
      {
      Data1=(LONG*)Addr1;  Addr1=Addr1+4;
      Data3=(UBYTE*)Addr3; Addr3++;
      *Data1=(*Data3-128)*65535;
      }
   while ((Addr1<MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24) &&
          (Addr3<MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24));
   while (Addr1<MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24)
      {
      Data1=(LONG*)Addr1; Addr1=Addr1+4;
      *Data1=0;
      }
   }
else if (MyMode==MD_STEREO)
   {
   Addr3=OldLoadAddr; 
   Addr1=MyWTStdMsg->MemA24[0];
   Addr2=MyWTStdMsg->MemA24[1];
   do
      {
      Data1=(LONG*)Addr1;  Addr1=Addr1+4;
      Data3=(UBYTE*)Addr3; Addr3++;
      *Data1=(*Data3-128)*65535;
      Data2=(LONG*)Addr2;  Addr2=Addr2+4;
      Data3=(UBYTE*)Addr3; Addr3++;
      *Data2=(*Data3-128)*65535;      
      }
   while ((Addr1<MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24) &&
          (Addr3<MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24));
   while (Addr1<MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24)
      {
      Data1=(LONG*)Addr1; Addr1=Addr1+4; *Data1=0;
      Data2=(LONG*)Addr2; Addr2=Addr2+4; *Data2=0;
      }
   }
MyWTStdMsg->Flags=MDE_READY;
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (IntuitionBase) && (GfxBase))
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"QuickTime 2.0 Stereo 8 Bit Loader");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               SCANANIM(1,2000000000);
               if (MyWTStdMsg->Flags==MDE_READY)
                  {
                  DEFINESCENE();
                  if (MyWTStdMsg->Flags==MDE_READY)
                     {
                     MyWTStdMsg->ActWaveOp->Operator[0]=LastPosition;
                     MyWTStdMsg->ActWaveOp->Operator[1]=1;
                     MyWTStdMsg->ActiveChannels=MyChannels;
                     MyWTStdMsg->ActiveMode=MyMode;
                     MyWTStdMsg->SRate=(LONG)(10000000.0/(AudioDescr.SampleRate*2.79365));
                     }
                  }
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT) CREATEANIM()
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      if (GfxLengthMemA) FreeVec(GfxLengthMemA);     if (GfxOffsetMemA) FreeVec(GfxOffsetMemA);
      if (SoundLengthMemA) FreeVec(SoundLengthMemA); if (SoundOffsetMemA) FreeVec(SoundOffsetMemA);
      if (GfxTimeMemA) FreeVec(GfxTimeMemA);
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   }
if (DOSBase) CloseLibrary((Library*)DOSBase);
if (GfxBase) CloseLibrary((Library*)GfxBase);
if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);
}
