#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>
#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/graphics_protos.h>

#include <pragma/all_lib.h>

#include <string.h>
#include <stdlib.h>
#include <math.h>

#include </WaveTracer/WTIncl.h>
#include </WaveTracer/EffIncl.c>

struct DPANHeader
   {
   UWORD Version,Frames;
   UBYTE FPS,pad1,pad2,pad3;
   };

extern APTR  SoundLengthMemA=NULL,SoundOffsetMemA=NULL;
extern APTR  GfxLengthMemA=NULL,GfxOffsetMemA=NULL;
extern DPANHeader DPAN;
extern WTStdMsg *MyWTStdMsg;
extern LONG LastPosition,MyMode,MyChannels,l,i;

extern void MESSAGEHANDLE(void);
extern void SENDERROR(char *Fehler);
extern void SCANANIM(LONG StartFrame, LONG EndFrame);


char          Buffer[2][10],ChunkName[4];
IntuiMessage *IMsg;
Gadget       *XGadget;
Gadget        TextGad[2]={NULL,0,40,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,
                          NULL,NULL,NULL,0,NULL,0,0,
                          NULL,0,40,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,
                          NULL,NULL,NULL,0,NULL,0,0};
StringInfo    TextInfo[2]={(UBYTE*)Buffer[0],(UBYTE*)Buffer[0],0,7,0,0,0,0,0,0,NULL,0,NULL,
                           (UBYTE*)Buffer[1],(UBYTE*)Buffer[1],0,7,0,0,0,0,0,0,NULL,0,NULL};
Window       *MyWindow;

LONG  FrameNum[2],ChunkLength;
UBYTE GadCode,RawCode;



void DEFINESCENE(void)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"DEFINITION QT AnimScene");
MyWTStdMsg->WTMsgPrc->PRC_Long1=85;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=1;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr))
   {
   SENDERROR("Couldnt open window!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   };
MyWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
WRITE(40,60,1,3,MyWindow,"1");  WRITE(76,60,2,0,MyWindow,"-");
inttostr(DPAN.Frames,Buffer[0]); WRITE(120,60,1,3,MyWindow,Buffer[0]);
WRITE(160,60,2,0,MyWindow,"QT Anim-Length");
WRITE(76,41,2,0,MyWindow,"-");
WRITE(160,41,2,0,MyWindow,"QT Anim-Scene");
if ((MyWTStdMsg->ActWaveOp->Operator[4]>=1) && (MyWTStdMsg->ActWaveOp->Operator[4]<=DPAN.Frames) &&
    (MyWTStdMsg->ActWaveOp->Operator[5]>=1) && (MyWTStdMsg->ActWaveOp->Operator[5]<=DPAN.Frames) &&
    (MyWTStdMsg->ActWaveOp->Operator[4]<MyWTStdMsg->ActWaveOp->Operator[5]))
   {
   FrameNum[0]=MyWTStdMsg->ActWaveOp->Operator[4];
   FrameNum[1]=MyWTStdMsg->ActWaveOp->Operator[5];
   }
else
   {
   FrameNum[0]=1;
   FrameNum[1]=DPAN.Frames;
   };
for (i=0; i<2; i++)
   {
   TextGad[i].LeftEdge=10+i*80;
   TextGad[i].SpecialInfo=&TextInfo[i];
   TextGad[i].GadgetID=i+3;
   MAKEBORDER(MyWindow,9+i*80,39,70+i*80,53,NEGATIVE);
   inttostr(FrameNum[i],Buffer[i]);
   AddGadget(MyWindow,&TextGad[i],NULL);
   };
RefreshGadgets(MyWindow->FirstGadget,MyWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(MyWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class==GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      }
   else Delay(1);

   for (i=0; i<=2; i++)
      {
      if (GadCode==3)
         {
         FrameNum[0]=strtol(Buffer[0],NULL,10);
         if (FrameNum[0]>=FrameNum[1]) FrameNum[0]=FrameNum[1]-1;
         if (FrameNum[0]<1) FrameNum[0]=1;
         inttostr(FrameNum[0],Buffer[0]);
         RefreshGadgets(MyWindow->FirstGadget,MyWindow,NULL);
         GadCode=4;
         };
      if (GadCode==4)
         {
         FrameNum[1]=strtol(Buffer[1],NULL,10);
         if (FrameNum[1]<=FrameNum[0]) FrameNum[1]=FrameNum[0]+1;
         if (FrameNum[1]>DPAN.Frames) FrameNum[1]=DPAN.Frames;
         inttostr(FrameNum[1],Buffer[1]);
         RefreshGadgets(MyWindow->FirstGadget,MyWindow,NULL);
         GadCode=3;
         }
      }

   }
while ((GadCode!=1) && (GadCode!=2) && (RawCode!=68) && (RawCode!=69));
CloseWindow(MyWindow);
if ((GadCode==2) || (RawCode==69)) MyWTStdMsg->Flags=MDE_CANCELLED else
   {
   MyWTStdMsg->ActWaveOp->Operator[4]=FrameNum[0];
   MyWTStdMsg->ActWaveOp->Operator[5]=FrameNum[1];
   MyWTStdMsg->Flags=MDE_READY;
   if ((FrameNum[0]>1) || (FrameNum[1]<DPAN.Frames)) SCANANIM(FrameNum[0],FrameNum[1]);
   }
}

