#include <exec/types.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>

#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>

#include <clib/intuition_protos.h>
#include <clib/graphics_protos.h>

#include <pragma/all_lib.h>

#include <string.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>
#include </common/QT.h>

extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;

extern DPANHeader DPAN;
extern AudioDescription AudioDescr;
extern LONG MyMode,MyChannels,LastPosition;
extern APTR  SoundLengthMemA,SoundOffsetMemA,GfxLengthMemA,GfxOffsetMemA,GfxTimeMemA;


extern void SCANANIM(LONG StartFrame, LONG EndFrame);
extern void DEFINESCENE(void);



void CREATEANIM(void)

{
SDBodyScene *MySDBodyScene;


MyWTStdMsg->ActiveChannels=0x3F;
MyWTStdMsg->PlayL24=MyWTStdMsg->ActWaveOp->Operator[0]*MyWTStdMsg->ActWaveOp->Operator[1]*4;
if (((MyWTStdMsg->ActWaveOp->Operator[4]>=1) || (MyWTStdMsg->ActWaveOp->Operator[5]<=DPAN.Frames)) &&
     (MyWTStdMsg->ActWaveOp->Operator[4]<MyWTStdMsg->ActWaveOp->Operator[5]))
   {
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ALLOC_SPECIAL_DATA;
   MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_SCENE;
   MESSAGEHANDLE();
   if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr)
      {
      MySDBodyScene=(SDBodyScene*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;                
      MySDBodyScene->sdb_SDHeader.NextSpecialData=NULL;
      MySDBodyScene->sdb_SDHeader.sdh_Size=sizeof(SDBodyScene);
      MySDBodyScene->sdb_SDHeader.sdh_Type=SD_SCENE;
      strcpy(MySDBodyScene->sdb_Name,"");
      MySDBodyScene->sdb_StartFrame=MyWTStdMsg->ActWaveOp->Operator[4];
      MySDBodyScene->sdb_EndFrame=MyWTStdMsg->ActWaveOp->Operator[5];
      MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SPECIAL_DATA_FOUND;
      MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_SCENE;
      MyWTStdMsg->WTMsgPrc->PRC_NewPtr=MySDBodyScene;
      MESSAGEHANDLE();
      MyWTStdMsg->Flags=MDE_READY;
      return;
      }
   else
      {
      MyWTStdMsg->Flags=MDE_NO_MEMORY;
      return;
      }
   }
MyWTStdMsg->Flags=MDE_READY;
}

void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (IntuitionBase) && (GfxBase))
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"QuickTime Runtime Analyzing Loader");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               SCANANIM(1,2000000000);
               if (MyWTStdMsg->Flags==MDE_READY)
                  {
                  DEFINESCENE();
                  if (MyWTStdMsg->Flags==MDE_READY)
                     {
                     MyWTStdMsg->ActWaveOp->Operator[0]=LastPosition;
                     MyWTStdMsg->ActWaveOp->Operator[1]=1;
                     MyWTStdMsg->ActiveChannels=MyChannels;
                     MyWTStdMsg->ActiveMode=MyMode;
                     MyWTStdMsg->SRate=(LONG)(10000000.0/(AudioDescr.SampleRate*2.79365));
                     }
                  }
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT) CREATEANIM()
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      if (GfxLengthMemA) FreeVec(GfxLengthMemA);     if (GfxOffsetMemA) FreeVec(GfxOffsetMemA);
      if (SoundLengthMemA) FreeVec(SoundLengthMemA); if (SoundOffsetMemA) FreeVec(SoundOffsetMemA);
      if (GfxTimeMemA) FreeVec(GfxTimeMemA);
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   }
if (DOSBase) CloseLibrary((Library*)DOSBase);
if (GfxBase) CloseLibrary((Library*)GfxBase);
if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);
}
