#include <exec/types.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include </WaveTracer/WTincl.h>

#include <inttostr.h>
#include <math.h>

#ifndef __PPC__
   #include <pragma/all_lib.h>
#endif

extern struct IntuitionBase *IntuitionBase;
extern struct WTStdMsg      *MyWTStdMsg;

extern void MESSAGEHANDLE(void);



void MAKEWAVE(LONG SAddr)

{
LONG  *Data1;
LONG   Ctr,Steps=6,Addr1,WaveSize,StepCtr=25;
FLOAT  StepSize,PeriodSize,SFreq,SineFactor;
char   s[10];
UBYTE  CtrStep;



WaveSize=MyWTStdMsg->ActWaveOp->Operator[0]*MyWTStdMsg->ActWaveOp->Operator[1]*4;
if (WaveSize>MyWTStdMsg->MemL24) WaveSize=MyWTStdMsg->MemL24;
MyWTStdMsg->PlayL24=WaveSize;
Ctr=MyWTStdMsg->ActWaveOp->Operator[4];
SFreq=10000000.0/(MyWTStdMsg->SRate*2.79365);
PeriodSize=SFreq/Ctr;
SineFactor=80000;
CtrStep=(MyWTStdMsg->ActWaveOp->Operator[5]-MyWTStdMsg->ActWaveOp->Operator[4])/2500;
if (CtrStep<1) CtrStep=1;
if (SAddr)
   {
   do
      {
      StepCtr--;
      if (StepCtr<=1)
         {
         #ifdef __PPC__
            StepCtr=250;
         #else
            StepCtr=25;
         #endif
         inttostr(Ctr,s);
         strcat(s," Hz");
         MyWTStdMsg->Flags=0;
         MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,s);
         MESSAGEHANDLE();
         }
      StepSize=6.2831852/PeriodSize;
      Steps=Steps-(IntuitionBase->Micros & 0x5555);
      if (MyWTStdMsg->ActWaveOp->Operator[3]==1) SineFactor=((MyWTStdMsg->ActWaveOp->Operator[5]*40)/Ctr);
      Addr1=SAddr;
      do
         {
         Data1=(LONG*)(Addr1); Addr1=Addr1+4;
         *Data1=*Data1+(LONG)(SineFactor*sin(StepSize*Steps));
         Steps++;
         }
      while (Addr1<SAddr+WaveSize);
      Ctr=Ctr+CtrStep;
      PeriodSize=SFreq/Ctr;
      }
   while ((Ctr<=MyWTStdMsg->ActWaveOp->Operator[5]) && (PeriodSize>=1));
   }
}
