#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/IntuitionBase.h>
#include <libraries/dos.h>

#include <clib/intuition_protos.h>
#include <clib/graphics_protos.h>
#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <inttostr.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/EffIncl.c>
#include </WaveTracer/WTIncl.h>

extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;


extern void MAKEWAVE(LONG SAddr);



BYTE       ChBit,ChID,ChannelDone;
PropInfo   SchieberInfo[2]={FREEHORIZ,0,0,0,0,0,0,0,0,0,0,
                            FREEHORIZ,0,0,0,0,0,0,0,0,0,0};
Image      SImage[2];
char       Buffer[2][20],UndoBuffer[2][20];
StringInfo TextInfo[2]={(UBYTE*)Buffer[0],(UBYTE*)UndoBuffer[0],0,9,0,0,0,0,0,0,NULL,0,NULL,
                        (UBYTE*)Buffer[1],(UBYTE*)UndoBuffer[1],0,9,0,0,0,0,0,0,NULL,0,NULL};
Gadget     Schieber[2]={NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[0],
                        NULL,NULL,0,&SchieberInfo[0],0,0,
                        NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[1],
                        NULL,NULL,0,&SchieberInfo[1],0,0};
Gadget     TextGad[2]={NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,
                       NULL,NULL,NULL,0,&TextInfo[0],0,0,
                       NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,
                       NULL,NULL,NULL,0,&TextInfo[1],0,0};



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



void CREATEPROPGAD(WORD LEdge, WORD TEdge, WORD XSet, WORD XJump, WORD GadNum,
                   WORD IDOffset, Window *XWindow)


{
SImage[GadNum]=*MyWTStdMsg->WTImg->KnobImg;
Schieber[GadNum].LeftEdge=LEdge;
Schieber[GadNum].TopEdge=TEdge;
Schieber[GadNum].GadgetID=IDOffset+(GadNum+1)*2-1,0;
SchieberInfo[GadNum].HorizPot=XSet;
SchieberInfo[GadNum].HorizBody=XJump;
TextGad[GadNum].LeftEdge=LEdge+332;
TextGad[GadNum].TopEdge=TEdge+1;
TextGad[GadNum].GadgetID=IDOffset+(GadNum+1)*2,0;
strcpy(UndoBuffer[GadNum],"");
MAKEBORDER(*XWindow,LEdge+330,TEdge,LEdge+394,TEdge+14,NEGATIVE);
}



void DEFINEWAVE(void)

{
Window   *DWindow;
BYTE      i,GadCode,RawCode;
IntuiText DKnopfTx[3]={2,0,0,32,2,MyWTStdMsg->WTScreen->Font,"white noise",NULL,
                       2,0,0,39,2,MyWTStdMsg->WTScreen->Font,"pink noise",NULL,
                       2,0,0,26 ,2,MyWTStdMsg->WTScreen->Font,"Dolby-noise",NULL};
Gadget    DKnopf[5]={NULL,500,40,128,16,GADGHCOMP+GADGIMAGE,0x3,BOOLGADGET,NULL,NULL,NULL,0,NULL,1,0,
                     NULL,0,40,128,16,GADGHCOMP+GADGIMAGE,0x3,BOOLGADGET,NULL,NULL,&DKnopfTx[0],0,NULL,2,0,
                     NULL,0,40,128,16,GADGHCOMP+GADGIMAGE,0x3,BOOLGADGET,NULL,NULL,&DKnopfTx[1],0,NULL,3,0,
                     NULL,0,40,128,16,GADGHCOMP+GADGIMAGE,0x3,BOOLGADGET,NULL,NULL,&DKnopfTx[2],0,NULL,4,0,
                     NULL,10,103,21,12,GADGHIMAGE+GADGIMAGE,TOGGLESELECT+0x3,BOOLGADGET,NULL,NULL,NULL,0,NULL,5,0};
Gadget       *XGadget;
IntuiMessage *IMsg;


if ((MyWTStdMsg->ActWaveOp->Operator[4]<1) ||
    (MyWTStdMsg->ActWaveOp->Operator[4]>MyWTStdMsg->ActWaveOp->Operator[5]))
   {
   MyWTStdMsg->ActWaveOp->Operator[4]=16;
   MyWTStdMsg->ActWaveOp->Operator[3]=0;
   }
if ((MyWTStdMsg->ActWaveOp->Operator[5]<MyWTStdMsg->ActWaveOp->Operator[4]) ||
    (MyWTStdMsg->ActWaveOp->Operator[5]>25000))
   {
   MyWTStdMsg->ActWaveOp->Operator[5]=20000;
   MyWTStdMsg->ActWaveOp->Operator[3]=0;
   }
if ((MyWTStdMsg->ActWaveOp->Operator[3]<0) || (MyWTStdMsg->ActWaveOp->Operator[3]>1))
 MyWTStdMsg->ActWaveOp->Operator[3]=0;
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Definition HQ-Noisegenerator ( by QXC)");
MyWTStdMsg->WTMsgPrc->PRC_Long1=123;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=0;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr))
   {
   SENDERROR("Can't open definitionwindow!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
DWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
for (i=0; i<2; i++)
   {
   CREATEPROPGAD(10,66+i*17,(MyWTStdMsg->ActWaveOp->Operator[i+4]-1)*2,2,i,8,DWindow);
   inttostr(MyWTStdMsg->ActWaveOp->Operator[i+4],Buffer[i]);
   }
WRITE(410,67,2,0,*DWindow,"lower frequency");
WRITE(410,83,2,0,*DWindow,"upper frequency");
DKnopf[0].GadgetRender=MyWTStdMsg->WTImg->GImg5;
DKnopf[0].GadgetText=MyWTStdMsg->WTImg->OKIText;
for (i=1; i<4; i++)
   {
   DKnopf[i].LeftEdge=i*135-125;
   DKnopf[i].GadgetRender=MyWTStdMsg->WTImg->GImg1;
   }
DKnopf[4].GadgetRender=MyWTStdMsg->WTImg->ButtonImg1;
DKnopf[4].SelectRender=MyWTStdMsg->WTImg->ButtonImg2;
if (MyWTStdMsg->ActWaveOp->Operator[3]!=0) DKnopf[4].Flags=DKnopf[4].Flags | SELECTED;
WRITE(35,104,2,0,*DWindow,"A = 1/f");
for (i=0; i<5; i++) AddGadget(DWindow,&DKnopf[i],NULL);
for (i=0; i<2; i++) AddGadget(DWindow,&TextGad[i],NULL);
for (i=0; i<2; i++) AddGadget(DWindow,&Schieber[i],NULL);
RefreshGadgets(DWindow->FirstGadget,DWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(DWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class=GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         if ((GadCode>=0) && (GadCode<=3) && (IMsg->Class==GADGETDOWN)) GadCode=0;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      }
   else Delay(1);

   if (GadCode==2)
      {
      strcpy(Buffer[0],"16");
      strcpy(Buffer[1],"20000");
      if ((DKnopf[4].Flags & SELECTED)==SELECTED) DKnopf[4].Flags=DKnopf[4].Flags-SELECTED;
      }
   if (GadCode==3)
      {
      strcpy(Buffer[0],"50");
      strcpy(Buffer[1],"10000");
      DKnopf[4].Flags=DKnopf[4].Flags | SELECTED;
      }
   if (GadCode==4)
      {
      strcpy(Buffer[0],"100");
      strcpy(Buffer[1],"7000");
      if ((DKnopf[4].Flags & SELECTED)==SELECTED) DKnopf[4].Flags=DKnopf[4].Flags-SELECTED;
      }

   if ((GadCode==9) || ((Schieber[0].Flags & SELECTED)==SELECTED))
      {
      MyWTStdMsg->ActWaveOp->Operator[4]=(SchieberInfo[0].HorizPot/2)+1;
      if (MyWTStdMsg->ActWaveOp->Operator[4]<1) MyWTStdMsg->ActWaveOp->Operator[4]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[4]>MyWTStdMsg->ActWaveOp->Operator[5])
       MyWTStdMsg->ActWaveOp->Operator[4]=MyWTStdMsg->ActWaveOp->Operator[5];
      inttostr(MyWTStdMsg->ActWaveOp->Operator[4],Buffer[0]);
      RefreshGadgets(&TextGad[0],DWindow,NULL);
      }
   if ((GadCode==2) || (GadCode==3) || (GadCode==4) || (GadCode==10))
      {
      MyWTStdMsg->ActWaveOp->Operator[4]=strtol(Buffer[0],NULL,0);
      if (MyWTStdMsg->ActWaveOp->Operator[4]<1) MyWTStdMsg->ActWaveOp->Operator[4]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[4]>MyWTStdMsg->ActWaveOp->Operator[5])
       MyWTStdMsg->ActWaveOp->Operator[4]=MyWTStdMsg->ActWaveOp->Operator[5];
      inttostr(MyWTStdMsg->ActWaveOp->Operator[4],Buffer[0]);
      SchieberInfo[0].HorizPot=(MyWTStdMsg->ActWaveOp->Operator[4]-1)*2;
      RefreshGadgets(&Schieber[0],DWindow,NULL);
      }

   if ((GadCode==11) || ((Schieber[1].Flags & SELECTED)==SELECTED))
      {
      MyWTStdMsg->ActWaveOp->Operator[5]=(SchieberInfo[1].HorizPot/2)+1;
      if (MyWTStdMsg->ActWaveOp->Operator[5]<MyWTStdMsg->ActWaveOp->Operator[4])
       MyWTStdMsg->ActWaveOp->Operator[5]=MyWTStdMsg->ActWaveOp->Operator[4];
      if (MyWTStdMsg->ActWaveOp->Operator[5]>25000) MyWTStdMsg->ActWaveOp->Operator[5]=25000;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[5],Buffer[1]);
      RefreshGadgets(&TextGad[1],DWindow,NULL);
      }
   if ((GadCode==2) || (GadCode==3) || (GadCode==4) || (GadCode==12))
      {
      MyWTStdMsg->ActWaveOp->Operator[5]=strtol(Buffer[1],NULL,0);
      if (MyWTStdMsg->ActWaveOp->Operator[5]<MyWTStdMsg->ActWaveOp->Operator[4])
       MyWTStdMsg->ActWaveOp->Operator[5]=MyWTStdMsg->ActWaveOp->Operator[4];
      if (MyWTStdMsg->ActWaveOp->Operator[5]>25000) MyWTStdMsg->ActWaveOp->Operator[5]=25000;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[5],Buffer[1]);
      SchieberInfo[1].HorizPot=(MyWTStdMsg->ActWaveOp->Operator[5]-1)*2;
      RefreshGadgets(&Schieber[1],DWindow,NULL);
      }
   }
while ((GadCode!=1) && (RawCode!=68));
if (RawCode==68)
   {
   DKnopf[0].Flags=DKnopf[0].Flags | SELECTED;
   RefreshGadgets(DWindow->FirstGadget,DWindow,NULL);
   Delay(5);
   }
if ((DKnopf[4].Flags & SELECTED)==SELECTED) MyWTStdMsg->ActWaveOp->Operator[3]=1
 else MyWTStdMsg->ActWaveOp->Operator[3]=0;
CloseWindow(DWindow);
};



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (IntuitionBase) && (GfxBase))
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            DEFINEWAVE();
            MyWTStdMsg->Flags=MDE_NICE_SOFTMOD;
            }
         else if (MyWTStdMsg->Flags==MDC_DEFINEIT) MyWTStdMsg->Flags=MDE_NICE_SOFTMOD
         else if (MyWTStdMsg->Flags==MDC_DOIT)
            {
            ChBit=1; ChannelDone=-1;
            for (ChID=0; ChID<6; ChID++)
               {
               if ((MyWTStdMsg->ActiveChannels & ChBit)==ChBit)
                  {
                  if (ChannelDone<0)
                     {
                     MAKEWAVE(MyWTStdMsg->MemA24[ChID]);
                     ChannelDone=ChID;
                     }
                  else CopyMem((APTR)MyWTStdMsg->MemA24[ChannelDone],(APTR)MyWTStdMsg->MemA24[ChID],MyWTStdMsg->PlayL24);
                  }
               ChBit=ChBit*2;
               }
            MyWTStdMsg->Flags=MDE_READY;
            }
         else (MyWTStdMsg->Flags=MDE_ERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   }
if (DOSBase) CloseLibrary((Library*)DOSBase);
if (GfxBase) CloseLibrary((Library*)GfxBase);
if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);
}
