program SoftModul;

Uses ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}
{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod"}

type ByteArr4=array[1..4] of byte;

var IMsg                :^IntuiMessage;
var DKnopf              :array[1..38] of Gadget;
var TextGad             :Gadget;
var XGadget             :^Gadget;
var TextInfo            :StringInfo;
var DKnopfTx            :array[1..3] of IntuiText;
var MyWindow            :^Window;
var Addr1,Addr2,l       :long;
var i                   :integer;
var Data1,Data2         :^long;
var RawCode,GadCode     :byte;
var MsgGone             :boolean;
var s,Buffer            :string[5];
var BA                  :^ByteArr4;
var FileFR,PathFR       :string[150];
var Suffix              :string[4];
var FHandle             :BPTR;
var CCnt,CID            :byte;



procedure WRITE(LEdge,TEdge :word; Stpen,DMode :byte; Wind :Window; txt :str);

var IT1 :IntuiText;

begin
   IT1:=IntuiText(StPen,0,0,LEdge,TEdge,MyWTStdMsg^.WTScreen^.Font,txt,NIL);
   if DMode=3 then IT1.LeftEdge:=LEdge-IntuiTextLength(^IT1) div 2;
   PrintIText(Wind.RPort,^IT1,0,0);
end;



procedure MAKEWAVE(SAddr :long);

var Wave1A,Wave1L,Play1L,Steps  :long;
var Waves,ChBit,ChID,i          :byte;
var Stepsize                    :real;

begin
   with MyWTStdMsg^ do begin
      Wave1L:=ActWaveOp^.Operator[1]*4+16;
      Wave1A:=AllocMem(Wave1L,MEMF_CLEAR);
      if Wave1A=0 then begin
         Flags:=MDE_No_MEMORY;
         exit;
      end;
      Stepsize:=6.2831852/ActWaveOp^.Operator[1];
      Addr1:=Wave1A; Steps:=0;
      repeat
         Data1:=ptr(Addr1); Addr1:=Addr1+4;
         Data1^:=round(8388000*sin(Stepsize*Steps));
         Steps:=Steps+1;
      until Addr1>=Wave1A+Wave1L;
      while not (Data1^<0) do begin  {            (Data1^ in [-4000..4000]) do begin}
         Data1^:=0;
         Addr1:=Addr1-4; Data1:=ptr(Addr1);
      end;
      Play1L:=Addr1-Wave1A;
      Waves:=0;
      l:=1;    for i:=1 to 32 do begin
         if not (ActWaveOp^.Operator[4] and l=0) and (ActWaveOp^.Operator[1]>i*4) then begin
            Waves:=Waves+1; Addr1:=Wave1A; Addr2:=SAddr;
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+(4*i);
               while Addr1>Wave1A+Play1L do Addr1:=Addr1-Play1L;
               Data2:=ptr(Addr2); Addr2:=Addr2+4;
               Data2^:=(Data1^ div i)+Data2^;
            until Addr2>=SAddr+MemL24;
         end;
      l:=l*2;  end;
      if Waves>1 then begin
         Addr2:=SAddr;
         repeat
            Data2:=ptr(Addr2); Addr2:=Addr2+4;
            Data2^:=Data2^ div Waves;
         until Addr2>=SAddr+MemL24;
      end;
      PlayL24:=Play1L*ActWaveOp^.Operator[2];
      if PlayL24>MemL24 then PlayL24:=MemL24;
      FreeMem(Wave1A,Wave1L);
      ChBit:=1;
      for ChID:=1 to 6 do begin
         if not (ActiveChannels and ChBit=0) and (MemA24[ChID]<>SAddr) and (MemA24[ChID]<>0) then
          CopyMemQuick(SAddr,MemA24[ChID],PlayL24);
         ChBit:=ChBit*2;
      end;
      Flags:=MDE_READY;
   end;
end;



procedure SETPARAMETERS;

begin
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition MULTIPLE SINES ( by QXC)',
                        '','','','',190,0,0,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'Can`t open definitionwindow!','Operation cancelled!',
                           '','OK','',0,0,0,0,0,NIL);
         MESSAGEHANDLE;
         Flags:=MDE_ERROR;
         exit;
      end;
      MyWindow:=WTMsgPrc^.PRC_NewPtr;

      l:=1;
      for i:=0 to 31 do begin
         DKnopf[i+1]:=Gadget(NIL,i mod 8 * 70+40,i div 8 * 20+48,21,12,GADGHIMAGE+
                             GADGIMAGE,TOGGLESELECT+$3,BOOLGADGET,WTImg^.ButtonImg1,
                             WTImg^.ButtonImg2,NIL,0,Nil,i,0);
         s:=intstr(i+1)+'.';
         WRITE(i mod 8 * 70+65, i div 8 * 20+48,1,0,Mywindow^,s);
         if not (ActWaveOp^.Operator[4] and l=0) then DKnopf[i+1].Flags:=DKnopf[i+1].Flags or SELECTED;
         l:=l*2;
      end;
      for i:=33 to 35 do DKnopf[i]:=Gadget(NIL,(i-33)*132+10,167,128,16,GADGHCOMP+GADGIMAGE,
                                            $1,BOOLGADGET,WTImg^.GImg1,NIL,^DKnopfTx[i-32],
                                            0,NIL,i,0);
      DKnopf[36]:=Gadget(NIL,500,167,128,16,GADGHCOMP+GADGIMAGE,$3,BOOLGADGET,WTImg^.GImg5,
                         NIL,WTImg^.OKIText,0,NIL,36,0);
      for i:=37 to 38 do DKnopf[i]:=Gadget(NIL,80+(i-36)*100,127,43,21,GADGHIMAGE+
                                    GADGIMAGE,$1,BOOLGADGET,WTImg^.GImg3,WTImg^.GImg4,NIL,0,
                                    NIL,i,0);
      TextGad:=Gadget(NIL,60,135,40,15,GADGHCOMP,STRINGCENTER+$1,STRGADGET,NIL,NIL,
                      NIL,0,^TextInfo,39,0);
      TextInfo:=StringInfo(^Buffer,^Buffer,0,5,0,0,0,0,0,0,NIL,0,NIL);
      SetAPen(MyWindow^.RPort,1);
      Move(MyWindow^.RPort,101,133); Draw(MyWindow^.RPort,58,133);
      Draw(MyWindow^.RPort,58,148);  Draw(MyWindow^.RPort,59,147);
      Draw(MyWindow^.RPort,59,132);
      SetAPen(MyWindow^.RPort,2);
      Move(MyWindow^.RPort,59,148);  Draw(MyWindow^.RPort,101,148);
      Draw(MyWindow^.RPort,101,134); Draw(MyWindow^.RPort,100,134);
      Draw(MyWindow^.RPort,100,148);
      with ActWaveOp^ do BA:=ptr(addr(Operator[4]));
      Buffer:=chr(BA^[1])+chr(BA^[2])+chr(BA^[3])+chr(BA^[4]);
      WRITE(79,150,2,3,MyWindow^,'Bit-string');
      WRITE(200,150,2,3,MyWindow^,'Load');
      WRITE(300,150,2,3,MyWindow^,'Save');

      DKnopfTx[1]:=IntuiText(2,0,0,62,2,NIL,'1',NIL);
      DKnopfTx[2]:=IntuiText(2,0,0,50,2,NIL,'2n+1',NIL);
      DKnopfTx[3]:=IntuiText(2,0,0,40,2,NIL,'Invert',NIL);

      for i:=1 to 38 do AddGadget(MyWindow,^DKnopf[i],NIL);
      AddGadget(MyWindow,^TextGad,NIL);
      RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
      FileFR:=''; Flags:=0;
      repeat
         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(MyWindow^.UserPort);
         If IMsg<>Nil Then begin
            if (IMsg^.class in [GADGETDOWN,GADGETUP]) then begin
               XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg);
            MsgGone:=true;
         End else MsgGone:=false;

         if GadCode in [1..32] then begin
            ActWaveOp^.Operator[4]:=0;
            l:=1;   for i:=1 to 32 do begin
               if not (DKnopf[i].flags and SELECTED=0) then ActWaveOp^.Operator[4]:=ActWaveOp^.Operator[4]+l;
            l:=l*2; end;
            Buffer:=chr(BA^[1])+chr(BA^[2])+chr(BA^[3])+chr(BA^[4]);
            RefreshGadgets(^TextGad,MyWindow,NIL);
         end else if GadCode in [33..35] then begin
            case GadCode of
               33: begin
                      DKnopf[1].Flags:=DKnopf[1].Flags or SELECTED;
                      for i:=2 to 32 do DKnopf[i].Flags:=Dknopf[i].Flags and not SELECTED;
                   end;
               34: for i:=1 to 32 do if odd(i) then
                    DKnopf[i].Flags:=DKnopf[i].Flags or SELECTED
                    else DKnopf[i].Flags:=DKnopf[i].Flags and not SELECTED;
               35: for i:=1 to 32 do DKnopf[i].Flags:=DKnopf[i].Flags xor SELECTED;
               otherwise;
            end;
            ActWaveOp^.Operator[4]:=0;
            l:=1;   for i:=1 to 32 do begin
               if not (DKnopf[i].flags and SELECTED=0) then ActWaveOp^.Operator[4]:=ActWaveOp^.Operator[4]+l;
            l:=l*2; end;
            Buffer:=chr(BA^[1])+chr(BA^[2])+chr(BA^[3])+chr(BA^[4]);
            RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
         end else if GadCode=37 then begin
            WTMsgPrc^:=MsgPrc(WTM_FILEREQ,'','LOADER/SOFTMOD-DATA/',FileFR,
                              '#?.OW','LOAD datafile',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            if WTMsgPrc^.PRC_Long1<>-1 then begin
               PathFR:=WTMsgPrc^.PRC_Str1;
               FileFR:=WTMsgPrc^.PRC_Str3;
               FHandle:=DosOpen(PathFR,MODE_OLDFILE);
               if FHandle<>0 then begin
                  l:=DosRead(FHandle,^ActWaveOp^.Operator[4],4);
                  DosClose(FHandle);
                  l:=1;
                  for i:=0 to 31 do begin
                     if not (ActWaveOp^.Operator[4] and l=0)
                      then DKnopf[i+1].Flags:=DKnopf[i+1].Flags or SELECTED
                       else DKnopf[i+1].Flags:=DKnopf[i+1].Flags and not SELECTED;
                     l:=l*2;
                  end;
                  Buffer:=chr(BA^[1])+chr(BA^[2])+chr(BA^[3])+chr(BA^[4]);
                  RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
               end else begin
                  WTMsgPrc^:=MsgPrc(WTM_TASKREQ,PathFR,'Can`t find file!',
                                    '','OK','',0,0,0,0,0,NIL);
                  MESSAGEHANDLE;
               end;
            end;
         end else if GadCode=38 then begin
            WTMsgPrc^:=MsgPrc(WTM_FILEREQ,'','LOADER/SOFTMOD-DATA/',FileFR,
                              '#?.OW','SAVE datafile',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            if WTMsgPrc^.PRC_Long1<>-1 then begin
               PathFR:=WTMsgPrc^.PRC_Str1;
               FileFR:=WTMsgPrc^.PRC_Str3;
               for i:=1 to 3 do Suffix[i]:=FileFR[length(FileFR)-3+i];
               Suffix[4]:=chr(0);
               if Suffix<>'.OW' then begin
                  PathFR:=PathFR+'.OW'; FileFR:=FileFR+'.OW';
               end;
               FHandle:=DosOpen(PathFR,MODE_NEWFILE);
               if FHandle<>0 then begin
                  l:=DosWrite(FHandle,^ActWaveOp^.Operator[4],4);
                  DosClose(FHandle);
               end else begin
                  WTMsgPrc^:=MsgPrc(WTM_TASKREQ,PathFR,'Can`t create file!',
                                    '','OK','',0,0,0,0,0,NIL);
                  MESSAGEHANDLE;
               end;
            end;
         end else if GadCode=39 then begin
            for i:=1 to 4 do BA^[i]:=ord(Buffer[i]);
            l:=1;
            for i:=0 to 31 do begin
               if not (ActWaveOp^.Operator[4] and l=0)
                then DKnopf[i+1].Flags:=DKnopf[i+1].Flags or SELECTED
                 else DKnopf[i+1].Flags:=DKnopf[i+1].Flags and not SELECTED;
               l:=l*2;
            end;
            RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
         end;

      Until (GadCode=36) or (RawCode=68);
      if RawCode=68 then begin
         DKnopf[36].flags:=DKnopf[36].flags or SELECTED;
         RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
         delay(5);
      end;
      ActWaveOp^.Operator[4]:=0;
      l:=1;   for i:=1 to 32 do begin
         if not (DKnopf[i].flags and SELECTED=0) then ActWaveOp^.Operator[4]:=ActWaveOp^.Operator[4]+l;
      l:=l*2; end;
      CloseWindow(MyWindow);
      Flags:=MDE_NICE_SOFTMOD;
   end;
end;



begin
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   OpenLib(DosBase,'dos.library',0);
   if CREATEPORTS(PORT_LOADER) then begin
      with MyWTStdMsg^ do if Version=VERSION_LOADER then begin
         if Flags=MDC_ASKREADY then SETPARAMETERS
         else if Flags=MDC_DEFINEIT then Flags:=MDE_NICE_SOFTMOD
         else if Flags=MDC_DOIT then begin
            CID:=1;
            for CCnt:=1 to 6 do begin
               if not (ActiveChannels and CID=0) then MAKEWAVE(MemA24[CCnt]);
               CID:=CID*2;
            end;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(DosBase);
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.

