#include <exec/types.h>
#include <intuition/intuitionbase.h>
#include <libraries/mpega.h>
#include <libraries/dos.h>

#include <clib/mpega_protos.h>
#include <clib/exec_protos.h>

#include <pragma/mpega_lib.h>
#include <pragma/all_lib.h>

#include <string.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

struct Library *MPEGABase;

#ifdef __MIXEDBINARY__
   extern LONG INITIATEWARPOS(void);
#endif   

LONG          SFrequency;
MPEGA_STREAM *mps = NULL;
MPEGA_CTRL    mpa_ctrl={NULL,{0,{0,2,48000},{0,2,48000}},
                             {0,{0,2,48000},{0,2,48000}},
                        1,16000};



void READMPEG(void)

{
LONG  MemOffset,pcm_count,Addr1,Addr2;
BOOL  DoStream;
WORD *pcm[MPEGA_MAX_CHANNELS];
BYTE  i;
LONG *Data24;
WORD *Data16;


#ifdef __MIXEDBINARY__
   MemOffset=INITIATEWARPOS();
#else   
   MemOffset=MyWTStdMsg->ActWaveOp->Operator[0]*2;
#endif;   
DoStream=TRUE;
mps=MPEGA_open(MyWTStdMsg->ActWaveOp->OpString,&mpa_ctrl);
if (mps)
   {
   if (((mps->mode==3) && (!(MyWTStdMsg->MemA24[2]))) ||
       ((mps->mode<3) && ((!(MyWTStdMsg->MemA24[0])) || (!(MyWTStdMsg->MemA24[1])))))
      {
      MPEGA_close(mps);
      MyWTStdMsg->Flags=MDE_NO_MEMORY;
      return;
      }
   while (DoStream)
      {
      if (MemOffset<mpa_ctrl.stream_buffer_size) DoStream=FALSE;
      if (DoStream)
         {
         if (mps->mode==3)
            {
            pcm[0]=(WORD*)(MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24-MemOffset);
            pcm[1]=NULL;
            }
         else
            {
            pcm[0]=(WORD*)(MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24-MemOffset);
            pcm[1]=(WORD*)(MyWTStdMsg->MemA24[1]+MyWTStdMsg->MemL24-MemOffset);
            }
         pcm_count=MPEGA_decode_frame(mps,pcm);
         if (pcm_count<0) DoStream=FALSE else MemOffset=MemOffset-(pcm_count*2);
         }
      }
   MPEGA_close(mps);
   for (i=0; i<3; i++) if (((mps->mode==3) && (i==2)) || (i<2))
      {
      if (MyWTStdMsg->MemA24[i])
         {
         Addr1=MyWTStdMsg->MemA24[i];
         Addr2=MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24-MyWTStdMsg->ActWaveOp->Operator[0]*2;
         do
            {
            Data24=(LONG*)Addr1; Addr1=Addr1+4;
            Data16=(WORD*)Addr2; Addr2=Addr2+2;
            *Data24=*Data16*256;
            }
         while ((Addr1<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24) && (Addr2<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24-MemOffset));
         MyWTStdMsg->PlayL24=Addr1-MyWTStdMsg->MemA24[i];
         }
      }
   MyWTStdMsg->Flags=MDE_READY;
   }
else
   {
   SENDERROR("Can't read MPEG!");
   MyWTStdMsg->Flags=MDE_ERROR;
   }
}



void main (void)

{
if (CREATEPORTS(PORT_LOADER))
   {
   if (MyWTStdMsg->Version==VERSION_LOADER)
      {
      MPEGABase=OpenLibrary("mpega_wt.library",0);
      if (!MPEGABase) MPEGABase=OpenLibrary("mpega.library",0);
      if (MPEGABase)
         {            
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"MPEG-Audio-Loader (using mpega.library)");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            SFrequency=5+(LONG)(10000000.0/(MyWTStdMsg->SRate*2.79365));
            mpa_ctrl.layer_1_2.mono.freq_max=SFrequency;
            mpa_ctrl.layer_1_2.stereo.freq_max=SFrequency;
            mpa_ctrl.layer_3.mono.freq_max=SFrequency;
            mpa_ctrl.layer_3.stereo.freq_max=SFrequency;
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               #ifdef __MIXEDBINARY__
                  INITIATEWARPOS();
               #endif
               mps=MPEGA_open(MyWTStdMsg->ActWaveOp->OpString,&mpa_ctrl);
               if (mps)
                  {
                  if (mps->mode==3)
                     {
                     MyWTStdMsg->ActiveMode=MD_MONO;
                     MyWTStdMsg->ActiveChannels=CH_CENTER;
                     }
                  else
                     {
                     MyWTStdMsg->ActiveMode=MD_STEREO;
                     MyWTStdMsg->ActiveChannels=CH_LEFT+CH_RIGHT;
                     }
                  MyWTStdMsg->ActWaveOp->Operator[0]=(LONG)(mps->dec_frequency*(mps->ms_duration/1000.0));
                  MyWTStdMsg->ActWaveOp->Operator[1]=1;
                  MyWTStdMsg->SRate=(LONG)(10000000.0/(mps->dec_frequency*2.79365));
                  MyWTStdMsg->Flags=MDE_READY;
                  MPEGA_close(mps);
                  }
               else MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               READMPEG();
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         CloseLibrary(MPEGABase);
         }
      else
         {
         SENDERROR("Can't open mpega.library!");
         MyWTStdMsg->Flags=MDE_READY;         
         }
      }
   else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
   MESSAGEHANDLE();
   RemPort(MyPort);
   DeleteMsgPort(MyPort)
   }
}
