#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>

extern struct DOSBase *DOSBase;

struct IFFHeader
   {
   char IFFId[4];
   LONG IFFLength;
   char IFFType[4];
   };
struct IFFChunk
   {
   char ChunkID[4];
   LONG ChunkLength;
   };
struct MaudHeader
   {
   LONG  SampleSize;
   UWORD ResolutionLeft,ResolutionRight;
   LONG  SampleFreq,Unknown1;
   UWORD ChannelNum;
   char  Unknown2[14];
   };

MaudHeader MaudHd;
IFFHeader  IFFHd;
IFFChunk   IFFCh;

LONG  MemLS,l,SampleDepth,Loaded,Size,RealLength,MemLLoad;
LONG  Addr24[6];
APTR  MemALoad;
UBYTE SampleRes;
WORD  i;
char  s[50];
UBYTE MyChannels,MyMode,ChBit,ChID,ChCnt;



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



BOOL GETSAVEMEM(void)

{
MemLLoad=(100032/ChCnt)*ChCnt;
MemALoad=AllocVec(MemLLoad,MEMF_FAST);
if (!MemALoad)
   {
   l=AvailMem(MEMF_LARGEST);
   if (l>MemLLoad) l=MemLLoad;
   MemLLoad=l;
   MemLLoad=((ULONG)(MemLLoad/ChCnt))*ChCnt;
   MemALoad=AllocVec(MemLLoad,MEMF_FAST);
   if (!MemALoad) return FALSE;
   }
return TRUE;
}



BOOL READHEADER(void)

{
MemLS=0;
Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
Read(MyWTStdMsg->ActFHandle,&IFFHd,12);
if (!(strncmp(IFFHd.IFFId,"FORM",4)))
   {
   MyMode=0;
   if (!(strncmp(IFFHd.IFFType,"MAUD",4)))
      {
      do
         {
         l=Read(MyWTStdMsg->ActFHandle,&IFFCh,8);
         if (IFFCh.ChunkLength%2==1) IFFCh.ChunkLength++;
         if (!(strncmp(IFFCh.ChunkID,"MHDR",4)))
            {
            Loaded=Read(MyWTStdMsg->ActFHandle,&MaudHd,IFFCh.ChunkLength);
            if (MyMode==0) MyMode=MD_MONO;
            MemLS=MaudHd.SampleSize/MyMode;
            MyWTStdMsg->SRate=(LONG)(10000000.0/(MaudHd.SampleFreq*2.79365));
            if (MyWTStdMsg->SRate<60) MyWTStdMsg->SRate=60;
            if (MyWTStdMsg->SRate>60000) MyWTStdMsg->SRate=60000;
            SampleRes=MaudHd.ResolutionLeft;
            if (SampleRes>16)
               {
               SENDERROR("Unknown sample-resolution!");
               MyWTStdMsg->Flags=MDE_ERROR;
               return FALSE;               
               }
            if (MaudHd.ChannelNum==1) MyMode=MD_MONO
            else if (MaudHd.ChannelNum==2) MyMode=MD_STEREO
            else if (MaudHd.ChannelNum==3) MyMode=MD_3CH
            else if (MaudHd.ChannelNum==4) MyMode=MD_SURROUND
            else if (MaudHd.ChannelNum==5) MyMode=MD_AC3_Sub
            else if (MaudHd.ChannelNum==6) MyMode=MD_AC3
            else
               {
               SENDERROR("Too much audiochannels in MAUD-file!");
               MyWTStdMsg->Flags=MDE_ERROR;
               return FALSE;
               }
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETCHANNELBITS;
            MyWTStdMsg->WTMsgPrc->PRC_Long1=MyMode;
            MESSAGEHANDLE();
            if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)MyChannels=CH_LEFT
             else MyChannels=MyWTStdMsg->WTMsgPrc->PRC_Long1;
            }
         else if (strncmp(IFFCh.ChunkID,"MDAT",4)) Seek(MyWTStdMsg->ActFHandle,IFFCh.ChunkLength,OFFSET_CURRENT);
         }
      while ((strncmp(IFFCh.ChunkID,"MDAT",4)) && (l>=8));
      if (l<8)
         {
         SENDERROR("File corrupt! Can't find MDAT-chunk");
         MyWTStdMsg->Flags=MDE_ERROR;
         return FALSE;
         }
      }
   else
      {
      strcpy(s,"No MAUD-IFF (");
      strcat(s,IFFHd.IFFType);
      strcat(s,") !");
      SENDERROR(s);
      MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
      return FALSE;
      }
   }
else
   {
   MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
   return FALSE;
   }
return TRUE;
}



void READDATA8(void)

{
UBYTE *Data8;
LONG   Addr8;
LONG  *Data1;


if (!GETSAVEMEM())
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
Loaded=0;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   Loaded=Loaded+Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   Addr8=(LONG)MemALoad;
   do
      {
      ChBit=1;
      for (i=0; i<6; i++)
         {
         if  (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
            {
            if (MyWTStdMsg->MemA24[i])
               {
               Data8=(UBYTE*)(Addr8);     Addr8++;
               Data1=(LONG*)(Addr24[i]);  Addr24[i]=Addr24[i]+4;
               *Data1=(*Data8-127)*65535;
               }
            else Addr8++;
            }
         ChBit=ChBit*2;
         }
      }
   while (Addr8<(LONG)MemALoad+l);
   }
while (Loaded<MemLS*ChCnt);
Loaded=(Loaded/ChCnt)*4;
MyWTStdMsg->Flags=MDE_READY;
}



void READDATA16(void)

{
WORD *Data16;
LONG  Addr16;
LONG *Data1;


if (!GETSAVEMEM())
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
Loaded=0;
do
   {
   l=MemLS*ChCnt-Loaded;
   if (l>MemLLoad) l=MemLLoad;
   Loaded=Loaded+Read(MyWTStdMsg->ActFHandle,MemALoad,l);
   Addr16=(LONG)MemALoad;
   do
      {
      ChBit=1;
      for (i=0; i<6; i++)
         {
         if  (((MyChannels & ChBit)==ChBit) && (Addr24[i]<MyWTStdMsg->MemA24[i]+MyWTStdMsg->MemL24))
            {
            if (MyWTStdMsg->MemA24[i])
               {
               Data16=(WORD*)(Addr16);    Addr16=Addr16+2;
               Data1=(LONG*)(Addr24[i]);  Addr24[i]=Addr24[i]+4;
               *Data1=*Data16*255;
               }
            else Addr16=Addr16+2;
            }
         ChBit=ChBit*2;
         }
      }
   while (Addr16<(LONG)MemALoad+l);
   }
while (Loaded<MemLS*ChCnt);
Loaded=(Loaded/ChCnt)*4;
MyWTStdMsg->Flags=MDE_READY;
}



void LOADMAUD(void)

{
for (i=0; i<6; i++) Addr24[i]=MyWTStdMsg->MemA24[i];
ChCnt=0; ChBit=1;
for (i=0; i<6; i++)
   {
   if ((MyChannels & ChBit)==ChBit) ChCnt++;
   ChBit=ChBit*2;
   }
if (SampleRes<=8) READDATA8() else if (SampleRes<=16) READDATA16();
if (MemALoad) FreeVec(MemALoad);
MyWTStdMsg->PlayL24=Loaded;
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
if (DOSBase)
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"MAUD 5.1 8 & 16 Bit Loader");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               if (READHEADER())
                  {
                  MyWTStdMsg->ActWaveOp->Operator[0]=MemLS;
                  MyWTStdMsg->ActWaveOp->Operator[1]=1;
                  MyWTStdMsg->ActiveMode=MyMode;
                  MyWTStdMsg->ActiveChannels=MyChannels;
                  MyWTStdMsg->Flags=MDE_READY;
                  }
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (READHEADER())
                  {
                  MyChannels=(MyChannels & MyWTStdMsg->ActiveChannels);
                  if (MyChannels==0) MyWTStdMsg->Flags=MDE_CHANNELERROR
                  else
                     {
                     if (MyWTStdMsg->ActWaveOp->Operator[0]<MemLS) MemLS=MyWTStdMsg->ActWaveOp->Operator[0];
                     LOADMAUD();
                     }
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   CloseLibrary((Library*)DOSBase);
   }
}
