#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>

extern struct DOSBase *DOSBase;

struct HSNDHeader
   {
   char  SndID[8];
   UWORD SampleFreq,w2;
   LONG  D2,D3,SampleLength;
   UWORD w3,w4;
   LONG  Depth;
   UBYTE w[16];
   char  SndSpec[42];
   };


LONG   MemLS;

HSNDHeader HSND;



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



BOOL READHEADER(void)

{
UBYTE i;

SDBodyShortText *MySDBodyShortText;


Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
Read(MyWTStdMsg->ActFHandle,&HSND,sizeof(HSNDHeader));
if (!(strncmp(HSND.SndID,"HSND1.1",7)))
   {
   MemLS=HSND.SampleLength;
   if (HSND.Depth>8)
      {
      SENDERROR("Unknown sample-resolution!");
      MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
      return FALSE;
      }
   MyWTStdMsg->SRate=(LONG)(10000000.0/(HSND.SampleFreq*2.79365));
   if (MyWTStdMsg->SRate<60) MyWTStdMsg->SRate=60;
   if (MyWTStdMsg->SRate>60000) MyWTStdMsg->SRate=60000;
   if (strlen(HSND.SndSpec)>0)
      {
      for (i=0; i<strlen(HSND.SndSpec); i++)
         {
         if ((UBYTE)(HSND.SndSpec[i])==0x81) HSND.SndSpec[i]=(char)0xFC       // 
         else if ((UBYTE)(HSND.SndSpec[i])==0x84) HSND.SndSpec[i]=(char)0xE4  // 
         else if ((UBYTE)(HSND.SndSpec[i])==0x9E) HSND.SndSpec[i]=(char)0xDF; // 
         }
      MyWTStdMsg->Flags=0;
      MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ALLOC_SPECIAL_DATA;
      MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_SHORT_TEXT;
      MESSAGEHANDLE();
      if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr)
         {
         MySDBodyShortText=(SDBodyShortText*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
         MySDBodyShortText->sdb_SDHeader.NextSpecialData=NULL;
         MySDBodyShortText->sdb_SDHeader.sdh_Size=sizeof(SDBodyShortText);
         MySDBodyShortText->sdb_SDHeader.sdh_Type=SD_SHORT_TEXT;
         strcpy(MySDBodyShortText->sdb_TextString,HSND.SndSpec);
         MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SPECIAL_DATA_FOUND;
         MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_SHORT_TEXT;
         MyWTStdMsg->WTMsgPrc->PRC_NewPtr=MySDBodyShortText;
         MESSAGEHANDLE();
         }
      }
   }
else
   {
   MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
   return FALSE;
   }
return TRUE;
}



void LOADHSND(void)

{
BYTE *Data8;
LONG *Data1;
LONG  Addr1,Addr8;

  
if (!MyWTStdMsg->MemA24[2])
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
Addr8=MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24-MemLS;
Addr1=MyWTStdMsg->MemA24[2];
Read(MyWTStdMsg->ActFHandle,(APTR)Addr8,MemLS);
do
   {
   Data8=(BYTE*)Addr8; Addr8++;
   Data1=(LONG*)Addr1; Addr1=Addr1+4;
   *Data1=*Data8*65535;
   }
while (Addr8<MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24);
MyWTStdMsg->PlayL24=Addr1-MyWTStdMsg->MemA24[2];
MyWTStdMsg->Flags=MDE_READY;
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
if (DOSBase)
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"HSND 1.0 Mono 8 Bit Loader");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               if (READHEADER())
                  {
                  MyWTStdMsg->ActWaveOp->Operator[0]=MemLS;
                  MyWTStdMsg->ActWaveOp->Operator[1]=1;
                  MyWTStdMsg->ActiveMode=MD_MONO;
                  MyWTStdMsg->ActiveChannels=CH_CENTER;
                  MyWTStdMsg->Flags=MDE_READY;
                  }
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               if (READHEADER())
                  {
                  if ((MyWTStdMsg->ActiveChannels & CH_CENTER)==0) MyWTStdMsg->Flags=MDE_CHANNELERROR
                  else
                     {
                     if (MyWTStdMsg->ActWaveOp->Operator[0]<MemLS) MemLS=MyWTStdMsg->ActWaveOp->Operator[0];
                     LOADHSND();
                     }
                  }
               else MyWTStdMsg->Flags=MDE_ERROR;
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   CloseLibrary((Library*)DOSBase);
   }
}
