program SoftModul;

Uses ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h"}

const OFLAG_TIMEPATTERN=1;
const OFLAG_SOUND=2;
const OFLAG_SOUNDEND=8;

type r_VoiceHeader=record
        OneShotHiSamples,RepeatHiSamples        :long;
        SamplesPerHiCycle                       :long;
        SamplesPerSec                           :word;
        CtOctave1,SCompression1,FixedVolume1    :byte;
        CtOctave2,SCompression2,FixedVolume2    :byte;
     end;
type r_SXHeader=record
        SampleDepth,FixedVolume         :byte;
        SoundLength,PlayRate,Flags      :long;
        UsedChannels,UsedMode,res1,res2 :byte;
        res3                            :long;
     end;
type r_ADSRHeader=record
        Attack,Decay,Sustain,Release    :long;
     end;
type r_TimeData=record
        StartTime,EndTime,Res1          :long;
     end;
type r_CinemaData=record;
        x,y,z                   :integer;
        Steps                   :word;
        res2                    :integer;
        Volume,res1             :byte
        RelTime                 :long;
     end;
type r_ObjectHeader=record;
        Flags                   :word;
        Name                    :string[20];
        Sample                  :string[200];
        DataMemA,DataMemL       :long;
     end;
type r_IFFCh=record
        Name            :string[4];
        Length          :long;
     end;
type r_CNHDChunk=record;
        Frames                  :long;
        FPS,pad                 :byte;
        Threshold               :integer;
        AnimJiffies             :long
        reserved1               :long;
     end;

type SpCoordArr=array[1..3] of integer;

var SXHeader                    :r_SXHeader;
var VHDR                        :r_VoiceHeader;
var ADSRHeader                  :r_ADSRHeader;
var SpCoords                    :array [1..5] of SPCoordArr;
var CNHDChunk                   :r_CNHDChunk;
var ObjMemA,ObjMemL,SMemA,SMemL,
    RSMemL                      :long;
var IFFCH                       :r_IFFCh;
var MyObjectHeader              :^r_ObjectHeader;
var IMsg                        :^IntuiMessage;
var DKnopf                      :array [1..2] of Gadget;
var DKnopfTx                    :array [1..4] of IntuiText;
var XGadget                     :^Gadget;
var MyWindow                    :^Window;
var l,FrameSteps,MaxPlayL24     :long;
var i                           :integer;
var RawCode,GadCode             :byte;
var MsgGone                     :boolean;
var s                           :string[200];
var FileFR,PathFR               :string[150];
var UsedObjects,ActObject       :byte;
var FHandle                     :BPTR;


{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod"}

var MySList                     :SelectListGad;
var MyPLP                       :PlayListPattern;

function TASKREQUEST(s1,s2,g1,g2,g3 :string):byte;

begin
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_TASKREQ,s1,s2,g1,g2,g3,0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      TASKREQUEST:=WTMsgPrc^.PRC_Long1;
   end;
end;



procedure SDINFO;

var MySDBodyANIM            :^SDBodyANIM;

begin
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_ALLOC_SPECIAL_DATA,'','','','','',SD_ANIMINFO,0,0,0,0,NIL);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_NewPtr<>NIL then begin
         MySDBodyAnim:=WTMsgPrc^.PRC_NewPtr;
         MySDBodyANIM^:=SDBodyANIM(SDHeader(NIL,sizeof(SDBodyANIM),SD_ANIMINFO),
                                   CNHDChunk.Frames,CNHDChunk.FPS,0,0);
         Flags:=0;
         WTMsgPrc^:=MsgPrc(WTM_SPECIAL_DATA_FOUND,'','','','','',
                           SD_ANIMINFO,0,0,0,0,MySDBodyAnim);
         MESSAGEHANDLE;
      end;
   end;
end;



function LOADCINEMA(LoadData :boolean):boolean;

var MyTimeData          :r_TimeData;
var UsedTimes           :long;

begin
   LOADCINEMA:=false;
   with MyWTStdMsg^ do begin
      l:=DosSeek(ActFHandle,0,OFFSET_BEGINNING);
      l:=DosRead(ActFHandle,^s,4);
      s[5]:=chr(0);
      if s<>'FORM' then begin
         Flags:=MDE_NOTMYFORMAT;
         exit;
      end;
      l:=DosSeek(ActFHandle,8,OFFSET_BEGINNING);
      l:=DosRead(ActFHandle,^s,4);
      s[5]:=chr(0);
      if s<>'CINM' then begin
         s:='Kein CineData-Format ('+s+')!';
         l:=TASKREQUEST(s,'Operation cancelled!','','OK','');
         Flags:=MDE_NOTMYFORMAT;
         exit;
      end;
      UsedObjects:=0;
      UsedTimes:=0;
      repeat
         l:=DosRead(ActFHandle,^IFFCh,8);
         if l<>0 then begin
            if IFFCh.Name='FRDT' then UsedObjects:=UsedObjects+1;
            if IFFCh.Name='TIME' then UsedTimes:=UsedTimes+1;
            l:=DosSeek(ActFHandle,IFFCh.Length,OFFSET_CURRENT);
         end;
      until l=0;
      if UsedTimes>UsedObjects then UsedObjects:=UsedTimes;
      if UsedObjects=0 then exit else begin
         ObjMemL:=UsedObjects*sizeof(r_ObjectHeader);
         ObjMemA:=AllocVec(ObjMemL,MEMF_CLEAR);
         if ObjMemA=0 then begin
            Flags:=MDE_NO_MEMORY;
            exit;
         end;
         l:=DosSeek(ActFHandle,12,OFFSET_BEGINNING);
         i:=0;
         repeat
            l:=DosRead(ActFHandle,^IFFCh,8);
            if l<>0 then begin
               if IFFCh.Name='CNHD' then begin
                  IFFCh.Length:=IFFCh.Length-DosRead(ActFHandle,^CNHDChunk,sizeof(r_CNHDChunk));
                  with CNHDChunk do begin
                     if not LoadData then begin
                        if FPS<>0 then ActWaveOp^.Operator[1]:=round(((10000000/(SRate*2.79365))/FPS)*Frames)
                        else ActWaveOp^.Operator[1]:=round((10000000/(SRate*2.79365))/60*AnimJiffies);
                        ActWaveOp^.Operator[2]:=1;
                     end;
                     if FPS<>0 then FrameSteps:=round((10000000/(SRate*2.79365))/FPS);
                     l:=round(SQRT(SQR(Threshold/2)/2));
                     SPCoords[1]:=SPCoordArr( l, l, 0);
                     SPCoords[2]:=SPCoordArr(-l, l, 0);
                     SPCoords[3]:=SPCoordArr( 0, l, 0);
                     SPCoords[4]:=SPCoordArr( l,-l, 0);
                     SPCoords[5]:=SPCoordArr(-l,-l, 0);
                     if ActiveMode=MD_SURROUND then SPCoords[4]:=SpCoordArr(0,-l,0);
                  end;
               end else if IFFCh.Name='FRDT' then begin
                  MyObjectHeader:=ptr(ObjMemA+i*sizeof(r_ObjectHeader));
                  MyObjectHeader^:=r_ObjectHeader(0,'','',0,0);
                  IFFCh.Length:=IFFCh.Length-DosRead(ActFHandle,^MyObjectHeader^,222);
                  {*** Flags, Name und Samplepath laden ***}
                  with MyObjectHeader^ do begin
                     DataMemA:=0;
                     if (Sample<>'') and not (Flags and OFLAG_SOUND=0)
                     and LoadData then begin
                        DataMemL:=IFFCh.Length;
                        DataMemA:=AllocVec(DataMemL,MEMF_CLEAR);
                        if DataMemA=0 then begin
                           Flags:=MDE_NO_MEMORY;
                           exit;
                        end;
                        IFFCh.Length:=IFFCh.Length-DosRead(ActFHandle,ptr(DataMemA),DataMemL);
                     end;
                  end;
                  i:=i+1;
               end else if (IFFCh.Name='TIME') and LoadData then begin
                  IFFCh.Length:=IFFCh.Length-DosRead(ActFHandle,^l,2);
                  IFFCh.Length:=IFFCh.Length-DosRead(ActFHandle,^s,20);
                  repeat
                     IFFCh.Length:=IFFCh.Length-DosRead(ActFHandle,^MyTimeData,sizeof(r_TimeData));
                     Flags:=0;
                     WTMsgPrc^:=MsgPrc(WTM_ADDPATTERN,'','','','','',0,0,0,0,0,NIL);
                     MESSAGEHANDLE;
                     if WTMsgPrc^.PRC_Long1<>-1 then MyPLP:=WTMsgPrc^.PRC_NewPtr;
                     MyPLP^.Name:=s;
                     MyPLP^.BeginOffset:=4*round((10000000/(SRate*2.79365))/60*MyTimeData.StartTime);
                     MyPLP^.EndOffset:=4*round((10000000/(SRate*2.79365))/60*MyTimeData.EndTime);
                  until IFFCh.Length<sizeof(r_TimeData);
                  WTMsgPrc^:=MsgPrc(WTM_DRAWTIMEPATTERNLIST,'','','','','',0,0,0,0,0,NIL);
                  MESSAGEHANDLE;
               end else if (IFFCh.Name='ANIM') and LoadData then begin
                  IFFCh.Length:=IFFCh.Length-DosRead(ActFHandle,^s,200);
                  WTMsgPrc^:=MsgPrc(WTM_ADDANIMPATH,s,'','','','',0,0,0,0,0,NIL);
                  MESSAGEHANDLE;
               end;
               if IFFCh.Length<>0 then l:=DosSeek(ActFHandle,IFFCh.Length,OFFSET_CURRENT);
            end;
         until l=0;
      end;
   end;
   LOADCINEMA:=true;
end;



procedure MAKEWAVE;

var i,j,ChID            :byte;
var LoaderWTStdMsg      :WTStdMsg;
var Addr1,Addr2,Addr3   :long;
var Data1,Data2,Data3   :^long;
var Data16              :^integer;
var Data8               :^short;


procedure ADDSOUND(SAddr :long; Channel :byte);

var ActDistance,LastDistance,Actspeed,
    ActFactor,LastFactor,Factor,Stepsize,
    ActDPDistance,LastDPDistance,
    ActDPFactor,LastDPFactor,DPFactor,
    DPStepsize,DPOffset,SizeFactor              :real;
var MyCinemaData                                :^r_CinemaData;
var DummyCineData                               :r_CinemaData;
var CineAddr,StepCtr                            :long;
var MySteps                                     :word;
var LastFrame,TurnedOff,SetToOff,UseDummy       :boolean;


procedure JUSTDOIT;

begin
   with MyCinemaData^ do begin
      if x>-32000 then begin
         if TurnedOff then begin
            with MyCinemaData^ do LastDPDistance:=SQRT(SQR(x/10)+SQR(y/10)+SQR(z/10))*10;
            MyCinemaData:=ptr(CineAddr);
            with MyCinemaData^ do ActDPDistance:=SQRT(SQR(x/10)+SQR(y/10)+SQR(z/10))*10;
            LastDPDistance:=LastDPDistance+(LastDPDistance-ActDPDistance);
         end;
         TurnedOff:=false;
         MyCinemaData:=ptr(CineAddr);
         if MyCinemaData^.x<=-32000 then LastFrame:=true;
         MyCinemaData:=ptr(CineAddr-sizeof(r_CinemaData));

         {*** Doppler -> Hrposition ***}
         if not LastFrame then begin
            ActDPDistance:=SQRT(SQR(x/10)+SQR(y/10)+SQR(z/10))*10;
            ActSpeed:=LastDPDistance-ActDPDistance;
         end;
         {*** Volume -> Speaker ***}
         ActDistance:=SQRT(SQR((SpCoords[Channel,1]-x)/10)
                          +SQR((SpCoords[Channel,2]-y)/10)
                          +SQR((SPCoords[Channel,3]-z)/10))*10;
      end;
      if (ADSRHeader.Release=0) and (round(DPOffset)*4>=RSMemL)
      then begin
         TurnedOff:=true;
         Addr1:=Addr1+(FrameSteps*4);
         exit;
      end;

      if ActSpeed<-299.9 then ActSpeed:=-299.9;
      if ActSpeed>299.9 then Actspeed:=299.9;

      with CNHDChunk do
       if ActDistance>=Threshold then ActFactor:=0 else ActFactor:=(Threshold-Actdistance)/Threshold;
      if MyWTStdMsg^.ActWaveOp^.Operator[6]=1 then begin
         ActDPFactor:=1;
         LastDPFactor:=1;                                    {*** aus ***}
      end else if MyWTStdMsg^.ActWaveOp^.Operator[6]=2 then begin
         ActSpeed:=300+ActSpeed;
         ActDPFactor:=ActSpeed/300                            {*** linear ***}
      end else if MyWTStdMsg^.ActWaveOp^.Operator[6]=3 then begin
         if ActSpeed>0 then ActDPFactor:=(SQRT(ActSpeed)/48)+1
         else if ActSpeed<0 then ActDPFactor:=-(SQRT(-ActSpeed)/48)+1
         else ActDPFactor:=1;                                 {*** quadratisch ***}
      end else if MyWTStdMsg^.ActWaveOp^.Operator[6]=4 then begin
         if ActSpeed>0 then ActDPFactor:=(ln(ActSpeed+1)/27)+1
         else if ActSpeed<0 then ActDPFactor:=-(ln(-ActSpeed+1)/27)+1
         else ActDPFactor:=1;                                 {*** logarithmisch ***}
      end;
      if (LastDistance<=0) and (Addr1>SAddr) then LastDistance:=ActDistance;
      if LastDistance>=0 then begin
         StepCtr:=FrameSteps;
            {*** VOLUME ***}
         Stepsize:=(ActFactor-LastFactor)/FrameSteps;
         Factor:=LastFactor;
            {*** DOPPLER ***}
         DPStepsize:=(ActDPFactor-LastDPFactor)/FrameSteps;
         DPFactor:=LastDPFactor;
         repeat
            Data1:=ptr(Addr1);   Addr1:=Addr1+4;
            Data2:=ptr(SMemA+(round(DPOffset)*4)); DPOffset:=DPOffset+(DPFactor*SizeFactor);
            if ADSRHeader.Release<>0 then begin
               if round(DPOffset)*4>=ADSRHeader.Release then
                DPOffset:=DPOffset-((ADSRHeader.Release-ADSRHeader.Sustain) div 4);
            end else if round(DPOffset)*4>=RSMemL then begin
               TurnedOff:=true;
{               if MyCinemaData^.x<=-32000 then} LastDistance:=0;
               Addr1:=Addr1+StepCtr*4;
               exit;
            end;
            DPFactor:=DPFactor+DPStepsize;
            StepCtr:=StepCtr-1;
            Factor:=Factor+Stepsize;
            Data1^:=Data1^+round(Data2^*(MyCinemaData^.Volume/100)*Factor);
         until (StepCtr<=0) or (Addr1>=SAddr+MyWTStdMsg^.MemL24);
      end;
      LastDistance:=ActDistance;     LastFactor:=ActFactor;
      LastDPDistance:=ActDPDistance; LastDPFactor:=ActDPFactor;
   end;
end;



begin
   CineAddr:=MyObjectHeader^.DataMemA;
   Addr1:=SAddr;       DPOffset:=0;
   LastFrame:=false;   LastDPFactor:=1;
   MySteps:=0;
   SizeFactor:=MyWTStdMsg^.SRate/SXHeader.PlayRate;
   TurnedOff:=true;   SetToOff:=false; UseDummy:=false;
   if CineAddr<>0 then begin
      repeat
         if MySteps<=0 then begin
            if UseDummy then MyCinemaData:=ptr(addr(DummyCineData))
            else MyCinemaData:=ptr(CineAddr);
            MySteps:=MyCinemaData^.Steps;
            CineAddr:=CineAddr+sizeof(r_CinemaData);
         end;
         MySteps:=MySteps-1;
         if MyCinemaData^.x<=-32000 then SetToOff:=true;
         if (MyCinemaData^.x>-32000) and SetToOff then begin
            SetToOff:=false;
            DPOffset:=0;
         end;
         if CNHDChunk.FPS=0 then begin
            if MyCinemaData^.RelTime=0 then MyCinemaData^.RelTime:=1;
            FrameSteps:=round(((10000000/(MyWTStdMsg^.SRate*2.79365))/60)*MyCinemaData^.RelTime);
         end;
         with MyCinemaData^ do if (x>-32000)
         or (not TurnedOff and not (MyObjectHeader^.Flags and OFLAG_SOUNDEND=0))
          then JUSTDOIT else begin
            Addr1:=Addr1+(FrameSteps*4);
            TurnedOff:=true;
         end;

         with MyObjectHeader^ do
         if (CineAddr>=DataMemA+DataMemL) and (MySteps=0) and not LastFrame then begin
            LastFrame:=true;
            CineAddr:=CineAddr-sizeof(r_CinemaData);
         end;

         if not (MyObjectHeader^.Flags and OFLAG_SOUNDEND=0)
         and (CineAddr>=MyObjectHeader^.DataMemA+MyObjectHeader^.DataMemL)
         and (round(DPOffset)*4<RSMemL) then begin
            DummyCineData:=MyCinemaData^;
            DummyCineData.x:=-32000;
            DummyCineData.Steps:=1;
            UseDummy:=true;
         end;

      until ((CineAddr>=MyObjectHeader^.DataMemA+MyObjectHeader^.DataMemL)
      and (MySteps=0) and not UseDummy)
      or (UseDummy and (round(DPOffset)*4>=RSMemL))
      or (Addr1>=SAddr+MyWTStdMsg^.MemL24);

      if Addr1-SAddr>MaxPlayL24 then MaxPlayL24:=Addr1-SAddr;
      if MaxPlayL24>MyWTStdMsg^.MemL24 then MaxPlayL24:=MyWTStdMsg^.MemL24;
   end;
end;


begin
   MaxPlayL24:=0;
   with MyWTStdMsg^ do begin
      Flags:=0;
      if not LOADCINEMA(true) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      SDINFO;
      Flags:=MDE_ERROR;
      for j:=1 to UsedObjects do begin
         MyObjectHeader:=ptr(ObjMemA+pred(j)*sizeof(r_ObjectHeader));
         SMemA:=0;
         with MyObjectHeader^ do if (Sample<>'')
         and not (Flags and OFLAG_SOUND=0) then begin
            FHandle:=DosOpen(Sample,MODE_OLDFILE);
            if FHandle<>0 then begin
               l:=DosRead(FHandle,^s,8); s[5]:=chr(0);
               if s='FORM' then begin
                  l:=DosRead(FHandle,^s,4); s[5]:=chr(0);
                  if (s='HISX') or (s='24SX') or (s='16SX') then repeat
                     l:=DosRead(FHandle,^IFFCh,8);
                     if l<>0 then begin
                        if IFFCh.Name='SXHD' then begin
                           IFFCH.Length:=IFFCh.Length-DosRead(FHandle,^SXHeader,sizeof(r_SXHeader));
                           with SXHeader do begin
                              if Flags and not COMPRESSION_DELTA and not COMPRESSION_3BYTE<>0 then begin
                                 l:=TASKREQUEST(Sample,'Unknown compression-method!','','OK','');
                                 DosClose(FHandle);
                                 exit;
                              end;
                              if not (UsedChannels in [1,2,4,8,16,32,64]) then begin
                                 l:=TASKREQUEST(Sample,'File isn`t a 1.0 mono sample!','','OK','');
                                 DosClose(FHandle);
                                 exit;
                              end;
                              SMemL:=SoundLength;
                              if (SampleDepth>16) and not (Flags and COMPRESSION_3BYTE=0)
                               then SoundLength:=(SoundLength div 4) * 3
                              else SMemL:=SoundLength*2;
                           end;
                           SMemL:=SMemL+4;
                           SMemA:=AllocVec(SMemL,0);
                           if SMemA=0 then begin
                              Flags:=MDE_NO_MEMORY;
                              DosClose(FHandle);
                              exit;
                           end;
                        end else if (IFFCh.Name='ADSR') then
                        IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^ADSRHeader,sizeof(r_ADSRHeader))
                        else if (IFFCh.Name='BODY') and (SMemA<>0) then begin
                           IFFCh.Length:=IFFCh.Length-DosRead(FHandle,ptr(SMemA+SMemL-SXHeader.SoundLength),SXHeader.SoundLength);
                           if (SXHeader.SampleDepth>16) and not (Flags and COMPRESSION_3BYTE=0) then begin
                              Addr1:=SMemA; Addr2:=SMemA+SMemL-SXHeader.SoundLength-1;
                              repeat
                                 Data1:=ptr(Addr1); Addr1:=Addr1+4;
                                 Data2:=ptr(Addr2); Addr2:=Addr2+3;
                                 Data1^:=(Data2^ and $00FFFFFF)-MAX24;
                              until (Addr1>=SMemA+SMemL) or (Addr2>=SMemA+SMemL);
                              RSMemL:=Addr1-SMemA;
                           end else if SXHeader.SampleDepth<=16 then begin
                              Addr1:=SMemA; Addr2:=SMemA+SMemL-SXHeader.SoundLength;
                              l:=MAX24 div 32768;
                              repeat
                                 Data1:=ptr(Addr1); Addr1:=Addr1+4;
                                 Data16:=ptr(Addr2); Addr2:=Addr2+2;
                                 Data1^:=Data16^*l;
                              until (Addr1>=SMemA+SMemL) or (Addr2>=SMemA+SMemL);
                              RSMemL:=Addr1-SMemA;
                           end;
                           Data1^:=0;
                        end;
                        if IFFCh.Length<>0 then l:=DosSeek(FHandle,IFFCH.Length,OFFSET_CURRENT);
                     end;
                  until l=0
                  else if s='8SVX' then repeat
                     l:=DosRead(FHandle,^IFFCh,8);
                     if l<>0 then begin
                        if IFFCh.Name='VHDR' then begin
                           IFFCH.Length:=IFFCh.Length-DosRead(FHandle,^VHDR,sizeof(r_VoiceHeader));
                           with VHDR do begin
                              if (SCompression1<>0) or (SCompression2<>0) then begin
                                 l:=TASKREQUEST(Sample,'Unknown compression-method!','','OK','');
                                 DosClose(FHandle);
                                 exit;
                              end;
                              SMemL:=(OneShotHiSamples+RepeatHiSamples)*4+4;
                              SXHeader.PlayRate:=round(10000000/(SamplesPerSec*2.79365));
                              if RepeatHiSamples>0 then
                               ADSRHeader:=r_ADSRHeader(0,0,OneShotHiSamples*4,
                                                        (OneShotHiSamples+RepeatHiSamples)*4);
                           end;
                           SMemA:=AllocVec(SMemL,0);
                           if SMemA=0 then begin
                              Flags:=MDE_NO_MEMORY;
                              DosClose(FHandle);
                              exit;
                           end;
                        end else if (IFFCh.Name='CHAN') then begin
                           IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^l,4);
                           if not (l in [1,2,4,8,16,32,64]) then begin
                              l:=TASKREQUEST(Sample,'File isn`t a 1.0 Mono sample!','','OK','');
                              DosClose(FHandle);
                              exit;
                           end;
                        end else if (IFFCh.Name='ADSR') then begin
                           IFFCh.Length:=IFFCh.Length-DosRead(FHandle,^ADSRHeader,sizeof(r_ADSRHeader));
                           ADSRHeader.Sustain:=ADSRHeader.Sustain*4;
                           ADSRHeader.Release:=ADSRHeader.Release*4;
                        end else if (IFFCh.Name='BODY') and (SMemA<>0) then begin
                           l:=IFFCh.Length;
                           IFFCh.Length:=IFFCh.Length-DosRead(FHandle,ptr(SMemA+SMemL-l),pred(SMemL div 4));
                           Addr1:=SMemA; Addr2:=SMemA+SMemL-l;
                           l:=MAX24 div 65535;
                           repeat
                              Data1:=ptr(Addr1); Addr1:=Addr1+4;
                              Data8:=ptr(Addr2); Addr2:=Addr2+1;
                              Data1^:=Data8^*l;
                           until (Addr1>=SMemA+SMemL) or (Addr2>=SMemA+SMemL);
                           RSMemL:=Addr1-SMemA;
                           Data1^:=0;
                        end;
                        if IFFCh.Length<>0 then l:=DosSeek(FHandle,IFFCH.Length,OFFSET_CURRENT);
                     end;
                  until l=0
                  else begin
                     MyWTStdMsg^.Flags:=0;
                     s:='Defined sample has an unknown IFF-format ('+s+')!';
                     WTMsgPrc^:=MsgPrc(WTM_TASKREQ,s,'','','OK','',0,0,0,0,0,NIL);
                     MESSAGEHANDLE;
                     Flags:=MDE_NOTMYFORMAT;
                     DosClose(FHandle);
                     exit;
                  end;
               end else begin
                  Flags:=MDE_NOTMYFORMAT;
                  DosClose(FHandle);
                  exit;
               end;
               DosClose(FHandle);
            end else begin
               MyWTStdMsg^.Flags:=0;
               WTMsgPrc^:=MsgPrc(WTM_TASKREQ,Sample,'Can`t find file!','','OK','',0,0,0,0,0,NIL);
               MESSAGEHANDLE;
               MyWTStdMsg^.Flags:=MDE_FILEERROR;
               exit;
            end;
            if ADSRHeader.Release>RSMemL then ADSRHeader.Release:=RSMemL;
            for i:=1 to 5 do if MemA24[i]<>0 then begin
               MyWTStdMsg^.Flags:=0;
               s:='Objekt: '+MyObjectHeader^.Name+', Channel: ';
               if (i=1) then s:=s+'L'
               else if (i=2) then s:=s+'R'
               else if (i=3) then s:=s+'C'
               else if (i=4) then s:=s+'SL'
               else if (i=5) then s:=s+'SR';
               WTMsgPrc^:=MsgPrc(WTM_WORKINFO,s,'','','','',0,0,0,0,0,NIL);
               MESSAGEHANDLE;
               ADDSOUND(MemA24[i],i);
            end;
            if SMemA<>0 then FreeVec(SMemA);
            SMemA:=0;
         end;
      end;
      if MaxPlayL24>0 then PlayL24:=MaxPlayL24 else PlayL24:=MemL24;
      for i:=1 to 6 do if MemA24[i]<>0 then begin
         Data1:=ptr(MemA24[i]+PlayL24-4);
         Data1^:=1;
      end;
      MyWTStdMsg^.Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'Optimizing front-channels','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      if (MemA24[1]<>0) and (MemA24[2]<>0) and (MemA24[3]<>0) then begin
         Addr1:=MemA24[1]; Addr2:=MemA24[2];  Addr3:=MemA24[3];
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data2:=ptr(Addr2); Addr2:=Addr2+4;
            Data3:=ptr(Addr3); Addr3:=Addr3+4;
            l:=(Data1^+Data2^) div 2;
            Data1^:=Data1^-l;
            Data2^:=Data2^-l;
            Data3^:=Data3^ div 2;
         until Addr1>=MemA24[1]+PlayL24;
      end;
      Flags:=MDE_READY;
   end;
end;



procedure SETPARAMETERS;



begin
   with MyWTStdMsg^ do begin
      if not LOADCINEMA(false) then exit;
      SDINFO;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition CineData-Loader,  by QXC & VWP',
                        '','','','',70,0,0,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         l:=TASKREQUEST('Can`t open window!','Operation cancelled!','','OK','');
         Flags:=MDE_ERROR;
         exit;
      end;
      MyWindow:=WTMsgPrc^.PRC_NewPtr;
      with ActWaveOp^ do if not (Operator[6] in [1..4]) then Operator[6]:=1;
      l:=1;
      DKnopf[1]:=Gadget(NIL,500,40,128,16,GADGHCOMP+GADGIMAGE,$3,BOOLGADGET,
                        WTImg^.GImg5,NIL,WTImg^.OKIText,0,NIL,1,0);
      DKnopf[2]:=Gadget(NIL,20,40,128,16,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,
                        WTImg^.GImg2,NIL,^DKnopfTx[ActWaveOp^.Operator[6]],0,Nil,4,0);
      DKnopfTx[1]:=IntuiText(2,0,0,3,2,NIL,'no Doppler-effect',NIL);
      DKnopfTx[2]:=IntuiText(2,0,0,3,2,NIL,'Doppler linear',NIL);
      DKnopfTx[3]:=IntuiText(2,0,0,3,2,NIL,'Doppler squared',NIL);
      DKnopfTx[4]:=IntuiText(2,0,0,3,2,NIL,'Doppler logarythm.',NIL);
      MySList:=SelectListGad(MyWindow,^DKnopf[2],ActWaveOp^.Operator[6],0,0,0,
                             ITTArr(^DKnopfTx[1],^DKnopfTx[2],^DKnopfTx[3],^DKnopfTx[4],
                             NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL));

      for i:=1 to 2 do AddGadget(MyWindow,^DKnopf[i],NIL);
      RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
      FileFR:=''; Flags:=0; ActObject:=1;
      repeat
         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(MyWindow^.UserPort);
         If IMsg<>Nil Then begin
            if (IMsg^.class in [GADGETDOWN,GADGETUP]) then begin
               XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg);
            MsgGone:=true;
         End else MsgGone:=false;

         if GadCode=4 then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_DOSELECTLIST,'','','','','',0,0,0,0,0,^MySList);
            MESSAGEHANDLE;
            if WTMsgPrc^.PRC_Long1<>-1 then ActWaveOp^.Operator[6]:=WTMsgPrc^.PRC_Long1
         end;

      Until (GadCode=1) or (RawCode=68);
      if RawCode=68 then begin
         DKnopf[1].flags:=DKnopf[1].flags or SELECTED;
         RefreshGadgets(MyWindow^.FirstGadget,MyWindow,NIL);
         delay(5);
      end;
      CloseWindow(MyWindow);
      Flags:=MDE_READY;
   end;
end;



begin
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   OpenLib(DosBase,'dos.library',0);

   ObjMemA:=0; ObjMemL:=0; SMemA:=0;
   ADSRHeader:=r_ADSRHeader(0,0,0,0);

   if CREATEPORTS(PORT_LOADER) then begin
      with MyWTStdMsg^ do if Version=VERSION_LOADER then begin
         if Flags=MDC_ASKREADY then begin
            l:=TASKREQUEST('CineData Loader',COPYRIGHT,'','OK','');
            Flags:=MDE_READY;
         end else if Flags=MDC_DEFINEIT then begin
            SETPARAMETERS;
            ActiveChannels:=$3F;
            ActiveMode:=MD_AC3;
         end else if Flags=MDC_DOIT then MAKEWAVE;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;

   if ObjMemA<>0 then begin
      for i:=1 to UsedObjects do begin
         MyObjectHeader:=ptr(ObjMemA+pred(i)*sizeof(r_ObjectHeader));
         with MyObjectHeader^ do if DataMemA<>0 then FreeVec(DataMemA);
      end;
      FreeVec(ObjMemA);
   end;
   if SMemA<>0 then FreeVec(SMemA);
end.


