#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>
#include <clib/intuition_protos.h>

//#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <iostream.h>

extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;

#define OFLAG_TIMEPATTERN 1
#define OFLAG_SOUND       2
#define OFLAG_SOUNDEND    8

struct VoiceHeader
   {
   LONG  OneShotHiSamples,RepeatHiSamples,SamplesPerHiCycle;
   UWORD SamplesPerSec;
   UBYTE CtOctave1,SCompression1,FixedVolume1;
   UBYTE CtOctave2,SCompression2,FixedVolume2;
   };
struct SXHeader
   {
   UBYTE SampleDepth,FixedVolume;
   LONG  SoundLength,PlayRate,Flags;
   UBYTE UsedChannels,UsedMode,res1,res2;
   LONG  res3;
   };
struct ADSRHeader
   {
   LONG Attack,Decay,Sustain,Release;
   };
struct TimeData
   {
   LONG StartTime,EndTime,Res1;
   };
struct CinemaData
   {
   WORD  x,y,z;
   UWORD Steps;
   WORD  res2;
   UBYTE Volume,res1;
   LONG  RelTime;
   };
struct ObjectHeader
   {
   UWORD Flags;
   char  Name[20],Sample[200];
   APTR  DataMemA;
   LONG  DataMemL;
   };
struct IFFChunk
   {
   char Name[4];
   LONG Length;
   };
struct CNHDChunk
   {
   LONG  Frames;
   UBYTE FPS,pad;
   WORD  Threshold;
   LONG  AnimJiffies,reserved1;
   }; 
struct SPCoordHd
   {
   WORD SPCoordArr[3];
   };

SXHeader    SXHD;
VoiceHeader VHDR;
ADSRHeader  ADSR;


APTR ObjMemA,SMemA;
LONG ObjMemL,SMemL,RSMemL,UsedObjects,FrameSteps;
BPTR FHandle;

SPCoordHd SPCoords[5]={{0,0,0},
                       {0,0,0},
                       {0,0,0},
                       {0,0,0},
                       {0,0,0}};
CNHDChunk     CNHD;
IFFChunk      IFFCh;
ObjectHeader *MyObjectHeader;
LONG          l,MaxPlayL24;
CinemaData   *MyCinemaData;
CinemaData    DummyCineData;
LONG          CineAddr,StepCtr;
UWORD         MySteps;
BOOL          LastFrame,TurnedOff,SetToOff,UseDummy;
WORD          i;
FLOAT         ActDistance,LastDistance,ActSpeed,ActFactor,LastFactor,Factor;
FLOAT         Stepsize,ActDPDistance,LastDPDistance,ActDPFactor,LastDPFactor;
FLOAT         DPFactor,DPStepsize,DPOffset,SizeFactor;
LONG          Addr1,Addr2,Addr3;
LONG         *Data1,*Data2,*Data3;
WORD         *Data16;
BYTE         *Data8;

/*var s                           :string[200];
var FileFR,PathFR               :string[150];
var ActObject       :byte;
var FHandle                     :BPTR;*/
PlayListPattern *MyPLP;



UBYTE TASKREQUEST(char *s1, char *s2, char *g1, char *g2, char *g3)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,s1);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,s2);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,g1);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,g2);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,g3);
MyWTStdMsg->WTMsgPrc->PRC_Long1=0;
MESSAGEHANDLE();
return (UBYTE) MyWTStdMsg->WTMsgPrc->PRC_Long1;
}



void SDINFO(void)

{
SDBodyAnim *MySDBodyANIM;

cout << "SDINFO\n";
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ALLOC_SPECIAL_DATA;
MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_ANIMINFO;
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr)
   {
   MySDBodyANIM=(SDBodyAnim*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
   MySDBodyANIM->sdb_SDHeader.NextSpecialData=NULL;
   MySDBodyANIM->sdb_SDHeader.sdh_Size=sizeof(SDBodyAnim);
   MySDBodyANIM->sdb_SDHeader.sdh_Type=SD_ANIMINFO;
   MySDBodyANIM->sdb_Frames=CNHD.Frames;
   MySDBodyANIM->sdb_FPS=CNHD.FPS;
   MySDBodyANIM->sdb_Flags=0;
   MySDBodyANIM->sdb_pad=0;
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SPECIAL_DATA_FOUND;
   MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_ANIMINFO;
   MyWTStdMsg->WTMsgPrc->PRC_NewPtr=MySDBodyANIM;
   MESSAGEHANDLE();
   }
cout << "SDINFO done\n";
}



BOOL LOADCINEMA(BOOL LoadData)

{
TimeData MyTimeData;
LONG     UsedTimes,l,m;
char     s[50],s1[5];


cout << "LOADCINEMA\n";
Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
Read(MyWTStdMsg->ActFHandle,&s,4);
if (strncmp(s,"FORM",4))
   {
   MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
   return FALSE;
   }
Seek(MyWTStdMsg->ActFHandle,8,OFFSET_BEGINNING);
Read(MyWTStdMsg->ActFHandle,&s1,4);
if (strncmp(s1,"CINM",4))
   {
   s1[5]=0;
   strcpy(s,"No CineData-format (");
   strcat(s,s1);
   strcat(s,")!");
   TASKREQUEST(s,"Operation cancelled!","","OK","");
   MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
   return FALSE;
   }
UsedObjects=0;
UsedTimes=0;
do
   {
   l=Read(MyWTStdMsg->ActFHandle,&IFFCh,sizeof(IFFChunk));
   if (l>0)
      {
cout << "   " << IFFCh.Name << "\n";
      if (!(strncmp(IFFCh.Name,"FRDT",4))) UsedObjects++;
      if (!(strncmp(IFFCh.Name,"TIME",4))) UsedTimes++;
      Seek(MyWTStdMsg->ActFHandle,IFFCh.Length,OFFSET_CURRENT);
      }
   }
while (l>0);
if (UsedTimes>UsedObjects) UsedObjects=UsedTimes;
if (UsedObjects==0) return FALSE else
   {
   ObjMemL=UsedObjects*sizeof(ObjectHeader);
   ObjMemA=AllocVec(ObjMemL,MEMF_CLEAR);
   if (!ObjMemA)
      {
      MyWTStdMsg->Flags=MDE_NO_MEMORY;
      return FALSE;
      }
   Seek(MyWTStdMsg->ActFHandle,12,OFFSET_BEGINNING);
   i=0;
   do
      {
      l=Read(MyWTStdMsg->ActFHandle,&IFFCh,8);
      if (l>0)
         {
cout << "   " << IFFCh.Name << "\n";
         if (!strncmp(IFFCh.Name,"CNHD",4))
            {
            IFFCh.Length=IFFCh.Length-Read(MyWTStdMsg->ActFHandle,&CNHD,sizeof(CNHDChunk));
            if (!LoadData)
               {
               if (CNHD.FPS!=0) MyWTStdMsg->ActWaveOp->Operator[0]=(LONG)(((10000000.0/(MyWTStdMsg->SRate*2.79365))/CNHD.FPS)*CNHD.Frames)
               else MyWTStdMsg->ActWaveOp->Operator[0]=(LONG)((10000000.0/(MyWTStdMsg->SRate*2.79365))/60*CNHD.AnimJiffies);
               MyWTStdMsg->ActWaveOp->Operator[1]=1;
               }
            if (CNHD.FPS!=0) FrameSteps=(LONG)((10000000.0/(MyWTStdMsg->SRate*2.79365))/CNHD.FPS);
            m=(LONG)(sqrt(pow(labs(CNHD.Threshold/2),2)/2));
            SPCoords[0].SPCoordArr[0]=m;  SPCoords[0].SPCoordArr[1]=m;
            SPCoords[1].SPCoordArr[0]=-m; SPCoords[1].SPCoordArr[1]=m;
            SPCoords[2].SPCoordArr[0]=0;  SPCoords[2].SPCoordArr[1]=m;
            SPCoords[3].SPCoordArr[0]=m;  SPCoords[3].SPCoordArr[1]=-m;
            SPCoords[4].SPCoordArr[0]=-m; SPCoords[4].SPCoordArr[1]=-m;
            if (MyWTStdMsg->ActiveMode==MD_SURROUND)
               {
               SPCoords[3].SPCoordArr[0]=0;
               SPCoords[3].SPCoordArr[1]=-m;
               }
            }
         else if (!strncmp(IFFCh.Name,"FRDT",4))
            {
            MyObjectHeader=(ObjectHeader*)((LONG)ObjMemA+i*sizeof(ObjectHeader));
            MyObjectHeader->Flags=0;
            strcpy(MyObjectHeader->Name,"");
            strcpy(MyObjectHeader->Sample,"");
            MyObjectHeader->DataMemA=NULL;
            MyObjectHeader->DataMemL=0;
            IFFCh.Length=IFFCh.Length-Read(MyWTStdMsg->ActFHandle,(APTR)MyObjectHeader,sizeof(ObjectHeader)-8);
            // *** Flags, Name und Samplepath laden ***
            MyObjectHeader->DataMemA=NULL;
            if ((strlen(MyObjectHeader->Sample)>0) && 
                ((MyObjectHeader->Flags & OFLAG_SOUND)==OFLAG_SOUND) && 
                (LoadData))
               {
               MyObjectHeader->DataMemL=IFFCh.Length;
               MyObjectHeader->DataMemA=AllocVec(MyObjectHeader->DataMemL,MEMF_CLEAR);
               if (!MyObjectHeader->DataMemA)
                  {
                  MyWTStdMsg->Flags=MDE_NO_MEMORY;
                  return FALSE;
                  }
               IFFCh.Length=IFFCh.Length-Read(MyWTStdMsg->ActFHandle,MyObjectHeader->DataMemA,MyObjectHeader->DataMemL);
               }
            i++;
            }
         else if ((!strncmp(IFFCh.Name,"TIME",4)) && (LoadData))
            {
            IFFCh.Length=IFFCh.Length-Read(MyWTStdMsg->ActFHandle,&l,2);
            IFFCh.Length=IFFCh.Length-Read(MyWTStdMsg->ActFHandle,&s,20);
            do
               {
               IFFCh.Length=IFFCh.Length-Read(MyWTStdMsg->ActFHandle,&MyTimeData,sizeof(TimeData));
               MyWTStdMsg->Flags=0;
               MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ADDPATTERN;
               MESSAGEHANDLE();
               if (MyWTStdMsg->WTMsgPrc->PRC_Long1!=-1) MyPLP=(PlayListPattern*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
               strcpy(MyPLP->Name,s);
               MyPLP->BeginOffset=4*(LONG)((10000000.0/(MyWTStdMsg->SRate*2.79365))/60*MyTimeData.StartTime);
               MyPLP->EndOffset=4*(LONG)((10000000/(MyWTStdMsg->SRate*2.79365))/60*MyTimeData.EndTime);
               }
            while (IFFCh.Length>sizeof(TimeData));
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_DRAWTIMEPATTERNLIST;
            MESSAGEHANDLE();
            }
         else if ((!strncmp(IFFCh.Name,"ANIM",4)) && (LoadData))
            {
            IFFCh.Length=IFFCh.Length-Read(MyWTStdMsg->ActFHandle,&s,200);
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ADDANIMPATH;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,s);
            MESSAGEHANDLE();
            }
         if (IFFCh.Length!=0) l=Seek(MyWTStdMsg->ActFHandle,IFFCh.Length,OFFSET_CURRENT);
         }
      }
   while (l>0);
   }
cout << "LOADCINEMA done\n";
return TRUE;
}



void JUSTDOIT(UBYTE Channel, LONG SAddr)

{
//with MyCinemaData^ do begin
if (MyCinemaData->x>-32000)
   {
   if (TurnedOff)
      {
      LastDPDistance=sqrt( pow(labs(MyCinemaData->x/10),2) + pow(labs(MyCinemaData->y/10),2) + pow(labs(MyCinemaData->z/10),2) )*10;
      MyCinemaData=(CinemaData*)CineAddr;
      ActDPDistance=sqrt( pow(labs(MyCinemaData->x/10),2) + pow(labs(MyCinemaData->y/10),2) + pow(labs(MyCinemaData->z/10),2) )*10;
      LastDPDistance=LastDPDistance+(LastDPDistance-ActDPDistance);
      }
   TurnedOff=FALSE;
   MyCinemaData=(CinemaData*)CineAddr;
   if (MyCinemaData->x<=-32000) LastFrame=TRUE;
   MyCinemaData=(CinemaData*)(CineAddr-sizeof(CinemaData));

   // *** Doppler -> Hrposition ***
   if (!LastFrame)
      {
      ActDPDistance=sqrt( pow(labs(MyCinemaData->x/10),2) + pow(labs(MyCinemaData->y/10),2) + pow(labs(MyCinemaData->z/10),2) )*10;
      ActSpeed=LastDPDistance-ActDPDistance;
      }
   // *** Volume -> Speaker ***
   ActDistance=sqrt(pow(labs((SPCoords[Channel].SPCoordArr[1]-MyCinemaData->x)/10),2)
                   +pow(labs((SPCoords[Channel].SPCoordArr[2]-MyCinemaData->y)/10),2)
                   +pow(labs((SPCoords[Channel].SPCoordArr[3]-MyCinemaData->z)/10),2))*10;
   }
if ((ADSR.Release==0) && ((LONG)(DPOffset)*4>=RSMemL))
   {
   TurnedOff=TRUE;
   Addr1=Addr1+(FrameSteps*4);
   return;
   }

if (ActSpeed<-299.9) ActSpeed=-299.9;
if (ActSpeed>299.9) ActSpeed=299.9;
if (ActDistance>=CNHD.Threshold) ActFactor=0 else ActFactor=(CNHD.Threshold-ActDistance)/CNHD.Threshold;
if (MyWTStdMsg->ActWaveOp->Operator[5]==1)
   {
   ActDPFactor=1;
   LastDPFactor=1;                                    // *** aus ***
   }
else if (MyWTStdMsg->ActWaveOp->Operator[5]==2)
   {
   ActSpeed=300+ActSpeed;
   ActDPFactor=ActSpeed/300                           // *** linear ***
   }
else if (MyWTStdMsg->ActWaveOp->Operator[5]==3)
   {
   if (ActSpeed>0) ActDPFactor=(sqrt(ActSpeed)/48)+1
   else if (ActSpeed<0) ActDPFactor=-(sqrt(-ActSpeed)/48)+1
   else ActDPFactor=1;                                // *** quadratisch ***
   }
else if (MyWTStdMsg->ActWaveOp->Operator[5]==4)
   {
   if (ActSpeed>0) ActDPFactor=(log(ActSpeed+1)/27)+1
   else if (ActSpeed<0) ActDPFactor=-(log(-ActSpeed+1)/27)+1
   else ActDPFactor=1;                                // *** logarithmisch ***
   }
if ((LastDistance<=0) && (Addr1>SAddr)) LastDistance=ActDistance;
if (LastDistance>=0)
   {
   StepCtr=FrameSteps;
   // *** VOLUME ***
   Stepsize=(ActFactor-LastFactor)/FrameSteps;
   Factor=LastFactor;
   // *** DOPPLER ***
   DPStepsize=(ActDPFactor-LastDPFactor)/FrameSteps;
   DPFactor=LastDPFactor;
   if (Addr1<SAddr+MyWTStdMsg->MemL24) do
      {
      Data1=(LONG*)Addr1;   Addr1=Addr1+4;
      Data2=(LONG*)((LONG)SMemA+((LONG)(DPOffset)*4));
      DPOffset=DPOffset+(DPFactor*SizeFactor);
      if (ADSR.Release!=0)
         {
         if ((LONG)(DPOffset)*4>=ADSR.Release) DPOffset=DPOffset-((ADSR.Release-ADSR.Sustain) / 4);
         }
      else if ((LONG)(DPOffset)*4>=RSMemL)
         {
         TurnedOff=TRUE;
/*               if MyCinemaData^.x<=-32000 then*/ LastDistance=0;
         Addr1=Addr1+StepCtr*4;
         return;
         }
      DPFactor=DPFactor+DPStepsize;
      StepCtr--;
      Factor=Factor+Stepsize;
      *Data1=*Data1+(LONG)(*Data2*(MyCinemaData->Volume/100)*Factor);
      }
   while ((StepCtr>0) && (Addr1<SAddr+MyWTStdMsg->MemL24) && (Addr2<(LONG)SMemA+SMemL));
   }
LastDistance=ActDistance;     LastFactor=ActFactor;
LastDPDistance=ActDPDistance; LastDPFactor=ActDPFactor;
}



void ADDSOUND(LONG SAddr, UBYTE Channel)

{
CineAddr=(LONG)MyObjectHeader->DataMemA;
Addr1=SAddr;       DPOffset=0;
LastFrame=FALSE;   LastDPFactor=1;
MySteps=0;
SizeFactor=MyWTStdMsg->SRate/SXHD.PlayRate;
TurnedOff=TRUE;    SetToOff=FALSE;
UseDummy=FALSE;
if (CineAddr)
   {
   do
      {
      if (MySteps<=0)
         {
         if (UseDummy) MyCinemaData=(CinemaData*)(&DummyCineData) else MyCinemaData=(CinemaData*)(CineAddr);
         MySteps=MyCinemaData->Steps;
         CineAddr=CineAddr+sizeof(CinemaData);
         }
      MySteps--;
      if (MyCinemaData->x<=-32000) SetToOff=TRUE;
      if ((MyCinemaData->x>-32000) && (SetToOff))
         {
         SetToOff=FALSE;
         DPOffset=0;
         }
      if (CNHD.FPS==0)
         {
         if (MyCinemaData->RelTime==0) MyCinemaData->RelTime=1;
         FrameSteps=(LONG)(((10000000.0/(MyWTStdMsg->SRate*2.79365))/60.0)*MyCinemaData->RelTime);
         }
      if ((MyCinemaData->x>-32000) || ((!TurnedOff) && ((MyObjectHeader->Flags & OFLAG_SOUNDEND)==OFLAG_SOUNDEND)))
       JUSTDOIT(Channel,SAddr) else
         {
         Addr1=Addr1+(FrameSteps*4);
         TurnedOff=TRUE;
         }

      if ((CineAddr>=(LONG)MyObjectHeader->DataMemA+MyObjectHeader->DataMemL) &&
          (MySteps==0) && (!LastFrame))
         {
         LastFrame=TRUE;
         CineAddr=CineAddr-sizeof(CinemaData);
         }

      if (((MyObjectHeader->Flags & OFLAG_SOUNDEND)==OFLAG_SOUNDEND) &&
          (CineAddr>=(LONG)MyObjectHeader->DataMemA+MyObjectHeader->DataMemL) &&
          ((LONG)(DPOffset)*4<RSMemL))
         {
         DummyCineData=*MyCinemaData;
         DummyCineData.x=-32000;
         DummyCineData.Steps=1;
         UseDummy=TRUE;
         }
      }
   while (((CineAddr<(LONG)MyObjectHeader->DataMemA+MyObjectHeader->DataMemL) || (MySteps!=0) || (UseDummy)) &&
          ((!UseDummy) || ((LONG)(DPOffset)*4<RSMemL)) &&
          (Addr1<SAddr+MyWTStdMsg->MemL24));
   if (Addr1-SAddr>MaxPlayL24) MaxPlayL24=Addr1-SAddr;
   if (MaxPlayL24>MyWTStdMsg->MemL24) MaxPlayL24=MyWTStdMsg->MemL24;
   }
}



void MAKEWAVE(void)

{
UBYTE     i,j;
char      s[30],s1[100];
LONG      Addr1;


cout << "MAKEWAVE\n";
MaxPlayL24=0;
if (!LOADCINEMA(TRUE))
   {
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
SDINFO();
if (ObjMemA) for (j=1; j<=UsedObjects; j++)
   {
   MyObjectHeader=(ObjectHeader*)((LONG)ObjMemA+(j-1)*sizeof(ObjectHeader));
   SMemA=NULL;
   if ((strlen(MyObjectHeader->Sample)>0) && ((MyObjectHeader->Flags & OFLAG_SOUND)==OFLAG_SOUND))
      {
      FHandle=Open(MyObjectHeader->Sample,MODE_OLDFILE);
      if (FHandle)
         {
         Read(FHandle,&s,8);
         if (!strncmp("FORM",s,4))
            {
            Read(FHandle,&s,4);
            if ((!strncmp("HISX",s,4)) || (!strncmp("24SX",s,4)) || (!strncmp("16SX",s,4))) do
               {
               l=Read(FHandle,&IFFCh,8);
               if (l!=0)
                  {
                  if (!strncmp(IFFCh.Name,"SXHD",4))
                     {
                     IFFCh.Length=IFFCh.Length-Read(FHandle,&SXHD,sizeof(SXHeader));
                     if ((SXHD.Flags-(SXHD.Flags & (COMPRESSION_DELTA+COMPRESSION_3BYTE)))>0)
                        {
                        TASKREQUEST(MyObjectHeader->Sample,"Unknown compression-method!","","OK","");
                        Close(FHandle);
                        MyWTStdMsg->Flags=MDE_ERROR;
                        return;
                        }
                     if ((SXHD.UsedChannels!=1) && (SXHD.UsedChannels!=2) &&
                         (SXHD.UsedChannels!=4) && (SXHD.UsedChannels!=8) &&
                         (SXHD.UsedChannels!=16) && (SXHD.UsedChannels!=32) &&
                         (SXHD.UsedChannels!=64))
                        {
cout << MyWTStdMsg->UsedChannels << "\n";
                        TASKREQUEST(MyObjectHeader->Sample,"File isn`t a 1.0 mono sample!","","OK","");
                        Close(FHandle);
                        MyWTStdMsg->Flags=MDE_ERROR;
                        return;
                        }
                     SMemL=SXHD.SoundLength;
                     if ((SXHD.SampleDepth>16) && ((SXHD.Flags & COMPRESSION_3BYTE)==COMPRESSION_3BYTE))
                      SXHD.SoundLength=(SXHD.SoundLength/4)*3 else SMemL=SXHD.SoundLength*2;
                     SMemL=SMemL+4;
                     SMemA=AllocVec(SMemL,MEMF_CLEAR);
                     if (!SMemA)
                        {
                        MyWTStdMsg->Flags=MDE_NO_MEMORY;
                        Close(FHandle);
                        return;
                        }
                     }
                  else if (!strncmp(IFFCh.Name,"ADSR",4)) IFFCh.Length=IFFCh.Length-Read(FHandle,&ADSR,sizeof(ADSRHeader))
                  else if ((!strncmp(IFFCh.Name,"BODY",4)) && (SMemA))
                     {
cout << IFFCh.Length << "\n";
                     IFFCh.Length=IFFCh.Length-Read(FHandle,(APTR)((LONG)SMemA+SMemL-SXHD.SoundLength),SXHD.SoundLength);
cout << IFFCh.Length << "\n";
                     if ((SXHD.SampleDepth>16) && ((SXHD.Flags & COMPRESSION_3BYTE)==COMPRESSION_3BYTE))
                        {
                        Addr1=(LONG)SMemA;
                        Addr2=(LONG)SMemA+SMemL-SXHD.SoundLength-1;
                        do
                           {
                           Data1=(LONG*)Addr1; Addr1=Addr1+4;
                           Data2=(LONG*)Addr2; Addr2=Addr2+3;
                           *Data1=(*Data2 & 0x00FFFFFF)-MAX24;
                           }
                        while ((Addr1<(LONG)SMemA+SMemL) && (Addr2<(LONG)SMemA+SMemL));
                        RSMemL=Addr1-(LONG)SMemA;
                        }
                     else if (SXHD.SampleDepth<=16)
                        {
                        Addr1=(LONG)SMemA;
                        Addr2=(LONG)SMemA+SMemL-SXHD.SoundLength;
                        l=MAX24/32768;
                        do
                           {
                           Data1=(LONG*)Addr1;  Addr1=Addr1+4;
                           Data16=(WORD*)Addr2; Addr2=Addr2+2;
                           *Data1=*Data16*l;
                           }
                        while ((Addr1<(LONG)SMemA+SMemL) && (Addr2<(LONG)SMemA+SMemL));
                        RSMemL=Addr1-(LONG)SMemA;
                        }
                     *Data1=0;
                     }
                  if (IFFCh.Length!=0) l=Seek(FHandle,IFFCh.Length,OFFSET_CURRENT);
                  }
               }
            while (l!=0);
            else if (!strncmp(s,"8SVX",4)) do
               {
               l=Read(FHandle,&IFFCh,8);
               if (l!=0)
                  {
                  if (!strncmp(IFFCh.Name,"VHDR",4))
                     {
                     IFFCh.Length=IFFCh.Length-Read(FHandle,&VHDR,sizeof(VoiceHeader));
                     if ((VHDR.SCompression1!=0) || (VHDR.SCompression2!=0))
                        {
                        TASKREQUEST(MyObjectHeader->Sample,"Unknown compression-method!","","OK","");
                        Close(FHandle);
                        MyWTStdMsg->Flags=MDE_ERROR;
                        return;
                        }
                     SMemL=(VHDR.OneShotHiSamples+VHDR.RepeatHiSamples)*4+4;
                     SXHD.PlayRate=(LONG)(10000000.0/(VHDR.SamplesPerSec*2.79365));
                     if (VHDR.RepeatHiSamples>0)
                        {
                        ADSR.Attack=0;
                        ADSR.Decay=0;
                        ADSR.Sustain=VHDR.OneShotHiSamples*4,
                        ADSR.Release=(VHDR.OneShotHiSamples+VHDR.RepeatHiSamples)*4;
                        }
                     SMemA=AllocVec(SMemL,0);
                     if (!SMemA)
                        {
                        MyWTStdMsg->Flags=MDE_NO_MEMORY;
                        Close(FHandle);
                        return;
                        }
                     }
                  else if (!strncmp(IFFCh.Name,"CHAN",4))
                     {
                     IFFCh.Length=IFFCh.Length-Read(FHandle,&l,4);
                     if ((l!=1) && (l!=2) && (l!=4) && (l!=8) && (l!=16) && (l!=32) && (l!=64))
                        {
                        TASKREQUEST(MyObjectHeader->Sample,"File isn`t a 1.0 mono sample!","","OK","");
                        Close(FHandle);
                        MyWTStdMsg->Flags=MDE_ERROR;
                        return;
                        }
                     }
                  else if (!strncmp(IFFCh.Name,"ADSR",4))
                     {
                     IFFCh.Length=IFFCh.Length-Read(FHandle,&ADSR,sizeof(ADSRHeader));
                     ADSR.Sustain=ADSR.Sustain*4;
                     ADSR.Release=ADSR.Release*4;
                     }
                  else if ((!strncmp(IFFCh.Name,"BODY",4)) && (SMemA))
                     {
                     l=IFFCh.Length;
                     IFFCh.Length=IFFCh.Length-Read(FHandle,(APTR)((LONG)SMemA+SMemL-l),(SMemL/4)-1);
                     Addr1=(LONG)SMemA;
                     Addr2=(LONG)SMemA+SMemL-l;
                     l=MAX24/65535;
                     do
                        {
                        Data1=(LONG*)Addr1; Addr1=Addr1+4;
                        Data8=(BYTE*)Addr2; Addr2++;
                        *Data1=*Data8*l;
                        }
                     while ((Addr1<(LONG)SMemA+SMemL) || (Addr2<(LONG)SMemA+SMemL));
                     RSMemL=Addr1-(LONG)SMemA;
                     *Data1=0;
                     }
                  if (IFFCh.Length!=0) l=Seek(FHandle,IFFCh.Length,OFFSET_CURRENT);
                  }
               }
            while (l!=0)
            else
               {
               strcpy(s1,"Defined sample has an unknown IFF-format (");
               strcat(s1,s);
               strcat(s1,")!");
               TASKREQUEST(s1,"Operation cancelled","","OK","");
               MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
               Close(FHandle);
               return;
               }
            }
         else
            {
            MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
            Close(FHandle);
            return;
            }
         Close(FHandle);
         }
      else
         {
         TASKREQUEST(MyObjectHeader->Sample,"Can`t find file!","","OK","");
         MyWTStdMsg->Flags=MDE_FILEERROR;
         return;
         }
      if (ADSR.Release>RSMemL) ADSR.Release=RSMemL;
      for (i=0; i<5; i++) if (MyWTStdMsg->MemA24[i])
         {
         MyWTStdMsg->Flags=0;
         strcpy(s1,"Objekt: ");
         strcat(s1,MyObjectHeader->Name);
         strcat(s1,", Channel: ");
         if (i==0) strcpy(s,"L")
         else if (i==1) strcpy(s,"R")
         else if (i==2) strcpy(s,"C")
         else if (i==3) strcpy(s,"SL")
         else if (i==4) strcpy(s,"SR");
         strcat(s1,s);
         MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
         strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,s1);
         MESSAGEHANDLE();
         ADDSOUND(MyWTStdMsg->MemA24[i],i);
         }
      if (SMemA) FreeVec(SMemA);
      SMemA=0;
      }
   }
else
   {
   MyWTStdMsg->Flags=MDE_NO_MEMORY;
   return;
   }
if (MaxPlayL24>0) MyWTStdMsg->PlayL24=MaxPlayL24 else MyWTStdMsg->PlayL24=MyWTStdMsg->MemL24;
for (i=0; i<6; i++) if (MyWTStdMsg->MemA24[i])
   {
   Data1=(LONG*)(MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24-4);
   *Data1=1;
   }
/*MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Optimizing frontchannels");
MESSAGEHANDLE();
if ((MyWTStdMsg->MemA24[0]) && (MyWTStdMsg->MemA24[1]) && (MyWTStdMsg->MemA24[2]))
   {
   Addr1=MyWTStdMsg->MemA24[0];
   Addr2=MyWTStdMsg->MemA24[1];
   Addr3=MyWTStdMsg->MemA24[2];
   do
      {
      Data1=(LONG*)(Addr1); Addr1=Addr1+4;
      Data2=(LONG*)(Addr2); Addr2=Addr2+4;
      Data3=(LONG*)(Addr3); Addr3=Addr3+4;
      l=(*Data1+*Data2)/2;
      *Data1=*Data1-l;
      *Data2=*Data2-l;
      *Data3=*Data3/2;
      }
   while (Addr1<MyWTStdMsg->MemA24[0]+MyWTStdMsg->PlayL24);
   }*/
cout << "MAKEWAVE done\n";
cout << MyWTStdMsg->PlayL24 << "  " << MyWTStdMsg->MemL24 << "\n";
if (MyWTStdMsg->PlayL24>MyWTStdMsg->MemL24) MyWTStdMsg->PlayL24=MyWTStdMsg->MemL24;
MyWTStdMsg->Flags=MDE_READY;
}



void SETPARAMETERS(void)

{
IntuiMessage *IMsg;
Gadget        DKnopf[2]={NULL,500,40,128,16,GADGHCOMP+GADGIMAGE,0x3,BOOLGADGET,NULL,NULL,NULL,0,NULL,1,0,
                         NULL,10,40,128,16,GADGHCOMP+GADGIMAGE,0x1,BOOLGADGET,NULL,NULL,NULL,0,NULL,2,0};
IntuiText     DKnopfTx[4]={2,0,0,4,2,NULL,"no Doppler-effect",NULL,
                           2,0,0,4,2,NULL,"Doppler linear",NULL,
                           2,0,0,4,2,NULL,"Doppler squared",NULL,
                           2,0,0,4,2,NULL,"Doppler logarythm.",NULL};
SelectListGad MySList={NULL,&DKnopf[1],0,0,0,0,
                       {&DKnopfTx[0],&DKnopfTx[1],&DKnopfTx[2],&DKnopfTx[3],NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL}};
Gadget       *XGadget;
Window       *MyWindow;
UBYTE         RawCode,GadCode;


if (!LOADCINEMA(FALSE)) return;
//SDINFO;
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Definition CineData-Loader,  by QXC");
MyWTStdMsg->WTMsgPrc->PRC_Long1=70;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=0;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr))
   {
   TASKREQUEST("Can`t open window!","Operation cancelled!","","OK","");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
MyWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
if ((MyWTStdMsg->ActWaveOp->Operator[5]<1) || (MyWTStdMsg->ActWaveOp->Operator[5]>4))
 MyWTStdMsg->ActWaveOp->Operator[5]=1;
DKnopf[0].GadgetRender=MyWTStdMsg->WTImg->GImg5;
DKnopf[0].GadgetText=MyWTStdMsg->WTImg->OKIText;
DKnopf[1].GadgetRender=MyWTStdMsg->WTImg->GImg2;
DKnopf[1].GadgetText=&DKnopfTx[MyWTStdMsg->ActWaveOp->Operator[5]-1];
MySList.GadWindow=MyWindow;
MySList.SelectedGad=MyWTStdMsg->ActWaveOp->Operator[5];
for (i=0; i<2; i++) AddGadget(MyWindow,&DKnopf[i],NULL);
RefreshGadgets(MyWindow->FirstGadget,MyWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(MyWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class==GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      }
   else Delay(1);

   if (GadCode==2)
      {
      MyWTStdMsg->Flags=0;
      MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_DOSELECTLIST;
      MyWTStdMsg->WTMsgPrc->PRC_NewPtr=&MySList;
      MESSAGEHANDLE();
      if (MyWTStdMsg->WTMsgPrc->PRC_Long1!=-1)
       MyWTStdMsg->ActWaveOp->Operator[5]=MyWTStdMsg->WTMsgPrc->PRC_Long1
      }
   }
while ((GadCode!=1) && (RawCode!=68));
if (RawCode==68)
   {
   DKnopf[0].Flags=DKnopf[0].Flags | SELECTED;
   RefreshGadgets(MyWindow->FirstGadget,MyWindow,NULL);
   Delay(5);
   }
CloseWindow(MyWindow);
MyWTStdMsg->Flags=MDE_READY;
}


void main (void)

{
ObjMemA=NULL; ObjMemL=0; 
SMemA=NULL;
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (IntuitionBase) && (GfxBase))
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"CineData Loader");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               SETPARAMETERS();
               MyWTStdMsg->ActiveMode=MD_AC3;
               MyWTStdMsg->ActiveChannels=CH_LEFT+CH_RIGHT+CH_CENTER+
                                          CH_SLEFT+CH_SRIGHT+CH_SUB;
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT) MAKEWAVE();
            else MyWTStdMsg->Flags=MDE_ERROR;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   if (ObjMemA)
      {
      for (i=1; i<=UsedObjects; i++)
         {
         MyObjectHeader=(ObjectHeader*)((LONG)ObjMemA+(i-1)*sizeof(ObjectHeader));
         if (MyObjectHeader->DataMemA) FreeVec(MyObjectHeader->DataMemA);
         }
      FreeVec(ObjMemA);
      }
   if (SMemA) FreeVec(SMemA);
   }
if (DOSBase) CloseLibrary((Library*)DOSBase);
if (GfxBase) CloseLibrary((Library*)GfxBase);
if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);
}

