#include <exec/types.h>
#include <exec/memory.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>

//#include <pragma/all_lib.h>


#ifdef __PPC__
   struct Library *PowerPCBase
#endif

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/WTIncl.h>

#include <string.h>

extern struct DOSBase *DOSBase;

struct CDXLHeader
   {
   UBYTE CDXLType,Info;
   LONG  CurrSize,PrevSize;
   UWORD res1,CurrFrameNum,Width,Height,Depth,CMapSize,RawSoundSize;
   LONG  res2,res3;
   };

CDXLHeader CDXL;

LONG   BitMapSize,Addr1,Addr2;
LONG   MemLS,l,m,Loaded;
UBYTE  MyChannels,MyMode;
LONG  *Data2;
BYTE  *Data1;



void READCDXL(void)

{
MemLS=0;
do
   {
   l=Read(MyWTStdMsg->ActFHandle,&CDXL,sizeof(CDXLHeader));
   if (l==0) return;
   if (CDXL.CurrSize>0)
      {
      if ((CDXL.Info & 0x10)==0x10)
         {
         MyMode=MD_STEREO;
         MyChannels=CH_LEFT+CH_RIGHT;
         MemLS=MemLS+(CDXL.RawSoundSize/2);
         }
      else
         {
         MyMode=MD_MONO;
         MyChannels=CH_CENTER;
         MemLS=MemLS+CDXL.RawSoundSize;
         }
      Seek(MyWTStdMsg->ActFHandle,CDXL.CurrSize-sizeof(CDXLHeader),OFFSET_CURRENT);
      }
   }
while (CDXL.CurrSize>0);
}



void CALCDATA(UBYTE ChID)

{
if (!MyWTStdMsg->MemA24[ChID]) return;
Addr1=MyWTStdMsg->MemA24[ChID]+MyWTStdMsg->MemL24-MemLS;
Addr2=MyWTStdMsg->MemA24[ChID];
do
   {
   Data1=(BYTE*)Addr1; Addr1++;
   Data2=(LONG*)Addr2; Addr2=Addr2+4;
   *Data2=*Data1*65535;
   }
while ((Addr1<MyWTStdMsg->MemA24[ChID]+MyWTStdMsg->MemL24) &&
       (Addr2<MyWTStdMsg->MemA24[ChID]+MyWTStdMsg->MemL24));
}



void LOADCDXL(void)


{
Loaded=0;
Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
do
   {
   l=Read(MyWTStdMsg->ActFHandle,&CDXL,sizeof(CDXLHeader));
   if ((l==0) || (Loaded>=MemLS))
      {
      if ((CDXL.Info & 0x10)==0) CALCDATA(2) else
         {
         CALCDATA(1);
         CALCDATA(2);
         }
      MyWTStdMsg->Flags=MDE_READY;        
      return;
      }
   if (CDXL.CurrSize>0)
      {
      BitMapSize=(CDXL.Width*CDXL.Height)/8*CDXL.Depth;
      CDXL.CurrSize=CDXL.CurrSize-sizeof(CDXLHeader)-CDXL.CMapSize-BitMapSize;
      Seek(MyWTStdMsg->ActFHandle,CDXL.CMapSize,OFFSET_CURRENT);
      Seek(MyWTStdMsg->ActFHandle,BitMapSize,OFFSET_CURRENT);
      Seek(MyWTStdMsg->ActFHandle,CDXL.CurrSize-CDXL.RawSoundSize,OFFSET_CURRENT);
      if (MyMode==MD_STEREO)
         {
         l=CDXL.RawSoundSize/2;
         if (MyWTStdMsg->MemA24[0])
            {
            Addr1=MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24-MemLS+Loaded;
            if (Addr1+l>MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24) l=(MyWTStdMsg->MemA24[0]+MyWTStdMsg->MemL24)-Addr1;
            m=Read(MyWTStdMsg->ActFHandle,(APTR)Addr1,l);
            }
         if (MyWTStdMsg->MemA24[1])
            {
            Addr1=MyWTStdMsg->MemA24[1]+MyWTStdMsg->MemL24-MemLS+Loaded;
            m=Read(MyWTStdMsg->ActFHandle,(APTR)Addr1,l);
            }
         CDXL.CurrSize=CDXL.CurrSize-m*2;
         }
      else
         {
         l=CDXL.RawSoundSize;
         if (MyWTStdMsg->MemA24[2])
            {
            Addr1=MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24-MemLS+Loaded;
            if (Addr1+l>MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24) l=(MyWTStdMsg->MemA24[2]+MyWTStdMsg->MemL24)-Addr1;
            m=Read(MyWTStdMsg->ActFHandle,(APTR)Addr1,l);
            }
         }
      Loaded=Loaded+m;
      }
   }
while (CDXL.CurrSize>0);
MyWTStdMsg->Flags=MDE_READY;
};



void main (void)

{
#ifdef __PPC__
   PowerPCBase=(struct PowerPCBase*)OpenLibrary("powerpc.library",39)
   DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
   if ((DOSBase) && (PowerPCBase))
#else
   DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
   if (DOSBase)
#endif
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"CDXL-sound 2.0 Stereo 8 Bit Loader");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               READCDXL();
               MyWTStdMsg->ActWaveOp->Operator[0]=MemLS;
               MyWTStdMsg->ActWaveOp->Operator[1]=1;
               MyWTStdMsg->ActiveMode=MyMode;
               MyWTStdMsg->ActiveChannels=MyChannels;
               MyWTStdMsg->Flags=MDE_READY;
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT)
               {
               READCDXL();
               if ((MyChannels & MyWTStdMsg->ActiveChannels)==0) MyWTStdMsg->Flags=MDE_CHANNELERROR else
                  {
                  if (MyWTStdMsg->ActWaveOp->Operator[0]<MemLS) MemLS=MyWTStdMsg->ActWaveOp->Operator[0];
                  LOADCDXL();
                  MyWTStdMsg->PlayL24=Loaded*4;
                  }
               }
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   CloseLibrary((Library*)DOSBase);
   #ifdef __PPC__
      CloseLibrary((Library*)PowerPCBase);
   #endif
   }
}
