#include <exec/types.h>
#include <exec/memory.h>

#include <libraries/dos.h>
#include <intuition/intuitionbase.h>

#include <clib/dos_protos.h>
#include <clib/intuition_protos.h>
#include <clib/graphics_protos.h>

#include <pragma/all_lib.h>

#include </WaveTracer/ModIncl.h>
#include </WaveTracer/EffIncl.c>
#include </WaveTracer/WTIncl.h>

#include <string.h>
#include <stdlib.h>
#include <math.h>


extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;

struct DPANHeader
   {
   UWORD Version,Frames;
   UBYTE FPS,pad1,pad2,pad3;
   };

struct ANHDHeader
   {
   UBYTE Operation,Mask;
   UWORD w,h,x,y;
   LONG  AbsTime,RelTime;
   UBYTE Interleave,pad0;
   LONG  Bits;
   UBYTE pad[16];
   };


char          Buffer[2][10],ChunkName[4];
IntuiMessage *IMsg;
Gadget       *XGadget;
Gadget        TextGad[2]={NULL,0,40,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,
                          NULL,NULL,NULL,0,NULL,0,0,
                          NULL,0,40,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,
                          NULL,NULL,NULL,0,NULL,0,0};
StringInfo    TextInfo[2]={(UBYTE*)Buffer[0],(UBYTE*)Buffer[0],0,7,0,0,0,0,0,0,NULL,0,NULL,
                           (UBYTE*)Buffer[1],(UBYTE*)Buffer[1],0,7,0,0,0,0,0,0,NULL,0,NULL};
Window       *MyWindow;
DPANHeader    DPAN;
ANHDHeader    ANHD;

BOOL  MsgGone;
LONG  LastPosition,FrameNum[2],l,ChunkLength;
UBYTE GadCode,RawCode;
WORD  i;



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



void CALCSAMPLESIZE(LONG FrameMode, LONG StartFrame, LONG EndFrame)

{
LONG MyFrames;


MyWTStdMsg->Flags=0;
if (FrameMode==0)
   {
   if (DPAN.Frames<EndFrame-StartFrame) MyFrames=DPAN.Frames else MyFrames=EndFrame-StartFrame+1;
   LastPosition=(LONG)(MyFrames*((10000000.0/(MyWTStdMsg->SRate*2.79365))/DPAN.FPS))
   }
else if (FrameMode>0)
   {
   if (ANHD.RelTime==0) ANHD.RelTime=1;
   if ((DPAN.Frames>=StartFrame) && (DPAN.Frames<=EndFrame))
    LastPosition=(LONG)(LastPosition+((ANHD.RelTime/60.0)*((10000000.0/(MyWTStdMsg->SRate*2.79365)))));
   }
};



BOOL READCHUNK(void)

{
l=Read(MyWTStdMsg->ActFHandle,&ChunkName,4);
l=l+Read(MyWTStdMsg->ActFHandle,&ChunkLength,4);
if (l==8) return TRUE else return FALSE;
};



void SCANANIM(LONG StartFrame, LONG EndFrame)

{
SDBodyAnim *MySDBodyANIM;


LastPosition=0;
DPAN.Frames=0;
DPAN.FPS=0;
Seek(MyWTStdMsg->ActFHandle,0,OFFSET_BEGINNING);
READCHUNK();
if (!(strncmp(ChunkName,"FORM",4)))
   {
   Read(MyWTStdMsg->ActFHandle,&ChunkName,4);
   if (!(strncmp(ChunkName,"ANIM",4)))
      {
      while (READCHUNK() && (ChunkLength>0))
         {
         if (ChunkLength%2==1) ChunkLength++;
         if (!(strncmp(ChunkName,"FORM",4)))
            {
            DPAN.Frames++;
            Seek(MyWTStdMsg->ActFHandle,4,OFFSET_CURRENT);
            }
         else
            {
            if (!(strncmp(ChunkName,"DPAN",4)))
               {
               Read(MyWTStdMsg->ActFHandle,&DPAN,sizeof(DPANHeader));
               CALCSAMPLESIZE(0,StartFrame,EndFrame);
               MyWTStdMsg->Flags=0;
               MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ALLOC_SPECIAL_DATA;
               MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_ANIMINFO;
               MESSAGEHANDLE();
               if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr)
                  {
                  MySDBodyANIM=(SDBodyAnim*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;                
                  MySDBodyANIM->sdb_SDHeader.NextSpecialData=NULL;
                  MySDBodyANIM->sdb_SDHeader.sdh_Size=sizeof(SDBodyAnim);
                  MySDBodyANIM->sdb_SDHeader.sdh_Type=SD_ANIMINFO;
                  MySDBodyANIM->sdb_Frames=DPAN.Frames;
                  MySDBodyANIM->sdb_FPS=DPAN.FPS;
                  MySDBodyANIM->sdb_Flags=0;
                  MySDBodyANIM->sdb_pad=0;
                  MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SPECIAL_DATA_FOUND;
                  MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_ANIMINFO;
                  MyWTStdMsg->WTMsgPrc->PRC_NewPtr=MySDBodyANIM;
                  MESSAGEHANDLE();
                  }
               MyWTStdMsg->Flags=MDE_READY;
               return;
               }
            else if (!(strncmp(ChunkName,"ANHD",4)))
               {
               ChunkLength=ChunkLength-Read(MyWTStdMsg->ActFHandle,&ANHD,sizeof(ANHDHeader));
               CALCSAMPLESIZE(DPAN.Frames,StartFrame,EndFrame)
               }
            Seek(MyWTStdMsg->ActFHandle,ChunkLength,OFFSET_CURRENT);
            }
         }
      MyWTStdMsg->Flags=MDE_READY;
      }
   else MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
   }
else MyWTStdMsg->Flags=MDE_NOTMYFORMAT;
};



void CREATEANIM(void)

{
SDBodyScene *MySDBodyScene;


MyWTStdMsg->ActiveChannels=0x3F;
MyWTStdMsg->PlayL24=MyWTStdMsg->ActWaveOp->Operator[0]*MyWTStdMsg->ActWaveOp->Operator[1]*4;
if (((MyWTStdMsg->ActWaveOp->Operator[4]>=1) || (MyWTStdMsg->ActWaveOp->Operator[5]<=DPAN.Frames)) &&
     (MyWTStdMsg->ActWaveOp->Operator[4]<MyWTStdMsg->ActWaveOp->Operator[5]))
   {
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_ALLOC_SPECIAL_DATA;
   MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_SCENE;
   MESSAGEHANDLE();
   if (MyWTStdMsg->WTMsgPrc->PRC_NewPtr)
      {
      MySDBodyScene=(SDBodyScene*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;                
      MySDBodyScene->sdb_SDHeader.NextSpecialData=NULL;
      MySDBodyScene->sdb_SDHeader.sdh_Size=sizeof(SDBodyScene);
      MySDBodyScene->sdb_SDHeader.sdh_Type=SD_SCENE;
      strcpy(MySDBodyScene->sdb_Name,"");
      MySDBodyScene->sdb_StartFrame=MyWTStdMsg->ActWaveOp->Operator[4];
      MySDBodyScene->sdb_EndFrame=MyWTStdMsg->ActWaveOp->Operator[5];
      MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SPECIAL_DATA_FOUND;
      MyWTStdMsg->WTMsgPrc->PRC_Long1=SD_SCENE;
      MyWTStdMsg->WTMsgPrc->PRC_NewPtr=MySDBodyScene;
      MESSAGEHANDLE();
      MyWTStdMsg->Flags=MDE_READY;
      return;
      }
   else
      {
      MyWTStdMsg->Flags=MDE_NO_MEMORY;
      return;
      }
   }
MyWTStdMsg->Flags=MDE_READY;
}



void DEFINESCENE(void)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"DEFINITION AnimScene");
MyWTStdMsg->WTMsgPrc->PRC_Long1=85;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=1;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr))
   {
   SENDERROR("Couldnt open window!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   };
MyWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
WRITE(40,60,1,3,MyWindow,"1");  WRITE(76,60,2,0,MyWindow,"-");
inttostr(DPAN.Frames,Buffer[0]); WRITE(120,60,1,3,MyWindow,Buffer[0]);
WRITE(160,60,2,0,MyWindow,"Anim-Length");
WRITE(76,41,2,0,MyWindow,"-");
WRITE(160,41,2,0,MyWindow,"Anim-Scene");
if ((MyWTStdMsg->ActWaveOp->Operator[4]>=1) && (MyWTStdMsg->ActWaveOp->Operator[4]<=DPAN.Frames) &&
    (MyWTStdMsg->ActWaveOp->Operator[5]>=1) && (MyWTStdMsg->ActWaveOp->Operator[5]<=DPAN.Frames) &&
    (MyWTStdMsg->ActWaveOp->Operator[4]<MyWTStdMsg->ActWaveOp->Operator[5]))
   {
   FrameNum[0]=MyWTStdMsg->ActWaveOp->Operator[4];
   FrameNum[1]=MyWTStdMsg->ActWaveOp->Operator[5];
   }
else
   {
   FrameNum[0]=1;
   FrameNum[1]=DPAN.Frames;
   };
for (i=0; i<2; i++)
   {
   TextGad[i].LeftEdge=10+i*80;
   TextGad[i].SpecialInfo=&TextInfo[i];
   TextGad[i].GadgetID=i+3;
   MAKEBORDER(MyWindow,9+i*80,39,70+i*80,53,NEGATIVE);
   inttostr(FrameNum[i],Buffer[i]);
   AddGadget(MyWindow,&TextGad[i],NULL);
   };
RefreshGadgets(MyWindow->FirstGadget,MyWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(MyWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class==GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      }
   else Delay(1);

   for (i=0; i<=2; i++)
      {
      if (GadCode==3)
         {
         FrameNum[0]=strtol(Buffer[0],NULL,10);
         if (FrameNum[0]>=FrameNum[1]) FrameNum[0]=FrameNum[1]-1;
         if (FrameNum[0]<1) FrameNum[0]=1;
         inttostr(FrameNum[0],Buffer[0]);
         RefreshGadgets(MyWindow->FirstGadget,MyWindow,NULL);
         GadCode=4;
         };
      if (GadCode==4)
         {
         FrameNum[1]=strtol(Buffer[1],NULL,10);
         if (FrameNum[1]<=FrameNum[0]) FrameNum[1]=FrameNum[0]+1;
         if (FrameNum[1]>DPAN.Frames) FrameNum[1]=DPAN.Frames;
         inttostr(FrameNum[1],Buffer[1]);
         RefreshGadgets(MyWindow->FirstGadget,MyWindow,NULL);
         GadCode=3;
         }
      }

   }
while ((GadCode!=1) && (GadCode!=2) && (RawCode!=68) && (RawCode!=69));
CloseWindow(MyWindow);
if ((GadCode==2) || (RawCode==69)) MyWTStdMsg->Flags=MDE_CANCELLED else
   {
   MyWTStdMsg->ActWaveOp->Operator[4]=FrameNum[0];
   MyWTStdMsg->ActWaveOp->Operator[5]=FrameNum[1];
   if ((FrameNum[0]>1) || (FrameNum[1]<DPAN.Frames)) SCANANIM(FrameNum[0],FrameNum[1]);
   MyWTStdMsg->Flags=MDE_READY;
   }
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (IntuitionBase) && (GfxBase))
   {
   if (CREATEPORTS(PORT_LOADER))
      {
      if (MyWTStdMsg->Version==VERSION_LOADER)
         {
         if (MyWTStdMsg->Flags==MDC_ASKREADY)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"ANIM runtime analyzing Loader");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,COPYRIGHT);
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=MDE_READY
            }
         else if (MyWTStdMsg->ActFHandle)
            {
            if (MyWTStdMsg->Flags==MDC_DEFINEIT)
               {
               SCANANIM(1,2000000000);
               if (MyWTStdMsg->Flags==MDE_READY)
                  {
                  DEFINESCENE();
                  MyWTStdMsg->ActWaveOp->Operator[0]=LastPosition;
                  MyWTStdMsg->ActWaveOp->Operator[1]=1;
                  MyWTStdMsg->ActiveChannels=0x3F;
                  MyWTStdMsg->ActiveMode=MyWTStdMsg->ActWaveOp->SoundMode;
                  }
               }
            else if (MyWTStdMsg->Flags==MDC_DOIT) CREATEANIM()
            else MyWTStdMsg->Flags=MDE_NO_MEMORY;
            }
         else (MyWTStdMsg->Flags=MDE_FILEERROR);
         }
      else MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE();
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   }
if (DOSBase) CloseLibrary((Library*)DOSBase);
if (GfxBase) CloseLibrary((Library*)GfxBase);
if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);
}
