Program IFF;

Uses Intuition,Graphics;

var f :text;

Label Ende;

{$incl "libraries/dos.h","AGA.lib","intuition/intuitionbase.h"}
{$path "DEVELOP:WT_DSS/WaveTracer/";incl "WTIncl.mod"}

Type
 BitMapHeader=Record
   Width,Height            :Word;
   dX,dY                   :Integer;
   Depth,Mask              :Byte;
   Kompr,pad               :Boolean;
   transcolor              :Word;
   XAspect,YAspect         :Byte;
   SWidth,SHeight          :integer
 End;

type RGBX=record
        r,g,b              :byte;
     end;
type TagArr=array[1..10] of long;

var Fhandle                             :Long;
    MyScreen                            :^Screen;
    NeuScreen                           :NewScreen;
    Tags                                :TagArr;
var IBase                               :^IntuitionBase;
var MyView                              :p_ViewPort;
var FName                               :string[150];
    Hunkname                            :string[5];
    HName                               :^String[4];
    LongWord,Anz,LineSize,colors        :Long;
    ErrorFlag,BodyFlag,scr,mem          :Boolean;
    BMHD                                :^BitMapHeader;
    BMap,ScrMode,l,cnt,mema,meml        :Long;
var ModFlags                            :long;
    i,Zeile,Plane,Count                 :integer;
    RGB                                 :array [0..255] of ^RGBX;
var ltx                                 :^long;
var s                                   :str;


procedure ErrorProc;

begin
   if scr then CloseScreen(MyScreen);
   if mem then Free_Mem(mema,meml);
   goto Ende;
end;

Procedure OverRead(L:Long);

Var buf       :^String[50];

Begin
   While (L>50) and not ErrorFlag Do Begin
      cnt:=cnt+50;
      L:=L-50;
   End;
   cnt:=cnt+L mod 50
End;

Procedure ReadHunkName;

Begin
   If not ErrorFlag Then Begin
      HName:=ptr(cnt);   cnt:=cnt+4;
      Hunkname:=Hname^;
      Hunkname[5]:=chr(0);
   End
End;

Procedure ReadLong;

Var ltx :^Long;

Begin
   If not ErrorFlag Then Begin
      ltx:=ptr(cnt);   cnt:=cnt+4;
      LongWord:=ltx^;
   End
End;

Procedure LiesZeile(Adr:Long);

Var Anz,Count,Size,AdrCnt    :Long;
var i,j,k                    :integer;
var Head,Body                :Short;
var Mem                      :^Short;
var btx,bty                  :^byte;

Begin
   If Not ErrorFlag Then Begin
      with BMHD^ do if Width mod 8=0 then Size:=Width div 8 else Size:=(BMHD^.Width+8) div 7;

      If not BMHD^.Kompr Then Begin
         AdrCnt:=Adr;
         for k:=1 to Size do begin
            btx:=ptr(cnt);      cnt:=cnt+1;
            bty:=ptr(AdrCnt);   AdrCnt:=AdrCnt+1;
            bty^:=btx^
         end;
      End Else Begin
         i:=0;
         While (i<Size) and not ErrorFlag Do Begin
            btx:=ptr(cnt);   cnt:=cnt+1;
            Head:=btx^;
            If Head>=0 Then Begin
               AdrCnt:=Adr+i;
               for k:=1 to Head+1 do begin
                  btx:=ptr(cnt);      cnt:=cnt+1;
                  bty:=ptr(AdrCnt);   AdrCnt:=AdrCnt+1;
                  bty^:=btx^
               end;
               i:=i+Head+1
            End Else Begin
               btx:=ptr(cnt);   cnt:=cnt+1;
               Body:=btx^;
               For j:=1 to 1-Head Do Begin
                  Mem:=Ptr(Adr+i);
                  Mem^:=Body;
                  i:=i+1
               End
            End
         End
     End;
  End
end;


procedure MAKEIMGDATA;

var lp                  :^long;
var l,lw,Size           :long;
var Planeaddr           :array[1..7] of long;
var j,i                 :integer;

begin
   FName:=FName+'.data';
   FHandle:=DosOpen(FName,MODE_NEWFILE);
   if FHandle=0 then exit;
   with BMHD^ do if Width mod 8=0 then Size:=Width div 8 else Size:=(BMHD^.Width+8) div 7;
   l:=DosWrite(FHandle,^ModFlags,4);
   for i:=1 to BMHD^.Depth do begin

      PlaneAddr[i]:=long(MyScreen^.BitMap.Planes[i-1]);
      writeln('Plane #',i,': ',PlaneAddr[i]);
      l:=0;
      for j:=1 to BMHD^.Height do begin
         l:=l+DosWrite(FHandle,ptr(PlaneAddr[i]),Size);
         PlaneAddr[i]:=PlaneAddr[i]+MyScreen^.BitMap.BytesPerRow;
      end;
      writeln(l,' Bytes gespeichert');
   end;
   DosClose(FHandle);
end;



Begin
   OpenLib(intbase,'intuition.library',39);
   OpenLib(gfxbase,'graphics.library' ,39);
   mem:=false;  scr:=false;
   write('Name der Icon-Bilddatei: ');
   readln(FName);
   writeln('Zu setztende Flags');
   writeln('   (0 - kein Definitionsfenster,');
   writeln('    1 - EFF_DEFWIN - Definitionsfenster,');
     write('    2 - EFF_NOCALC Keine Neuberechnung der 8Bit-Daten): ');
   readln(ModFlags);

   ErrorFlag:=false;  Bodyflag:=false;
   reset(f,FName);
   if IOResult<>0 then begin
      if not fromwb then writeln('File ',FName,' nicht gefunden!');
      goto Ende;
   end;
   meml:=filesize(f);
   close(f);
   mema:=Alloc_Mem(meml,1);
   if mema=0 then begin
      mema:=Alloc_Mem(meml,2);
      if mema=0 then goto Ende;
   end;
   mem:=true;
   cnt:=mema;
   Fhandle:=Open(FName,MODE_OLDFILE);
   If FHandle=0 Then Begin
      if not FromWB then writeln('File nicht gefunden!');
      ErrorProc;
   End;
   l:=DosRead(FHandle,ptr(mema),meml);
   DosClose(FHandle);
   if l<200 then ErrorProc;
   ReadHunkName;
   If HunkName<>'FORM' Then Begin
      if not fromwb then writeln('Kein IFF!');
      ErrorProc
   End;
   ReadLong;
   ReadHunkName;
   If HunkName<>'ILBM' Then Begin
      if not fromwb then writeln('Kein ILBM');
      ErrorProc;
   End;
   ReadHunkName;
   ScrMode:=0;
   While Not Errorflag Do Begin
      ReadLong;
      writeln(HunkName,'  ',LongWord);

      If HunkName='BMHD' Then Begin
         BMHD:=ptr(cnt);   cnt:=cnt+sizeof(BitMapHeader);
         OverRead(LongWord-SizeOf(BitMapHeader));
         with BMHD^ do begin
            writeln('   Picture:    ',Width,' x ',Height,' x ',Depth,'; ',Mask);
            writeln('   Offset:     ',dX,' x ',dY);
            if Kompr then writeln('   Komprimiert') else writeln('   Nicht komprimiert');
            writeln('   Transcolor: ',transcolor);
            writeln('   Aspect:     ',XAspect,' x ',YAspect);
            writeln('   Screen:     ',SWidth,' x ',SHeight);
         end;

      End else If HunkName='CMAP' Then Begin
         colors:=LongWord;
         RGB[0]:=ptr(cnt);
         For i:=0 to LongWord div 3-1 Do Begin
            RGB[i]:=ptr(cnt);   cnt:=cnt+3;
         End;

      end else if HunkName='CAMG' then begin
         ltx:=ptr(cnt);   cnt:=cnt+4;
         ScrMode:=ltx^;
         writeln('   ScreenMode: ',ScrMode);

      end else if HunkName='ANNO' then begin
         s:=ptr(cnt);
         writeln('   ',s);
         OverRead(LongWord);

      End else If HunkName='BODY' Then Begin
         with BMHD^ do begin
            NeuScreen:=NewScreen(0,0,SWidth,SHeight,Depth,1,0,$0,CUSTOMSCREEN,
                                 NIL,' by VWP & QXC',NIL,NIL);
            Tags:=TagArr(SA_DisplayID,ScrMode,
                         SA_Interleaved, _TRUE,
                         SA_Draggable,   _FALSE,
                         TAG_DONE,       0,0,0);
            MyScreen:=OpenScreenTagList(^NeuScreen,^Tags);
            if MyScreen=NIL then begin
               if not fromwb then writeln('Kann Screen nicht ffnen!');
               ErrorProc
            end else scr:=true;
            MyView:=^MyScreen^.ViewPort;
            For i:=0 to colors div 3-1 Do
               SetRGB4(MyView,i,RGB[i]^.r div 16,RGB[i]^.g div 16,RGB[i]^.b div 16)
         end;
         If Bodyflag then ErrorProc;
         For Zeile:=0 to pred(BMHD^.Height) Do
            For Plane:=0 to pred(BMHD^.Depth) Do
               LiesZeile(Long(MyScreen^.BitMap.Planes[Plane])+Zeile*MyScreen^.BitMap.BytesPerRow);
         ErrorFlag:=True;
         BodyFlag:=true;
      end Else OverRead(LongWord);
      If not ErrorFlag Then ReadHunkName
   End;
  MAKEIMGDATA;
   Free_Mem(mema,meml);
   CloseScreen(MyScreen);
Ende:
   CloseLib(GfxBase);
   CloseLib(IntBase);
End.


