program animplay;

Uses ExecIO,Intuition,Graphics;

{$incl "libraries/dos.h","exec/memory.h","AGA.lib"}

{$path "WaveTracer/"; incl "WTIncl.mod"}

const PORT_ANIM='WTAnimPort';

type BArr32=array[0..31] of byte;

type p_AnimMsg=^AnimMsg;
type AnimMsg=Record
        wt_Node                       :Message;
        ShowPic,StartFrame,EndFrame   :long;
        IntuiWindow3                  :^Window;
        AnimHandle                    :^BPTR;
        AnimPicPos                    :long
        CachePicPos                   :^long;
        NewColorR,NewColorG,NewColorB :BArr32;
        MyScreen                      :^Screen;
        E3Knopf                       :^Gadget;
        GImg                          :^Image;
        TDeviceValid                  :^boolean;
        UseVMem,FrameCache            :boolean;
        AnimErrorTxt,VMemStr,AnimPath :string[200];
     end;

type AnimHeader=record
        Operation,Mask          :byte;
        Width,Height            :word;
        x,y                     :integer;
        AbsTime,RelTime         :long;
        Interleave              :byte;
        pad0                    :byte;
        Bits                    :long;
        pad                     :array [1..16] of byte;
     end;
Type BitMapHeader=Record
        Width,Height    :Word;
        dX,dY           :Integer;
        Depth,Mask      :Byte;
        Kompr,pad       :Boolean;
        transcolor      :Word;
        XAspect,YAspect :Byte;
        SWidth,SHeight  :integer
     End;

type DeLTA=record;
        DataPtr         :array[1..16] of long;
     end;



type LArr8=array [1..8] of PLANEPTR;
type BArr8=array [1..8] of byte;
type LArr2=array [1..2] of long;
type WArr7=array [1..7] of word;

var E3KnopfTx                                   :IntuiText;

var MyAnimBitMap                                :array [1..2] of BitMap;
var MyAnimRastPort                              :array [1..2] of RastPort;
var AnimBMemL                                   :long;
var AnimBMemA                                   :array [1..2] of long;
var AnimAScr                                    :byte;
var AnimBMHD                                    :BitMapHeader;
var ColorR,ColorG,ColorB                        :array [0..255] of byte;

var AnimPort                                    :^MsgPort;
var MyAMsg                                      :^AnimMsg;
var MyLArr                                      :LArr8;
var ChunkName                                   :string[5];
var ChunkLength,Frames,l,m,ChunkPos,ChunkMemA,
    DeltaFlags                                  :long;
var ColCnt                                      :integer;

var LineSize,BodyAddr                           :long;
var RGB: Record r,g,b                           :Byte End;


var NewColorPos,ColorUsed                       :byte;
var Col2Col                                     :array [0..255] of short;

var ErrorFlag,HeadFlag,FirstFrame,DataFound,
    HAMAnim,Leave                               :Boolean;
var CacheFHandle                                :BPTR;
var ANHD                                        :AnimHeader;
var DLTA                                        :DeLTA;
var i,j,Zeile,Plane,Count                       :integer;
var DeltaMemA,DeltaMemL,StartFrame,EndFrame     :long;
var RestOffset,RestLength                       :word;
var AnimSDHeader                                :^SDHeader;
var AnimSDBodyScene                             :^SDBodyScene;
var s                                           :string;


procedure CLEARPORT(PortName :str);

var BadPort     :^MsgPort;
var BadMsg      :^Message;

begin
   BadPort:=FindPort(PortName);
   Forbid;
   while BadPort<>NIL do begin
      BadMsg:=Get_Msg(BadPort);
      while BadMsg<>NIL do begin
         Reply_Msg(BadMsg);
         BadMsg:=Get_Msg(BadPort);
      end;
      RemPort(BadPort);
      BadPort:=FindPort(PortName);
   end;
   Permit;
end;



procedure READCHUNK;

begin
   l:=DosRead(MyAMsg^.AnimHandle^,^ChunkName,4);
   ChunkName[5]:=chr(0);
   l:=l+DosRead(MyAMsg^.AnimHandle^,^ChunkLength,4);
   if l<8 then ErrorFlag:=true;
end;



procedure SCALEDOWNIMAGE(AnimAScr :byte);

var x,y,i,PixX,PixY,BPixX,BPixY,
    BeforeColor                 :integer;
var MyColor                     :byte;
var ColorFound,DoHAM            :boolean;
var MinDifference,MinPos,w      :word;
var FactorX,FactorY             :real;
var WinX,WinY                   :word;



procedure FINDREALCOLOR;

var XR,XG,XB                    :integer;
var XColor                      :byte;

begin
   XR:=-1;   XG:=-1;   XB:=-1;
   repeat
      XColor:=ReadPixel(^MyAnimRastPort[AnimAScr],PixX,PixY);
      if AnimBMHD.Depth=6 then begin
         case (XColor and $30) of
            $00: begin
                    if XR<0 then XR:=ColorR[XColor];
                    if XG<0 then XG:=ColorG[XColor];
                    if XB<0 then XB:=ColorB[XColor];
                 end;
            $20: if XR<0 then XR:=((XColor and $F)*17);
            $30: if XG<0 then XG:=((XColor and $F)*17);
            $10: if XB<0 then XB:=((XColor and $F)*17);
         end;
      end else begin
         case (XColor and $C0) of
            $00: begin
                    if XR<0 then XR:=ColorR[XColor];
                    if XG<0 then XG:=ColorG[XColor];
                    if XB<0 then XB:=ColorB[XColor];
                 end;
            $80: if XR<0 then XR:=(XColor and $3F*4);
            $C0: if XG<0 then XG:=(XColor and $3F*4);
            $40: if XB<0 then XB:=(XColor and $3F*4);
         end;
      end;
      PixX:=PixX-1;
   until (XR>=0) and (XG>=0) and (XB>=0);
   ColorR[255]:=XR; ColorG[255]:=XG; ColorB[255]:=XB;
end;



begin
   AnimAscr:=3-AnimAScr;
   for i:=8 to 23 do begin
      MyAMsg^.NewColorR[i]:=0;
      MyAMsg^.NewColorG[i]:=0;
      MyAMsg^.NewColorB[i]:=0;
   end;
   NewColorPos:=8;
   for i:=0 to 255 do Col2Col[i]:=-1;
   WinX:=(MyAMsg^.IntuiWindow3^.Width-24); WinY:=(MyAMsg^.IntuiWindow3^.Height-20);
   FactorX:=AnimBMHD.Width/WinX;   FactorY:=AnimBMHD.Height/WinY;
   BPixX:=0; BPixY:=0; BeforeColor:=1000;
   for y:=0 to pred(WinY) do for x:=0 to pred(WinX) do begin
      PixX:=round(x*FactorX); PixY:=round(y*FactorY);
      if (PixX=BPixX) and (PixY=BPixY) and (BPixX>0) and (BPixY>0) then
       WritePixel(MyAMsg^.IntuiWindow3^.RPort,x+5,y+17) else begin
         BPixX:=PixX; BPixY:=PixY;
         MyColor:=ReadPixel(^MyAnimRastPort[AnimAScr],PixX,PixY);
         if HAMAnim and
         (((AnimBMHD.Depth=8) and (MyColor>63)) or
         ((AnimBMHD.Depth=6) and (MyColor>15))) then begin
            MyColor:=255;
            Col2Col[255]:=-1;
            FINDREALCOLOR;
         end;
         if BeforeColor=MyColor then WritePixel(MyAMsg^.IntuiWindow3^.RPort,x+5,y+17)
         else begin
            BeforeColor:=MyColor;
            if Col2Col[MyColor]=-1 then begin
               ColorFound:=false;
               for i:=0 to 31 do if not (ColorFound)
                and ((i<NewColorPos) or (i>23))
                and (MyAMsg^.NewColorR[i]=ColorR[MyColor])
                and (MyAMsg^.NewColorG[i]=ColorG[MyColor])
                and (MyAMsg^.NewColorB[i]=ColorB[MyColor]) then begin
                  ColorFound:=true;
                  Col2Col[MyColor]:=i;
               end;
               if not ColorFound then begin
                  MinDifference:=64000;
                  for i:=0 to 31 do
                  if (i<NewColorPos) or (i>23) then begin
                     w:=abs(MyAMsg^.NewColorR[i]-ColorR[MyColor])
                       +abs(MyAMsg^.NewColorG[i]-ColorG[MyColor])
                       +abs(MyAMsg^.NewColorB[i]-ColorB[MyColor]);
                     if w<MinDifference then begin
                        MinPos:=i;
                        MinDifference:=w;
                     end;
                  end;
                  if (NewColorPos>23) or (MinDifference<24) then begin
                     ColorFound:=true;
                     Col2Col[MyColor]:=MinPos;
                  end;
               end;
               if not ColorFound and (NewColorPos<24) then begin
                  Col2Col[MyColor]:=NewColorPos;
                  MyAMsg^.NewColorR[NewColorPos]:=ColorR[MyColor];
                  MyAMsg^.NewColorG[NewColorPos]:=ColorG[MyColor];
                  MyAMsg^.NewColorB[NewColorPos]:=ColorB[MyColor];
                  SetRGB32(^MyAMsg^.MyScreen^.ViewPort,NewColorPos,MyAMsg^.NewColorR[NewColorPos]*$1000000,MyAMsg^.NewColorG[NewColorPos]*$1000000,MyAMsg^.NewColorB[NewColorPos]*$1000000);
                  NewColorPos:=NewColorPos+1;
                  ColorFound:=true;
               end;
            end;
            if (x+5<=MyAMsg^.IntuiWindow3^.Width-19) and (y+17<=MyAMsg^.IntuiWindow3^.Height-3) then begin
               SetAPen(MyAMsg^.IntuiWindow3^.RPort,Col2Col[MyColor]);
               WritePixel(MyAMsg^.IntuiWindow3^.RPort,x+5,y+17);
            end;
         end;
      end;
   end;
end;



procedure ANIM8_32;

type LArr16=array [1..16] of long;

var DataAddr                    :^LArr16;
var i,j                         :long;
var Addr,PlaneAddr,ColumnCtr,
    ColumnTarget                :long;
var OpCode,Data1,Data2          :^long;
var OpCtr                       :long;
var NewVert                     :boolean;

begin
   DataAddr:=ptr(DeltaMemA);
   ColumnTarget:=AnimBMHD.Width div 8;
   for i:=1 to 16 do if DataAddr^[i]<>0 then begin
      if i>AnimBMHD.Depth then exit;
      Addr:=DataAddr^[i]+DeltaMemA;
      ColumnCtr:=-4;
      OpCtr:=0;
      PlaneAddr:=long(MyAnimBitMap[AnimAScr].Planes[pred(i)]);
      if PlaneAddr=0 then exit;
      while ColumnCtr<ColumnTarget do begin

         OpCode:=ptr(Addr); Addr:=Addr+4;
         if OpCtr=0 then NewVert:=true;

         if NewVert then begin
            ColumnCtr:=ColumnCtr+4;
            PlaneAddr:=long(MyAnimBitMap[AnimAScr].Planes[pred(i)])+ColumnCtr;
            OpCtr:=OpCode^;
            if OpCtr<>0 then begin
               OpCtr:=OpCode^;
               NewVert:=false;
               OpCode:=ptr(Addr); Addr:=Addr+4;
            end;
         end;

         if (ColumnCtr<ColumnTarget) and not NewVert then begin
            if OpCode^=0 then begin
               OpCode:=ptr(Addr); Addr:=Addr+4;
               Data1:=ptr(Addr);  Addr:=Addr+4;
               for j:=1 to OpCode^ do begin
                  Data2:=ptr(PlaneAddr); PlaneAddr:=PlaneAddr+MyAnimBitMap[AnimAScr].BytesPerRow;
                  Data2^:=Data1^;
               end;
               OpCtr:=OpCtr-1;
            end else if (OpCode^ and $80000000=0) then begin
               PlaneAddr:=PlaneAddr+(MyAnimBitMap[AnimAScr].BytesPerRow*OpCode^);
               OpCtr:=OpCtr-1;
            end else if (OpCode^ and $80000000=$80000000) then begin
               OpCode^:=OpCode^ and $7FFFFFFF;
               for j:=1 to OpCode^ do begin
                  Data1:=ptr(Addr);      Addr:=Addr+4;
                  Data2:=ptr(PlaneAddr); PlaneAddr:=PlaneAddr+MyAnimBitMap[AnimAScr].BytesPerRow;
                  Data2^:=Data1^;
               end;
               OpCtr:=OpCtr-1;
            end;
         end;
      end;
   end;
end;



procedure ANIM8_16;

type LArr16=array [1..16] of long;

var DataAddr                    :^LArr16;
var i,j                         :integer;
var Addr,PlaneAddr,ColumnCtr,
    ColumnTarget                :long;
var OpCode,Data1,Data2          :^word;
var OpCtr                       :word;
var NewVert                     :boolean;

begin
   DataAddr:=ptr(DeltaMemA);
   ColumnTarget:=AnimBMHD.Width div 8;
   for i:=1 to 16 do if DataAddr^[i]<>0 then begin
      if i>AnimBMHD.Depth then exit;
      Addr:=DataAddr^[i]+DeltaMemA;
      ColumnCtr:=-2;
      OpCtr:=0;
      PlaneAddr:=long(MyAnimBitMap[AnimAScr].Planes[pred(i)]);
      if PlaneAddr=0 then exit;
      while ColumnCtr<ColumnTarget do begin

         OpCode:=ptr(Addr); Addr:=Addr+2;
         if OpCtr=0 then NewVert:=true;

         if NewVert then begin
            ColumnCtr:=ColumnCtr+2;
            PlaneAddr:=long(MyAnimBitMap[AnimAScr].Planes[pred(i)])+ColumnCtr;
            OpCtr:=OpCode^;
            if OpCtr<>0 then begin
               OpCtr:=OpCode^;
               NewVert:=false;
               OpCode:=ptr(Addr); Addr:=Addr+2;
            end;
         end;

         if (ColumnCtr<ColumnTarget) and not NewVert then begin
            if OpCode^=0 then begin
               OpCode:=ptr(Addr); Addr:=Addr+2;
               Data1:=ptr(Addr);  Addr:=Addr+2;
               for j:=1 to OpCode^ do begin
                  Data2:=ptr(PlaneAddr); PlaneAddr:=PlaneAddr+MyAnimBitMap[AnimAScr].BytesPerRow;
                  Data2^:=Data1^;
               end;
               OpCtr:=OpCtr-1;
            end else if (OpCode^ and $8000=0) then begin
               PlaneAddr:=PlaneAddr+(MyAnimBitMap[AnimAScr].BytesPerRow*OpCode^);
               OpCtr:=OpCtr-1;
            end else if (OpCode^ and $8000=$8000) then begin
               OpCode^:=OpCode^ and $7FFF;
               for j:=1 to OpCode^ do begin
                  Data1:=ptr(Addr);      Addr:=Addr+2;
                  Data2:=ptr(PlaneAddr); PlaneAddr:=PlaneAddr+MyAnimBitMap[AnimAScr].BytesPerRow;
                  Data2^:=Data1^;
               end;
               OpCtr:=OpCtr-1;
            end;
         end;
      end;
   end;
end;



procedure ANIM7_32;

type LArr16=array [1..16] of long;

var DataAddr                    :^LArr16;
var i,j                         :integer;
var OpAddr,DAddr,PlaneAddr,
    ColumnCtr,ColumnTarget      :long;
var DataL1,DataL2               :^long;
var OpCode                      :^byte;
var OpCtr                       :byte;
var NewVert                     :boolean;

begin
   DataAddr:=ptr(DeltaMemA);
   ColumnTarget:=AnimBMHD.Width div 8;
   for i:=1 to 8 do if DataAddr^[i]<>0 then begin
      if i>AnimBMHD.Depth then exit;
      OpAddr:=DataAddr^[i]+DeltaMemA;
      DAddr:=DataAddr^[i+8]+DeltaMemA;
      ColumnCtr:=-4;
      OpCtr:=0;
      PlaneAddr:=long(MyAnimBitMap[AnimAScr].Planes[pred(i)]);
      if PlaneAddr=0 then exit;
      while ColumnCtr<ColumnTarget do begin

         OpCode:=ptr(OpAddr); OpAddr:=OpAddr+1;
         if OpCtr=0 then NewVert:=true;

         if NewVert then begin
            ColumnCtr:=ColumnCtr+4;
            PlaneAddr:=long(MyAnimBitMap[AnimAScr].Planes[pred(i)])+ColumnCtr;
            OpCtr:=OpCode^;
            if OpCtr<>0 then begin
               OpCtr:=OpCode^;
               NewVert:=false;
               OpCode:=ptr(OpAddr); OpAddr:=OpAddr+1;
            end;
         end;

         if (ColumnCtr<ColumnTarget) and not NewVert then begin
            if OpCode^=0 then begin
               OpCode:=ptr(OpAddr); OpAddr:=OpAddr+1;
               DataL1:=ptr(DAddr);  DAddr:=DAddr+4;
               for j:=1 to OpCode^ do begin
                  DataL2:=ptr(PlaneAddr); PlaneAddr:=PlaneAddr+MyAnimBitMap[AnimAScr].BytesPerRow;
                  DataL2^:=DataL1^;
               end;
               OpCtr:=OpCtr-1;
            end else if (OpCode^ and $80=0) then begin
               PlaneAddr:=PlaneAddr+(MyAnimBitMap[AnimAScr].BytesPerRow*OpCode^);
               OpCtr:=OpCtr-1;
            end else if (OpCode^ and $80=$80) then begin
               OpCode^:=OpCode^ and $7F;
               for j:=1 to OpCode^ do begin
                  DataL1:=ptr(DAddr);     DAddr:=DAddr+4;
                  DataL2:=ptr(PlaneAddr); PlaneAddr:=PlaneAddr+MyAnimBitMap[AnimAScr].BytesPerRow;
                  DataL2^:=DataL1^;
               end;
               OpCtr:=OpCtr-1;
            end;
         end;
      end;
   end;
end;



procedure ANIM7_16;

type LArr16=array [1..16] of long;

var DataAddr                    :^LArr16;
var i,j                         :integer;
var OpAddr,DAddr,PlaneAddr,
    ColumnCtr,ColumnTarget      :long;
var DataW1,DataW2               :^word;
var OpCode                      :^byte;
var OpCtr                       :byte;
var NewVert                     :boolean;

begin
   DataAddr:=ptr(DeltaMemA);
   ColumnTarget:=AnimBMHD.Width div 8;
   for i:=1 to 8 do if DataAddr^[i]<>0 then begin
      if i>AnimBMHD.Depth then exit;
      OpAddr:=DataAddr^[i]+DeltaMemA;
      DAddr:=DataAddr^[i+8]+DeltaMemA;
      ColumnCtr:=-2;
      OpCtr:=0;
      PlaneAddr:=long(MyAnimBitMap[AnimAScr].Planes[pred(i)]);
      if PlaneAddr=0 then exit;
      while ColumnCtr<ColumnTarget do begin

         OpCode:=ptr(OpAddr); OpAddr:=OpAddr+1;
         if OpCtr=0 then NewVert:=true;

         if NewVert then begin
            ColumnCtr:=ColumnCtr+2;
            PlaneAddr:=long(MyAnimBitMap[AnimAScr].Planes[pred(i)])+ColumnCtr;
            OpCtr:=OpCode^;
            if OpCtr<>0 then begin
               OpCtr:=OpCode^;
               NewVert:=false;
               OpCode:=ptr(OpAddr); OpAddr:=OpAddr+1;
            end;
         end;

         if (ColumnCtr<ColumnTarget) and not NewVert then begin
            if OpCode^=0 then begin
               OpCode:=ptr(OpAddr); OpAddr:=OpAddr+1;
               DataW1:=ptr(DAddr);  DAddr:=DAddr+2;
               for j:=1 to OpCode^ do begin
                  DataW2:=ptr(PlaneAddr); PlaneAddr:=PlaneAddr+MyAnimBitMap[AnimAScr].BytesPerRow;
                  DataW2^:=DataW1^;
               end;
               OpCtr:=OpCtr-1;
            end else if (OpCode^ and $80=0) then begin
               PlaneAddr:=PlaneAddr+(MyAnimBitMap[AnimAScr].BytesPerRow*OpCode^);
               OpCtr:=OpCtr-1;
            end else if (OpCode^ and $80=$80) then begin
               OpCode^:=OpCode^ and $7F;
               for j:=1 to OpCode^ do begin
                  DataW1:=ptr(DAddr);     DAddr:=DAddr+2;
                  DataW2:=ptr(PlaneAddr); PlaneAddr:=PlaneAddr+MyAnimBitMap[AnimAScr].BytesPerRow;
                  DataW2^:=DataW1^;
               end;
               OpCtr:=OpCtr-1;
            end;
         end;
      end;
   end;
end;



procedure ANIM5;

type LArr16=array [1..16] of long;

var DataAddr                    :^LArr16;
var i,j                         :integer;
var Addr,PlaneAddr,ColumnCtr,
    ColumnTarget                :long;
var OpCode,Data1,Data2          :^byte;
var OpCtr                       :byte;
var NewVert                     :boolean;

begin
   DataAddr:=ptr(DeltaMemA);
   ColumnTarget:=AnimBMHD.Width div 8;
   for i:=1 to 16 do if DataAddr^[i]<>0 then begin
      if i>AnimBMHD.Depth then exit;
      Addr:=DataAddr^[i]+DeltaMemA;
      ColumnCtr:=-1;
      OpCtr:=0;
      PlaneAddr:=long(MyAnimBitMap[AnimAScr].Planes[pred(i)]);
      if PlaneAddr=0 then exit;
      while ColumnCtr<ColumnTarget do begin

         OpCode:=ptr(Addr); Addr:=Addr+1;
         if OpCtr=0 then NewVert:=true;

         if NewVert then begin
            ColumnCtr:=ColumnCtr+1;
            PlaneAddr:=long(MyAnimBitMap[AnimAScr].Planes[pred(i)])+ColumnCtr;
            OpCtr:=OpCode^;
            if OpCtr<>0 then begin
               OpCtr:=OpCode^;
               NewVert:=false;
               OpCode:=ptr(Addr); Addr:=Addr+1;
            end;
         end;

         if (ColumnCtr<ColumnTarget) and not NewVert then begin
            if OpCode^=0 then begin
               OpCode:=ptr(Addr); Addr:=Addr+1;
               Data1:=ptr(Addr);  Addr:=Addr+1;
               for j:=1 to OpCode^ do begin
                  Data2:=ptr(PlaneAddr); PlaneAddr:=PlaneAddr+MyAnimBitMap[AnimAScr].BytesPerRow;
                  Data2^:=Data1^;
               end;
               OpCtr:=OpCtr-1;
            end else if (OpCode^ and $80=0) then begin
               PlaneAddr:=PlaneAddr+(MyAnimBitMap[AnimAScr].BytesPerRow*OpCode^);
               OpCtr:=OpCtr-1;
            end else if (OpCode^ and $80=$80) then begin
               OpCode^:=OpCode^ and $7F;
               for j:=1 to OpCode^ do begin
                  Data1:=ptr(Addr);      Addr:=Addr+1;
                  Data2:=ptr(PlaneAddr); PlaneAddr:=PlaneAddr+MyAnimBitMap[AnimAScr].BytesPerRow;
                  Data2^:=Data1^;
               end;
               OpCtr:=OpCtr-1;
            end;
         end;
      end;
   end;
end;



Procedure LiesZeile(Adr:Long; Plane :byte);

Var Count,Size          :Long;
var i,j                 :integer;
var Head,Body,Mem       :^Short;

Begin
   If Not ErrorFlag Then Begin
      Size:=(AnimBMHD.Width+7) div 8;
      If not AnimBMHD.Kompr Then begin
         CopyMemQuick(BodyAddr,Adr,Size);
         BodyAddr:=BodyAddr+Size;
      End Else Begin
         i:=0;
         While (i<Size) and not ErrorFlag Do Begin
            Head:=ptr(BodyAddr); BodyAddr:=BodyAddr+1;
            If Head^>=0 Then Begin
               CopyMem(BodyAddr,Adr+i,Head^+1);
               BodyAddr:=BodyAddr+Head^+1;
               i:=i+Head^+1
            End Else Begin
               Body:=ptr(BodyAddr); BodyAddr:=BodyAddr+1;
               For j:=1 to 1-Head^ Do Begin
                  Mem:=Ptr(Adr+i);
                  Mem^:=Body^;
                  i:=i+1
               End
            End
         End
      End;
   End
End;



procedure SETNEWWINDOWDIMENSIONS;

var AnimV,WinV          :long;
var NewWidth,NewHeight  :word;

begin
   AnimV:=round(10*(AnimBMHD.SWidth/AnimBMHD.SHeight));
   WinV:=round(10*((MyAMsg^.IntuiWindow3^.Width-24)/(MyAMsg^.IntuiWindow3^.Height-20)));
   if AnimV=WinV then exit;
   if AnimV>WinV then begin
      if MyAMsg^.IntuiWindow3^.Height>148 then begin
         MyAMsg^.IntuiWindow3^.Height:=round(((MyAMsg^.IntuiWindow3^.Width-24)/(AnimV/10))+20);
         if MyAMsg^.IntuiWindow3^.Height<148 then MyAMsg^.IntuiWindow3^.Height:=148;
         SETNEWWINDOWDIMENSIONS;
      end else if MyAMsg^.IntuiWindow3^.Width<344 then begin
         MyAMsg^.IntuiWindow3^.Width:=round(((MyAMsg^.IntuiWindow3^.Height-20)*(AnimV/10))+24);
         if MyAMsg^.IntuiWindow3^.Width>344 then MyAMsg^.IntuiWindow3^.Width:=344;
         SETNEWWINDOWDIMENSIONS;
      end;
   end else begin
      if MyAMsg^.IntuiWindow3^.Width>184 then begin
         MyAMsg^.IntuiWindow3^.Width:=round(((MyAMsg^.IntuiWindow3^.Height-20)*(AnimV/10))+24);
         if MyAMsg^.IntuiWindow3^.Width<184 then MyAMsg^.IntuiWindow3^.Width:=184;
         SETNEWWINDOWDIMENSIONS;
      end else if MyAMsg^.IntuiWindow3^.Height<276 then begin
         MyAMsg^.IntuiWindow3^.Height:=round(((MyAMsg^.IntuiWindow3^.Width-24)/(AnimV/10))+20);
         if MyAMsg^.IntuiWindow3^.Height>276 then MyAMsg^.IntuiWindow3^.Height:=276;
         SETNEWWINDOWDIMENSIONS;
      end;
   end;
end;



procedure SETERRORGAD(ETxt :str);

begin
   if MyAMsg^.IntuiWindow3^.FirstGadget=^MyAMsg^.E3Knopf then RemoveGadgets(MyAMsg^.IntuiWindow3,^MyAMsg^.E3Knopf);
   MyAMsg^.E3Knopf^:=Gadget(NIL,MyAMsg^.IntuiWindow3^.Width div 2-71,75,128,16,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,^MyAMsg^.GImg,NIL,^E3KnopfTx,0,NIL,1,0);
   E3KnopfTx:=IntuiText(2,1,0,45,2,^MyAMsg^.MyScreen^.Font,'- ??? -',NIL);
   AddGadget(MyAMsg^.IntuiWindow3,^MyAMsg^.E3Knopf,NIL);
   RefreshGadgets(MyAMsg^.IntuiWindow3^.FirstGadget,MyAMsg^.IntuiWindow3,NIL);
   MyAMsg^.AnimErrorTxt:=ETxt;
end;



procedure CACHEFRAME(FrameNum :long);

procedure DISKFULL;

begin
{   l:=TASKREQUEST(Prefs.VMemStr,PText[191],NIL,PText[220],NIL);}
   DosClose(CacheFHandle);
   l:=DeleteFile(s);
   MyAMsg^.TDeviceValid^:=false;
end;


begin
   if not (FrameNum in [StartFrame..EndFrame]) then exit;
   if MyAMsg^.UseVMem and MyAMsg^.FrameCache and MyAMsg^.TDeviceValid^ then begin
      s:=intstr(FrameNum); while length(s)<5 do s:='0'+s;
      s:=MyAMsg^.VMemStr+s;
      CacheFHandle:=DosOpen(s,MODE_NEWFILE);
      if CacheFHandle<>0 then begin
         l:=DosWrite(CacheFHandle,^ColorR[0],256);
         l:=l+DosWrite(CacheFHandle,^ColorG[0],256);
         l:=l+DosWrite(CacheFHandle,^ColorB[0],256);
         if l<768 then begin
            DISKFULL;
            exit;
         end;
         l:=DosWrite(CacheFHandle,ptr(AnimBMemA[AnimAScr]),AnimBMemL);
         if l<AnimBMemL then begin
            DISKFULL;
            exit;
         end;
         DosClose(CacheFHandle);
      end;
   end;
end;



function DISPLAYCACHE(FrameNum :long):boolean;

var AnimAScr    :byte;

begin
   DISPLAYCACHE:=false;
   if odd(FrameNum) then AnimAScr:=1 else AnimAScr:=2;
   s:=intstr(FrameNum); while length(s)<5 do s:='0'+s;
   s:=MyAMsg^.VMemStr+s;
   CacheFHandle:=DosOpen(s,MODE_OLDFILE);
   if CacheFHandle<>0 then begin
      l:=DosRead(CacheFHandle,^ColorR[0],256);
      l:=DosRead(CacheFHandle,^ColorG[0],256);
      l:=DosRead(CacheFHandle,^ColorB[0],256);
      l:=DosRead(CacheFHandle,ptr(AnimBMemA[AnimAScr]),AnimBMemL);
      DosClose(CacheFHandle);
   end else exit;
   DISPLAYCACHE:=true;
end;



procedure DOANIM;

begin
writeln('->');
   ErrorFlag:=false; HeadFlag:=true; FirstFrame:=false; DeltaMemA:=0;
   if MyAMsg^.IntuiWindow3^.FirstGadget=^MyAMsg^.E3Knopf then RemoveGadgets(MyAMsg^.IntuiWindow3,^MyAMsg^.E3Knopf);
   if ((MyAMsg^.ShowPic>-1) and (MyAMsg^.UseVMem) and (MyAMsg^.FrameCache)) then begin
      if (MyAMsg^.AnimPicPos>=MyAMsg^.ShowPic) then if DISPLAYCACHE(MyAMsg^.ShowPic) then begin
         SetAPen(MyAMsg^.IntuiWindow3^.RPort,0);
         RectFill(MyAMsg^.IntuiWindow3^.RPort,5,17,MyAMsg^.IntuiWindow3^.Width-19,MyAMsg^.IntuiWindow3^.Height-3);
         if odd(MyAMsg^.ShowPic) then SCALEDOWNIMAGE(2) else SCALEDOWNIMAGE(1);
         MyAMsg^.CachePicPos^:=MyAMsg^.ShowPic;
         exit;
      end;
   end;
   SetAPen(MyAMsg^.IntuiWindow3^.RPort,0);
   RectFill(MyAMsg^.IntuiWindow3^.RPort,5,17,MyAMsg^.IntuiWindow3^.Width-19,MyAMsg^.IntuiWindow3^.Height-3);
   if MyAMsg^.ShowPic=-1 then begin
      if (MyAMsg^.AnimHandle^=0) or (AnimBMemA[1]=0) or (MyAMsg^.IntuiWindow3=NIL) then exit;
      SCALEDOWNIMAGE(AnimAScr);
writeln('A');
      exit;
   end;
writeln('AnimHandle: ',MyAMsg^.AnimHandle^);
   if MyAMsg^.AnimHandle^=0 then begin
      HAMAnim:=false;
      for i:=1 to 2 do if AnimBMemA[i]<>0 then begin
         FreeMem(AnimBMemA[i],AnimBMemL);
         AnimBMemA[i]:=0;
      end;
writeln('AnimHandle: ',MyAMsg^.AnimHandle^);
writeln(MyAMsg^.AnimPath);
      MyAMsg^.AnimHandle^:=DosOpen(MyAMsg^.AnimPath,MODE_OLDFILE);
writeln('AnimHandle: ',MyAMsg^.AnimHandle^);
      If MyAMsg^.AnimHandle^=0 Then begin
{         SETERRORGAD(PText[189]);}
writeln('B');
         exit;
      End;
writeln('*2,5');
   end;
writeln('*3');
   if (MyAMsg^.ShowPic=1) or (MyAMsg^.ShowPic<MyAMsg^.AnimPicPos) then begin
      ErrorFlag:=false; HeadFlag:=false;
      FirstFrame:=true; Frames:=0;
      DeltaMemA:=0;
      l:=DosSeek(MyAMsg^.AnimHandle^,0,OFFSET_BEGINNING);
writeln('AnimHandle: ',MyAMsg^.AnimHandle^);
      READCHUNK;
writeln('AnimHandle: ',MyAMsg^.AnimHandle^);
writeln(ChunkName);
      If ChunkName<>'FORM' Then Begin
{         SETERRORGAD(PText[186]);}
writeln('C');
writeln('AnimHandle: ',MyAMsg^.AnimHandle^);
         DosClose(MyAMsg^.AnimHandle^); MyAMsg^.AnimHandle^:=0;
writeln('AnimHandle: ',MyAMsg^.AnimHandle^);
         MyAMsg^.AnimPath:='';
writeln('C-');
         exit;
      end;
      l:=DosRead(MyAMsg^.AnimHandle^,^ChunkName,4);
      If ChunkName<>'ANIM' Then Begin
{         SETERRORGAD(PText[185]);}
writeln('D');
         DosClose(MyAMsg^.AnimHandle^); MyAMsg^.AnimHandle^:=0;
         MyAMsg^.AnimPath:='';
writeln('D-');
         exit;
      end;
   end else Frames:=MyAMsg^.AnimPicPos;
writeln('*4');
   if (MyAMsg^.ShowPic>MyAMsg^.AnimPicPos) and MyAMsg^.UseVMem
   and MyAMsg^.FrameCache then begin
      if DISPLAYCACHE(MyAMsg^.AnimPicPos-1) then begin end;
      if DISPLAYCACHE(MyAMsg^.AnimPicPos) then begin end
   end;
writeln('*5');
   READCHUNK;
   DataFound:=false;
writeln('*6');
   while (not Errorflag) and (ChunkLength>0) and (not DataFound) do begin
      ChunkPos:=DosSeek(MyAMsg^.AnimHandle^,0,OFFSET_CURRENT);
      if odd(ChunkLength) then ChunkPos:=ChunkPos+1;
      if ChunkName='FORM' then begin
         l:=DosSeek(MyAMsg^.AnimHandle^,4,OFFSET_CURRENT);
         Frames:=Frames+1;
      end else if ChunkName='DLTA' then begin
         if AnimBMemA[AnimAScr]=0 then begin
{            SETERRORGAD(PText[183]);}
            DosClose(MyAMsg^.AnimHandle^); MyAMsg^.AnimHandle^:=0;
writeln('E');
            exit;
         end;
         DeltaMemL:=ChunkLength;
         DeltaMemA:=AllocMem(DeltaMemL,0);
         if DeltaMemA=0 then begin
{            SETERRORGAD(PText[183]);}
            DosClose(MyAMsg^.AnimHandle^); MyAMsg^.AnimHandle^:=0;
writeln('F');
            exit;
         end;
         l:=DosRead(MyAMsg^.AnimHandle^,ptr(DeltaMemA),DeltaMemL);
         DeltaFlags:=ANHD.Operation;
         if ANHD.Operation in [7,8] then if (ANHD.Bits and $1=$1)
          then DeltaFlags:=DeltaFlags or $80;
         case DeltaFlags of
             $5: ANIM5;
             $7: ANIM7_16;
            $87: ANIM7_32;
             $8: ANIM8_16;
            $88: ANIM8_32;
            otherwise begin
{               s:=PText[182]+' (ANIM '+intstr(DeltaFlags and not $80)+')';
               SETERRORGAD(s);}
               DosClose(MyAMsg^.AnimHandle^); MyAMsg^.AnimHandle^:=0;
               MyAMsg^.AnimPath:='';
writeln('G');
               exit;
            end;
         end;
         CACHEFRAME(Frames);
         AnimAScr:=3-AnimAScr;
         FreeMem(DeltaMemA,DeltaMemL);
         DeltaMemA:=0;
         if Frames>=MyAMsg^.ShowPic then DataFound:=true;
      end else if ChunkName='ANHD' then
         l:=DosRead(MyAMsg^.Animhandle^,^ANHD,SizeOf(AnimHeader))
      else If ChunkName='BMHD' Then Begin
         l:=DosRead(MyAMsg^.Animhandle^,^AnimBMHD,SizeOf(BitMapHeader));
         With AnimBMHD Do if AnimBMemA[1]=0 then begin
            SWidth:=Width;
            SHeight:=Height;
            SETNEWWINDOWDIMENSIONS;
            MoveWindow(MyAMsg^.IntuiWindow3,0,0);
            RefreshWindowFrame(MyAMsg^.IntuiWindow3);
            SetAPen(MyAMsg^.IntuiWindow3^.RPort,0);
            RectFill(MyAMsg^.IntuiWindow3^.RPort,5,17,MyAMsg^.IntuiWindow3^.Width-19,MyAMsg^.IntuiWindow3^.Height-3);
         end;
         HeadFlag:=true
      End Else If ChunkName='CMAP' Then Begin
         ColCnt:=ChunkLength div 3-1;
         For i:=0 to ColCnt Do Begin
            l:=DosRead(MyAMsg^.AnimHandle^,^RGB,3);
            If l<>3 Then begin
               DosClose(MyAMsg^.AnimHandle^);
               MyAMsg^.AnimHandle^:=0;
writeln('H');
               exit;
            end;
            ColorR[i]:=RGB.r; ColorG[i]:=RGB.g; ColorB[i]:=RGB.b;
         End;
      end else if ChunkName='CAMG' then begin
         l:=DosRead(MyAMsg^.AnimHandle^,^m,4);
         if m and $0800=$0800 then HAMAnim:=true else HAMAnim:=false;
      end else If ChunkName='BODY' then begin
         l:=((AnimBMHD.SWidth*AnimBMHD.SHeight) div 8)*AnimBMHD.Depth;
         if (l<>AnimBMemL) then for i:=1 to 2 do if (AnimBMemA[i]<>0) then FreeMem(AnimBMemA[i],AnimBMemL);
         AnimBMemL:=l;
         for i:=1 to 2 do begin
            AnimBMemA[i]:=AllocMem(AnimBMemL,MEMF_CLEAR);
            if AnimBMemA[i]=0 then begin
{               SETERRORGAD(PText[183]);}
               DosClose(MyAMsg^.AnimHandle^); MyAMsg^.AnimHandle^:=0;
writeln('I');
               exit;
            end;
            l:=(AnimBMHD.SWidth*AnimBMHD.SHeight) div 8;
            MyLArr:=LArr8(NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL);
            for j:=1 to AnimBMHD.Depth do MyLArr[j]:=ptr(AnimBMemA[i]+(l*pred(j)));
            MyAnimBitMap[i]:=BitMap(AnimBMHD.SWidth div 8,AnimBMHD.SHeight,0,AnimBMHD.Depth,0,MyLArr);
            MyAnimRastPort[i]:=MyAMsg^.MyScreen^.RastPort;
            MyAnimRastPort[i].BitMap:=^MyAnimBitMap[i];
         end;
         AnimAScr:=1;
         DeltaMemA:=AllocMem(ChunkLength,0);
         if DeltaMemA=0 then begin
{            SETERRORGAD(PText[182]);}
            DosClose(MyAMsg^.AnimHandle^); MyAMsg^.AnimHandle^:=0;
writeln('J');
            exit;
         end;
         l:=DosRead(MyAMsg^.AnimHandle^,ptr(DeltaMemA),ChunkLength);
         if l<ChunkLength then begin
            DosClose(MyAMsg^.AnimHandle^); MyAMsg^.AnimHandle^:=0;
writeln('K');
            exit;
         end;
         BodyAddr:=DeltaMemA;
         FirstFrame:=false;
         If not HeadFlag Then begin
            DosClose(MyAMsg^.AnimHandle^); MyAMsg^.AnimHandle^:=0;
writeln('L');
            exit;
         end;
         LineSize:=(AnimBMHD.SWidth+7) div 8;
         For Zeile:=0 to AnimBMHD.Height-1 Do
          For Plane:=0 to pred(AnimBMHD.Depth) Do
           LiesZeile(Long(MyAnimBitMap[AnimAScr].Planes[Plane])+Zeile*MyAnimBitMap[AnimAScr].BytesPerRow,Plane);
         FreeMem(DeltaMemA,ChunkLength);
         DeltaMemA:=0;
         CopyMemQuick(AnimBMemA[AnimAscr],AnimBMemA[3-AnimAScr],AnimBMemL);
         CACHEFRAME(Frames);
         AnimAScr:=3-AnimAScr;
         if Frames>=MyAMsg^.ShowPic then DataFound:=true;
      End;
      if ChunkName<>'FORM' then l:=DosSeek(MyAMsg^.AnimHandle^,ChunkPos+ChunkLength,OFFSET_BEGINNING);
      if not Errorflag and (ChunkLength>0) and (not DataFound) then READCHUNK;
   End;
   if ((Frames<MyAMsg^.ShowPic) and (ErrorFlag or not HeadFlag)) or (AnimBMemA[1]=0) then begin
{      SETERRORGAD(PText[192]);}
writeln('M');
      exit;
   end else SCALEDOWNIMAGE(AnimAScr);
   MyAMsg^.AnimPicPos:=MyAMsg^.ShowPic;
   MyAMsg^.CachePicPos^:=MyAMsg^.ShowPic;
writeln('N');
end;



Begin {*** ANIMPLAY ***}
   OpenLib(DosBase,'dos.library',39);
   OpenLib(IntBase,'intuition.library',39);
   OpenLib(GfxBase,'graphics.library',39);
   CLEARPORT(PORT_ANIM);
   AnimPort:=CreatePort(PORT_ANIM,0);

   for i:=1 to 2 do AnimBMemA[i]:=0; Leave:=FALSE;

   if AnimPort<>NIL then repeat
      repeat
         MyAMsg:=p_AnimMsg(WaitPort(AnimPort));
         MyAMsg:=p_AnimMsg(GetMsg(AnimPort));
      until MyAMsg<>NIL;
writeln(MyAMsg^.AnimHandle^);
      if MyAMsg^.ShowPic<=-10 then Leave:=TRUE else if (MyAMsg^.ShowPic>=-1) then DOANIM;
   until Leave;

   for i:=1 to 2 do if (AnimBMemA[i]<>0) then FreeMem(AnimBMemA[i],AnimBMemL);
   CLEARPORT(PORT_ANIM);
   CloseLib(DosBase);
   CloseLib(GfxBase);
   CloseLib(IntBase);
writeln('Gone!!!');
end;


