Program Effectmod;

USES Intuition,Graphics,ExecIO;

type BPTR=long;

var DWindow                             :^Window;

var XGadget                             :^Gadget;
var Schieber,Textgad                    :array [1..2] of Gadget;
var SImage                              :array [1..2] of Image;
var SchieberInfo                        :array [1..2] of PropInfo;
var s                                   :string[5];

var IMsg                                :^IntuiMessage;
var Addr0                               :long;
var Data0                               :^long;
var RawCode,GadCode,ChBit,ChID          :byte;
var i,j                                 :integer;
var l,BeginOffset,EndOffset             :long;
var Valid                               :boolean;

{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
       "EffIncl.mod"}



procedure DOTONE(SAddr :long; Step :byte);

var Factor,Divider      :real;
var Addr1               :long;
var Data1,Data2         :^long;

begin
   if SAddr=0 then exit else with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=-1 then begin
         Valid:=false;
         exit;
      end;

      if (ActWaveOp^.Operator[1]<>0) and (Step<>6) then begin
         if ActWaveOp^.Operator[1]<0 then Factor:=-1/(21+ActWaveOp^.Operator[1]*2) else Factor:=ActWaveOp^.Operator[1];
         Addr1:=SAddr+BeginOffset;
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data2:=Ptr(Addr1);
            l:=round( ((Data1^/2)-(Data2^/2)) * Factor);
            Data1^:=Data1^+l;
         until Addr1>=SAddr+EndOffset;
      end;

      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=-1 then begin
         Valid:=false;
         exit;
      end;

      if ActWaveOp^.Operator[2]<>0 then begin
         if ActWaveOp^.Operator[2]<0 then Factor:=-1/(21+ActWaveOp^.Operator[2]*2) else Factor:=ActWaveOp^.Operator[2];
         Addr1:=SAddr+BeginOffset;
         Divider:=abs(Factor)+1;
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            l:=(Data1^+l) div 2;
            Data1^:=round((Data1^+l*Factor)/Divider);
         until Addr1>=SAddr+EndOffset;
      end;
   end;
end;



procedure DEFINETONE;


procedure WRITEVALUES(Gad :byte);


begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      SetAPen(DWindow^.RPort,0);
      RectFill(DWindow^.RPort,267+pred(Gad)*325,79,298+pred(Gad)*325,91);
      l:=SchieberInfo[Gad].HorizPot div 3121;
      Operator[Gad]:=l-10;
      s:=intstr(Operator[Gad]);
      WRITE(Gad*320-33,80,2,3,DWindow^,s);
   end;
end;



begin
   with MyWTStdMsg^ do begin
      with ActWaveOp^ do if Operator[1]=-1 then begin
         Operator[1]:=0;
         Operator[2]:=0;
         Channels:=UsedChannels;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition TONE (by Cybertrace)','','','','',110,0,3,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      WTMsgPrc^:=MsgPrc(WTM_SETCHANNELGADS,'','','','','',ActiveMode,ActWaveOp^.Channels,0,0,0,NIL);
      MESSAGEHANDLE;
      for i:=1 to 2 do begin
         SImage[i]:=WTImg^.KnobImg^;
         Schieber[i]:=Gadget(NIL,10+pred(i)*325,78,240,15,GADGIMAGE,$83,PROPGADGET,
                             ^SImage[i],NIL,Nil,0,^SchieberInfo[i],i+8,0);
         MAKEBORDER(DWindow^,265+pred(i)*320,78,305+pred(i)*320,92,POSITIVE);
      end;
      SchieberInfo[1]:=Propinfo(FREEHORIZ,(ActWaveOp^.Operator[1]+10)*3121,0,$FFFF div 21,0,0,0,0,0,0,0);
      SchieberInfo[2]:=Propinfo(FREEHORIZ,(ActWaveOp^.Operator[2]+10)*3121,0,$FFFF div 21,0,0,0,0,0,0,0);
      WRITE(125,94,2,0,DWindow^,'Treble');
      WRITE(455,94,2,0,DWindow^,'Bass');
      for i:=1 to 2 do AddGadget(DWindow,^Schieber[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      WRITEVALUES(1);
      WRITEVALUES(2);
      repeat
         RawCode:=0; GadCode:=0;
         IMsg:=Get_Msg(DWindow^.UserPort);
         If IMsg<>Nil Then begin
            if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
               XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
            end;
            if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
            Reply_Msg(IMsg);
         end else delay(1);

         if (GadCode=9) or not (Schieber[1].Flags and SELECTED=0) then WRITEVALUES(1);
         if (GadCode=10) or not (Schieber[2].Flags and SELECTED=0) then WRITEVALUES(2);

      until (Gadcode in [1..2]) or (RawCode in [68..69]);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETCHANNELGADS,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      ActWaveOp^.Channels:=WTMsgPrc^.PRC_Long1;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINETONE
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'Tone,  by CyberTrace','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            WTMsgPrc^:=MsgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            Valid:=true;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if Valid and not (ActWaveOp^.Channels and ChBit=0) then
               DOTONE(MemA24[ChID],ChID);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION; MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.

