Program Effectmod;

USES Intuition,Graphics,ExecIO;

type BPTR=long;


var DWindow                             :^Window;
var XGadget                             :^Gadget;
var Schieber,Textgad                    :array [1..2] of Gadget;
var SImage                              :array [1..2] of Image;
var SchieberInfo                        :array [1..2] of PropInfo;
var TextInfo                            :array [1..2] of StringInfo;
var Buffer,UndoBuffer                   :array [1..2] of string[20];

var IMsg                                :^IntuiMessage;
var BeginOffset,EndOffset               :long;
var RawCode,GadCode,ChBit,ChID          :byte;
var i,j                                 :integer;
var l                                   :long;
var Valid                               :boolean;

{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
"EffIncl.mod","Schieber.mod"}



procedure DORANGE(SAddr :long);

var DataX,RangeCtr,Addr1:long;
var Data1               :^long;
var Factor1,FactorX     :real;

begin
   if SAddr=0 then exit;
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      FactorX:=ActWaveOp^.Operator[1]/100;
      Factor1:=1-FactorX;
      Addr1:=SAddr+BeginOffset;
      repeat
         repeat
            RangeCtr:=ActWaveOp^.Operator[2];
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            DataX:=Data1^;
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data1^:=round(Data1^*Factor1+DataX*FactorX);
               RangeCtr:=RangeCtr-1;
               j:=j+1;
            until (RangeCtr<=0) or (j>2000);
         until (Addr1>=SAddr+EndOffset) or (j>2000);
         j:=0;
         MESSAGEHANDLE;
         if WTMsgPrc^.PRC_Long1=-1 then begin
            Valid:=false;
            exit;
         end;
      until Addr1>=SAddr+EndOffset;
   end;
end;



procedure DEFINERANGE;

begin
   with MyWTStdMsg^ do begin
      with ActWaveOp^ do begin
         if Operator[1]=-1 then Operator[1]:=70;
         if Operator[2]=-1 then Operator[2]:=8;
         Channels:=UsedChannels;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition TIMERANGE','','','','',115,0,3,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      WTMsgPrc^:=MsgPrc(WTM_SETCHANNELGADS,'','','','','',ActiveMode,ActWaveOp^.Channels,0,0,0,NIL);
      MESSAGEHANDLE;
      for i:=1 to 2 do begin
         CREATEPROPGAD(10,61+i*17,pred(ActWaveOp^.Operator[i])*661,655,i,8,DWindow^);
         Buffer[i]:=intstr(ActWaveOp^.Operator[i]);
      end;
      SchieberInfo[2].HorizPot:=pred(ActWaveOp^.Operator[2])*1310;
      SchieberInfo[2].HorizBody:=1310;
      WRITE(410,79,2,0,DWindow^,'Effectlevel');
      WRITE(410,95,2,0,DWindow^,'Rangesize');

      for i:=1 to 2 do AddGadget(DWindow,^TextGad[i],NIL);
      for i:=1 to 2 do AddGadget(DWindow,^Schieber[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         if (GadCode=9) or not (Schieber[1].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[1]:=succ(SchieberInfo[1].HorizPot div 661);
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            RefreshGadgets(^TextGad[1],DWindow,NIL);
          end;
          if GadCode=10 then begin
            val(Buffer[1],ActWaveOp^.Operator[1],j);
            if ActWaveOp^.Operator[1]<1 then ActWaveOp^.Operator[1]:=1;
            if ActWaveOp^.Operator[1]>100 then ActWaveOp^.Operator[1]:=100;
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            SchieberInfo[1].HorizPot:=pred(ActWaveOp^.Operator[1])*661;
            RefreshGadgets(^Schieber[1],DWindow,NIL);
         end;

         if (GadCode=11) or not (Schieber[2].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[2]:=succ(SchieberInfo[2].HorizPot div 1310);
            if ActWaveOp^.Operator[2]>50 then ActWaveOp^.Operator[2]:=50;
            Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
            RefreshGadgets(^TextGad[2],DWindow,NIL);
          end;
          if GadCode=12 then begin
            val(Buffer[2],ActWaveOp^.Operator[2],j);
            if ActWaveOp^.Operator[2]<1 then ActWaveOp^.Operator[2]:=1;
            if ActWaveOp^.Operator[2]>50 then ActWaveOp^.Operator[2]:=50;
            Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
            SchieberInfo[2].HorizPot:=pred(ActWaveOp^.Operator[2])*1310;
            RefreshGadgets(^Schieber[2],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETCHANNELGADS,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      ActWaveOP^.Channels:=WTMsgPrc^.PRC_Long1;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINERANGE
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'TimeRange, '+COPYRIGHT,'','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            WTMsgPrc^:=MsgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            Valid:=true;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if not (ActWaveOp^.Channels and ChBit=0) and Valid then
               DORANGE(MemA24[ChID]);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.
