#include <exec/types.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>
#include <clib/intuition_protos.h>

#include <pragma/all_lib.h>

#include <stdlib.h>
#include <string.h>

//#include <math.h>
#include <inttostr.h>

#include </WaveTracer/WTIncl.h>
#include </WaveTracer/ModIncl.h>

#define NEGATIVE 3
#define POSITIVE 0

extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;

extern void WRITE(UWORD LEdge, UWORD TEdge, UBYTE StPen, UBYTE DMode, Window *Wind, char *txt);
extern void MAKEBORDER(Window *Wind, UWORD LEdge, UWORD TEdge, UWORD REdge, UWORD BEdge, UBYTE Color);
extern void DORANGE(LONG SAddr);

PropInfo   SchieberInfo[2]={FREEHORIZ,0,0,0,0,0,0,0,0,0,0,
                            FREEHORIZ,0,0,0,0,0,0,0,0,0,0};
Image      SImage[2];
char       Buffer[2][20],UndoBuffer[2][20];
StringInfo TextInfo[2]={(UBYTE*)Buffer[0],(UBYTE*)UndoBuffer[0],0,9,0,0,0,0,0,0,NULL,0,NULL,
                        (UBYTE*)Buffer[1],(UBYTE*)UndoBuffer[1],0,9,0,0,0,0,0,0,NULL,0,NULL};
Gadget     Schieber[2]={NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[0],NULL,NULL,0,&SchieberInfo[0],0,0,
                        NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[1],NULL,NULL,0,&SchieberInfo[1],0,0};
Gadget     TextGad[2]={NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,NULL,NULL,NULL,0,&TextInfo[0],0,0,
                       NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,NULL,NULL,NULL,0,&TextInfo[1],0,0};
LONG       BeginOffset,EndOffset;
UBYTE      ChBit,ChID;
BOOL       Valid;                   



void CREATEPROPGAD(WORD LEdge, WORD TEdge, WORD XSet, WORD XJump, WORD GadNum,
                   WORD IDOffset, Window *XWindow)

{
SImage[GadNum]=*MyWTStdMsg->WTImg->KnobImg;
Schieber[GadNum].LeftEdge=LEdge;
Schieber[GadNum].TopEdge=TEdge;
Schieber[GadNum].GadgetID=IDOffset+(GadNum+1)*2-1,0;
SchieberInfo[GadNum].HorizPot=XSet;
SchieberInfo[GadNum].HorizBody=XJump;
TextGad[GadNum].LeftEdge=LEdge+332;
TextGad[GadNum].TopEdge=TEdge+1;
TextGad[GadNum].GadgetID=IDOffset+(GadNum+1)*2,0;
strcpy(UndoBuffer[GadNum],"");
MAKEBORDER(XWindow,LEdge+330,TEdge,LEdge+394,TEdge+14,NEGATIVE);
}



void DEFINERANGE(void)

{
Window       *DWindow;
UBYTE         RawCode,GadCode,i;
IntuiMessage *IMsg;
Gadget       *XGadget;

if (MyWTStdMsg->ActWaveOp->Operator[0]==-1)
   {
   MyWTStdMsg->ActWaveOp->OpType=0;
   MyWTStdMsg->ActWaveOp->Operator[0]=70;
   MyWTStdMsg->ActWaveOp->Operator[1]=7;
   MyWTStdMsg->ActWaveOp->Channels=MyWTStdMsg->UsedChannels;
   }
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Definition TIME RANGE");
MyWTStdMsg->WTMsgPrc->PRC_Long1=115;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=3;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr))
   {
   SENDERROR("Couldn't open window!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
DWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SETCHANNELGADS;
MyWTStdMsg->WTMsgPrc->PRC_Long1=MyWTStdMsg->ActiveMode;
MyWTStdMsg->WTMsgPrc->PRC_Long2=MyWTStdMsg->ActWaveOp->Channels;
MESSAGEHANDLE();
for (i=0; i<2; i++)
   {
   CREATEPROPGAD(10,76+i*17,(MyWTStdMsg->ActWaveOp->Operator[i]-1)*661,661,i,8,DWindow);
   inttostr(MyWTStdMsg->ActWaveOp->Operator[i],Buffer[i]);
   AddGadget(DWindow,&TextGad[i],NULL);
   AddGadget(DWindow,&Schieber[i],NULL);
   }
WRITE(410,77,2,0,DWindow,"% Effectlevel");
WRITE(410,93,2,0,DWindow,"Rangesize");

RefreshGadgets(DWindow->FirstGadget,DWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(DWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class==GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      }
   else Delay(1);

   if ((GadCode==9) || ((Schieber[0].Flags & SELECTED)==SELECTED))
      {
      MyWTStdMsg->ActWaveOp->Operator[0]=(SchieberInfo[0].HorizPot/661)+1;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[0],Buffer[0]);
      if (MyWTStdMsg->ActWaveOp->Operator[0]<1) MyWTStdMsg->ActWaveOp->Operator[0]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[0]>100) MyWTStdMsg->ActWaveOp->Operator[0]=100;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[0],Buffer[0]);
      RefreshGadgets(&TextGad[0],DWindow,NULL);
      }
   if (GadCode==10)
      {
      MyWTStdMsg->ActWaveOp->Operator[0]=strtol(Buffer[0],NULL,0);
      if (MyWTStdMsg->ActWaveOp->Operator[0]<1) MyWTStdMsg->ActWaveOp->Operator[0]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[0]>100) MyWTStdMsg->ActWaveOp->Operator[0]=100;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[0],Buffer[0]);
      SchieberInfo[0].HorizPot=(MyWTStdMsg->ActWaveOp->Operator[0]-1)*661;
      RefreshGadgets(&Schieber[0],DWindow,NULL);
      }

   if ((GadCode==11) || ((Schieber[1].Flags & SELECTED)==SELECTED))
      {
      MyWTStdMsg->ActWaveOp->Operator[1]=(SchieberInfo[1].HorizPot/661)+1;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[1],Buffer[1]);
      if (MyWTStdMsg->ActWaveOp->Operator[1]<1) MyWTStdMsg->ActWaveOp->Operator[1]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[1]>100) MyWTStdMsg->ActWaveOp->Operator[1]=100;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[1],Buffer[1]);
      RefreshGadgets(&TextGad[1],DWindow,NULL);
      }
   if (GadCode==12)
      {
      MyWTStdMsg->ActWaveOp->Operator[1]=strtol(Buffer[1],NULL,0);
      if (MyWTStdMsg->ActWaveOp->Operator[1]<1) MyWTStdMsg->ActWaveOp->Operator[1]=1;
      if (MyWTStdMsg->ActWaveOp->Operator[1]>100) MyWTStdMsg->ActWaveOp->Operator[1]=100;
      inttostr(MyWTStdMsg->ActWaveOp->Operator[1],Buffer[1]);
      SchieberInfo[1].HorizPot=(MyWTStdMsg->ActWaveOp->Operator[1]-1)*661;
      RefreshGadgets(&Schieber[1],DWindow,NULL);
      }

   }
while (!((GadCode==1) || (GadCode==2) || (RawCode==68) || (RawCode==69)));
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETCHANNELGADS;
MESSAGEHANDLE();
MyWTStdMsg->ActWaveOp->Channels=MyWTStdMsg->WTMsgPrc->PRC_Long1;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_LEAVEWIN;
MyWTStdMsg->WTMsgPrc->PRC_Long1=RawCode;
MyWTStdMsg->WTMsgPrc->PRC_Long2=GadCode;
MyWTStdMsg->WTMsgPrc->PRC_NewPtr=DWindow;
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==1) MyWTStdMsg->Flags=MDE_READY else MyWTStdMsg->Flags=MDE_CANCELLED;
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (GfxBase) && (IntuitionBase))
   {
   if (CREATEPORTS(PORT_EFFECTMOD))
      {
      if (MyWTStdMsg->Version==VERSION_EFFECTMOD)
         {
         if (MyWTStdMsg->Flags==MDC_DEFINEIT) DEFINERANGE()
         else if (MyWTStdMsg->Flags==MDC_DOIT)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"TimeRange, ");
            strcat(MyWTStdMsg->WTMsgPrc->PRC_Str1,COPYRIGHT);
            MESSAGEHANDLE();
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETMARKOFFSET;
            MESSAGEHANDLE();
            BeginOffset=MyWTStdMsg->WTMsgPrc->PRC_Long1;
            EndOffset=MyWTStdMsg->WTMsgPrc->PRC_Long2;
            ChBit=1; Valid=TRUE;
            for (ChID=0; ChID<6; ChID++)
               {
               if ((Valid) && ((MyWTStdMsg->ActWaveOp->Channels & ChBit)==ChBit))
                DORANGE(MyWTStdMsg->MemA24[ChID]);
               ChBit=ChBit*2;
               }
            if (Valid) MyWTStdMsg->Flags=MDE_READY else MyWTStdMsg->Flags=MDE_CANCELLED;
            }
         else MyWTStdMsg->Flags=MDE_NO_MEMORY;
         MESSAGEHANDLE();
         }
      else
         {
         MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
         MESSAGEHANDLE();
         }
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   if (DOSBase) CloseLibrary((Library*)DOSBase);
   if (GfxBase) CloseLibrary((Library*)GfxBase);
   if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);   
   }
}

