Program Effectmod;

USES Intuition,Graphics,ExecIO;

type BPTR=long;

var DWindow                             :^Window;

var XGadget                             :^Gadget;
var Schieber,Textgad                    :array [1..7] of Gadget;
var SImage                              :array [1..7] of Image;
var SchieberInfo                        :array [1..7] of PropInfo;
var TextInfo                            :array [1..7] of StringInfo;
var Buffer,UndoBuffer                   :array [1..7] of string[10];

var IMsg                                :^IntuiMessage;
var Addr0,Addr1,Addr2                   :long;
var Data0,Data1,Data2                   :^long;
var RawCode,GadCode                     :byte;
var i,j                                 :integer;
var l,Op1,Op2,Op3,BeginOffset,EndOffset :long;
var Valid                               :boolean;

{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
       "EffIncl.mod","Schieber.mod"}



procedure DOTH;

var ChBit,ChID  :byte;

procedure DOCHORUS(SAddr :long);

var Factor,Addr         :array[1..100] of real;
var Data                :array[1..100] of ^long;
var Last,j              :integer;

begin
   if SAddr=0 then exit;
   with MyWTStdMsg^ do begin
      WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      Addr0:=SAddr+BeginOffset;
      Last:=Op3;
      i:=0;
      repeat
        i:=i+1;
        Addr[i]:=round(pred(i)*((10000000/(SRate*2.79365))/400));
        Factor[i]:=((PlayL24-BeginOffset))/((PlayL24-BeginOffset)-(Addr[i]*4));
      until (i=Last) or (Addr[i]*4+BeginOffset>=PlayL24);
      if Addr[i]*4>=PlayL24 then Last:=pred(i) else Last:=i;
      j:=2000;
      if Last>0 then repeat
         repeat
            Data0:=ptr(Addr0); Addr0:=Addr0+4;
            for i:=1 to Last do if Addr[i]*4+BeginOffset<PlayL24 then begin
               Data[i]:=ptr(round(Addr[i])*4+SAddr+BeginOffset);
               Addr[i]:=Addr[i]+Factor[i];
               Data0^:=Data0^-Data[i]^;
            end;
            while (Last>1) and (Addr[Last]*4+BeginOffset>=PlayL24) do Last:=Last-1;
            j:=j+1;
         until (Addr0>=SAddr+EndOffset) or (Last=0) or (j>2000);
         j:=0;
         MESSAGEHANDLE;
         if WTMsgPrc^.PRC_Long1=-1 then begin
            Valid:=false;
            exit;
         end;
      until (Addr0>=SAddr+EndOffset) or (Last=0);
   end;
end;



procedure DOECHO(SAddr :long; Step: byte);

var Echos,REchos        :integer;

begin
   if SAddr=0 then exit;
   with MyWTStdMsg^ do begin
      Echos:=1; REchos:=1; Step:=Step*8;
      repeat
         Addr1:=SAddr+BeginOffset;
         Addr2:=SAddr+BeginOffset+(Echos*Op2*4)+Step;
         MESSAGEHANDLE;
         if WTMsgPrc^.PRC_Long1=-1 then begin
            Valid:=false;
            exit;
         end;
         if Addr2<SAddr+EndOffset then repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data2:=ptr(Addr2); Addr2:=Addr2+4;
            Data2^:=(Data1^+Data2^+Data2^) div 3;
         until (Addr2>=SAddr+PlayL24);
         Echos:=Echos+1; REchos:=REchos+Echos;
      until (REchos>=Op1) or (Addr1>SAddr+PlayL24);
   end;
end;



begin
   with MyWTStdMsg^ do begin
      if MemL24>PlayL24 then for i:=1 to 6 do if MemA24[i]>0 then begin
         Addr1:=MemA24[i]+PlayL24;
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data1^:=0;
         until (Addr1>=MemA24[i]+MemL24);
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      BeginOffset:=WTMsgPrc^.PRC_Long1;
      EndOffset:=WTMsgPrc^.PRC_Long2;
      WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      PlayL24:=MemL24;
      Valid:=true;
      ChBit:=1;
      for ChID:=1 to 6 do begin
         if Valid and (ActWaveOp^.Operator[ChID]>0)
         and not (UsedChannels and ChBit=0) then begin
            l:=round(10000000/(SRate*2.79365));
            Op1:=ActWaveOp^.Operator[ChID];
            Op2:=round(l*1986/15839);                     if Op2=0 then Op2:=1;
            Op3:=round(ActWaveOp^.Operator[ChID]*6.5/10); if Op3=0 then Op3:=1;
            if Valid then DOECHO(MemA24[ChID],ChID);
            if Valid then DOCHORUS(MemA24[ChID]);
         end;
         ChBit:=ChBit*2;
      end;
   end;
end;



procedure DEFINETH;

var s           :string;
var ChBit,ChID  :byte;

procedure GETGAD(GadID :byte);

var GadNum      :byte;

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      GadNum:=GadID*2-1;
      if (GadCode=GadNum+2) or not (Schieber[GadID].flags and SELECTED=0) then begin
         Operator[GadID]:=SchieberInfo[GadID].HorizPot div 1310;
         if Operator[GadID]>50 then Operator[GadID]:=50;
         if Operator[GadID]<0 then Operator[GadID]:=0;
         Buffer[GadID]:=intstr(Operator[GadID]);
         RefreshGadgets(^TextGad[GadID],DWindow,NIL);
      end;
      if (GadCode=GadNum+3) then begin
         val(Buffer[GadID],Operator[GadID],i);
         if Operator[GadID]>50 then Operator[GadID]:=50;
         if Operator[GadID]<0 then Operator[GadID]:=0;
         Buffer[GadID]:=intstr(Operator[GadID]);
         SchieberInfo[GadID].HorizPot:=Operator[GadID]*1310;
         RefreshGadgets(^TextGad[GadID],DWindow,NIL);
      end;
   end;
end;


begin
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition THOUSANDS','','','','',163,0,1,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;

      with ActWaveOp^ do if Operator[1]=-1 then begin
         Operator[1]:=6;
         Operator[2]:=6;
         Operator[3]:=11;
         Operator[4]:=17;
         Operator[5]:=17;
         Operator[6]:=0;
      end;


      ChBit:=1;
      for i:=1 to 7 do begin
         if i<7 then l:=ActWaveOp^.Operator[i] else l:=ActWaveOp^.Operator[1];
         Buffer[i]:=intstr(l);
         UndoBuffer[i]:=Buffer[i];
         CREATEPROPGAD(10,23+17*i,l*1310,1310,i,2,DWindow^);
         if (i<7) and (ActiveChannels and ChBit=0) then begin
            Schieber[i].Flags:=Schieber[i].Flags or GADGDISABLED;
            TextGad[i].Flags:=TextGad[i].Flags or GADGDISABLED;
         end;
         AddGadget(DWindow,^Schieber[i],NIL);
         AddGadget(DWindow,^TextGad[i],NIL);
         case i of
            1: s:='L';
            2: s:='R';
            3: s:='C';
            4: s:='SL';
            5: s:='SR';
            6: s:='Sub';
            7: s:='Gesamt';
         end;
         WRITE(414,i*17+24,2,0,DWindow^,s);
         ChBit:=ChBit*2;
      end;
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         for i:=1 to 6 do GETGAD(i);

         if (GadCode=15) or not (Schieber[7].flags and SELECTED=0) then begin
            l:=SchieberInfo[7].HorizPot div 1310;
            if l>50 then l:=50;
            if l<0 then l:=0;
            for i:=1 to 7 do begin
               if i<7 then ActWaveOp^.Operator[i]:=l;
               Buffer[i]:=intstr(l);
               SchieberInfo[i].HorizPot:=l*1310;
            end;
            RefreshGadgets(^TextGad[7],DWindow,NIL);
         end;
         if (GadCode=16) then begin
            val(Buffer[7],l,i);
            if l>50 then l:=50;
            if l<0 then l:=0;
            for i:=1 to 7 do begin
               if i<7 then ActWaveOp^.Operator[i]:=l;
               Buffer[i]:=intstr(l);
               SchieberInfo[i].HorizPot:=l*1310;
            end;
            RefreshGadgets(^TextGad[7],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINETH
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'Thousands, '+COPYRIGHT,'','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            DOTH;
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.

