#include <exec/types.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>
#include <clib/intuition_protos.h>

#ifdef __Storm__
   #include <inttostr.h>
#else
   #include <pragma/all_lib.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <math.h>

#include </WaveTracer/WTIncl.h>
#include </WaveTracer/ModIncl.h>

#define NEGATIVE 3
#define POSITIVE 0

extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;

extern void WRITE(UWORD LEdge, UWORD TEdge, UBYTE StPen, UBYTE DMode, Window *Wind, char *txt);
extern void MAKEBORDER(Window *Wind, UWORD LEdge, UWORD TEdge, UWORD REdge, UWORD BEdge, UBYTE Color);
extern void DOTH(void);

PropInfo   SchieberInfo[7]={FREEHORIZ,0,0,0,0,0,0,0,0,0,0,
                            FREEHORIZ,0,0,0,0,0,0,0,0,0,0,
                            FREEHORIZ,0,0,0,0,0,0,0,0,0,0,
                            FREEHORIZ,0,0,0,0,0,0,0,0,0,0,
                            FREEHORIZ,0,0,0,0,0,0,0,0,0,0,
                            FREEHORIZ,0,0,0,0,0,0,0,0,0,0,
                            FREEHORIZ,0,0,0,0,0,0,0,0,0,0};
Image      SImage[7];
char       Buffer[7][20],UndoBuffer[7][20];
StringInfo TextInfo[7]={(UBYTE*)Buffer[0],(UBYTE*)UndoBuffer[0],0,9,0,0,0,0,0,0,NULL,0,NULL,
                        (UBYTE*)Buffer[1],(UBYTE*)UndoBuffer[1],0,9,0,0,0,0,0,0,NULL,0,NULL,
                        (UBYTE*)Buffer[2],(UBYTE*)UndoBuffer[2],0,9,0,0,0,0,0,0,NULL,0,NULL,
                        (UBYTE*)Buffer[3],(UBYTE*)UndoBuffer[3],0,9,0,0,0,0,0,0,NULL,0,NULL,
                        (UBYTE*)Buffer[4],(UBYTE*)UndoBuffer[4],0,9,0,0,0,0,0,0,NULL,0,NULL,
                        (UBYTE*)Buffer[5],(UBYTE*)UndoBuffer[5],0,9,0,0,0,0,0,0,NULL,0,NULL,
                        (UBYTE*)Buffer[6],(UBYTE*)UndoBuffer[6],0,9,0,0,0,0,0,0,NULL,0,NULL};
Gadget     Schieber[7]={NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[0],NULL,NULL,0,&SchieberInfo[0],0,0,
                        NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[1],NULL,NULL,0,&SchieberInfo[1],0,0,
                        NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[2],NULL,NULL,0,&SchieberInfo[2],0,0,
                        NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[3],NULL,NULL,0,&SchieberInfo[3],0,0,
                        NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[4],NULL,NULL,0,&SchieberInfo[4],0,0,
                        NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[5],NULL,NULL,0,&SchieberInfo[5],0,0,
                        NULL,0,0,320,15,GADGHCOMP+GADGIMAGE,0x83,PROPGADGET,&SImage[6],NULL,NULL,0,&SchieberInfo[6],0,0};
Gadget     TextGad[7]={NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,NULL,NULL,NULL,0,&TextInfo[0],0,0,
                       NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,NULL,NULL,NULL,0,&TextInfo[1],0,0,
                       NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,NULL,NULL,NULL,0,&TextInfo[2],0,0,
                       NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,NULL,NULL,NULL,0,&TextInfo[3],0,0,
                       NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,NULL,NULL,NULL,0,&TextInfo[4],0,0,
                       NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,NULL,NULL,NULL,0,&TextInfo[5],0,0,
                       NULL,0,0,60,15,GADGHCOMP,LONGINT+STRINGCENTER+0x1,STRGADGET,NULL,NULL,NULL,0,&TextInfo[6],0,0};
LONG       BeginOffset,EndOffset;
UBYTE      ChBit,ChID;
BOOL       Valid;                   
Window    *DWindow;
UBYTE      RawCode,GadCode,i;


void CREATEPROPGAD(WORD LEdge, WORD TEdge, WORD XSet, WORD XJump, WORD GadNum,
                   WORD IDOffset, Window *XWindow)

{
SImage[GadNum]=*MyWTStdMsg->WTImg->KnobImg;
Schieber[GadNum].LeftEdge=LEdge;
Schieber[GadNum].TopEdge=TEdge;
Schieber[GadNum].GadgetID=IDOffset+(GadNum+1)*2-1,0;
SchieberInfo[GadNum].HorizPot=XSet;
SchieberInfo[GadNum].HorizBody=XJump;
TextGad[GadNum].LeftEdge=LEdge+332;
TextGad[GadNum].TopEdge=TEdge+1;
TextGad[GadNum].GadgetID=IDOffset+(GadNum+1)*2,0;
strcpy(UndoBuffer[GadNum],"");
MAKEBORDER(XWindow,LEdge+330,TEdge,LEdge+394,TEdge+14,NEGATIVE);
}



void GETGAD(UBYTE GadID)

{
UBYTE GadNum;

GadNum=GadID*2-1;
GadID--;
if ((GadCode==GadNum+2) || ((Schieber[GadID].Flags & SELECTED)==SELECTED))
   {
   MyWTStdMsg->ActWaveOp->Operator[GadID]=SchieberInfo[GadID].HorizPot/1310;
   if (MyWTStdMsg->ActWaveOp->Operator[GadID]<0) MyWTStdMsg->ActWaveOp->Operator[GadID]=0
   else if (MyWTStdMsg->ActWaveOp->Operator[GadID]>50) MyWTStdMsg->ActWaveOp->Operator[GadID]=50;
   inttostr(MyWTStdMsg->ActWaveOp->Operator[GadID],Buffer[GadID]);
   RefreshGadgets(&TextGad[GadID],DWindow,NULL);
   }
if (GadCode==GadNum+3)
   {
   MyWTStdMsg->ActWaveOp->Operator[GadID]=strtol(Buffer[GadID],NULL,0);
   if (MyWTStdMsg->ActWaveOp->Operator[GadID]<0) MyWTStdMsg->ActWaveOp->Operator[GadID]=0
   else if (MyWTStdMsg->ActWaveOp->Operator[GadID]>50) MyWTStdMsg->ActWaveOp->Operator[GadID]=50;
   inttostr(MyWTStdMsg->ActWaveOp->Operator[GadID],Buffer[GadID]);
   SchieberInfo[GadID].HorizPot=MyWTStdMsg->ActWaveOp->Operator[GadID]*1310;
   RefreshGadgets(&TextGad[GadID],DWindow,NULL);
   }     
}



void DEFINETH(void)

{
IntuiMessage *IMsg;
Gadget       *XGadget;
LONG          l;
char          s[20];

if (MyWTStdMsg->ActWaveOp->Operator[0]==-1)
   {
   MyWTStdMsg->ActWaveOp->OpType=0;
   MyWTStdMsg->ActWaveOp->Operator[0]=6;
   MyWTStdMsg->ActWaveOp->Operator[1]=6;
   MyWTStdMsg->ActWaveOp->Operator[2]=11;
   MyWTStdMsg->ActWaveOp->Operator[3]=17;
   MyWTStdMsg->ActWaveOp->Operator[4]=17;
   MyWTStdMsg->ActWaveOp->Operator[5]=0;
   MyWTStdMsg->ActWaveOp->Channels=MyWTStdMsg->UsedChannels;
   }
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Definition THOUSANDS");
MyWTStdMsg->WTMsgPrc->PRC_Long1=163;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=1;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr))
   {
   SENDERROR("Couldn't open window!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
DWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_SETCHANNELGADS;
MyWTStdMsg->WTMsgPrc->PRC_Long1=MyWTStdMsg->ActiveMode;
MyWTStdMsg->WTMsgPrc->PRC_Long2=MyWTStdMsg->ActWaveOp->Channels;
MESSAGEHANDLE();
ChBit=1;
for (i=0; i<=6; i++)
   {
   if (i<6) l=MyWTStdMsg->ActWaveOp->Operator[i] else l=MyWTStdMsg->ActWaveOp->Operator[0];
   inttostr(l,Buffer[i]);
   CREATEPROPGAD(10,40+17*i,l*1310,1310,i,2,DWindow);
   if ((i<6) && ((MyWTStdMsg->ActiveChannels & ChBit)==0))
      {
      Schieber[i].Flags=Schieber[i].Flags | GADGDISABLED;
      TextGad[i].Flags=TextGad[i].Flags | GADGDISABLED;
      }
   AddGadget(DWindow,&Schieber[i],NULL);
   AddGadget(DWindow,&TextGad[i],NULL);
   switch (i)
      {
      case 0:
         strcpy(s,"L");
         break;
      case 1:
         strcpy(s,"R");
         break;
      case 2:
         strcpy(s,"C");
         break;
      case 3:
         strcpy(s,"SL");
         break;
      case 4:
         strcpy(s,"SR");
         break;
      default:
         strcpy(s,"All");
         break;
      }
   WRITE(414,i*17+41,2,0,DWindow,s);
   ChBit=ChBit*2;
   }
RefreshGadgets(DWindow->FirstGadget,DWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(DWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class==GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      }
   else Delay(1);

   for (i=0; i<=6; i++) GETGAD(i);

   if ((GadCode==15) || ((Schieber[6].Flags & SELECTED)==SELECTED))
      {
      l=SchieberInfo[6].HorizPot/1310;
      if (l>50) l=50 else if (l<0) l=0;
      for (i=0; i<7; i++)
         {
         if (i<6) MyWTStdMsg->ActWaveOp->Operator[i]=l;
         inttostr(l,Buffer[i]);
         SchieberInfo[i].HorizPot=l*1310;
         }
      RefreshGadgets(&TextGad[6],DWindow,NULL);
      }
   if (GadCode==16)
      {
      l=strtol(Buffer[6],NULL,0);
      if (l>50) l=50 else if (l<0) l=0;
      for (i=0; i<7; i++)
         {
         if (i<6) MyWTStdMsg->ActWaveOp->Operator[i]=l;
         inttostr(l,Buffer[i]);
         SchieberInfo[i].HorizPot=l*1310;
         }
      RefreshGadgets(&TextGad[6],DWindow,NULL);
      }

   }
while (!((GadCode==1) || (GadCode==2) || (RawCode==68) || (RawCode==69)));
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETCHANNELGADS;
MESSAGEHANDLE();
MyWTStdMsg->ActWaveOp->Channels=MyWTStdMsg->WTMsgPrc->PRC_Long1;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_LEAVEWIN;
MyWTStdMsg->WTMsgPrc->PRC_Long1=RawCode;
MyWTStdMsg->WTMsgPrc->PRC_Long2=GadCode;
MyWTStdMsg->WTMsgPrc->PRC_NewPtr=DWindow;
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==1) MyWTStdMsg->Flags=MDE_READY else MyWTStdMsg->Flags=MDE_CANCELLED;
}




void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (GfxBase) && (IntuitionBase))
   {
   if (CREATEPORTS(PORT_EFFECTMOD))
      {
      if (MyWTStdMsg->Version==VERSION_EFFECTMOD)
         {
         if (MyWTStdMsg->Flags==MDC_DEFINEIT) DEFINETH()
         else if (MyWTStdMsg->Flags==MDC_DOIT)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Thousands, ");
            strcat(MyWTStdMsg->WTMsgPrc->PRC_Str1,COPYRIGHT);
            MESSAGEHANDLE();
            DOTH();
            if (Valid) MyWTStdMsg->Flags=MDE_READY else MyWTStdMsg->Flags=MDE_CANCELLED;
            }
         else MyWTStdMsg->Flags=MDE_NO_MEMORY;
         MESSAGEHANDLE();
         }
      else
         {
         MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
         MESSAGEHANDLE();
         }
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   if (DOSBase) CloseLibrary((Library*)DOSBase);
   if (GfxBase) CloseLibrary((Library*)GfxBase);
   if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);   
   }
}

