Program Effectmod;

USES Intuition,Graphics,ExecIO;

type BPTR=long;

{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
       "EffIncl.mod"}

var DWindow                             :^Window;

var XGadget                             :^Gadget;
var Schieber,Textgad                    :array [1..2] of Gadget;
var SImage                              :array [1..2] of Image;
var SchieberInfo                        :array [1..2] of PropInfo;
var TextInfo                            :array [1..2] of StringInfo;
var Buffer,UndoBuffer                   :array [1..2] of string[20];

var IMsg                                :^IntuiMessage;
var RawCode,GadCode,ChID,ChBit          :byte;
var i,j                                 :integer;
var l,BeginOffset,EndOffset             :long;
var Valid                               :boolean;



procedure DOTECH(SAddr :long);


var Addr1,l                     :long;
var Data1                       :^long;
var Factor1,Stepsize,Factor2    :real;

begin
   if SAddr=0 then exit;
   with MyWTStdMsg^ do begin
      Stepsize:=(ActWaveOp^.Operator[2]-ActWaveOp^.Operator[1])*4/(EndOffset-BeginOffset)/50;
      Factor1:=ActWaveOp^.Operator[1]/50;
      Addr1:=SAddr+BeginOffset;
      i:=0;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      repeat
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            if Factor1>1 then begin
               l:=round(Data1^*Factor1);
               if (l>MAX24) or (l<-MAX24) then begin
                  Factor2:=2-Factor1;
                  l:=round(Data1^*Factor2);
                  Data1^:=l-Data1^
               end;
            end;
            Factor1:=Factor1+Stepsize;
            i:=i+1;
         until (Addr1>=SAddr+EndOffset) or (i>2000);
         i:=0;
         MESSAGEHANDLE;
         if WTMsgPrc^.PRC_Long1=-1 then begin
            Valid:=false;
            exit;
         end;
      until Addr1>=SAddr+EndOffset;
   end;
end;



procedure DEFINETECH;

begin
   with MyWTStdMsg^ do begin
      with ActWaveOp^ do begin
         Channels:=UsedChannels;
         if Operator[1]=-1 then Operator[1]:=100;
         if Operator[2]=-1 then Operator[2]:=25;
      end;

      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition TECHNOISE','','','','',110,0,3,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      WTMsgPrc^:=MsgPrc(WTM_SETCHANNELGADS,'','','','','',Activemode,ActWaveOp^.Channels,0,0,0,NIL);
      MESSAGEHANDLE;
      for i:=1 to 2 do begin
         SImage[i]:=WTImg^.KnobImg^;
         Schieber[i]:=Gadget(NIL,10,50+i*20 ,320,15,GADGHCOMP+GADGIMAGE,$83,PROPGADGET,
                      ^SImage[i],NIL,Nil,0,^SchieberInfo[i],i+2,0);
         SchieberInfo[i]:=Propinfo(FREEHORIZ,ActWaveOp^.Operator[i]*655,0,655,0,0,0,0,0,0,0);
         TextGad[i]:=Gadget(Nil,342,51+i*20,42,15,GADGHCOMP,_LONGINT+STRINGCENTER+$1,STRGADGET,NIL,Nil,Nil,0,^TextInfo[i],i+4,0);
         MAKEBORDER(DWindow^,340,50+i*20,385,64+i*20,NEGATIVE);
         TextInfo[i]:=StringInfo(^Buffer[i],^Undobuffer[i],0,7,0,0,0,0,0,0,Nil,0,Nil);
         Buffer[i]:=intstr(ActWaveOp^.Operator[i]); UndoBuffer[i]:='';
      end;
      WRITE(400,71,2,0,DWindow^,'Begin-techlevel');
      WRITE(400,91,2,0,DWindow^,'End-techlevel');

      for i:=1 to 2 do AddGadget(DWindow,^TextGad[i],NIL);
      for i:=1 to 2 do AddGadget(DWindow,^Schieber[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         if (GadCode=3) or not (Schieber[1].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[1]:=SchieberInfo[1].HorizPot div 655;
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            RefreshGadgets(^TextGad[1],DWindow,NIL);
          end;
          if GadCode=5 then begin
            val(Buffer[1],ActWaveOp^.Operator[1],j);
            if ActWaveOp^.Operator[1]<0 then ActWaveOp^.Operator[1]:=0;
            if ActWaveOp^.Operator[1]>100 then ActWaveOp^.Operator[1]:=100;
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            SchieberInfo[1].HorizPot:=ActWaveOp^.Operator[1]*655;
            RefreshGadgets(^Schieber[1],DWindow,NIL);
         end;


         if (GadCode=4) or not (Schieber[2].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[2]:=SchieberInfo[2].HorizPot div 655;
            Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
            RefreshGadgets(^TextGad[2],DWindow,NIL);
          end;
          if GadCode=6 then begin
            val(Buffer[2],ActWaveOp^.Operator[2],j);
            if ActWaveOp^.Operator[2]<0 then ActWaveOp^.Operator[2]:=0;
            if ActWaveOp^.Operator[2]>100 then ActWaveOp^.Operator[2]:=100;
            Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
            SchieberInfo[2].HorizPot:=ActWaveOp^.Operator[2]*655;
            RefreshGadgets(^Schieber[2],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      WTMsgPrc^:=MsgPrc(WTM_GETCHANNELGADS,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      ActWaveOp^.Channels:=WTMsgPrc^.PRC_Long1;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINETECH
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'TechNoise, '+COPYRIGHT,'','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            WTMsgPrc^:=MsgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            Valid:=true;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if Valid and not (ActWaveOp^.Channels and ChBit=0) then
                DOTECH(MemA24[ChID]);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.



