#include <exec/types.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include </WaveTracer/WTincl.h>

#define DLB_NO_OFFSET 1
#define DLB_XQ_MODE   2

extern WTStdMsg *MyWTStdMsg;
extern void MESSAGEHANDLE(void);


void ENCODE(void)

{
LONG   SideDiv,CentDiv,SurrDiv,SubDiv;
LONG   Addr1,Addr2,Addr3;
LONG  *Data1,*Data2,*Data3;
WORD   i;


MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
switch (MyWTStdMsg->ActiveMode)
   {
   case MD_3CH:
      CentDiv=3;
      SideDiv=(LONG)(3.0/2.0);
      break;
   case MD_AC3_Sub:
      CentDiv=3;
      SideDiv=(LONG)(3.0/2.0);
      SurrDiv=(LONG)(6.0/2.0);
      break;
   case MD_AC3:
      CentDiv=4;
      SideDiv=(LONG)(4.0/2.0);
      SurrDiv=(LONG)(8.0/2.0);
      SubDiv=4;
      break;
   default:
      // MD_SURROUND,MD_QUADRO
      CentDiv=3;
      SideDiv=(LONG)(3.0/2.0);
      SurrDiv=3;
      break;
   }
if ((MyWTStdMsg->MemA24[0]) && (MyWTStdMsg->MemA24[1]))
   {
   // LEFT & RIGHT
   for (i=0; i<2; i++) if (MyWTStdMsg->MemA24[i])
      {
      Addr1=MyWTStdMsg->MemA24[i];
      do
         {
         Data1=(LONG*)Addr1; Addr1=Addr1+4;
         *Data1=*Data1/SideDiv;
         }
      while (Addr1<MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24);
      }
   if ((MyWTStdMsg->MemA24[2]) && ((MyWTStdMsg->UsedChannels & CH_CENTER)==CH_CENTER))
      {
      // CENTER
      Addr1=MyWTStdMsg->MemA24[0];
      Addr2=MyWTStdMsg->MemA24[1];
      Addr3=MyWTStdMsg->MemA24[2];
      do
         {
         Data1=(LONG*)Addr1; Addr1=Addr1+4;
         Data2=(LONG*)Addr2; Addr2=Addr2+4;
         Data3=(LONG*)Addr3; Addr3=Addr3+4;
         *Data1=*Data1+(*Data3 / CentDiv);
         *Data2=*Data2+(*Data3 / CentDiv);
         *Data3=0;
         }
      while (Addr3<MyWTStdMsg->MemA24[2]+MyWTStdMsg->PlayL24);
      }
   }
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
   {
   MyWTStdMsg->Flags=MDE_CANCELLED;
   return;
   }
if ((MyWTStdMsg->MemA24[2]) && (MyWTStdMsg->MemA24[3]))
   {
   // SURROUND LEFT/RIGHT
   for (i=3; i<=4; i++) if (MyWTStdMsg->MemA24[i])
      {
      Addr1=MyWTStdMsg->MemA24[2];
      Addr2=MyWTStdMsg->MemA24[3];
      Addr3=MyWTStdMsg->MemA24[i]+800;
      if ((MyWTStdMsg->ActWaveOp->Operator[0] & DLB_NO_OFFSET)==DLB_NO_OFFSET) Addr3=MyWTStdMsg->MemA24[i];
      while (Addr3>=MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24) Addr3=Addr3-8;
      do
         {
         Data1=(LONG*)Addr1; Addr1=Addr1+4;
         Data2=(LONG*)Addr2; Addr2=Addr2+4;
         Data3=(LONG*)Addr3; Addr3=Addr3+4;
         if (i==3)
            {
            *Data1=*Data3 / SurrDiv;
            *Data2=-*Data3 / SurrDiv;
            }
         else
            {
            *Data1=*Data3 / SurrDiv + *Data1;
            *Data2=-*Data3 / SurrDiv + *Data2;
            *Data3=0;
            }
         }
      while (Addr3<MyWTStdMsg->MemA24[i]+MyWTStdMsg->PlayL24);
      if (i==3) while (Addr1<MyWTStdMsg->MemA24[2]+MyWTStdMsg->PlayL24)
         {
         Data1=(LONG*)Addr1; Addr1=Addr1+4;
         Data2=(LONG*)Addr2; Addr2=Addr2+4;
         *Data1=0;
         *Data2=0;
         }
      else if (MyWTStdMsg->MemA24[4])
         {
         Addr1=MyWTStdMsg->MemA24[4];
         do
            {
            Data1=(LONG*)Addr1; Addr1=Addr1+4;
            *Data1=0;
            }
         while ((Addr1<MyWTStdMsg->MemA24[4]+MyWTStdMsg->PlayL24) &&
                (Addr1<MyWTStdMsg->MemA24[4]+800))
         }
      }
   }
if (MyWTStdMsg->MemA24[5])
   {
   // SUBWOOFER
   Addr1=MyWTStdMsg->MemA24[2];
   Addr2=MyWTStdMsg->MemA24[3];
   Addr3=MyWTStdMsg->MemA24[5];
   do
      {
      Data1=(LONG*)Addr1; Addr1=Addr1+4;
      Data2=(LONG*)Addr2; Addr2=Addr2+4;
      Data3=(LONG*)Addr3; Addr3=Addr3+4;
      *Data1=(*Data3 / SubDiv) + *Data1;
      *Data2=(*Data3 / SubDiv) + *Data2;
      *Data3=0;
      }
   while (Addr3<MyWTStdMsg->MemA24[5]+MyWTStdMsg->PlayL24);
   }
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
   {
   MyWTStdMsg->Flags=MDE_CANCELLED;
   return;
   }
if (((MyWTStdMsg->ActWaveOp->Operator[0] & DLB_XQ_MODE)==0) &&
    (MyWTStdMsg->MemA24[0]) && (MyWTStdMsg->MemA24[1]) &&
    (MyWTStdMsg->MemA24[2]) && (MyWTStdMsg->MemA24[3]))
   {
   Addr1=MyWTStdMsg->MemA24[0];
   Addr2=MyWTStdMsg->MemA24[3];
   do
      {
      Data1=(LONG*)Addr1; Addr1=Addr1+4;
      Data2=(LONG*)Addr2; Addr2=Addr2+4;
      *Data1=(*Data1+(*Data2)) / 2;
      *Data2=0;
      }
   while (Addr1<MyWTStdMsg->MemA24[0]+MyWTStdMsg->PlayL24);
   Addr1=MyWTStdMsg->MemA24[1];
   Addr2=MyWTStdMsg->MemA24[2];
   do
      {
      Data1=(LONG*)Addr1; Addr1=Addr1+4;
      Data2=(LONG*)Addr2; Addr2=Addr2+4;
      *Data1=(*Data1+(*Data2)) / 2;
      *Data2=0;
      }
   while (Addr1<MyWTStdMsg->MemA24[1]+MyWTStdMsg->PlayL24);
   }
//PlayL24:=PlayL24-4;
MyWTStdMsg->Flags=MDE_READY;
}

