Program Effectmod;

{Operator[2] und Operator[3] werden fr SpectraFX-Einstellung vorinitialisiert;
 Operator[1] dient als Flag fr DLB_-Mode, OpType ist dafr eigentlich vor-
 gesehen und wurde hierfr schon vorbereitet!!!}

USES ExecIO,Intuition,Graphics;

type BPTR=long;

const DLB_NO_OFFSET=1;
const DLB_XQ_MODE=2;

var Valid               :boolean;
var DWindow             :^Window;
var XGadget             :^Gadget;
var DKnopf              :array [3..4] of Gadget;
var IMsg                :^IntuiMessage;
var RawCode,GadCode     :byte;


{$incl "exec/memory.h"}
{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod","EffIncl.mod"}


procedure ENCODE;


var SideDiv,CentDiv,SurrDiv,SubDiv      :long;
var Addr1,Addr2,Addr3                   :long;
var Data1,Data2,Data3                   :^long;
var DataA1,DataA2,DataA3                :^byte;
var i,j                                 :byte;


begin
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      { MAX24=8355835 }
      case ActiveMode of
         MD_3CH:      begin
                         CentDiv:=round(3);
                         SideDiv:=round(3/2)
                      end;

         MD_AC3_SUB:  begin
                         CentDiv:=round(3);
                         SideDiv:=round(3/2);
                         SurrDiv:=round(6/2);
                      end;
         MD_AC3:      begin
                         CentDiv:=round(4);
                         SideDiv:=round(4/2);
                         SurrDiv:=round(8/2);
                         SubDiv:=round(4);
                      end;
         otherwise begin
            {MD_SURROUND,MD_QUADRO}
            CentDiv:=round(3);
            SideDiv:=round(3/2);
            SurrDiv:=round(3);
         end;
      end;

      if (MemA24[1]<>0) and (MemA24[2]<>0) then begin
         { LEFT & RIGHT }
         for i:=1 to 2 do if MemA24[i]<>0 then begin
            Addr1:=MemA24[i];
            Addr3:=MemA24[i];
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data3:=ptr(Addr3); Addr3:=Addr3+4;
               Data1^:=Data3^ div SideDiv;
            until Addr3>=MemA24[i]+PlayL24;
         end;
         { CENTER }
         if (MemA24[3]<>0) and (UsedChannels and CH_CENTER=CH_CENTER) then begin
            Addr1:=MemA24[1];
            Addr2:=MemA24[2];
            Addr3:=MemA24[3];
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data2:=ptr(Addr2); Addr2:=Addr2+4;
               Data3:=ptr(Addr3); Addr3:=Addr3+4;
               Data1^:=Data1^+(Data3^ div CentDiv);
               Data2^:=Data2^+(Data3^ div CentDiv);
               Data3^:=0;
            until Addr3>=MemA24[3]+PlayL24;
         end;
      end;

      if (MemA24[3]<>0) and (MemA24[4]<>0) then begin
         { SURROUND LEFT/RIGHT }
         for i:=4 to 5 do if MemA24[i]<>0 then begin
            Addr1:=MemA24[3];
            Addr2:=MemA24[4];
            Addr3:=MemA24[i]+100;
            if (ActWaveOp^.Operator[1] and DLB_NO_OFFSET=DLB_NO_OFFSET) then Addr3:=MemA24[i];
            while Addr3>=MemA24[i]+PlayL24 do Addr3:=Addr3-8;
            repeat
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data2:=ptr(Addr2); Addr2:=Addr2+4;
               Data3:=ptr(Addr3); Addr3:=Addr3+4;
               if i=4 then begin
                  Data1^:=Data3^ div SurrDiv;
                  Data2^:=-Data3^ div SurrDiv;
               end else begin
                  Data1^:=Data3^ div SurrDiv + Data1^;
                  Data2^:=-Data3^ div SurrDiv + Data2^;
                  Data3^:=0;
               end;
            until Addr3>=MemA24[i]+PlayL24;
            if i=4 then while Addr1<MemA24[3]+PlayL24 do begin
               Data1:=ptr(Addr1); Addr1:=Addr1+4;
               Data2:=ptr(Addr2); Addr2:=Addr2+4;
               Data1^:=0;
               Data2^:=0;
            end;
         end;
      end;

      { SUBWOOFER }
      if MemA24[6]<>0 then begin
         Addr1:=MemA24[3];
         Addr2:=MemA24[4];
         Addr3:=MemA24[6];
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data2:=ptr(Addr2); Addr2:=Addr2+4;
            Data3:=ptr(Addr3); Addr3:=Addr3+4;
            Data1^:=(Data3^ div SubDiv) + Data1^;
            Data2^:=(Data3^ div SubDiv) + Data2^;
            Data3^:=0;
         until Addr3>=MemA24[6]+PlayL24;
      end;

      if (ActWaveOp^.Operator[1] and DLB_XQ_MODE=0)
      and (MemA24[1]<>0) and (MemA24[2]<>0)
      and (MemA24[3]<>0) and (MemA24[4]<>0) then begin
         Addr1:=MemA24[1]; Addr2:=MemA24[4];
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data2:=ptr(Addr2); Addr2:=Addr2+4;
            Data1^:=(Data1^+Data2^) div 2;
            Data2^:=0;
         until Addr1>=MemA24[1]+PlayL24;
         Addr1:=MemA24[2]; Addr2:=MemA24[3];
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data2:=ptr(Addr2); Addr2:=Addr2+4;
            Data1^:=(Data1^+Data2^) div 2;
            Data2^:=0;
         until Addr1>=MemA24[2]+PlayL24;
      end;

      if (MemAAlpha[1] or MemAAlpha[3])<>0 then begin {*** ALPHA ***}
         if (MemAAlpha[1]<>0) and (MemAAlpha[2]<>0) then begin
            { LEFT & RIGHT }
            for i:=1 to 2 do if MemAAlpha[i]<>0 then begin
               Addr1:=MemAAlpha[i];
               Addr3:=MemAAlpha[i];
               repeat
                  DataA1:=ptr(Addr1); Addr1:=Addr1+1;
                  DataA3:=ptr(Addr3); Addr3:=Addr3+1;
                  DataA1^:=DataA3^ div SideDiv;
               until Addr3>=MemAAlpha[i]+round(PlayL24/80+0.5);
            end;
            { CENTER }
            if MemAAlpha[3]<>0 then begin
               Addr1:=MemAAlpha[1];
               Addr2:=MemAAlpha[2];
               Addr3:=MemAAlpha[3];
               repeat
                  DataA1:=ptr(Addr1); Addr1:=Addr1+1;
                  DataA2:=ptr(Addr2); Addr2:=Addr2+1;
                  DataA3:=ptr(Addr3); Addr3:=Addr3+1;
                  DataA1^:=DataA1^+(DataA3^ div CentDiv);
                  DataA2^:=DataA2^+(DataA3^ div CentDiv);
                  DataA3^:=0;
               until Addr3>=MemAAlpha[3]+round(PlayL24/80+0.5);
            end;
         end;

         if (MemAAlpha[3]<>0) and (MemAAlpha[4]<>0) then begin
            { SURROUND LEFT/RIGHT }
            for i:=3 to 4 do for j:=0 to 25 do begin
               if j<round(PlayL24/80+0.5) then DataA1:=ptr(MemAAlpha[i]+j);
               DataA1^:=0;
            end;
            for i:=4 to 5 do if MemAAlpha[i]<>0 then begin
               Addr1:=MemAAlpha[3]+5;
               Addr2:=MemAAlpha[4]+5;
               Addr3:=MemAAlpha[i];
               while Addr3>=MemAAlpha[i]+round(PlayL24/80+0.5) do Addr3:=Addr3-8;
               repeat
                  DataA1:=ptr(Addr1); Addr1:=Addr1+1;
                  DataA2:=ptr(Addr2); Addr2:=Addr2+1;
                  DataA3:=ptr(Addr3); Addr3:=Addr3+1;
                  if i=4 then begin
                     DataA1^:=DataA3^ div SurrDiv;
                     DataA2^:=DataA3^ div SurrDiv;
                  end else begin
                     DataA1^:=DataA3^ div SurrDiv + DataA1^;
                     DataA2^:=DataA3^ div SurrDiv + DataA2^;
                     DataA3^:=0;
                  end;
               until Addr3>=MemAAlpha[i]+round((PlayL24-100)/80+0.5);
            end;
            if MemAAlpha[5]<>0 then for i:=3 to 4 do for j:=0 to 10 do begin
               if j<round(PlayL24/80+0.5) then DataA1:=ptr(MemAAlpha[5]+j);
               DataA1^:=0;
            end;
         end;

         { SUBWOOFER }
         if MemAAlpha[6]<>0 then begin
            Addr1:=MemAAlpha[3];
            Addr2:=MemAAlpha[4];
            Addr3:=MemAAlpha[6];
            repeat
               DataA1:=ptr(Addr1); Addr1:=Addr1+1;
               DataA2:=ptr(Addr2); Addr2:=Addr2+1;
               DataA3:=ptr(Addr3); Addr3:=Addr3+1;
               DataA1^:=(DataA3^ div SubDiv) + DataA1^;
               DataA2^:=(DataA3^ div SubDiv) + DataA1^;
               DataA3^:=0;
            until Addr3>=MemAAlpha[6]+round(PlayL24/80+0.5);
         end;

         if (ActWaveOp^.Operator[1] and DLB_XQ_MODE=0)
         and (MemAAlpha[1]<>0) and (MemAAlpha[2]<>0)
         and (MemAAlpha[3]<>0) and (MemAAlpha[4]<>0) then begin
            Addr1:=MemAAlpha[1]; Addr2:=MemAAlpha[4];
            repeat
               DataA1:=ptr(Addr1); Addr1:=Addr1+1;
               DataA2:=ptr(Addr2); Addr2:=Addr2+1;
               DataA1^:=(DataA1^+DataA2^) div 2;
               DataA2^:=0;
            until Addr1>=MemAAlpha[1]+round(PlayL24/80+0.5);
            Addr1:=MemAAlpha[2]; Addr2:=MemAAlpha[3];
            repeat
               DataA1:=ptr(Addr1); Addr1:=Addr1+1;
               DataA2:=ptr(Addr2); Addr2:=Addr2+1;
               DataA1^:=(DataA1^+DataA2^) div 2;
               DataA2^:=0;
            until Addr1>=MemAAlpha[2]+round(PlayL24/80+0.5);
         end;
      end;

      PlayL24:=PlayL24-4;
      Flags:=MDE_READY;
   end;
end;



procedure DEFINEENCODER;

var i   :integer;

begin
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition SURROUND-ENCODER','','','','',
                       80,0,1,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      with ActWaveOp^ do if Operator[1]=-1 then begin
         OpType:=0;   Operator[1]:=0; {DLB_-Mode}
         Operator[2]:=100;            {Dolby-Faktor}
         Operator[3]:=0;              {SpectraFX-Faktor}
      end;
      DKnopf[3]:=Gadget(NIL, 10,41,21,12,GADGHIMAGE+GADGIMAGE,RELVERIFY+TOGGLESELECT,BOOLGADGET,WTImg^.ButtonImg1,WTImg^.ButtonImg2,NIL,0,Nil,3,0);
      DKnopf[4]:=Gadget(NIL,255,41,21,12,GADGHIMAGE+GADGIMAGE,RELVERIFY+TOGGLESELECT,BOOLGADGET,WTImg^.ButtonImg1,WTImg^.ButtonImg2,NIL,0,Nil,4,0);
      if not (ActWaveOp^.Operator[1] and DLB_NO_OFFSET=0) then DKnopf[3].Flags:=DKnopf[3].Flags+SELECTED;
      if not (ActWaveOp^.Operator[1] and DLB_XQ_MODE=0) then DKnopf[4].Flags:=DKnopf[4].Flags+SELECTED;
      if ActiveMode<MD_SURROUND then DKnopf[4].Flags:=DKnopf[4].Flags or GADGDISABLED;
      WRITE( 35,41,2,0,DWindow^,'Suppress Offset');
      WRITE(280,41,2,0,DWindow^,'XQ - Xtended Quality');
      for i:=3 to 4 do AddGadget(DWindow,^DKnopf[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      ActWaveOp^.Operator[1]:=0;
      if not (DKnopf[3].Flags and SELECTED=0) then ActWaveOp^.Operator[1]:=DLB_NO_OFFSET;
      if not (DKnopf[4].Flags and SELECTED=0) then ActWaveOp^.Operator[1]:=ActWaveOp^.Operator[1]+DLB_XQ_MODE;

      if not (DKnopf[3].Flags and SELECTED=0) then ActWaveOp^.OpType:=DLB_NO_OFFSET;
      if not (DKnopf[4].Flags and SELECTED=0) then ActWaveOp^.OpType:=ActWaveOp^.OpType+DLB_XQ_MODE;

      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if ActiveMode<MD_3CH then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'Not enough channels found! You need at least',
                              '3.0-3Channel-Soundmode!','','OK','',
                              0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            Flags:=MDE_ERROR;
         end else if ActiveMode=MD_QUADRO then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'Cant encode Quadro-Sounds!',
                              'Please convert the soundmode to 5.0- or 5.1-Surround!',
                              '','OK','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            Flags:=MDE_ERROR;
         end else begin
            if Flags=MDC_DEFINEIT then DEFINEENCODER
            else if Flags=MDC_DOIT then begin
               Flags:=0;
               WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'SurroundEncoder by QXC','','','','',0,0,0,0,0,NIL);
               MESSAGEHANDLE;
               Valid:=true;
               ENCODE;
            end;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(IntBase);
end.


