// Program Effectmod;

#include <exec/types.h>
#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include <clib/dos_protos.h>
#include <clib/intuition_protos.h>

#include <pragma/all_lib.h>

#include <string.h>

#include </WaveTracer/ModIncl.h>


#define DLB_NO_OFFSET 1
#define DLB_XQ_MODE   2
#define NEGATIVE 3
#define POSITIVE 0

extern void ENCODE(void);
extern void WRITE(UWORD LEdge, UWORD TEdge, UBYTE StPen, UBYTE DMode, Window *Wind, char *txt);
extern void MAKEBORDER(Window *Wind, UWORD LEdge, UWORD TEdge, UWORD REdge, UWORD BEdge, UBYTE Color);

extern struct DOSBase *DOSBase;
struct IntuitionBase  *IntuitionBase;
struct GfxBase        *GfxBase;

struct DPANHeader
   {
   UWORD Version,Frames;
   UBYTE FPS,pad1,pad2,pad3;
   };
struct ANHDHeader
   {
   UBYTE Operation,Mask;
   UWORD w,h,x,y;
   LONG  AbsTime,RelTime;
   UBYTE Interleave,pad0;
   LONG  Bits;
   UBYTE pad[16];
   };

DPANHeader      DPAN={0,0,0,0,0,0};
ANHDHeader      ANHD;



void SENDERROR(char *Fehler)

{
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_TASKREQ;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,Fehler);
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str2,"Operation cancelled!");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str3,"");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str4,"OK");
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str5,"");
MESSAGEHANDLE();
}



void DEFINEENCODER(void)

{
WORD    i;
Window *DWindow;
Gadget *XGadget;
Gadget  DKnopf[2]={NULL,10,41,21,12,GADGHIMAGE+GADGIMAGE,RELVERIFY+TOGGLESELECT,BOOLGADGET,
                   NULL,NULL,NULL,0,NULL,3,0,
                   NULL,255,41,21,12,GADGHIMAGE+GADGIMAGE,RELVERIFY+TOGGLESELECT,BOOLGADGET,
                   NULL,NULL,NULL,0,NULL,4,0};
IntuiMessage *IMsg;
UBYTE   RawCode,GadCode;


MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_OPENDWIN;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"Definition SURROUND-ENCODER");
MyWTStdMsg->WTMsgPrc->PRC_Long1=80;
MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
MyWTStdMsg->WTMsgPrc->PRC_Long3=1;
MESSAGEHANDLE();
if ((MyWTStdMsg->WTMsgPrc->PRC_Long1==-1) || (!MyWTStdMsg->WTMsgPrc->PRC_NewPtr))
   {
   SENDERROR("Couldn't open window!");
   MyWTStdMsg->Flags=MDE_ERROR;
   return;
   }
DWindow=(Window*)MyWTStdMsg->WTMsgPrc->PRC_NewPtr;
if (MyWTStdMsg->ActWaveOp->Operator[0]==-1)
   {
   MyWTStdMsg->ActWaveOp->OpType=0;
   MyWTStdMsg->ActWaveOp->Operator[0]=0;   // DLB_-Mode
   MyWTStdMsg->ActWaveOp->Operator[1]=100; // Dolby-Faktor
   MyWTStdMsg->ActWaveOp->Operator[2]=0;   // SpectraFX-Faktor
   };
DKnopf[0].GadgetRender=MyWTStdMsg->WTImg->ButtonImg1;
DKnopf[0].SelectRender=MyWTStdMsg->WTImg->ButtonImg2;
DKnopf[1].GadgetRender=MyWTStdMsg->WTImg->ButtonImg1;
DKnopf[1].SelectRender=MyWTStdMsg->WTImg->ButtonImg2;
if ((MyWTStdMsg->ActWaveOp->Operator[0] & DLB_NO_OFFSET)==DLB_NO_OFFSET) DKnopf[0].Flags=DKnopf[0].Flags | SELECTED;
if ((MyWTStdMsg->ActWaveOp->Operator[0] & DLB_XQ_MODE)==DLB_XQ_MODE)     DKnopf[1].Flags=DKnopf[1].Flags | SELECTED;
if (MyWTStdMsg->ActiveMode<MD_SURROUND) DKnopf[1].Flags=DKnopf[1].Flags | GADGDISABLED;
WRITE( 35,41,2,0,DWindow,"Suppress Offset");
WRITE(280,41,2,0,DWindow,"XQ - Xtended Quality");
for (i=0; i<2; i++) AddGadget(DWindow,&DKnopf[i],NULL);
RefreshGadgets(DWindow->FirstGadget,DWindow,NULL);
do
   {
   RawCode=0; GadCode=0;
   IMsg=(IntuiMessage*)GetMsg(DWindow->UserPort);
   if (IMsg)
      {
      if ((IMsg->Class==GADGETDOWN) || (IMsg->Class==GADGETUP))
         {
         XGadget=(Gadget*)IMsg->IAddress;
         GadCode=XGadget->GadgetID;
         }
      if (IMsg->Class==RAWKEY) RawCode=IMsg->Code;
      ReplyMsg((Message*)IMsg);
      }
   else Delay(1);

   }
while ((GadCode!=1) && (GadCode!=2) && (RawCode!=68) && (RawCode!=69));
MyWTStdMsg->ActWaveOp->Operator[0]=0;
MyWTStdMsg->ActWaveOp->OpType=0;
if ((DKnopf[0].Flags & SELECTED)==SELECTED) MyWTStdMsg->ActWaveOp->Operator[0]=DLB_NO_OFFSET;
if ((DKnopf[1].Flags & SELECTED)==SELECTED) MyWTStdMsg->ActWaveOp->Operator[0]=MyWTStdMsg->ActWaveOp->Operator[0]+DLB_XQ_MODE;
if ((DKnopf[0].Flags & SELECTED)==SELECTED) MyWTStdMsg->ActWaveOp->OpType=DLB_NO_OFFSET;
if ((DKnopf[1].Flags & SELECTED)==SELECTED) MyWTStdMsg->ActWaveOp->OpType=MyWTStdMsg->ActWaveOp->OpType+DLB_XQ_MODE;
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_LEAVEWIN;
MyWTStdMsg->WTMsgPrc->PRC_Long1=RawCode;
MyWTStdMsg->WTMsgPrc->PRC_Long2=GadCode;
MyWTStdMsg->WTMsgPrc->PRC_NewPtr=DWindow;
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==1) MyWTStdMsg->Flags=MDE_READY else MyWTStdMsg->Flags=MDE_CANCELLED;
}



void main (void)

{
DOSBase=(struct DOSBase*)OpenLibrary("dos.library",39);
GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",39);
IntuitionBase=(struct IntuitionBase*)OpenLibrary("intuition.library",39);
if ((DOSBase) && (GfxBase) && (IntuitionBase))
   {
   if (CREATEPORTS(PORT_EFFECTMOD))
      {
      if (MyWTStdMsg->Version==VERSION_EFFECTMOD)
         {
         if (MyWTStdMsg->ActiveMode<MD_3CH)
            {
            SENDERROR("Not enought channels - you need at least 3.0-3Channel-Soundmode");
            MyWTStdMsg->Flags=MDE_ERROR;
            }
         else if (MyWTStdMsg->ActiveMode==MD_QUADRO)
            {
            SENDERROR("Cant encode Quadro-Sounds - please convert it to 4.0-, 5.0- or 5.1-Surround!");
            MyWTStdMsg->Flags=MDE_ERROR;
            }
         else if (MyWTStdMsg->Flags==MDC_DEFINEIT) DEFINEENCODER();
         else if (MyWTStdMsg->Flags==MDC_DOIT)
            {
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
            strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"SurroundEncoder, ");
            strcat(MyWTStdMsg->WTMsgPrc->PRC_Str1,COPYRIGHT);
            MESSAGEHANDLE();
            MyWTStdMsg->Flags=0;
            MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_RESTOREALPHA;
            MyWTStdMsg->WTMsgPrc->PRC_Long1=MyWTStdMsg->UsedChannels;
            if (MyWTStdMsg->MemA24[5]) MyWTStdMsg->WTMsgPrc->PRC_Long1=MyWTStdMsg->WTMsgPrc->PRC_Long1 | CH_SUB;
            MyWTStdMsg->WTMsgPrc->PRC_Long2=0;
            MyWTStdMsg->WTMsgPrc->PRC_Long3=MyWTStdMsg->PlayL24;
            MESSAGEHANDLE();
            ENCODE();
            }
         else MyWTStdMsg->Flags=MDE_NO_MEMORY;
         MESSAGEHANDLE();
         }
      else
         {
         MyWTStdMsg->Flags=MDE_WRONG_MODULEVERSION;
         MESSAGEHANDLE();
         }
      RemPort(MyPort);
      DeleteMsgPort(MyPort)
      }
   if (DOSBase) CloseLibrary((Library*)DOSBase);
   if (GfxBase) CloseLibrary((Library*)GfxBase);
   if (IntuitionBase) CloseLibrary((Library*)IntuitionBase);   
   }
}

