#include <exec/types.h>

#include <libraries/dos.h>
#include <intuition/intuitionbase.h>

#include <stdlib.h>
#include <string.h>
#include <math.h>

#include </WaveTracer/ModIncl.h>

extern LONG BeginOffset,EndOffset;
extern WTStdMsg *MyWTStdMsg;



void DOSUBNOISE(LONG SAddr)

{
LONG  *Data1;
LONG   Ctr,SFreq,Steps,Addr1,l,VolumeFactor,FadeInOffset,FadeOutOffset;
FLOAT  Stepsize,PeriodSize,FadeVolume,FInStepsize,FOutStepsize;
UBYTE  StepCtr;


if (!SAddr) return;
FadeInOffset=(LONG)(BeginOffset+((MyWTStdMsg->ActWaveOp->Operator[4]/1000.0)*(EndOffset-BeginOffset)));
FadeInOffset=(FadeInOffset/4)*4;
FadeOutOffset=(LONG)(BeginOffset+((MyWTStdMsg->ActWaveOp->Operator[5]/1000.0)*(EndOffset-BeginOffset)));
FadeOutOffset=(FadeOutOffset/4)*4;
VolumeFactor=(LONG)(8388000*(MyWTStdMsg->ActWaveOp->Operator[2]/100.0/(1+MyWTStdMsg->ActWaveOp->Operator[1]-MyWTStdMsg->ActWaveOp->Operator[0])));
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_WORKINFO;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"");
FadeVolume=0;
FInStepsize=4000.0/(FadeInOffset-BeginOffset);
FOutStepsize=4000.0/(EndOffset-FadeOutOffset);
Ctr=MyWTStdMsg->ActWaveOp->Operator[0];
SFreq=(LONG)(10000000/(MyWTStdMsg->SRate*2.79365));
PeriodSize=(FLOAT)SFreq/Ctr;
StepCtr=0;
do
   {
   StepCtr++;
   #ifdef __PPC__
      if (StepCtr>=100)
   #else
      if (StepCtr>=10)
   #endif;
      {
      StepCtr=0;
      MESSAGEHANDLE();
      if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
         {
         MyWTStdMsg->Flags=MDE_CANCELLED;
         return;
         }
      }
   Stepsize=6.2831852/PeriodSize;
   Steps=Ctr*Ctr+13;
   Addr1=SAddr+BeginOffset;
   do
      {
      Data1=(LONG*)(Addr1); Addr1=Addr1+4;
      if (MyWTStdMsg->ActWaveOp->OpType==1) //*** SLOW-Mode ***
         {
         l=Addr1-SAddr;
         if ((l>=BeginOffset) && (l<=FadeInOffset))
            {
            FadeVolume=FadeVolume+FInStepsize;
            *Data1=*Data1+(LONG)(VolumeFactor*(FadeVolume/1000.0*sin(Stepsize*Steps)));
            }
         else if ((l>=FadeOutOffset) && (l<=EndOffset))
            {
            FadeVolume=FadeVolume-FOutStepsize;
            *Data1=*Data1+(LONG)(VolumeFactor*(FadeVolume/1000.0*sin(Stepsize*Steps)));
            }
         else *Data1=*Data1+(LONG)(VolumeFactor*(sin(1.0*Stepsize*Steps)));
         }
      else *Data1=*Data1+(LONG)(VolumeFactor*(sin(1.0*Stepsize*Steps))); //*** FAST-Mode ***
      Steps++;
      }
   while (Addr1<SAddr+EndOffset);
   Ctr++;
   PeriodSize=(FLOAT)SFreq/Ctr;
   }
while ((Ctr<=MyWTStdMsg->ActWaveOp->Operator[1]) && (PeriodSize>2));
}


