#include <exec/types.h>

#include <libraries/dos.h>
#include <intuition/intuitionbase.h>

#include <stdlib.h>
#include <string.h>
#include <math.h>

#include </WaveTracer/ModIncl.h>

extern BOOL Valid;
extern LONG BeginOffset,EndOffset,l;
extern WTStdMsg *MyWTStdMsg;



void DOSUBNOISE(LONG SAddr)

{
LONG  *Data1;
LONG   Addr1;
LONG   fu,fo,oldfo,IntData,CalcData,FadeInOffset,FadeOutOffset;
FLOAT  FInStepSize,FOutStepSize,FadeVolume,SampleFreq,VolumeFactor;
WORD   StepCtr;

if (!SAddr) return;
SampleFreq=10000000/(MyWTStdMsg->SRate*2.79365);
fu=(LONG)((MAX24*2.0)/SampleFreq*(MyWTStdMsg->ActWaveOp->Operator[0]/10));
fo=(LONG)((MAX24*2.0)/SampleFreq*(MyWTStdMsg->ActWaveOp->Operator[1]/10));
oldfo=fo;
if (MyWTStdMsg->ActWaveOp->Operator[2]==100)
   {
   return
   }
else if (MyWTStdMsg->ActWaveOp->Operator[2]>100)
 VolumeFactor=(MyWTStdMsg->ActWaveOp->Operator[2]-100)/100.0
else if (MyWTStdMsg->ActWaveOp->Operator[2]<100)
 VolumeFactor=(100-MyWTStdMsg->ActWaveOp->Operator[2])/100.0;
FadeInOffset=(LONG)(BeginOffset+((MyWTStdMsg->ActWaveOp->Operator[4]/1000.0)*(EndOffset-BeginOffset)));
FadeInOffset=(FadeInOffset/4)*4;
FadeOutOffset=(LONG)(BeginOffset+((MyWTStdMsg->ActWaveOp->Operator[5]/1000.0)*(EndOffset-BeginOffset)));
FadeOutOffset=(FadeOutOffset/4)*4;

MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
strcpy(MyWTStdMsg->WTMsgPrc->PRC_Str1,"");

FadeVolume=0;
FInStepSize=4000/(FLOAT)(FadeInOffset-BeginOffset);
FOutStepSize=4000/(FLOAT)(EndOffset-FadeOutOffset);
IntData=0; StepCtr=1; Addr1=SAddr+BeginOffset;
CalcData=0;
do
   {
   do
      {
      StepCtr++;
      Data1=(LONG*)Addr1; Addr1=Addr1+4;
      if (((IntData>0) && (*Data1<=0)) || ((IntData<0) && (*Data1>=0)))
         {
         if (abs(*Data1-IntData)>fo)
            {
            if (oldfo*5>fo) fo=(LONG)(fo*1.1)
            }
         else fo=oldfo;
         }
      if (abs(*Data1-IntData)>fo)
         {
         if (*Data1<IntData) CalcData=IntData-fo else CalcData=IntData+fo;
         }
      else if ((abs(*Data1-IntData)>=1) && (abs(*Data1-IntData)<fu))
         {
         if (*Data1<IntData) CalcData=IntData-fu else CalcData=IntData+fu;
         }
      else CalcData=*Data1;
      IntData=CalcData;
      CalcData=(IntData+CalcData)/2;
      if (MyWTStdMsg->ActWaveOp->OpType==1) //*** SLOW-Mode ***
         {
         l=Addr1-SAddr;
         if ((l>=BeginOffset) && (l<=FadeInOffset)) FadeVolume=FadeVolume+FInStepSize
         else if ((l>=FadeOutOffset) && (l<=EndOffset)) FadeVolume=FadeVolume-FOutStepSize;
         if ((l>=FadeInOffset) && (l<=FadeOutOffset))
            {
            if (MyWTStdMsg->ActWaveOp->Operator[2]>100) *Data1=*Data1+(LONG)(CalcData*VolumeFactor)
            else *Data1=*Data1-(LONG)(CalcData*VolumeFactor);
            }
         else
            {
            if (MyWTStdMsg->ActWaveOp->Operator[2]>100) *Data1=*Data1+(LONG)(CalcData/1000*VolumeFactor*FadeVolume)
            else *Data1=*Data1-(LONG)(CalcData/1000.0*VolumeFactor*FadeVolume);
            }
         }
      else                                 //*** FAST-Mode ***
         {
         if (MyWTStdMsg->ActWaveOp->Operator[2]>100) *Data1=*Data1+(LONG)(CalcData*VolumeFactor)
         else *Data1=*Data1-(LONG)(CalcData*VolumeFactor);
         }
      }
   #ifdef __PPC__
      while (!((Addr1>=SAddr+EndOffset) || (StepCtr>=10000)));
      if (StepCtr>=10000)
   #else
      while (!((Addr1>=SAddr+EndOffset) || (StepCtr>=1000)));
      if (StepCtr>=1000)
   #endif
      {
      StepCtr=0;
      MESSAGEHANDLE();
      if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
         {
         Valid=FALSE;
         MyWTStdMsg->Flags=MDE_CANCELLED;
         return
         }
      }
   }
while(!(Addr1>=SAddr+EndOffset))
}

