#include <exec/types.h>

#include <intuition/gadgetclass.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/dos_protos.h>

#include <pragma/exec_lib.h>
#include <pragma/intuition_lib.h>
#include <pragma/gadtools_lib.h>
#include <pragma/all_lib.h>

#include <string.h>

#include </WaveTracer/WTIncl.h>

#define Project0_CNT 7

extern struct Library *IntuitionBase;
extern struct Library *GadToolsBase;
extern struct Window  *DWindow;

WaveOp                *ActWaveOp;
APTR                   VisualInfo = NULL;
Screen                *MyScreen;
struct Gadget         *Project0GList = NULL;
struct Gadget         *Project0Gadgets[7];

extern struct Gadget     *FastKnopf;
extern struct Gadget     *Schieber[3],*TextGad[3];

UWORD Project0GTypes[] = {
	SLIDER_KIND,
	SLIDER_KIND,
	SLIDER_KIND,
	INTEGER_KIND,
	INTEGER_KIND,
	INTEGER_KIND,
	CHECKBOX_KIND
};

struct NewGadget Project0NGad[] = {
	6,  78, 320, 17, NULL, NULL, 3, 0, NULL, NULL,
	6,  97, 320, 17, NULL, NULL, 5, 0, NULL, NULL,
	6, 116, 320, 17, NULL, NULL, 7, 0, NULL, NULL,

	334, 78, 60, 17, (UBYTE *)"Hz  Lower Frequency", NULL, 4, PLACETEXT_RIGHT, NULL, NULL,
	334, 97, 60, 17, (UBYTE *)"Hz  Upper Frequency", NULL, 6, PLACETEXT_RIGHT, NULL, NULL,
	334,116, 60, 17, (UBYTE *)"% Amplification", NULL, 8, PLACETEXT_RIGHT, NULL, NULL,
	
	6, 200, 21, 12, (UBYTE *)"FastMode", NULL, 101, PLACETEXT_RIGHT, NULL, NULL
};



ULONG Project0GTags[] = {
	(GTSL_Min),1, (GTSL_Max),250, (PGA_Freedom),LORIENT_HORIZ, (GA_RelVerify),TRUE, (TAG_DONE),
	(GTSL_Min),1, (GTSL_Max),250, (PGA_Freedom),LORIENT_HORIZ, (GA_RelVerify),TRUE, (TAG_DONE),
	(GTSL_Min),1, (GTSL_Max),1000, (PGA_Freedom),LORIENT_HORIZ, (GA_RelVerify),TRUE, (TAG_DONE),
	(GTIN_MaxChars),10, (TAG_DONE),
	(GTIN_MaxChars),10, (TAG_DONE),
	(GTIN_MaxChars),10, (TAG_DONE),
	(GTCB_Scaled),TRUE, (TAG_DONE)};



int SetupScreen( void )

{
if (!(VisualInfo=GetVisualInfo(MyScreen,TAG_DONE))) return(2L);
return( 0L );
}



void CloseDownScreen( void )
{
if ( VisualInfo ) 
   {
   FreeVisualInfo( VisualInfo );
   VisualInfo = NULL;
   }
}



int OpenProject0Window( void )

{
struct NewGadget	ng;
struct Gadget	*g;
UWORD		lc, tc;
UWORD		offx = MyScreen->WBorLeft, offy = MyScreen->WBorTop + MyScreen->RastPort.TxHeight + 1;

if ( ! ( g = CreateContext( &Project0GList ))) return( 1L );
for( lc = 0, tc = 0; lc < Project0_CNT; lc++ ) 
   {
   CopyMem((char * )&Project0NGad[ lc ], (char * )&ng, (long)sizeof( struct NewGadget ));
   ng.ng_VisualInfo = VisualInfo;
   ng.ng_TextAttr   = MyScreen->Font;
   ng.ng_LeftEdge  += offx;
   ng.ng_TopEdge   += offy;
   Project0Gadgets[ lc ] = g = CreateGadgetA((ULONG)Project0GTypes[ lc ], g, &ng, ( struct TagItem * )&Project0GTags[ tc ] );
   while( Project0GTags[ tc ] ) tc += 2;
   tc++;
   if ( NOT g ) return( 2L );
	}
AddGList(DWindow,Project0GList,NULL,0,NULL);
RefreshGList(DWindow->FirstGadget,DWindow,NULL,NULL);
return( 0L );
}



void CloseProject0Window( void )
{
RemoveGList(DWindow,DWindow->FirstGadget,NULL);
if (Project0GList)
   {
   FreeGadgets( Project0GList );
   Project0GList = NULL;
   }
}



BOOL OpenGUI(Screen *XScreen, WaveOp *XWaveOp)

{
MyScreen=XScreen;
ActWaveOp=XWaveOp;
if (SetupScreen()==0) 
   {
   if (OpenProject0Window()==0) 
      {
      Schieber[0]=Project0Gadgets[0];
      Schieber[1]=Project0Gadgets[1];
      Schieber[2]=Project0Gadgets[2];
      GT_SetGadgetAttrs(Schieber[0],DWindow,NULL,(GTSL_Level),ActWaveOp->Operator[0],TAG_DONE);
      GT_SetGadgetAttrs(Schieber[1],DWindow,NULL,(GTSL_Level),ActWaveOp->Operator[1],TAG_DONE);      
      GT_SetGadgetAttrs(Schieber[2],DWindow,NULL,(GTSL_Level),ActWaveOp->Operator[2],TAG_DONE);
      TextGad[0]=Project0Gadgets[3];
      TextGad[1]=Project0Gadgets[4];
      TextGad[2]=Project0Gadgets[5];
      GT_SetGadgetAttrs(TextGad[0],DWindow,NULL,(GTIN_Number),ActWaveOp->Operator[0],TAG_DONE);
      GT_SetGadgetAttrs(TextGad[1],DWindow,NULL,(GTIN_Number),ActWaveOp->Operator[1],TAG_DONE);
      GT_SetGadgetAttrs(TextGad[2],DWindow,NULL,(GTIN_Number),ActWaveOp->Operator[2],TAG_DONE);
      FastKnopf=Project0Gadgets[7];
      return(TRUE)
      }
   else return FALSE;
   }
else return FALSE;
}



void CloseGUI(void)

{
CloseProject0Window();
CloseDownScreen();
};
