#include <exec/types.h>
#ifdef __PPC__
   #include <clib/powerpc_protos.h>
   extern PowerPCBase;
#else
   #include <exec/memory.h>
   #include <clib/exec_protos.h>
#endif

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include </WaveTracer/WTIncl.h>

//#include <stdlib.h>

extern void MESSAGEHANDLE(void);

extern WTStdMsg *MyWTStdMsg;
extern LONG BeginOffset,EndOffset;
extern BOOL Valid;



void DOSHIFT(LONG SAddr)

{
LONG   StartAddr,EndAddr,Addr1,Addr2,LastAmp,MinDiff;
LONG  *Data1,*Data2;
WORD   i;
BOOL   FullPeriod,UpPeriod;
FLOAT  Factor,StepOffset;


if (!SAddr) return;
Factor=((10000000.0/(MyWTStdMsg->SRate*2.79365))/MyWTStdMsg->ActWaveOp->Operator[1]);
if (Factor>1) MinDiff=(LONG)((1000000.0/(MyWTStdMsg->SRate*2.79365))/10)*4
 else MinDiff=(LONG)((1000000.0/(MyWTStdMsg->SRate*2.79365))/10)*12;
FullPeriod=FALSE;
StartAddr=SAddr+BeginOffset; EndAddr=SAddr+BeginOffset;
Addr1=SAddr+BeginOffset;     Addr2=SAddr+BeginOffset;
Data1=(LONG*)Addr1;   LastAmp=*Data1;
Data2=(LONG*)Addr1+4;
#ifdef __PPC__
   i=1000;
#else
   i=100;
#endif;
if (*Data2>*Data1)
   {
   LastAmp=1;  UpPeriod=TRUE;
   }
else
   {
   LastAmp=-1; UpPeriod=FALSE;
   }
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
do
   {
   EndAddr=EndAddr+4; Data1=(LONG*)EndAddr;
   if (((*Data1<=0) && (LastAmp>0) && (!UpPeriod)) ||
       ((*Data1>=0) && (LastAmp<-0) && (UpPeriod)))
      {
      if (EndAddr-Addr1>MinDiff)
         {
         FullPeriod=TRUE; Addr1=StartAddr;
         }
      }
   LastAmp=*Data1;
   if (EndAddr>=SAddr+EndOffset) FullPeriod=TRUE;
   if ((FullPeriod) && (EndAddr-StartAddr<16)) FullPeriod=FALSE;
   if (FullPeriod)
      {
      if (Factor>1)
         {
         Addr1=StartAddr;
         StepOffset=0;
         do
            {
            Addr1=Addr1+4;                Data1=(LONG*)Addr1;
            StepOffset=StepOffset+Factor; Data2=(LONG*)(StartAddr+(LONG)(StepOffset)*4);
            *Data1=*Data2;
            }
         while ((StartAddr+(LONG)(StepOffset)*4<EndAddr) && (Addr1<SAddr+EndOffset));
         Addr2=StartAddr;
         do
            {
            Addr1=Addr1+4; Data1=(LONG*)Addr1;
            Addr2=Addr2+4; Data2=(LONG*)Addr2;
            *Data1=*Data2;
            }
         while ((Addr1<=EndAddr) && (Addr1<SAddr+EndOffset) && (Addr2<SAddr+EndOffset));
         StartAddr=EndAddr; FullPeriod=FALSE;
         }
      else
         {
         Addr1=StartAddr+(LONG)((EndAddr-StartAddr)/4.0*Factor)*4;
         Addr2=EndAddr;
         StepOffset=0;
         do
            {
            Data1=(LONG*)(Addr1-(LONG)(StepOffset)*4); StepOffset=StepOffset+Factor;
            Data2=(LONG*)Addr2;                        Addr2=Addr2-4;
            *Data2=*Data1;
            }
         while (((LONG)(StepOffset)*4<EndAddr-StartAddr) && (Addr2>StartAddr));
         StartAddr=EndAddr; FullPeriod=FALSE;
         }
      i++;
      if (i>100)
         {
         i=0;
         MESSAGEHANDLE();
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
            {
            Valid=FALSE;
            return;
            }
         }
      }
   }
while ((Addr1<SAddr+EndOffset) && (Addr2<SAddr+EndOffset) && (EndAddr<SAddr+EndOffset));
if ((Addr2<SAddr+EndOffset) && (EndOffset<MyWTStdMsg->PlayL24))
   {
   #ifdef __PPC__
      CopyMemPPC((APTR)(SAddr+EndOffset),(APTR)Addr2,MyWTStdMsg->PlayL24-EndOffset);
   #else
      CopyMem((APTR)(SAddr+EndOffset),(APTR)Addr2,MyWTStdMsg->PlayL24-EndOffset);
   #endif
   Addr2=Addr2+(MyWTStdMsg->PlayL24-EndOffset);
   }
while (Addr2<SAddr+MyWTStdMsg->PlayL24)
   {
   Data1=(LONG*)Addr2; Addr2=Addr2+4;
   *Data1=0;
   }
};

