Program Effectmod;

USES Intuition,Graphics,ExecIO;

type BPTR=long;

{$incl "exec/memory.h"}
{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
       "EffIncl.mod"}

var DWindow                             :^Window;

var XGadget                             :^Gadget;
var Schieber,Textgad                    :array [1..2] of Gadget;
var SImage                              :array [1..2] of Image;
var SchieberInfo                        :array [1..2] of PropInfo;
var TextInfo                            :array [1..2] of StringInfo;
var Buffer,UndoBuffer                   :array [1..2] of string[20];

var IMsg                                :^IntuiMessage;
var RawCode,GadCode,ChID,ChBit,GCnt     :byte;
var i,j                                 :integer;
var l,BeginOffset,EndOffset             :long;
var Valid                               :boolean;


procedure DOSHIFT(SAddr :long);

var StartAddr,EndAddr,Addr1,Addr2       :long;
var Data1,Data2                         :^long;
var i                                   :integer;
var LastAmp,MinDiff                     :long;
var FullPeriod,UpPeriod                 :boolean;
var Factor,StepOffset                   :real;

begin
   if (SAddr=0) then exit;
   Factor:=((10000000/(MyWTStdMsg^.SRate*2.79365))/MyWTStdMsg^.ActWaveOp^.Operator[2]);
   with MyWTStdMsg^ do begin
      if Factor>1 then MinDiff:=round((1000000/(SRate*2.79365))/10)*4
      else MinDiff:=round((1000000/(SRate*2.79365))/10)*12;
      FullPeriod:=false;
      StartAddr:=SAddr+BeginOffset; EndAddr:=SAddr+BeginOffset;
      Addr1:=SAddr+BeginOffset;     Addr2:=SAddr+BeginOffset;
      Data1:=ptr(Addr1);   LastAmp:=Data1^;
      Data2:=ptr(Addr1+4);
      i:=500;
      if Data2^>Data1^ then begin
         LastAmp:=1;
         UpPeriod:=true
      end else begin
         UpPeriod:=false;
         LastAmp:=-1;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPRC(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      repeat
         EndAddr:=EndAddr+4; Data1:=ptr(EndAddr);
         if ((Data1^<=0) and (LastAmp>0) and not UpPeriod) or
            ((Data1^>=0) and (LastAmp<-0) and UpPeriod) then begin
            if EndAddr-Addr1>MinDiff then begin
               FullPeriod:=true; Addr1:=StartAddr;
            end;
         end;
         LastAmp:=Data1^;
         if EndAddr>=SAddr+EndOffset then FullPeriod:=true;
         if FullPeriod and (EndAddr-StartAddr<16) then FullPeriod:=false;
         if FullPeriod then begin
            if Factor>1 then begin
               Addr1:=StartAddr;
               StepOffset:=0;
               repeat
                  Addr1:=Addr1+4;                Data1:=ptr(Addr1);
                  StepOffset:=StepOffset+Factor; Data2:=Ptr(StartAddr+round(StepOffset)*4);
                  Data1^:=Data2^;
               until (StartAddr+round(StepOffset)*4>EndAddr) or (Addr1>=SAddr+EndOffset);
               Addr2:=StartAddr;
               repeat
                  Addr1:=Addr1+4; Data1:=ptr(Addr1);
                  Addr2:=Addr2+4; Data2:=Ptr(Addr2);
                  Data1^:=Data2^;
               until (Addr1>EndAddr) or (Addr1>=SAddr+EndOffset)
               or (Addr2>=SAddr+EndOffset);
               StartAddr:=EndAddr; FullPeriod:=false;
            end else begin
               Addr1:=StartAddr+round((EndAddr-StartAddr)/4*Factor)*4;
               Addr2:=EndAddr;
               StepOffset:=0;
               repeat
                  Data1:=ptr(Addr1-round(StepOffset)*4); StepOffset:=StepOffset+Factor;
                  Data2:=ptr(Addr2);                     Addr2:=Addr2-4;
                  Data2^:=Data1^;
               until (round(StepOffset)*4>=EndAddr-StartAddr) or (Addr2<=StartAddr);
               StartAddr:=EndAddr; FullPeriod:=false;
            end;
            i:=i+1;
            if i>100 then begin
               i:=0;
               MESSAGEHANDLE;
               if WTMsgPrc^.PRC_Long1=-1 then begin
                  Valid:=false;
                  exit;
               end;
            end;
         end;
      until (Addr1>=SAddr+EndOffset) or (Addr2>=SAddr+EndOffset)
      or (EndAddr>=SAddr+EndOffset);
      if (Addr2<SAddr+EndOffset) and (EndOffset<PlayL24) then begin
         CopyMem(SAddr+EndOffset,Addr2,PlayL24-EndOffset);
         Addr2:=Addr2+(PlayL24-EndOffset);
      end;
      if Addr2<SAddr+PlayL24 then repeat
         Data1:=ptr(Addr2); Addr2:=Addr2+4;
         Data1^:=0;
      until Addr2>=SAddr+PlayL24;
   end;
end;



procedure DEFINESHIFT;

var s   :string[100];


procedure WRITEFACTOR;

begin
   s:=realstr((10000000/(MyWTStdMsg^.SRate*2.79365))/MyWTStdMsg^.ActWaveOp^.Operator[2],4);
   SetAPen(Dwindow^.RPort,0); RectFill(DWindow^.RPort,409,125,480,135);
   WRITE(409,125,2,0,DWindow^,s);
end;


begin
   with MyWTStdMsg^ do begin
      with ActWaveOp^ do begin
         Channels:=UsedChannels;
         if Operator[1]=-1 then Operator[1]:=SRate;
         if Operator[2]=-1 then Operator[2]:=round(10000000/(SRate*2.79365));
      end;

      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition PITCHSHIFT','','','','',145,0,3,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      WTMsgPrc^:=MsgPrc(WTM_SETCHANNELGADS,'','','','','',Activemode,ActWaveOp^.Channels,0,0,0,NIL);
      MESSAGEHANDLE;
      for i:=1 to 2 do begin
         SImage[i]:=WTImg^.KnobImg^;
         Schieber[i]:=Gadget(NIL,80,65+i*20 ,320,15,GADGHCOMP+GADGIMAGE,$83,PROPGADGET,
                      ^SImage[i],NIL,Nil,0,^SchieberInfo[i],i+2,0);
         SchieberInfo[i]:=Propinfo(FREEHORIZ,ActWaveOp^.Operator[i],0,1,0,0,0,0,0,0,0);
         TextGad[i]:=Gadget(Nil,410,66+i*20,42,15,GADGHCOMP,_LONGINT+STRINGCENTER+$1,STRGADGET,NIL,Nil,Nil,0,^TextInfo[i],i+4,0);
         MAKEBORDER(DWindow^,409,65+i*20,452,79+i*20,NEGATIVE);
         TextInfo[i]:=StringInfo(^Buffer[i],^Undobuffer[i],0,7,0,0,0,0,0,0,Nil,0,Nil);
         Buffer[i]:=intstr(ActWaveOp^.Operator[i]); UndoBuffer[i]:='';
      end;
      s:=intstr(SRate);                                 WRITE(40,87,2,3,DWindow^,s);
      s:=intstr(round(10000000/(SRate*2.79365)))+' Hz'; WRITE(40,107,2,3,DWindow^,s);
      WRITE(460,85,2,0,DWindow^,'Samplerate');
      WRITE(460,105,2,0,DWindow^,'Samplefrequency');
      WRITE(333,125,2,0,DWindow^,'Pitch-Factor:');
      WRITEFACTOR;

      for i:=1 to 2 do AddGadget(DWindow,^TextGad[i],NIL);
      for i:=1 to 2 do AddGadget(DWindow,^Schieber[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         if GadCode in [3..6] then begin
            GCnt:=0;
            repeat
               if (GadCode in [3,5]) and (GCnt<2) then begin
                  while (GadCode=3) or not (Schieber[1].flags and SELECTED=0) do begin
                     ActWaveOp^.Operator[1]:=SchieberInfo[1].HorizPot;
                     if ActWaveOp^.Operator[1]<1 then ActWaveOp^.Operator[1]:=1;
                     if ActWaveOp^.Operator[1]>65535 then ActWaveOp^.Operator[1]:=65535;
                     Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
                     RefreshGadgets(^TextGad[1],DWindow,NIL);
                     GadCode:=6;
                  end;
                  if GadCode=5 then begin
                     val(Buffer[1],ActWaveOp^.Operator[1],j);
                     if ActWaveOp^.Operator[1]<1 then ActWaveOp^.Operator[1]:=1;
                     if ActWaveOp^.Operator[1]>65535 then ActWaveOp^.Operator[1]:=65535;
                     Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
                     SchieberInfo[1].HorizPot:=ActWaveOp^.Operator[1];
                     RefreshGadgets(^Schieber[1],DWindow,NIL);
                  end;
                  GCnt:=GCnt+1;
                  if GCnt<2 then begin
                     Buffer[2]:=intstr(round(10000000/(ActWaveOp^.Operator[1]*2.79365)));
                     GadCode:=6;
                  end;
               end;

               if (GadCode in [4,6]) and (GCnt<2) then begin
                  while (GadCode=4) or not (Schieber[2].flags and SELECTED=0) do begin
                     ActWaveOp^.Operator[2]:=SchieberInfo[2].HorizPot;
                     if ActWaveOp^.Operator[2]<1 then ActWaveOp^.Operator[2]:=1;
                     if ActWaveOp^.Operator[2]>65535 then ActWaveOp^.Operator[2]:=65535;
                     Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
                     RefreshGadgets(^TextGad[2],DWindow,NIL);
                     GadCode:=5;
                  end;
                  if GadCode=6 then begin
                     val(Buffer[2],ActWaveOp^.Operator[2],j);
                     if ActWaveOp^.Operator[2]<1 then ActWaveOp^.Operator[2]:=1;
                     if ActWaveOp^.Operator[2]>65535 then ActWaveOp^.Operator[2]:=65535;
                     Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
                     SchieberInfo[2].HorizPot:=ActWaveOp^.Operator[2];
                     RefreshGadgets(^Schieber[2],DWindow,NIL);
                  end;
                  GCnt:=GCnt+1;
                  if GCnt<2 then begin
                     Buffer[1]:=intstr(round(10000000/(ActWaveOp^.Operator[2]*2.79365)));
                     GadCode:=5;
                  end;
               end;
               WRITEFACTOR;
            until GCnt>=2
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      WTMsgPrc^:=MsgPrc(WTM_GETCHANNELGADS,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      ActWaveOp^.Channels:=WTMsgPrc^.PRC_Long1;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINESHIFT
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'PitchShift, '+COPYRIGHT,'','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            WTMsgPrc^:=MsgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            Valid:=true;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if Valid and ((ActWaveOp^.Channels and ChBit)=ChBit) then
                DOSHIFT(MemA24[ChID]);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.

