#include <exec/types.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include </WaveTracer/WTIncl.h>
#include </WaveTracer/ModIncl.h>

#include <stdlib.h>

extern BOOL   Valid;
extern UBYTE  ChID,ChBit;
extern LONG   BeginOffset,EndOffset,WaveMaxAmp,AlphaMaxAmp;
extern struct WTStdMsg *MyWTStdMsg;



void DOAMP(LONG SAddr)

{
LONG   StartAddr,EndAddr,Addr1,MaxAmp,LastAmp;
LONG  *Data1;
BOOL   FullPeriod;
WORD   i;
FLOAT  Factor;


if (SAddr)
   {
   StartAddr=SAddr+BeginOffset; EndAddr=StartAddr; Addr1=StartAddr;
   FullPeriod=FALSE;
   MaxAmp=1;
   Data1=(LONG*)StartAddr; LastAmp=*Data1;
   i=0;
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
   do
      {
      EndAddr=EndAddr+4; Data1=(LONG*)EndAddr;
      if (labs(*Data1)>MaxAmp) MaxAmp=labs(*Data1);
      if (((*Data1<=0) && (LastAmp>0)) || ((*Data1>=0) && (LastAmp<0)))
         {
         FullPeriod=TRUE;
         Addr1=StartAddr;
         }
      LastAmp=*Data1;
      if (FullPeriod)
         {
         Addr1=StartAddr+4; Factor=8388000.0/MaxAmp;
         if (Factor>3) Factor=3;
         if (!(Factor==1)) do
            {
            Data1=(LONG*)Addr1; Addr1=Addr1+4;
            *Data1=(LONG)(*Data1*1.0*Factor);
            }
         while ((Addr1<EndAddr) && (Addr1<SAddr+EndOffset));
         EndAddr=EndAddr+4; StartAddr=EndAddr;
         FullPeriod=FALSE; MaxAmp=1;
         i++;
         #ifdef __PPC__
            if (i>10000)
         #else
            if (i>1000)
         #endif
            {
            i=0;
            MESSAGEHANDLE();
            if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
               {
               Valid=FALSE;
               return;
               }
            }
         }
      }
   while ((Addr1<SAddr+EndOffset) && (StartAddr<SAddr+EndOffset) && (EndAddr<SAddr+EndOffset));
   }
}
