#include <exec/types.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include </WaveTracer/WTIncl.h>
#include </WaveTracer/ModIncl.h>

#include <stdlib.h>

extern BOOL   Valid;
extern UBYTE  ChID,ChBit;
extern LONG   BeginOffset,EndOffset,WaveMaxAmp,AlphaMaxAmp;
extern struct WTStdMsg *MyWTStdMsg;



void SCANAMPLITUDE(LONG SAddr, LONG AlphaSAddr)

{
LONG   Addr1;
LONG  *Data1;
UBYTE *DataA1;
WORD   i;


if (SAddr)
   {
   Addr1=SAddr+BeginOffset;
   i=0;
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
   do
      {
      if (Addr1<SAddr+EndOffset) do
         {
         Data1=(LONG*)Addr1; Addr1=Addr1+4;
         if (labs(*Data1)>WaveMaxAmp) WaveMaxAmp=labs(*Data1);
         i++;
         }
      #ifdef __PPC__
         while ((Addr1<SAddr+EndOffset) && (i<40000));
      #else
         while ((Addr1<SAddr+EndOffset) && (i<4000));
      #endif
      i=0;
      MESSAGEHANDLE();
      if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
         {
         Valid=FALSE;
         return;
         }
      }
   while (Addr1<SAddr+EndOffset);
   if (AlphaSAddr)
      {
      Addr1=AlphaSAddr+(LONG)(BeginOffset/80+0.5);
      do
         {
         do
            {
            DataA1=(UBYTE*)Addr1; Addr1++;
            if (*DataA1>AlphaMaxAmp) AlphaMaxAmp=*DataA1;
            i++;
            }
         #ifdef __PPC__
            while ((Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5)) && (i<40000));
         #else
            while ((Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5)) && (i<4000));
         #endif
         i=0;
         MESSAGEHANDLE();
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
            {
            Valid=FALSE;
            return;
            }
         }
      while (Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5));
      }
   }
}



void MAXAMPLITUDE(LONG SAddr, LONG AlphaSAddr)

{
LONG   Addr1;
LONG  *Data1;
UBYTE *DataA1;
WORD   i;
FLOAT  Factor;


if (SAddr)
   {
   Addr1=SAddr+BeginOffset;
   i=0;
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
   if ((WaveMaxAmp>32) && (WaveMaxAmp<=MAX24-100))
      {
      Addr1=SAddr+BeginOffset;
      Factor=1.0*(MAX24/WaveMaxAmp);
      do
         {
         if (Addr1<SAddr+EndOffset) do
            {
            Data1=(LONG*)Addr1; Addr1=Addr1+4;
            *Data1=(LONG)(*Data1*Factor);
            i++;
            }
         #ifdef __PPC__
            while ((Addr1<SAddr+EndOffset) && (i<40000));
         #else
            while ((Addr1<SAddr+EndOffset) && (i<4000));
         #endif
         i=0;
         MESSAGEHANDLE();
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
            {
            Valid=FALSE;
            return;
            }
         }
      while (Addr1<SAddr+EndOffset);
      }
   if ((AlphaSAddr) && (AlphaMaxAmp<255))
      {
      Addr1=AlphaSAddr+(LONG)(BeginOffset/80+0.5);
      Addr1=AlphaSAddr+(LONG)(BeginOffset/80+0.5);
      Factor=255.0/AlphaMaxAmp;
      do
         {
         do
            {
            DataA1=(UBYTE*)Addr1; Addr1++;
            *DataA1=(UBYTE)(*DataA1*1.0*Factor);
            i++;
            }
         #ifdef __PPC__
            while ((Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5)) && (i<40000));
         #else
            while ((Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5)) && (i<4000));
         #endif
         i=0;
         MESSAGEHANDLE();
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
            {
            Valid=FALSE;
            return;
            }
         }
      while (Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5));
      }
   }
}


