#include <exec/types.h>

#include <intuition/intuitionbase.h>
#include <libraries/dos.h>

#include </WaveTracer/WTIncl.h>

//#include <stdlib.h>

extern void MESSAGEHANDLE(void);

extern WTStdMsg *MyWTStdMsg;
extern BOOL Valid;



void DOOFFSET(LONG SAddr, LONG AlphaSAddr, UBYTE Step)

{
LONG   Offset,Addr1,Addr2;
LONG  *Data1,*Data2;
UBYTE *DataA1,*DataA2;

if (!SAddr) return;
MyWTStdMsg->Flags=0;
MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
   {
   Valid=FALSE;
   return;
   };
Offset=MyWTStdMsg->ActWaveOp->Operator[Step]*4;
if (Offset==0) return;
Addr1=SAddr+MyWTStdMsg->MemL24;
Addr2=Addr1-Offset;
do
   {
   Addr1=Addr1-4; Data1=(LONG*)Addr1;
   Addr2=Addr2-4; Data2=(LONG*)Addr2;
   *Data1=*Data2;
   }
while (Addr2>SAddr);
do
   {
   Addr1=Addr1-4; Data1=(LONG*)Addr1;
   *Data1=0;
   }
while (Addr1>SAddr);
if (!AlphaSAddr) return;
MESSAGEHANDLE();
if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
   {
   Valid=FALSE;
   return;
   }
Offset=MyWTStdMsg->ActWaveOp->Operator[Step]*4;
Addr1=AlphaSAddr+(LONG)(MyWTStdMsg->PlayL24/80.0+0.5);
Addr2=Addr1-(LONG)(Offset/80.0+0.5);
do
   {
   Addr1--; DataA1=(UBYTE*)Addr1;
   Addr2--; DataA2=(UBYTE*)Addr2;
   *DataA1=*DataA2;
   }
while (Addr2>AlphaSAddr);
do
   {
   Addr1--; DataA1=(UBYTE*)Addr1;
   *DataA1=1;
   }
while (Addr1>AlphaSAddr);
}
