Program Effectmod;

USES Intuition,Graphics,ExecIO;

type BPTR=long;

var DWindow                             :^Window;
var FHandle                             :BPTR;
var XGadget                             :^Gadget;
var Schieber,Textgad                    :array [1..7] of Gadget;
var SImage                              :array [1..7] of Image;
var TextInfo                            :array [1..7] of StringInfo;
var SchieberInfo                        :array [1..7] of PropInfo;
var Buffer,UndoBuffer                   :array [1..7] of string[10];

var IMsg                                :^IntuiMessage;
var RawCode,GadCode,ChBit,ChID          :byte;
var i                                   :integer;
var l                                   :long;
var s                                   :string;
var Valid                               :boolean;


{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","EffIncl.mod",
       "ModIncl.mod","Schieber.mod"}



procedure DOOFFSET(SAddr,AlphaSAddr :long; Step :byte);

var Offset,Addr1,Addr2          :long;
var Data1,Data2                 :^long;
var DataA1,DataA2               :^byte;

begin
   if SAddr=0 then exit;
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=-1 then begin
         Valid:=false;
         exit;
      end;
      Offset:=ActWaveOp^.Operator[Step]*4;
      Addr1:=SAddr+MemL24;
      Addr2:=Addr1-Offset;
      repeat
         Addr1:=Addr1-4; Data1:=ptr(Addr1);
         Addr2:=Addr2-4; Data2:=ptr(Addr2);
         Data1^:=Data2^;
      until Addr2<=SAddr;
      repeat
         Addr1:=Addr1-4; Data1:=ptr(Addr1);
         Data1^:=0;
      until Addr1<=SAddr;

      if AlphaSAddr<>0 then begin
         MESSAGEHANDLE;
         if WTMsgPrc^.PRC_Long1=-1 then begin
            Valid:=false;
            exit;
         end;
         Offset:=ActWaveOp^.Operator[Step]*4;
         Addr1:=AlphaSAddr+round(PlayL24/80+0.5);
         Addr2:=Addr1-round(Offset/80+0.5);
         repeat
            Addr1:=Addr1-1; DataA1:=ptr(Addr1);
            Addr2:=Addr2-1; DataA2:=ptr(Addr2);
            DataA1^:=DataA2^;
         until Addr2<=AlphaSAddr;
         repeat
            Addr1:=Addr1-1; DataA1:=ptr(Addr1);
            DataA1^:=1;
         until Addr1<=AlphaSAddr;
      end;
   end;
end;



procedure DEFINEOFFSET;



procedure GETGAD(GadID :byte);

var GadNum      :byte;

begin
   with MyWTStdMsg^.ActWaveOp^ do begin
      GadNum:=GadID*2-1;
      if (GadCode=GadNum+2) or not (Schieber[GadID].flags and SELECTED=0) then begin
         Operator[GadID]:=SchieberInfo[GadID].HorizPot div 13;
         if Operator[GadID]>5000 then Operator[GadID]:=5000;
         if Operator[GadID]<0 then Operator[GadID]:=0;
         Buffer[GadID]:=intstr(Operator[GadID]);
         RefreshGadgets(^TextGad[GadID],DWindow,NIL);
      end;
      if (GadCode=GadNum+3) then begin
         val(Buffer[GadID],Operator[GadID],i);
         if Operator[GadID]>5000 then Operator[GadID]:=5000;
         if Operator[GadID]<0 then Operator[GadID]:=0;
         Buffer[GadID]:=intstr(Operator[GadID]);
         SchieberInfo[GadID].HorizPot:=Operator[GadID]*13;
         RefreshGadgets(^TextGad[GadID],DWindow,NIL);
      end;
   end;
end;



begin
   with MyWTStdMsg^ do begin
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition OFFSET','','','','',163,0,1,0,0,DWindow);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      with ActWaveOp^ do if ActWaveOp^.Operator[1]=-1 then begin
         ActWaveOp^.Operator[1]:=120;   ActWaveOp^.Operator[2]:=120;
         ActWaveOp^.Operator[3]:=0;     ActWaveOp^.Operator[4]:=340;
         ActWaveOp^.Operator[5]:=340;   ActWaveOp^.Operator[6]:=220;
      end;
      ChBit:=1;
      for i:=1 to 7 do begin
         if i<7 then l:=ActWaveOp^.Operator[i] else l:=ActWaveOp^.Operator[1];
         Buffer[i]:=intstr(l);
         UndoBuffer[i]:=Buffer[i];
         CREATEPROPGAD(10,23+17*i,l*13,13,i,2,DWindow^);
         if (i<7) and (ActiveChannels and ChBit=0) then begin
            Schieber[i].Flags:=Schieber[i].Flags or GADGDISABLED;
            TextGad[i].Flags:=TextGad[i].Flags or GADGDISABLED;
         end;
         AddGadget(DWindow,^Schieber[i],NIL);
         AddGadget(DWindow,^TextGad[i],NIL);
         case i of
            1: s:='L';
            2: s:='R';
            3: s:='C';
            4: s:='SL';
            5: s:='SR';
            6: s:='Sub';
            7: s:='All';
         end;
         WRITE(414,i*17+24,2,0,DWindow^,s);
         ChBit:=ChBit*2;
      end;
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.Class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end else if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         for i:=1 to 6 do GETGAD(i);

         if (GadCode=15) or not (Schieber[7].flags and SELECTED=0) then begin
            l:=SchieberInfo[7].HorizPot div 13;
            if l>5000 then l:=5000;
            if l<0 then l:=0;
            for i:=1 to 7 do begin
               if i<7 then ActWaveOp^.Operator[i]:=l;
               Buffer[i]:=intstr(l);
               SchieberInfo[i].HorizPot:=l*13;
            end;
            RefreshGadgets(^TextGad[7],DWindow,NIL);
         end;
         if (GadCode=16) then begin
            val(Buffer[7],l,i);
            if l>5000 then l:=5000;
            if l<0 then l:=0;
            for i:=1 to 7 do begin
               if i<7 then ActWaveOp^.Operator[i]:=l;
               Buffer[i]:=intstr(l);
               SchieberInfo[i].HorizPot:=l*13;
            end;
            RefreshGadgets(^TextGad[7],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINEOFFSET
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'Offset, '+COPYRIGHT,'','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            Valid:=true;
            ChBit:=1;
            PlayL24:=MemL24;
            for ChID:=1 to 6 do begin
               if Valid and (ActWaveOp^.Operator[ChID]>0) then DOOFFSET(MemA24[ChID],MemAAlpha[ChID],ChID);
               ChBit:=ChBit*2;
            end;
            if Valid then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.

