#include <exec/types.h>
#include <intuition/IntuitionBase.h>
#include <libraries/dos.h>
#include </WaveTracer/WTincl.h>
#include </WaveTracer/MODincl.h>

#include <stdlib.h>

extern LONG BeginOffset,EndOffset;
extern BOOL Valid;
extern WTStdMsg *MyWTStdMsg;



void DOMAXVOLUME(LONG SAddr, LONG AlphaSAddr)

{
LONG   Addr1,WaveMaxAmp;
LONG  *Data1;
UBYTE *DataA1;
WORD   i;
FLOAT  Factor;


if (SAddr)
   {
   Addr1=SAddr+BeginOffset;
   i=0;
   MyWTStdMsg->Flags=0;
   MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
   WaveMaxAmp=0;
   do
      {
      if (Addr1<SAddr+EndOffset) do
         {
         Data1=(LONG*)Addr1; Addr1=Addr1+4;
         if (labs(*Data1)>WaveMaxAmp) WaveMaxAmp=labs(*Data1);
         i++;
         }
      #ifdef __PPC__
         while ((Addr1<SAddr+EndOffset) && (i<40000));
      #else
         while ((Addr1<SAddr+EndOffset) && (i<4000));
      #endif
      i=0;
      MESSAGEHANDLE();
      if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
         {
         Valid=FALSE;
         return;
         }
      }
   while (Addr1<SAddr+EndOffset);
   if ((WaveMaxAmp>0) && (WaveMaxAmp<=MAX24))
      {
      Addr1=SAddr+BeginOffset;
      Factor=(FLOAT)MAX24/WaveMaxAmp;
      do
         {
         if (Addr1<SAddr+EndOffset) do
            {
            Data1=(LONG*)Addr1; Addr1=Addr1+4;
            *Data1=(LONG)(*Data1*Factor);
            i++;
            }
         #ifdef __PPC__
            while ((Addr1<SAddr+EndOffset) && (i<40000));
         #else
            while ((Addr1<SAddr+EndOffset) && (i<4000));
         #endif
         i=0;
         MESSAGEHANDLE();
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
            {
            Valid=FALSE;
            return;
            }
         }
      while (Addr1<SAddr+EndOffset);
      }
   else return;

   if (AlphaSAddr)
      {
      Addr1=AlphaSAddr+(LONG)(BeginOffset/80+0.5);
      WaveMaxAmp=0;
      do
         {
         do
            {
            DataA1=(UBYTE*)Addr1; Addr1++;
            if (*DataA1>WaveMaxAmp) WaveMaxAmp=*DataA1;
            i++;
            }
         #ifdef __PPC__
            while ((Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5)) && (i<40000));
         #else
            while ((Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5)) && (i<4000));
         #endif
         i=0;
         MESSAGEHANDLE();
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
            {
            Valid=FALSE;
            return;
            }
         }
      while (Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5));
      if (WaveMaxAmp<255)
         {
         Addr1=AlphaSAddr+(LONG)(BeginOffset/80+0.5);
         Factor=255.0/WaveMaxAmp;
         do
            {
            do
               {
               DataA1=(UBYTE*)Addr1; Addr1++;
               *DataA1=(UBYTE)(*DataA1*1.0*Factor);
               i++;
               }
            #ifdef __PPC__
               while ((Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5)) && (i<40000));
            #else
               while ((Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5)) && (i<4000));
            #endif
            i=0;
            MESSAGEHANDLE();
            if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
               {
               Valid=FALSE;
               return;
               }
            }
         while (Addr1<AlphaSAddr+(LONG)(EndOffset/80+0.5));
         }
      }
   }
}

