Program Effectmod;

USES Intuition,Graphics,ExecIO;

type BPTR=long;

var DWindow                             :^Window;

var XGadget                             :^Gadget;
var Schieber,Textgad                    :Gadget;
var SchieberInfo                        :PropInfo;
var TextInfo                            :StringInfo;
var Buffer,UndoBuffer                   :string[20];

var IMsg                                :^IntuiMessage;

var RawCode,GadCode,ChBit,ChID,ChCnt    :byte;
var i                                   :integer;
var l,GrenzPegel                        :long;
var Valid                               :boolean;


{$incl "exec/memory.h"}
{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
       "EffIncl.mod"}


procedure DONEEDLES(SAddr,AlphaSAddr :long);

var Addr1,Addr2,AddrA1,AddrA2   :long;
var Data1,Data2                 :^long;
var DataA1,DataA2               :^byte;
var ACtr1,ACtr2                 :byte;


procedure NORMALALPHA;

begin
   if ACtr1>=20 then begin
      ACtr1:=0;
      DataA1:=ptr(AddrA1); AddrA1:=AddrA1+1;
      DataA2:=ptr(AddrA2);
      DataA1^:=DataA2^;
   end;
   if ACtr2>=20 then begin
      ACtr2:=0;
      DataA2:=ptr(AddrA2); AddrA2:=AddrA2+1;
      DataA1^:=DataA2^;
   end;
end;



begin
   if SAddr=0 then exit;
   with MyWTStdMsg^ do begin
      GrenzPegel:=round(MAX24/ActWaveOp^.Operator[1]*pred(ActWaveOp^.Operator[1]));
      i:=0;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      Addr1:=SAddr;       Addr2:=Addr1;
      AddrA1:=AlphaSAddr; AddrA2:=AddrA1;
      ACtr1:=20;          ACtr2:=ACtr1;
      repeat
         repeat
            Data2:=ptr(Addr2); Addr2:=Addr2+4;
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            if AlphaSAddr<>0 then NORMALALPHA;
            ACtr1:=ACtr1+1; ACtr2:=ACtr2+1;
            while (abs(Data2^)>GrenzPegel) and (Addr2<SAddr+PlayL24) do begin
               Data2:=ptr(Addr2); Addr2:=Addr2+4;
               if AlphaSAddr<>0 then NORMALALPHA;
               ACtr2:=ACtr2+1;
            end;
            Data1^:=Data2^;
            i:=i+1;
         until (Addr2>=SAddr+PlayL24) or (i>4000);
         i:=0;
         MESSAGEHANDLE;
         if WTMsgPrc^.PRC_long1=-1 then begin
            Valid:=false;
            exit;
         end;
      until Addr2>=SAddr+PlayL24;
      if Addr2<SAddr+PlayL24 then begin
         CopyMemQuick(Addr2,Addr1,SAddr+PlayL24-Addr2);
         if AlphaSAddr<>0 then CopyMem(AddrA2,AddrA1,AlphaSAddr+round(PlayL24/80+0.5)-AddrA2);
         Addr1:=Addr1+(SAddr+PlayL24-Addr2);
         AddrA1:=AddrA1+(AlphaSAddr+round(PlayL24/80+0.5)-AddrA2);
      end;
      while Addr1<SAddr+PlayL24 do begin
         Data1:=ptr(Addr1); Addr1:=Addr1+4;
         Data1^:=0;
      end;
      while (AddrA1<AlphaSAddr+round(MemL24/80+0.5)) and (AlphaSAddr<>0) do begin
         DataA1:=ptr(AddrA1); AddrA1:=AddrA1+1;
         DataA1^:=1;
      end;
   end;
end;



procedure DEFINENEEDLES;

begin
   with MyWTStdMsg^ do begin
      with ActWaveOp^ do if Operator[1]=-1 then begin
         Operator[1]:=5;
         Channels:=UsedChannels;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition KILLNEEDLES','','','','',96,0,3,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      WTMsgPrc^:=MsgPrc(WTM_SETCHANNELGADS,'','','','','',ActiveMode,ActWaveOp^.Channels,0,0,0,NIL);
      MESSAGEHANDLE;
      Schieber:=Gadget(NIL,10,75 ,320,15,GADGHCOMP+GADGIMAGE,$83,PROPGADGET,WTImg^.KnobImg,NIL,Nil,0,^SchieberInfo,3,0);
      SchieberInfo:=Propinfo(FREEHORIZ,pred(ActWaveOp^.Operator[1])*1337,0,1311,0,0,0,0,0,0,0);
      TextGad:=Gadget(Nil,342,76,42,14,GADGHCOMP,_LONGINT+STRINGCENTER+$1,STRGADGET,NIL,Nil,Nil,0,^TextInfo,4,0);
      MAKEBORDER(DWindow^,340,75,385,89,NEGATIVE);
      TextInfo:=StringInfo(^Buffer,^Undobuffer,0,7,0,0,0,0,0,0,Nil,0,Nil);
      Buffer:=intstr(ActWaveOp^.Operator[1]); UndoBuffer:='';

      WRITE(390,77,2,0,DWindow^,'Threshold over average');
      AddGadget(DWindow,^TextGad,NIL);
      AddGadget(DWindow,^Schieber,NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         if (Gadcode=3) or not (Schieber.flags and SELECTED=0) then begin
            ActWaveOp^.Operator[1]:=succ(SchieberInfo.HorizPot div 1337);
            if ActWaveOp^.Operator[1]<2 then ActWaveOp^.Operator[1]:=2;
            if ActWaveOp^.Operator[1]>50 then ActWaveOp^.Operator[1]:=50;
            Buffer:=intstr(ActWaveOp^.Operator[1]);
            RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
         end;
         if Gadcode=4 then begin
            val(Buffer,ActWaveOp^.Operator[1],i);
            if ActWaveOp^.Operator[1]<2 then ActWaveOp^.Operator[1]:=2;
            if ActWaveOp^.Operator[1]>50 then ActWaveOp^.Operator[1]:=50;
            Buffer:=intstr(ActWaveOp^.Operator[1]);
            SchieberInfo.HorizPot:=pred(ActWaveOp^.Operator[1])*1337;
            RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETCHANNELGADS,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      ActWaveOp^.Channels:=WTMsgPrc^.PRC_Long1;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINENEEDLES
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'KillNeedles 2,  by QXC','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            Valid:=true;

            ChBit:=1; ChCnt:=0;
            for ChID:=1 to 6 do begin
               if Valid and not (ActWaveOp^.Channels and ChBit=0) then DONEEDLES(MemA24[ChID],MemAAlpha[ChID]);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.
