Program Effectmod;

USES Intuition,Graphics,ExecIO;

type BPTR=long;

var NeuScreen   :NewScreen;
var MyScreen    :^Screen;
var DWindow                             :^Window;
var FHandle                             :BPTR;

var XGadget                             :^Gadget;
var DKnopf                              :array [9..13] of Gadget;
var DKnopfTx                            :array [1..7] of IntuiText;

var IMsg                                :^IntuiMessage;
var RawCode,GadCode                     :byte;
var i,j                                 :integer;
var l                                   :long;
var s                                   :string;
var MsgGone,scr                         :boolean;
var PathFR,FileFR                       :string;
var LData                               :^byte;


{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
       "EffIncl.mod"}

var MySList1,MySList2                   :SelectListGad;



procedure CREATEGRAPH;

type ColorArr=array [1..93] of byte;

var Value0,ValueD,Color                         :short;
var Addr1,Addr0a,Addr0b,AddrDa,AddrDb           :long;
var DataBefore,ltu,x,y,AddrDivX,AddrDivY        :long;
var Data1                                       :^long;
var ScrInFront                                  :boolean;
var TimeX,TimeY,FactorX,FactorY                 :real;
var LastX,LastY,LastColor                       :integer;
var ColArr                                      :ColorArr;
var ChBit                                       :byte;


procedure SCREENHANDLE;

begin
   repeat until not (LData^ and 64=0);
   ScreenToBack(MyScreen);
end;


begin
   LData:=ptr($BFE001);
   with MyWTStdMsg^ do begin
      if not scr then begin
         NeuScreen:=NewScreen(0,0,320,256,5,14,0,0,CUSTOMSCREEN,NIL,'WaveTracer GraphicAnalyzer',NIL,NIL);
         MyScreen:=OpenScreen(^NeuScreen);
         if MyScreen=NIL then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_TASKREQ,'Can`t open analyzer-screen!',
                              'Operation cancelled!','','OK','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            exit;
         end else scr:=true;
         SetRGB4(^MyScreen^.ViewPort,0,0,0,0);
      end else begin
         SetAPen(^MyScreen^.RastPort,0);
         RectFill(^MyScreen^.RastPort,0,17,319,255);
         ScreenToFront(MyScreen);
      end;
      if (DKnopf[12].Flags and SELECTED=0) then
       ColArr:=ColorArr( 0, 0, 1,    0, 0, 2,    0, 0, 3,    0, 0, 4,
                         0, 0, 5,    0, 0, 6,    0, 0, 7,    0, 0, 8,
                         0, 0, 9,    0, 0,10,    0, 0,11,    0, 0,12,
                         0, 0,13,    0, 0,14,    0, 0,15,    1, 0,15,
                         2, 0,14,    3, 0,13,    4, 0,12,    5, 0,11,
                         6, 0,10,    7, 0, 9,    8, 0, 8,    9, 0, 7,
                        10, 0, 6,   11, 0, 5,   12, 0, 4,   13, 0, 3,
                        14, 0, 2,   15, 0, 1,   15, 0, 0)

      else
       ColArr:=ColorArr(10, 0, 0,    0, 0,10,   10, 0,10,   10,10, 0,
                         0,10,10,    0,10, 0,    1, 1, 1,    2, 2, 2,
                         3, 3, 3,    4, 4, 4,    5, 5, 5,    6, 6, 6,
                         7, 7, 7,    8, 8, 8,    9, 9, 9,   10,10,10,
                        11,11,11,   12,12,12,   13,13,13,   14,14,14,
                        15,15,15,    0, 0, 0,    0, 0, 0,    0, 0, 0,
                         0, 0, 0,    0, 0, 0,    0, 0, 0,    0, 0, 0,
                         0, 0, 0,    0, 0, 0,    0, 0, 0);
      for i:=1 to 31 do SetRGB4(^MyScreen^.ViewPort,i,ColArr[i*3-2],ColArr[i*3-1],ColArr[i*3]);
      ScrInFront:=true;

      AddrDivX:=PlayL24 div 320; AddrDivY:=PlayL24 div 238;
      FactorX:=320/PlayL24*4;
      FactorY:=238/PlayL24*4;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETCHANNELGADS,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      ActWaveOp^.Channels:=WTMsgPrc^.PRC_Long1;
      ChBit:=1;
      for i:=1 to 6 do begin
         if not (ActWaveOp^.Channels and ChBit=0) and (MemA24[i]>0) then begin
            TimeX:=0; TimeY:=0;
            Addr1:=MemA24[i];
            Data1:=ptr(Addr1);
            Addr0a:=MemA24[i]; Addr0b:=MemA24[i]; Value0:=1;
            AddrDa:=MemA24[i]; AddrDb:=MemA24[i]; ValueD:=1;

            repeat
               DataBefore:=Data1^;
               Addr1:=Addr1+4;   Data1:=ptr(Addr1);
               case ActWaveOp^.Operator[1] of
                  1: begin
                        if ((Data1^>0) and (Value0<0)) or ((Data1^<0) and (Value0>0)) then begin
                           Addr0a:=Addr0b; Addr0b:=Addr1; Value0:=Data1^ div abs(Data1^);
                        end;
                        l:=Addr0b-Addr0a;
                        if l>0 then x:=round(ln(l)*60) else x:=0;
                     end;
                  2: begin
                        ltu:=Data1^-DataBefore;
                        if ((ltu>0) and (ValueD<0)) or ((ltu<0) and (ValueD>0)) then begin
                           AddrDa:=AddrDb; AddrDb:=Addr1; ValueD:=ltu div abs(ltu);
                        end;
                        x:=(AddrDb-AddrDa);
                     end;
                  3: begin
                        l:=abs(DataBefore-Data1^);
                        if l>0 then x:=round(ln(l)*18) else x:=0;
                     end;
                  4: begin
                        l:=abs(DataBefore+Data1^);
                        if l>0 then x:=round(ln(l)*18) else x:=0;
                     end;
                  5: begin
                        TimeX:=TimeX+FactorX;
                        x:=round(TimeX);
                     end;
                  6: begin
                        l:=abs(Data1^);
                        if l>0 then x:=round(ln(l)*20) else x:=0;
                     end;
                  otherwise x:=100;
               end;
               x:=abs(x);
               if x>319 then x:=x mod 319;

               case ActWaveOp^.Operator[2] of
                  1: begin
                        if ((Data1^>0) and (Value0<0)) or ((Data1^<0) and (Value0>0)) then begin
                           Addr0a:=Addr0b; Addr0b:=Addr1; Value0:=Data1^ div abs(Data1^);
                        end;
                        l:=Addr0b-Addr0a;
                        if l>0 then y:=round(ln(l)*60) else x:=0;
                     end;
                  2: begin
                        ltu:=Data1^-DataBefore;
                        if ((ltu>0) and (ValueD<0)) or ((ltu<0) and (ValueD>0)) then begin
                           AddrDa:=AddrDb; AddrDb:=Addr1; ValueD:=ltu div abs(ltu);
                        end;
                        y:=(AddrDb-AddrDa)
                     end;
                  3: begin
                        l:=abs(DataBefore-Data1^);
                        if l>0 then y:=round(ln(l)*14) else y:=0;
                     end;
                  4: begin
                        l:=abs(DataBefore+Data1^);
                        if l>0 then y:=round(ln(l)*14) else y:=0;
                     end;
                  5: begin
                        TimeY:=TimeY+FactorY;
                        y:=round(TimeY);
                     end;
                  6: begin
                        l:=abs(Data1^);
                        if l>0 then y:=round(ln(l)*14) else y:=0;
                     end;
                  otherwise y:=100;
               end;
               y:=abs(y);
               if y>238 then y:=y mod 238;
               y:=255-y;

               Color:=ReadPixel(^MyScreen^.RastPort,x,y);
               if (DKnopf[12].Flags and SELECTED=0) then begin
                  Color:=Color+1;
                  if Color<0 then Color:=0;
                  if Color>31 then Color:=31;
               end else begin
                  if Color=0 then Color:=i else if Color<>i then begin
                     Color:=Color+1;
                     if Color<7 then Color:=7;
                     if Color>21 then Color:=21;
                  end;
               end;
               SetAPen(^MyScreen^.RastPort,Color);
               WritePixel(^MyScreen^.RastPort,x,y);

               if (LData^ and 64=0) then begin
                  SCREENHANDLE;
                  exit;
               end;
            until Addr1>=MemA24[i]+PlayL24;
         end;
         ChBit:=ChBit*2;
      end;

      repeat until not (LData^ and 64=0);
      if (DKnopf[13].Flags and GADGDISABLED=0) and not (DKnopf[13].Flags and SELECTED=0) then begin
         y:=16;
         repeat
            y:=y+1;
            x:=0;
            LastColor:=-1; LastX:=0;
            repeat
               Color:=ReadPixel(^MyScreen^.RastPort,x,y);
               if (Color>0) or (LastColor=-1) then begin
                  if (x-LastX>1) and (Color>0) then begin
                     if Color=LastColor then begin
                        SetAPen(^MyScreen^.RastPort,Color);
                        RectFill(^MyScreen^.RastPort,LastX,y,x,y);
                     end else begin
                        FactorX:=(Color-LastColor)/pred(x-LastX);
                        TimeX:=LastColor;
                        for i:=succ(LastX) to pred(x) do begin
                           TimeX:=TimeX+FactorX;
                           SetAPen(^MyScreen^.RastPort,round(TimeX));
                           WritePixel(^MyScreen^.RastPort,i,y);
                        end;
                     end;
                  end;
                  LastColor:=Color;
                  LastX:=x;
               end;
               x:=x+1;
            until (x>=320) or (LData^ and 64=0);
            if (LData^ and 64=0) then begin
               SCREENHANDLE;
               exit;
            end;
         until (y>=255) or (LData^ and 64=0);

         x:=0;
         repeat
            y:=16;
            LastColor:=0; LastY:=0;
            repeat
               Color:=ReadPixel(^MyScreen^.RastPort,x,y);
               if (Color>0) then begin
                  if (y-LastY>1) and (Color>0) and (LastColor>0) then begin
                     if Color=LastColor then begin
                        SetAPen(^MyScreen^.RastPort,Color);
                        RectFill(^MyScreen^.RastPort,x,LastY,x,y);
                     end else begin
                        FactorY:=(Color-LastColor)/pred(y-LastY);
                        TimeY:=LastColor;
                        for i:=succ(LastY) to pred(y) do begin
                           TimeY:=TimeY+FactorY;
                           SetAPen(^MyScreen^.RastPort,round(TimeY));
                           WritePixel(^MyScreen^.RastPort,x,i);
                        end;
                     end;
                  end;
                  LastColor:=Color;
                  LastY:=y;
               end;
               y:=y+1;
            until (y>=256) or (LData^ and 64=0);
            x:=x+1;
            if (LData^ and 64=0) then begin
               SCREENHANDLE;
               exit;
            end;
         until (x>=320) or (LData^ and 64=0);
      end;
      repeat
         delay(5);
      until (LData^ and 64=0);
      SCREENHANDLE
   end;
end;



procedure ANALYZE;

begin
   scr:=false;
   with MyWTStdMsg^ do begin
      with ActWaveOp^ do begin
         Operator[1]:=5;
         Operator[2]:=1;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Graphic-Analyzer, '+COPYRIGHT,'','','','',102,0,3,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=0;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      WTMsgPrc^:=MsgPrc(WTM_SETCHANNELGADS,'','','','','',ActiveMode,UsedChannels,0,0,0,NIL);
      MESSAGEHANDLE;

      DKnopf[9]:=Gadget(NIL,150,40,128,16,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,WTImg^.GImg2,NIL,NIL,0,Nil,9,0);
      DKnopf[10]:=Gadget(NIL,150,60,128,16,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,WTImg^.GImg2,NIL,NIL,0,Nil,10,0);
      DKnopf[11]:=Gadget(NIL,150,80,128,16,GADGHCOMP+GADGIMAGE,$1,BOOLGADGET,WTImg^.GImg5,NIL,^DKnopfTx[7],0,Nil,11,0);
      DKnopf[12]:=Gadget(NIL,10,71,21,12,GADGHIMAGE+GADGIMAGE,TOGGLESELECT+RELVERIFY,
                         BOOLGADGET,WTImg^.ButtonImg1,WTImg^.ButtonImg2,NIL,0,NIL,12,0);
      DKnopf[13]:=Gadget(NIL,10,85,21,12,GADGHIMAGE+GADGIMAGE+SELECTED,TOGGLESELECT+RELVERIFY,
                         BOOLGADGET,WTImg^.ButtonImg1,WTImg^.ButtonImg2,NIL,0,NIL,13,0);
      WRITE(285,41,2,0,DWindow^,'Parameter X-Achse');
      WRITE(285,61,2,0,DWindow^,'Parameter Y-Achse');
      WRITE(35,72,2,0,DWindow^,'Kanal-Farben');
      WRITE(35,86,2,0,DWindow^,'Interpolation');
      DKnopfTx[1]:=IntuiText(2,0,0,3,2,^WTScreen^.Font,'0-Point',NIL);
      DKnopfTx[2]:=IntuiText(2,0,0,3,2,^WTScreen^.Font,'+/- Change',NIL);
      DKnopfTx[3]:=IntuiText(2,0,0,3,2,^WTScreen^.Font,'Difference',NIL);
      DKnopfTx[4]:=IntuiText(2,0,0,3,2,^WTScreen^.Font,'Integral',NIL);
      DKnopfTx[5]:=IntuiText(2,0,0,3,2,^WTScreen^.Font,'Time',NIL);
      DKnopfTx[6]:=IntuiText(2,0,0,3,2,^WTScreen^.Font,'Amplitude',NIL);
      DKnopfTx[7]:=IntuiText(2,0,0,3,2,^WTScreen^.Font,'Calculate',NIL);
      MySList1:=SelectListGad(DWindow,^DKnopf[9],ActWaveOp^.Operator[1],0,0,0,
                              ITTArr(^DKnopfTx[1],^DKnopfTx[2],^DKnopfTx[3],^DKnopfTx[4],
                              ^DKnopfTx[5],^DKnopfTx[6],NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL));
      MySList2:=SelectListGad(DWindow,^DKnopf[10],ActWaveOp^.Operator[2],0,0,0,
                              ITTArr(^DKnopfTx[1],^DKnopfTx[2],^DKnopfTx[3],^DKnopfTx[4],
                              ^DKnopfTx[5],^DKnopfTx[6],NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL));
      DKnopf[9].GadgetText:=^DKnopfTx[ActWaveOp^.Operator[1]];
      DKnopf[10].GadgetText:=^DKnopfTx[ActWaveOp^.Operator[2]];
      for i:=9 to 13 do AddGadget(DWindow,^DKnopf[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; MsgGone:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               MsgGone:=true;
            End else delay(1);
         until MsgGone;

         if GadCode=9 then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_DOSELECTLIST,'','','','','',0,0,0,0,0,^MySList1);
            MESSAGEHANDLE;
            if WTMsgPrc^.PRC_Long1<>-1 then ActWaveOp^.Operator[1]:=WTMsgPrc^.PRC_Long1
         end;

         if GadCode=10 then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_DOSELECTLIST,'','','','','',0,0,0,0,0,^MySList2);
            MESSAGEHANDLE;
            if WTMsgPrc^.PRC_Long1<>-1 then ActWaveOp^.Operator[2]:=WTMsgPrc^.PRC_Long1
         end;

         if Gadcode=11 then CREATEGRAPH;

         if GadCode=12 then begin
            if not (DKnopf[12].Flags and SELECTED=0)
             then DKnopf[13].Flags:=DKnopf[13].Flags or GADGDISABLED
            else DKnopf[13].Flags:=DKnopf[13].Flags and not GADGDISABLED;
            RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      if scr then CloseScreen(MyScreen);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then ANALYZE
         else if Flags=MDC_DOIT then begin
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.
