Program Effectmod;

USES ExecIO,Intuition,Graphics;

type BPTR=long;

var Addr1       :long;
var Data1       :^long;

var DWindow                             :^Window;

var XGadget                             :^Gadget;
var Schieber,Textgad                    :array [1..2] of Gadget;
var SImage                              :array [1..2] of Image;
var SchieberInfo                        :array [1..2] of PropInfo;
var TextInfo                            :array [1..2] of StringInfo;
var Buffer,UndoBuffer                   :array [1..2] of string[20];

var IMsg                                :^IntuiMessage;
var RawCode,GadCode,ChBit,ChID          :byte;
var i                                   :integer;
var l,BeginOffset,EndOffset             :long;
var Valid                               :boolean;


{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
       "EffIncl.mod","Schieber.mod"}



procedure DEFINECOMP;

begin
   with MyWTStdMsg^ do begin
      with ActWaveOp^ do if (Operator[1]=-1) or (Operator[1]>300) then begin
         OpType:=1;
         Operator[1]:=200;
         ActWaveOp^.Channels:=UsedChannels;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition GAMMA-KORREKTUR',
                        '','','','',100,0,3,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      WTMsgPrc^:=MsgPrc(WTM_SETCHANNELGADS,'','','','','',ActiveMode,ActWaveOp^.Channels,0,0,0,NIL);
      MESSAGEHANDLE;
      CREATEPROPGAD(10,76,pred(ActWaveOp^.Operator[1])*218,218,1,8,DWindow^);
      Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
      WRITE(410,77,2,0,DWindow^,'%');
      AddGadget(DWindow,^TextGad[1],NIL);
      AddGadget(DWindow,^Schieber[1],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         if (Gadcode=9) or not (Schieber[1].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[1]:=succ(SchieberInfo[1].HorizPot div 218);
            if ActWaveOp^.Operator[1]<1 then ActWaveOp^.Operator[1]:=1;
            if ActWaveOp^.Operator[1]>300 then ActWaveOp^.Operator[1]:=300;
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            RefreshGadgets(^TextGad[1],DWindow,NIL);
         end;
         if Gadcode=10 then begin
            val(Buffer[1],ActWaveOp^.Operator[1],i);
            if ActWaveOp^.Operator[1]<1 then ActWaveOp^.Operator[1]:=1;
            if ActWaveOp^.Operator[1]>300 then ActWaveOp^.Operator[1]:=300;
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            SchieberInfo[1].HorizPot:=pred(ActWaveOp^.Operator[1])*131;
            RefreshGadgets(^Schieber[1],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETCHANNELGADS,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      ActWaveOp^.Channels:=WTMsgPrc^.PRC_Long1;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,GadCode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



procedure DOCOMP(SAddr :long);

var Data1               :^long;
var Addr1,l             :long;
var Factor              :real;
var EFactor,i           :byte;

begin
l:=0;
   with MyWTStdMsg^ do if (SAddr<>0) and (ActWaveOp^.Operator[1]<>100) then begin
      Addr1:=SAddr+BeginOffset;
      if ActWaveOp^.Operator[1]>100 then begin
         EFactor:=ActWaveOp^.Operator[1] div 100;
         repeat
            Data1:=ptr(Addr1);   Addr1:=Addr1+4;
            if Data1^<>0 then begin
               Factor:=2-abs(Data1^)/(MAX24*2);
               if Factor<>0 then for i:=1 to EFactor do Data1^:=round(Data1^*Factor);
            end;
         until Addr1>=SAddr+EndOffset;
      end else if ActWaveOp^.Operator[1]<100 then begin
         EFactor:=succ(100 div ActWaveOp^.Operator[1]);
         repeat
            Data1:=ptr(Addr1);   Addr1:=Addr1+4;
            if Data1^<>0 then begin
               Factor:=abs(Data1^)/MAX24;
               if Factor<>0 then for i:=1 to EFactor do Data1^:=round(Data1^*Factor);
            end;
         until Addr1>=SAddr+EndOffset;
      end
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINECOMP
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'Gamma, '+COPYRIGHT,'','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            Valid:=true;
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if Valid and not (ActWaveOp^.Channels and ChBit=0) then
                DOCOMP(MemA24[ChID]);
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.

