Program Effectmod;

USES Intuition,Graphics,ExecIO;

type BPTR=long;

var DWindow                             :^Window;

var XGadget                             :^Gadget;
var Schieber,Textgad                    :array [1..3] of Gadget;
var SImage                              :array [1..3] of Image;
var SchieberInfo                        :array [1..3] of PropInfo;
var TextInfo                            :array [1..3] of StringInfo;
var Buffer,UndoBuffer                   :array [1..3] of string[20];

var IMsg                                :^IntuiMessage;
var RawCode,GadCode,ChBit,ChID          :byte;
var i,j                                 :integer;
var l,BeginOffset,EndOffset             :long;
var Valid                               :boolean;


{$path "WaveTracer/","RAM:include/";incl "WTIncl.mod","ModIncl.mod",
       "EffIncl.mod","Schieber.mod"}



procedure DOECHO(SAddr,AlphaSAddr :long; Offset :byte);

var Addr1,Addr2         :long;
var Data1,Data2         :^long;
var DataA               :^byte;
var Echos,REchos        :integer;
var EFactor,GFactor     :real;
var ACtr                :byte;

begin
   if SAddr=0 then exit;
   with MyWTStdMsg^ do begin
      if AlphaSAddr<>0 then begin
         Addr1:=SAddr; Addr2:=AlphaSAddr+BeginOffset div 80;
         ACtr:=(BeginOffset mod 80) + 20;
         repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            if ACtr>=20 then begin
               ACtr:=ACtr-20;
               DataA:=ptr(Addr2); Addr2:=Addr2+1;
               if DataA^=0 then DataA^:=1;
            end;
            Data1^:=Data1^ div DataA^*255;
         until Addr1>=SAddr+PlayL24;
         Addr2:=AlphaSAddr+BeginOffset div 80;
         while Addr2<AlphaSAddr+round(PlayL24/80+0.5) do begin
            DataA:=ptr(Addr2); Addr2:=Addr2+1;
            DataA^:=255;
         end;
      end;
      Echos:=1; REchos:=1; Offset:=Offset*4;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETABORTINFO,'','','','','',0,0,0,0,0,NIL);
      if ActWaveOp^.Operator[3]=-1 then ActWaveOp^.Operator[3]:=100;
      EFactor:=ActWaveOp^.Operator[3]/100;
      GFactor:=EFactor+1;
      repeat
         Addr1:=SAddr+BeginOffset;
         Addr2:=SAddr+(Echos*ActWaveOp^.Operator[2]*4)+Offset+BeginOffset;
         MESSAGEHANDLE;
         if WTMsgPrc^.PRC_Long1=-1 then begin
            Valid:=false;
            exit;
         end;
         if Addr2<SAddr+MemL24 then repeat
            Data1:=ptr(Addr1); Addr1:=Addr1+4;
            Data2:=ptr(Addr2); Addr2:=Addr2+4;
            Data2^:=round((Data1^*EFactor+Data2^)/GFactor);
         until (Addr2>=SAddr+MemL24);
         EFactor:=EFactor*(ActWaveOp^.Operator[3]/100);
         if EFactor=0 then EFactor:=0.1;
         Echos:=Echos+1; REchos:=REchos+Echos;
      until REchos>=ActWaveOp^.Operator[1];
   end;
end;



procedure DEFINEECHO;

begin
   with MyWTStdMsg^ do begin
      with ActWaveOp^ do if Operator[1]=-1 then begin
         Operator[1]:=6;
         Operator[2]:=250;
         Operator[3]:=70;
         Channels:=UsedChannels;
      end;
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_OPENDWIN,'Definition FASTECHO','','','','',132,0,3,0,0,NIL);
      MESSAGEHANDLE;
      if (WTMsgPrc^.PRC_Long1=-1) or (WTMsgPrc^.PRC_NewPtr=NIL) then begin
         Flags:=MDE_ERROR;
         exit;
      end;
      DWindow:=WTMsgPrc^.PRC_NewPtr;
      WTMsgPrc^:=MsgPrc(WTM_SETCHANNELGADS,'','','','','',ActiveMode,ActWaveOp^.Channels,0,0,0,NIL);
      MESSAGEHANDLE;

      for i:=1 to 3 do CREATEPROPGAD(10,58+i*17,1,1,i,8,DWindow^);
      SchieberInfo[1]:=Propinfo(FREEHORIZ,pred(ActWaveOp^.Operator[1])*1680,0,1638,0,0,0,0,0,0,0);
      SchieberInfo[2]:=Propinfo(FREEHORIZ,pred(ActWaveOp^.Operator[2])*8,0,8,0,0,0,0,0,0,0);
      SchieberInfo[3]:=Propinfo(FREEHORIZ,pred(ActWaveOp^.Operator[3])*131,0,131,0,0,0,0,0,0,0);
      for i:=1 to 3  do Buffer[i]:=intstr(ActWaveOp^.Operator[i]);
      WRITE(410,76,2,0,DWindow^,'Number of echoes');
      WRITE(410,93,2,0,DWindow^,'Echoe-Distance');
      WRITE(410,110,2,0,Dwindow^,'Echoe-Amplitude');
      for i:=1 to 3 do AddGadget(DWindow,^TextGad[i],NIL);
      for i:=1 to 3 do AddGadget(DWindow,^Schieber[i],NIL);
      RefreshGadgets(DWindow^.FirstGadget,DWindow,NIL);
      repeat
         repeat
            RawCode:=0; GadCode:=0; Valid:=false;
            IMsg:=Get_Msg(DWindow^.UserPort);
            If IMsg<>Nil Then begin
               if IMsg^.class in [GADGETDOWN,GADGETUP] then begin
                  XGadget:=IMsg^.IAddress; GadCode:=XGadget^.GadgetID;
               end;
               if IMsg^.class=RAWKEY then RawCode:=IMsg^.Code;
               Reply_Msg(IMsg);
               Valid:=true;
            End else delay(1);
         until Valid;

         if (GadCode=9) or not (Schieber[1].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[1]:=succ(SchieberInfo[1].HorizPot div 1680);
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            RefreshGadgets(^TextGad[1],DWindow,NIL);
         end;
         if GadCode=10 then begin
            val(Buffer[1],ActWaveOp^.Operator[1],i);
            if ActWaveOp^.Operator[1]<1  then ActWaveOp^.Operator[1]:=1;
            if ActWaveOp^.Operator[1]>40 then ActWaveOp^.Operator[1]:=40;
            Buffer[1]:=intstr(ActWaveOp^.Operator[1]);
            SchieberInfo[1].HorizPot:=pred(ActWaveOp^.Operator[1])*1680;
            RefreshGadgets(^Schieber[1],DWindow,NIL);
         end;

         if (GadCode=11) or not (Schieber[2].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[2]:=succ(SchieberInfo[2].HorizPot div 8);
            if ActWaveOp^.Operator[2]<1    then ActWaveOp^.Operator[2]:=1;
            if ActWaveOp^.Operator[2]>8000 then ActWaveOp^.Operator[2]:=8000;
            Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
            RefreshGadgets(^TextGad[2],DWindow,NIL);
         end;
         if GadCode=12 then begin
            val(Buffer[2],ActWaveOp^.Operator[2],i);
            if ActWaveOp^.Operator[2]<1    then ActWaveOp^.Operator[2]:=1;
            if ActWaveOp^.Operator[2]>8000 then ActWaveOp^.Operator[2]:=8000;
            Buffer[2]:=intstr(ActWaveOp^.Operator[2]);
            SchieberInfo[2].HorizPot:=pred(ActWaveOp^.Operator[2])*8;
            RefreshGadgets(^Schieber[2],DWindow,NIL);
         end;

         if (GadCode=13) or not (Schieber[3].flags and SELECTED=0) then begin
            ActWaveOp^.Operator[3]:=succ(SchieberInfo[3].HorizPot div 131);
            if ActWaveOp^.Operator[3]<1 then ActWaveOp^.Operator[3]:=1;
            if ActWaveOp^.Operator[3]>500 then ActWaveOp^.Operator[3]:=500;
            Buffer[3]:=intstr(ActWaveOp^.Operator[3]);
            RefreshGadgets(^TextGad[3],DWindow,NIL);
         end;
         if GadCode=14 then begin
            val(Buffer[3],ActWaveOp^.Operator[3],i);
            if ActWaveOp^.Operator[3]<1 then ActWaveOp^.Operator[3]:=1;
            if ActWaveOp^.Operator[3]>500 then ActWaveOp^.Operator[3]:=500;
            Buffer[3]:=intstr(ActWaveOp^.Operator[3]);
            SchieberInfo[3].HorizPot:=pred(ActWaveOp^.Operator[3])*131;
            RefreshGadgets(^Schieber[3],DWindow,NIL);
         end;

      Until (GadCode in [1..2]) or (RawCode=68) or (RawCode=69);
      Flags:=0;
      WTMsgPrc^:=MsgPrc(WTM_GETCHANNELGADS,'','','','','',0,0,0,0,0,NIL);
      MESSAGEHANDLE;
      ActWaveOp^.Channels:=WTMsgPrc^.PRC_Long1;
      WTMsgPrc^:=MsgPrc(WTM_LEAVEWIN,'','','','','',RawCode,Gadcode,0,0,0,DWindow);
      MESSAGEHANDLE;
      if WTMsgPrc^.PRC_Long1=1 then Flags:=MDE_READY else Flags:=MDE_CANCELLED;
   end;
end;



begin {*** MAIN ***}
   OpenLib(IntBase,'intuition.library',0);
   OpenLib(GfxBase,'graphics.library',0);
   if CREATEPORTS(PORT_EFFECTMOD) then begin
      with MyWTStdMsg^ do if Version=VERSION_EFFECTMOD then begin
         if Flags=MDC_DEFINEIT then DEFINEECHO
         else if Flags=MDC_DOIT then begin
            Flags:=0;
            WTMsgPrc^:=MsgPrc(WTM_WORKINFO,'FastEcho, '+COPYRIGHT,'','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            WTMsgPrc^:=MsgPrc(WTM_GETMARKOFFSET,'','','','','',0,0,0,0,0,NIL);
            MESSAGEHANDLE;
            BeginOffset:=WTMsgPrc^.PRC_Long1;
            EndOffset:=WTMsgPrc^.PRC_Long2;
            WTMsgPrc^:=MsgPrc(WTM_RESTOREALPHA,'','','','','',
                              ActWaveOp^.Channels,BeginOffset,EndOffset,0,0,NIL);
            MESSAGEHANDLE;
            Valid:=true;
            ChBit:=1;
            for ChID:=1 to 6 do begin
               if Valid and not (ActWaveOp^.Channels and ChBit=0) then begin
                  Flags:=0;
                  DOECHO(MemA24[ChID],MemAAlpha[ChID],ChID);
               end;
               ChBit:=ChBit*2;
            end;
            Flags:=MDE_READY;
         end;
      end else Flags:=MDE_WRONG_MODULEVERSION;
      MESSAGEHANDLE;
      RemPort(MyPort);
   end;
   CloseLib(GfxBase);
   CloseLib(IntBase);
end.
