#include <exec/types.h>

#include <intuition/IntuitionBase.h>
#include <libraries/dos.h>

#include </WaveTracer/WTIncl.h>

#include <stdlib.h>


#define MODE_MOVEY   1
#define MODE_ROTATEZ 2

extern void MESSAGEHANDLE(void);

extern BOOL Valid;
extern WTStdMsg *MyWTStdMsg;
extern LONG BeginOffset,EndOffset;



void DOEGALIZER(LONG SAddr)

{
LONG   Offset,Ctr,Addr1;
LONG  *Data1;
WORD   i;
FLOAT  StepSize,FOffset;


if (SAddr)
   {
   if (MyWTStdMsg->ActWaveOp->OpType==MODE_MOVEY)
      {
      Addr1=SAddr+BeginOffset;
      MyWTStdMsg->Flags=0;
      MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
      Offset=0; Ctr=0;
      do
         {
         do
            {
            Data1=(LONG*)Addr1; Addr1=Addr1+4;
            Offset=Offset+*Data1/256;
            Ctr++;
            }
         while ((Addr1<SAddr+EndOffset) && labs(Offset<2000000000));
         FOffset=(FLOAT)(Offset/Ctr)*256;
         i=0;
         MESSAGEHANDLE();
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
            {
            Valid=FALSE;
            return;
            }
         }
      while (Addr1<SAddr+EndOffset);
      if ((FOffset>10) || (FOffset<-10))
         {
         Addr1=SAddr+BeginOffset;
         if (FOffset>MAX24) FOffset=MAX24 else if (FOffset<-MAX24) FOffset=-MAX24;
         Offset=(LONG)FOffset;
         do
            {
            do
               {
               Data1=(LONG*)Addr1; Addr1=Addr1+4;
               *Data1=*Data1-Offset;
               i++;
               }
            #ifdef __PPC__
               while ((Addr1<SAddr+EndOffset) && (i<20000));
            #else
               while ((Addr1<SAddr+EndOffset) && (i<2000));
            #endif
            i=0;
            MESSAGEHANDLE();
            if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
               {
               Valid=FALSE;
               return;
               }
            }
         while (Addr1<SAddr+EndOffset);
         }
      }
   else
      {
      Data1=(LONG*)(SAddr+BeginOffset);
      Offset=*Data1;
      Data1=(LONG*)(SAddr+EndOffset-4);
      StepSize=4.0*(Offset-*Data1)/(EndOffset-BeginOffset);
      Addr1=SAddr+BeginOffset;
      FOffset=(FLOAT)Offset;
      MyWTStdMsg->Flags=0;
      MyWTStdMsg->WTMsgPrc->PRC_Flags=WTM_GETABORTINFO;
      do
         {
         do
            {
            Data1=(LONG*)Addr1; Addr1=Addr1+4;
            *Data1=*Data1-(LONG)FOffset;
            FOffset=FOffset-StepSize;
            i++;
            }
         #ifdef __PPC__
            while ((Addr1<SAddr+EndOffset) && (i<20000));
         #else
            while ((Addr1<SAddr+EndOffset) && (i<2000));
         #endif
         i=0;
         MESSAGEHANDLE();
         if (MyWTStdMsg->WTMsgPrc->PRC_Long1==-1)
            {
            Valid=FALSE;
            return;
            }
         }
      while (Addr1<SAddr+EndOffset);
      }
   }
}

